/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.collections4.MapUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortConfigKeys;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.jbidibc.messages.port.BytePortConfigValue;
import org.bidib.jbidibc.messages.port.Int16PortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.BacklightPortValueListener;
import org.bidib.wizard.api.model.listener.DefaultNodeListListener;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.api.utils.PortListUtils;
import org.bidib.wizard.common.labels.BidibLabelUtils;
import org.bidib.wizard.common.labels.LabelsChangedEvent;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.PortTypeAware;
import org.bidib.wizard.model.ports.ServoPort;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.mvc.main.model.BacklightPortTableModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.listener.BacklightPortModelListener;
import org.bidib.wizard.mvc.main.view.exchange.NodeExchangeHelper;
import org.bidib.wizard.mvc.main.view.panel.BacklightPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;

public class BacklightPortPanelController {
    private static final Logger LOGGER = LoggerFactory.getLogger(BacklightPortPanelController.class);
    private final MainModel mainModel;
    @Autowired
    private SwitchingNodeService switchingNodeService;
    @Autowired
    private WizardLabelWrapper wizardLabelWrapper;
    private BacklightPortListPanel backlightPortListPanel;
    private final Subject<PortConfigChangeEvent> portConfigChangeEventSubject;
    private CompositeDisposable compDisp;

    public BacklightPortPanelController(MainModel mainModel) {
        this.mainModel = mainModel;
        this.compDisp = new CompositeDisposable();
        this.portConfigChangeEventSubject = PublishSubject.create().toSerialized();
    }

    public BacklightPortListPanel createPanel(TabVisibilityListener tabVisibilityListener) {
        final BacklightPortTableModel tableModel = new BacklightPortTableModel();
        tableModel.setPortListener(new BacklightPortModelListener(){

            public void labelChanged(BacklightPort port, String label) {
                port.setLabel(label);
                try {
                    NodeLabels nodeLabels = BacklightPortPanelController.this.getNodeLabels();
                    BidibLabelUtils.replaceLabel((NodeLabels)nodeLabels, (WizardLabelFactory.LabelTypes)WizardLabelFactory.LabelTypes.backlightPort, (int)port.getId(), (String)port.getLabel());
                    BacklightPortPanelController.this.saveLabels();
                }
                catch (InvalidConfigurationException ex) {
                    LOGGER.warn("Save backlight port labels failed.", (Throwable)ex);
                    String labelPath = ex.getReason();
                    JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(null), Resources.getString(NodeExchangeHelper.class, (String)"labelfileerror.message", (Object[])new Object[]{labelPath}), Resources.getString(NodeExchangeHelper.class, (String)"labelfileerror.title"), 0);
                }
            }

            public void configChanged(BacklightPort port, PortConfigKeys ... portConfigKeys) {
                LOGGER.info("The configuration of the port has changed: {}", (Object)port);
                try {
                    NodeInterface node = BacklightPortPanelController.this.mainModel.getSelectedNode();
                    BacklightPortPanelController.this.switchingNodeService.setPortConfig("main", node.getSwitchingNode(), (Port)port);
                }
                catch (Exception ex) {
                    LOGGER.warn("Set the backlightport config failed.", (Throwable)ex);
                    BacklightPortPanelController.this.mainModel.setNodeHasError(BacklightPortPanelController.this.mainModel.getSelectedNode(), true);
                }
            }

            public void changePortType(LcOutputType portType, Port<? extends BidibStatus> port) {
                LOGGER.info("The port type will change to: {}, port: {}", (Object)portType, port);
                HashMap values = new HashMap();
                BacklightPortPanelController.this.switchingNodeService.setPortConfig("main", BacklightPortPanelController.this.mainModel.getSelectedNode().getSwitchingNode(), port, portType, values);
            }

            @Override
            public void testButtonPressed(BacklightPort port, int requestedValue) {
                LOGGER.info("Test pressed for port: {}, requestedValue: {}", (Object)port, (Object)requestedValue);
                try {
                    BacklightPort backlightPort = new BacklightPort();
                    backlightPort.setId(port.getId());
                    backlightPort.setValue(Integer.valueOf(requestedValue));
                    NodeInterface node = BacklightPortPanelController.this.mainModel.getSelectedNode();
                    BacklightPortPanelController.this.switchingNodeService.setPortStatus("main", node.getSwitchingNode(), (Port)backlightPort);
                }
                catch (Exception ex) {
                    LOGGER.warn("Set the backlightport status failed.", (Throwable)ex);
                    BacklightPortPanelController.this.mainModel.setNodeHasError(BacklightPortPanelController.this.mainModel.getSelectedNode(), true);
                }
            }
        });
        this.backlightPortListPanel = new BacklightPortListPanel(this, tableModel, this.mainModel, tabVisibilityListener, this.portConfigChangeEventSubject);
        this.backlightPortListPanel.setPortListener(new BacklightPortValueListener(){

            public Class<?> getPortClass() {
                return BacklightPort.class;
            }

            public void labelChanged(BacklightPort port, String label) {
                LOGGER.info("The label has been changed by nodeScript, port: {}, label: {}", (Object)port, (Object)label);
                NodeLabels nodeLabels = BacklightPortPanelController.this.getNodeLabels();
                BidibLabelUtils.replaceLabel((NodeLabels)nodeLabels, (WizardLabelFactory.LabelTypes)WizardLabelFactory.LabelTypes.backlightPort, (int)port.getId(), (String)port.getLabel());
                BacklightPortPanelController.this.saveLabels();
                BacklightPortPanelController.this.backlightPortListPanel.repaint();
            }

            public void valueChanged(NodeInterface node, BacklightPort port) {
                LOGGER.info("Value has changed for backlight port: {}", (Object)port);
                SwingUtilities.invokeLater(() -> tableModel.notifyPortStatusChanged(port));
            }

            public void configChanged(NodeInterface node, BacklightPort port) {
                LOGGER.info("The configuration of the port has changed: {}", (Object)port);
                SwingUtilities.invokeLater(() -> tableModel.notifyPortConfigChanged(port));
            }

            public void valuesChanged(BacklightPort port, PortConfigKeys ... portConfigKeys) {
                LOGGER.info("The port value are changed for port: {}, portConfigKeys: {}", (Object)port, (Object)portConfigKeys);
                LinkedHashMap<Byte, Object> values = new LinkedHashMap<Byte, Object>();
                List servoPorts = BacklightPortPanelController.this.mainModel.getSelectedNode().getServoPorts();
                ServoPort servoPort = (ServoPort)PortListUtils.findPortByPortNumber((List)servoPorts, (int)port.getId());
                block7: for (PortConfigKeys key : portConfigKeys) {
                    if (!servoPort.isPortConfigKeySupported(key)) {
                        LOGGER.info("Unsupported port config key detected: {}", (Object)key);
                        continue;
                    }
                    switch (key) {
                        case BIDIB_PCFG_DIMM_DOWN: {
                            int dimMin = port.getDimSlopeDown();
                            if (port.isPortConfigKeySupported(Byte.valueOf((byte)68))) {
                                values.put((byte)68, new Int16PortConfigValue(Integer.valueOf(ByteUtils.getWORD((int)dimMin))));
                                continue block7;
                            }
                            if (!port.isPortConfigKeySupported(Byte.valueOf((byte)4))) continue block7;
                            values.put((byte)4, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)dimMin))));
                            continue block7;
                        }
                        case BIDIB_PCFG_DIMM_UP: {
                            int dimMax = port.getDimSlopeUp();
                            if (port.isPortConfigKeySupported(Byte.valueOf((byte)67))) {
                                values.put((byte)67, new Int16PortConfigValue(Integer.valueOf(ByteUtils.getWORD((int)dimMax))));
                                continue block7;
                            }
                            if (!port.isPortConfigKeySupported(Byte.valueOf((byte)3))) continue block7;
                            values.put((byte)3, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)dimMax))));
                            continue block7;
                        }
                        case BIDIB_PCFG_OUTPUT_MAP: {
                            Integer dmxMapping = port.getDmxMapping();
                            if (!port.isPortConfigKeySupported(Byte.valueOf((byte)6)) || dmxMapping == null) continue block7;
                            LOGGER.info("The backlightport has dmxMapping support: {}, dmxMapping: {}", (Object)port, (Object)dmxMapping);
                            values.put((byte)6, new BytePortConfigValue(ByteUtils.getLowByte((Integer)dmxMapping)));
                            continue block7;
                        }
                        default: {
                            LOGGER.warn("Unsupported port config key detected: {}", (Object)key);
                        }
                    }
                }
                if (MapUtils.isNotEmpty(values)) {
                    try {
                        LOGGER.info("Set the port params: {}", values);
                        BacklightPortPanelController.this.switchingNodeService.setPortConfig("main", BacklightPortPanelController.this.mainModel.getSelectedNode().getSwitchingNode(), (Port)port, null, values);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Set the backlightport parameters failed.", (Throwable)ex);
                        BacklightPortPanelController.this.mainModel.setNodeHasError(BacklightPortPanelController.this.mainModel.getSelectedNode(), true);
                    }
                } else {
                    LOGGER.info("No config values to save available.");
                }
            }

            public void testButtonPressed(NodeInterface node, BacklightPort port, int requestedValue) {
            }
        });
        this.mainModel.addNodeListListener((NodeListListener)new DefaultNodeListListener(){

            public void nodeChanged(NodeInterface node) {
                super.nodeChanged(node);
                LOGGER.info("The selected node has been changed: {}", (Object)node);
                BacklightPortPanelController.this.compDisp.dispose();
                BacklightPortPanelController.this.compDisp.clear();
                BacklightPortPanelController.this.compDisp = new CompositeDisposable();
                if (node != null) {
                    BacklightPortPanelController.this.addBacklightPortModelListener(node);
                }
            }
        });
        NodeInterface selectedNode = this.mainModel.getSelectedNode();
        if (selectedNode != null) {
            this.addBacklightPortModelListener(selectedNode);
        }
        return this.backlightPortListPanel;
    }

    private NodeLabels getNodeLabels() {
        WizardLabelFactory wizardLabelFactory = this.wizardLabelWrapper.getWizardLabelFactory();
        NodeLabels nodeLabels = wizardLabelFactory.loadLabels(Long.valueOf(this.mainModel.getSelectedNode().getUniqueId()), new String[0]);
        return nodeLabels;
    }

    private void saveLabels() {
        try {
            long uniqueId = this.mainModel.getSelectedNode().getUniqueId();
            this.wizardLabelWrapper.saveNodeLabels(Long.valueOf(uniqueId));
        }
        catch (Exception e) {
            LOGGER.warn("Save backlight labels failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @EventListener(value={LabelsChangedEvent.class})
    public void labelsChangedEvent(LabelsChangedEvent labelsChangedEvent) {
        LOGGER.info("The labels have changed, node: {}", (Object)labelsChangedEvent);
        if (this.backlightPortListPanel != null) {
            SwingUtilities.invokeLater(() -> this.backlightPortListPanel.refreshView());
        }
    }

    private void addBacklightPortModelListener(NodeInterface selectedNode) {
        LOGGER.info("Add backlight port model listener for node: {}", (Object)selectedNode);
        Disposable disp = this.portConfigChangeEventSubject.subscribe(evt -> {
            LOGGER.info("Received event: {}", evt);
            PortTypeAware port = evt.getPort();
            try {
                BacklightPort backlightPort = new BacklightPort();
                backlightPort.setId(port.getPortNumber().intValue());
                LOGGER.info("Prepared backlight port: {}", (Object)backlightPort);
                this.switchingNodeService.setPortConfig("main", selectedNode.getSwitchingNode(), (Port)backlightPort, null, evt.getPortConfig());
            }
            catch (Exception ex) {
                LOGGER.warn("Set the backlight port config failed.", (Throwable)ex);
                selectedNode.setNodeHasError(true);
                selectedNode.setReasonData("Set the backlight port config failed.");
            }
        });
        this.compDisp.add(disp);
    }
}

