/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.position.model;

import com.jgoodies.binding.beans.Model;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.core.schema.bidibbase.BaseLabel;
import org.bidib.jbidibc.messages.enums.PositionLocationEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.PositionAddressData;
import org.bidib.wizard.api.model.PositionFeedbackPort;
import org.bidib.wizard.api.model.RfBasisNode;
import org.bidib.wizard.api.model.listener.PortListListener;
import org.bidib.wizard.model.status.FeedbackPortStatus;
import org.bidib.wizard.mvc.position.controller.FeedbackPositionStatusChangeProvider;
import org.bidib.wizard.mvc.position.model.listener.FeedbackPositionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedbackPositionModel
extends Model
implements FeedbackPositionStatusChangeProvider {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedbackPositionModel.class);
    public static final String PROPERTY_PORT_LIST = "portList";
    public static final String PROPERTY_RFBASIS_NODES = "rfBasisNodes";
    private PropertyChangeListener pclFeedbackPorts;
    private final List<FeedbackPositionListener> feedbackPositionListeners = new LinkedList<FeedbackPositionListener>();
    private List<PositionFeedbackPort> portList = new LinkedList<PositionFeedbackPort>();
    private final List<PortListListener> portListListeners = new LinkedList<PortListListener>();
    private List<RfBasisNode> rfBasisNodes = new LinkedList<RfBasisNode>();
    private long uniqueId;
    private final PropertyChangeListener pclBaseNumber;
    private final IntFunction<BaseLabel> labelFunction;

    public FeedbackPositionModel(IntFunction<BaseLabel> labelFunction) {
        LOGGER.info("Create new instance of FeedbackPositionModel.");
        this.labelFunction = labelFunction;
        this.pclFeedbackPorts = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LOGGER.debug("Property has changed, evt: {}", (Object)evt);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (PortListListener listener : FeedbackPositionModel.this.portListListeners) {
                            LOGGER.debug("Notify listener that the ports have changed: {}", (Object)listener);
                            listener.listChanged();
                        }
                    }
                });
            }
        };
        this.addPropertyChangeListener(this.pclFeedbackPorts);
        this.pclBaseNumber = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LOGGER.info("The base number has changed on node: {}", evt.getSource());
                if (evt.getSource() instanceof NodeInterface) {
                    NodeInterface rfBasisNode = (NodeInterface)evt.getSource();
                    FeedbackPositionModel.this.checkForSingleOrMasterBasis(rfBasisNode);
                }
            }
        };
    }

    private void checkForSingleOrMasterBasis(NodeInterface rfBasisNode) {
        int baseNumber = rfBasisNode.getBaseNumber();
        LOGGER.info("Set the base number on the rfBasisNode: {}", (Object)baseNumber);
        if (baseNumber == 0 || baseNumber == 1) {
            LOGGER.info("This is the single or master basis.");
            long uniqueId = rfBasisNode.getUniqueId();
            LOGGER.info("Set the uniqueId in the feedbackPositionModel: {}", (Object)ByteUtils.formatHexUniqueId((long)uniqueId));
            this.setNodeUnique(uniqueId);
        }
    }

    public void setNodeUnique(long uniqueId) {
        LOGGER.info("Set the uniqueId: {}", (Object)uniqueId);
        this.uniqueId = uniqueId;
    }

    private long getUniqueId() {
        return this.uniqueId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPosition(byte[] address, int decoderAddress, PositionLocationEnum locationType, int locationAddress, byte[] extendedData) {
        LOGGER.info("Add position, locationType: {}, locationAddress: {}, decoderAddress: {}", new Object[]{locationType, locationAddress, decoderAddress});
        List<PositionFeedbackPort> list = this.portList;
        synchronized (list) {
            Stream<PositionFeedbackPort> prevPort = this.portList.stream().filter(p -> {
                for (PositionAddressData ad : p.getAddresses()) {
                    if (decoderAddress != ad.getDecoderAddress()) continue;
                    return true;
                }
                return false;
            });
            long lastSeenTimestamp = System.currentTimeMillis();
            PositionAddressData positionAddressData = new PositionAddressData(decoderAddress, lastSeenTimestamp);
            prevPort.iterator().forEachRemaining(p -> {
                p.removeAddress(positionAddressData);
                if (!p.hasAddresses()) {
                    p.setStatus(FeedbackPortStatus.FREE);
                }
            });
            Optional<PositionFeedbackPort> port = this.portList.stream().filter(p -> p.getId() == locationAddress).findFirst();
            if (port.isPresent()) {
                port.get().addAddress(positionAddressData);
                port.get().setStatus(FeedbackPortStatus.OCCUPIED);
            } else {
                PositionFeedbackPort newPort = new PositionFeedbackPort(locationAddress);
                if (this.getUniqueId() > 0L) {
                    try {
                        BaseLabel label = this.labelFunction.apply(newPort.getId());
                        LOGGER.info("New port, id: {}, current label: {}", (Object)newPort.getId(), (Object)label);
                        newPort.setLabel(label != null ? label.getLabel() : null);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Set the label of the feedback position port failed.", (Throwable)ex);
                    }
                } else {
                    LOGGER.info("No feedbackPortLabels or no uniqueId.");
                }
                newPort.addAddress(positionAddressData);
                newPort.setStatus(FeedbackPortStatus.OCCUPIED);
                LOGGER.debug("Created new port to add to portList: {}", (Object)newPort);
                this.portList.add(newPort);
            }
        }
        this.firePropertyChange(PROPERTY_PORT_LIST, null, this.portList);
    }

    public List<PositionFeedbackPort> getPortList() {
        return this.portList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RfBasisNode> getRfBasisNodes() {
        List<RfBasisNode> list = this.rfBasisNodes;
        synchronized (list) {
            return Collections.unmodifiableList(this.rfBasisNodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRfBasisNodes(List<RfBasisNode> rfBasisNodes) {
        List<RfBasisNode> list = rfBasisNodes;
        synchronized (list) {
            this.rfBasisNodes.clear();
            if (CollectionUtils.isNotEmpty(rfBasisNodes)) {
                this.rfBasisNodes.addAll(rfBasisNodes);
                for (RfBasisNode rfBasisNode : rfBasisNodes) {
                    this.addBaseNumberListener(rfBasisNode);
                }
            }
        }
        this.firePropertyChange(PROPERTY_RFBASIS_NODES, null, this.rfBasisNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRfBasisNode(RfBasisNode rfBasisNode) {
        List<RfBasisNode> list = this.rfBasisNodes;
        synchronized (list) {
            this.rfBasisNodes.add(rfBasisNode);
            this.addBaseNumberListener(rfBasisNode);
            this.checkForSingleOrMasterBasis(rfBasisNode.getNode());
        }
        this.firePropertyChange(PROPERTY_RFBASIS_NODES, null, this.rfBasisNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRfBasisNode(RfBasisNode rfBasisNode) {
        List<RfBasisNode> list = this.rfBasisNodes;
        synchronized (list) {
            this.rfBasisNodes.remove(rfBasisNode);
            this.removeBaseNumberListener(rfBasisNode);
        }
        this.firePropertyChange(PROPERTY_RFBASIS_NODES, null, this.rfBasisNodes);
    }

    private void addBaseNumberListener(RfBasisNode rfBasisNode) {
        rfBasisNode.getNode().addPropertyChangeListener("baseNumber", this.pclBaseNumber);
    }

    private void removeBaseNumberListener(RfBasisNode rfBasisNode) {
        rfBasisNode.getNode().removePropertyChangeListener("baseNumber", this.pclBaseNumber);
    }

    @Override
    public void addFeedbackPortListener(FeedbackPositionListener feedbackPositionListener) {
        this.feedbackPositionListeners.add(feedbackPositionListener);
    }

    @Override
    public void removeFeedbackPortListener(FeedbackPositionListener feedbackPositionListener) {
        this.feedbackPositionListeners.remove(feedbackPositionListener);
    }

    @Override
    public void addPortListListener(PortListListener portListListener) {
        this.portListListeners.add(portListListener);
    }

    @Override
    public void removePortListListener(PortListListener portListListener) {
        this.portListListeners.remove(portListListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAddressesAndPortStatus() {
        List<PositionFeedbackPort> list = this.portList;
        synchronized (list) {
            for (PositionFeedbackPort port : this.portList) {
                port.setStatus(FeedbackPortStatus.FREE);
                port.clear();
            }
        }
        this.firePropertyChange(PROPERTY_PORT_LIST, null, this.portList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validatePositions(List<PositionFeedbackPort> outdatedPorts, long timeout) {
        List<PositionFeedbackPort> list = this.portList;
        synchronized (list) {
            for (PositionFeedbackPort port : this.portList) {
                boolean outdated;
                if (port.getStatus() != FeedbackPortStatus.OCCUPIED || !(outdated = port.isOutdated(timeout))) continue;
                outdatedPorts.add(port);
            }
        }
    }
}

