/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.position.view;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.PositionAddressData;
import org.bidib.wizard.api.model.PositionFeedbackPort;
import org.bidib.wizard.api.model.listener.PortListener;
import org.bidib.wizard.client.common.dialog.LabelDialog;
import org.bidib.wizard.client.common.model.SimplePortTableModel;
import org.bidib.wizard.client.common.model.listener.PortModelListener;
import org.bidib.wizard.client.common.table.DefaultPortListMenuListener;
import org.bidib.wizard.client.common.table.PortTable;
import org.bidib.wizard.client.common.view.menu.PortListMenu;
import org.bidib.wizard.client.common.view.menu.listener.PortListMenuListener;
import org.bidib.wizard.model.ports.FeedbackPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.FeedbackPortStatus;
import org.bidib.wizard.mvc.main.view.panel.SimplePortListPanel;
import org.bidib.wizard.mvc.main.view.table.FlagEditor;
import org.bidib.wizard.mvc.position.controller.FeedbackPositionController;
import org.bidib.wizard.mvc.position.model.FeedbackPositionModel;
import org.bidib.wizard.mvc.position.model.FeedbackPositionTableModel;
import org.bidib.wizard.mvc.position.view.FeedbackPositionTableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedbackPositionListPanel
extends SimplePortListPanel<FeedbackPortStatus, PositionFeedbackPort, PortListener<PositionFeedbackPort>, PortModelListener<PositionFeedbackPort>> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedbackPositionListPanel.class);
    private final FeedbackPositionController controller;
    private final FeedbackPositionModel feedbackPositionModel;
    private final FeedbackPositionTableModel feedbackPositionTableModel;
    protected final ScheduledExecutorService outdatedPositionWorker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("outdatedPositionsWorkers-thread-%d").build());
    private final int outdatedTimeout = 2000;

    public FeedbackPositionListPanel(FeedbackPositionController controller, FeedbackPositionModel feedbackPositionModel, FeedbackPositionTableModel tableModel) {
        super(tableModel, Resources.getString(FeedbackPositionListPanel.class, (String)"empty_table"));
        this.controller = controller;
        this.feedbackPositionModel = feedbackPositionModel;
        LOGGER.debug("Create new FeedbackPositionListPanel.");
        FeedbackPositionTableCellRenderer renderer = new FeedbackPositionTableCellRenderer();
        renderer.setTimeout(2000);
        this.table.setDefaultCellRenderer((TableCellRenderer)renderer);
        this.table.setDefaultEditor(PositionFeedbackPort.class, (TableCellEditor)new FlagEditor(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                if (value instanceof PositionFeedbackPort) {
                    this.textField.setText(value != null ? ((PositionFeedbackPort)value).getLabel() : null);
                    this.textField.setToolTipText(null);
                } else {
                    this.textField.setText(value != null ? value.toString() : null);
                    this.textField.setToolTipText(null);
                }
                return this.textField;
            }
        });
        this.table.setRowHeight(60);
        this.table.setTableHeader(null);
        this.feedbackPositionTableModel = tableModel;
        this.feedbackPositionModel.addPortListListener(this);
        int interval = 2000;
        this.outdatedPositionWorker.scheduleAtFixedRate(() -> {
            LOGGER.debug("Trigger check outdated positions.");
            try {
                this.triggerValidatePositions();
            }
            catch (Exception ex) {
                LOGGER.warn("Trigger the position failed.", (Throwable)ex);
            }
            LOGGER.debug("Trigger position has finished.");
        }, 500L, interval, TimeUnit.MILLISECONDS);
    }

    @Override
    protected PortTable createPortTable(SimplePortTableModel<FeedbackPortStatus, PositionFeedbackPort, PortModelListener<PositionFeedbackPort>> tableModel, String emptyTableText) {
        return new PortTable((TableModel)tableModel, emptyTableText){
            private static final long serialVersionUID = 1L;

            public void adjustRowHeight() {
            }

            protected void prepareTableStyleProvider() {
            }

            public void clearTable() {
            }

            protected PortListMenu createMenu() {
                return new FeedbackPositionListMenu(this.popupEvent, "No port selected.");
            }

            protected PortListMenuListener createMenuListener() {
                this.setPortMappingVisible(false);
                LOGGER.info("Create the menu listener.");
                return new FeedbackPositionListMenuListener(){

                    public void editLabel(MouseEvent popupEvent) {
                        final int row = this.getRow(popupEvent.getPoint());
                        final int column = this.getColumn(popupEvent.getPoint());
                        LOGGER.info("Edit label on row: {}, column: {}", (Object)row, (Object)column);
                        if (row > -1) {
                            Object val = this.getValueAt(row, column);
                            if (val instanceof Port) {
                                val = ((Port)val).getLabel();
                            }
                            new LabelDialog((String)val, popupEvent.getXOnScreen(), popupEvent.getYOnScreen()){

                                public void labelChanged(String label) {
                                    LOGGER.info("Set the new label for row: {}, column: {}, label: {}", new Object[]{row, column, label});
                                    this.setValueAt(label, row, column);
                                }
                            };
                        } else {
                            LOGGER.warn("The row is not available!");
                        }
                    }

                    @Override
                    public void clearAddressesAndPortStatus() {
                        LOGGER.info("Clear all addresses and set the status to free.");
                        FeedbackPositionListPanel.this.feedbackPositionModel.clearAddressesAndPortStatus();
                    }

                    @Override
                    public void openLocoDialog() {
                        LOGGER.info("Open the loco controller.");
                        int row = this.getRow(popupEvent.getPoint());
                        int column = this.getColumn(popupEvent.getPoint());
                        if (row > -1) {
                            Object val = this.getValueAt(row, column);
                            if (val instanceof PositionFeedbackPort) {
                                PositionFeedbackPort feedbackPort = (PositionFeedbackPort)val;
                                if (CollectionUtils.isNotEmpty((Collection)feedbackPort.getAddresses())) {
                                    PositionAddressData positionAddressData = (PositionAddressData)feedbackPort.getAddresses().stream().findFirst().get();
                                } else {
                                    LOGGER.info("No address available.");
                                }
                            }
                        } else {
                            LOGGER.warn("The row is not available!");
                        }
                    }

                    @Override
                    public void openPomDialog() {
                        LOGGER.info("Open the POM controller.");
                        int row = this.getRow(popupEvent.getPoint());
                        int column = this.getColumn(popupEvent.getPoint());
                        if (row > -1) {
                            Object val = this.getValueAt(row, column);
                            if (val instanceof PositionFeedbackPort) {
                                PositionFeedbackPort feedbackPort = (PositionFeedbackPort)val;
                                if (CollectionUtils.isNotEmpty((Collection)feedbackPort.getAddresses())) {
                                    PositionAddressData positionAddressData = (PositionAddressData)feedbackPort.getAddresses().stream().findFirst().get();
                                } else {
                                    LOGGER.info("No address available.");
                                }
                            }
                        } else {
                            LOGGER.warn("The row is not available!");
                        }
                    }
                };
            }

            protected void showPortListMenu(MouseEvent e, PortListMenu portListMenu, int row, int column) {
                Object value = this.getValueAt(row, column);
                if (row >= 0 && column >= 0 && (value instanceof Port || value instanceof String)) {
                    if (row >= 0 && this.getSelectedRowCount() == 0) {
                        this.setRowSelectionInterval(row, row);
                    }
                    if (value instanceof FeedbackPort) {
                        FeedbackPort feedbackPort = (FeedbackPort)value;
                        if (!feedbackPort.isEnabled()) {
                            portListMenu.setMapPortEnabled(feedbackPort.isRemappingEnabled(), this.isPortMappingVisible());
                        } else {
                            portListMenu.setMapPortEnabled(false, this.isPortMappingVisible());
                        }
                        String label = null;
                        label = StringUtils.isNotBlank((CharSequence)feedbackPort.getLabel()) ? String.format("%1$02d : %2$s", feedbackPort.getId(), feedbackPort.getLabel()) : (feedbackPort.getId() > -1 ? String.format("%1$02d", feedbackPort.getId()) : " ");
                        ((FeedbackPositionListMenu)portListMenu).setLabel("Port: " + label);
                    } else {
                        portListMenu.setMapPortEnabled(false, false);
                        ((FeedbackPositionListMenu)portListMenu).setLabel("No port selected.");
                    }
                    portListMenu.setInsertPortsEnabled(false, false);
                    portListMenu.setRemovePortEnabled(false, false);
                    portListMenu.setPopupEvent(this.popupEvent);
                    this.grabFocus();
                    portListMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
    }

    @Override
    public void listChanged() {
        LOGGER.debug("List has changed, remove all rows and add rows again.");
        this.tableModel.setRowCount(0);
        List<PositionFeedbackPort> ports = this.getPorts();
        ((FeedbackPositionTableModel)this.tableModel).addRows(ports);
    }

    @Override
    protected List<PositionFeedbackPort> getPorts() {
        if (this.feedbackPositionModel != null) {
            return this.feedbackPositionModel.getPortList();
        }
        return Collections.emptyList();
    }

    public Class<?> getPortClass() {
        return PositionFeedbackPort.class;
    }

    private void triggerValidatePositions() {
        if (this.feedbackPositionModel != null) {
            ArrayList<PositionFeedbackPort> outdatedPorts = new ArrayList<PositionFeedbackPort>();
            this.feedbackPositionModel.validatePositions(outdatedPorts, 2000L);
            if (CollectionUtils.isNotEmpty(outdatedPorts)) {
                LOGGER.debug("Update outdated ports.");
                try {
                    SwingUtilities.invokeAndWait(() -> this.feedbackPositionTableModel.validatePositions(outdatedPorts));
                }
                catch (InterruptedException | InvocationTargetException ex) {
                    LOGGER.warn("Validate outdated positions failed.", (Throwable)ex);
                }
            }
        }
    }

    public void cleanup() {
        this.outdatedPositionWorker.shutdown();
    }

    private abstract class FeedbackPositionListMenuListener
    extends DefaultPortListMenuListener {
        private FeedbackPositionListMenuListener() {
        }

        public abstract void clearAddressesAndPortStatus();

        public abstract void openLocoDialog();

        public abstract void openPomDialog();
    }

    private class FeedbackPositionListMenu
    extends PortListMenu {
        private static final long serialVersionUID = 1L;
        private JMenuItem clearAddressesAndPortStatus;
        private JMenuItem openCarDialog;
        private JMenuItem openPomDialog;

        public FeedbackPositionListMenu(MouseEvent popupEvent, String label) {
            super(popupEvent, label);
            this.clearAddressesAndPortStatus = new JMenuItem(Resources.getString(FeedbackPositionListMenu.class, (String)"clearAddressesAndPortStatus") + " ...");
            this.clearAddressesAndPortStatus.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FeedbackPositionListMenu.this.fireClearAddressesAndPortStatus();
                }
            });
            this.add(this.clearAddressesAndPortStatus);
            this.openCarDialog = new JMenuItem(Resources.getString(FeedbackPositionListMenu.class, (String)"openCarDialog") + " ...");
            this.openCarDialog.setEnabled(false);
            this.openCarDialog.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FeedbackPositionListMenu.this.fireOpenLocoDialog();
                }
            });
            this.add(this.openCarDialog);
            this.openPomDialog = new JMenuItem(Resources.getString(FeedbackPositionListMenu.class, (String)"openPomDialog") + " ...");
            this.openPomDialog.setEnabled(false);
            this.openPomDialog.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FeedbackPositionListMenu.this.fireOpenPomDialog();
                }
            });
            this.add(this.openPomDialog);
        }

        private void fireClearAddressesAndPortStatus() {
            for (PortListMenuListener l : this.menuListeners) {
                if (!(l instanceof FeedbackPositionListMenuListener)) continue;
                ((FeedbackPositionListMenuListener)l).clearAddressesAndPortStatus();
            }
        }

        private void fireOpenLocoDialog() {
            for (PortListMenuListener l : this.menuListeners) {
                if (!(l instanceof FeedbackPositionListMenuListener)) continue;
                ((FeedbackPositionListMenuListener)l).openLocoDialog();
            }
        }

        private void fireOpenPomDialog() {
            for (PortListMenuListener l : this.menuListeners) {
                if (!(l instanceof FeedbackPositionListMenuListener)) continue;
                ((FeedbackPositionListMenuListener)l).openPomDialog();
            }
        }
    }
}

