/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.stepcontrol.view;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.bidib.wizard.mvc.stepcontrol.view.TurntableAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivateAspectButtonTableCellEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivateAspectButtonTableCellEditor.class);
    private TurntableAspect source;
    private AspectAwareButton button;

    public ActivateAspectButtonTableCellEditor() {
        this(new AspectAwareButton());
    }

    public ActivateAspectButtonTableCellEditor(AspectAwareButton button) {
        this.button = button;
        this.button.addActionListener(new LoadActionListener());
    }

    public ActivateAspectButtonTableCellEditor(ActionListener actionListener) {
        this.button = new AspectAwareButton();
        this.button.addActionListener(actionListener);
        this.button.addActionListener(new LoadActionListener());
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    protected JButton prepare(JTable table, Object value, boolean isSelected, int row, int column) {
        if (!(value instanceof TurntableAspect)) {
            this.source = null;
            this.button.setEnabled(false);
            this.button.setTurntableAspect(null);
            return null;
        }
        this.source = (TurntableAspect)value;
        this.button.setEnabled(true);
        this.button.setText(this.source.getName());
        this.button.setToolTipText(this.source.getTooltip());
        this.button.setTurntableAspect((TurntableAspect)value);
        return this.button;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JButton button = this.prepare(table, value, isSelected, row, column);
        return button;
    }

    @Override
    public Object getCellEditorValue() {
        return this.source;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.prepare(table, value, isSelected, row, column);
    }

    public static class AspectAwareButton
    extends JButton {
        private static final long serialVersionUID = 1L;
        private TurntableAspect turntableAspect;

        public TurntableAspect getTurntableAspect() {
            return this.turntableAspect;
        }

        public void setTurntableAspect(TurntableAspect turntableAspect) {
            this.turntableAspect = turntableAspect;
        }
    }

    public class LoadActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            LOGGER.debug("Action was performed for source: {}", (Object)ActivateAspectButtonTableCellEditor.this.source);
            ActivateAspectButtonTableCellEditor.this.stopCellEditing();
        }
    }
}

