/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.stepcontrol.view;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.Trigger;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.view.ValidationComponentUtils;
import com.jidesoft.swing.NullButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.function.BiConsumer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.Document;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringToUnsignedLongConverter;
import org.bidib.wizard.client.common.table.PortValidationResultModel;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.validation.IconFeedbackPanel;
import org.bidib.wizard.client.common.view.validation.PropertyValidationI18NSupport;
import org.bidib.wizard.common.exception.VetoChangeException;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.model.stepcontrol.TurnTableType;
import org.bidib.wizard.mvc.stepcontrol.model.StepControlAspect;
import org.bidib.wizard.mvc.stepcontrol.model.StepControlModel;
import org.bidib.wizard.mvc.stepcontrol.view.AspectCallbackListener;
import org.bidib.wizard.mvc.stepcontrol.view.AspectTable;
import org.bidib.wizard.mvc.stepcontrol.view.PositionOutOfRangeException;
import org.bidib.wizard.mvc.stepcontrol.view.StepControlPanel;
import org.bidib.wizard.mvc.stepcontrol.view.converter.AngleDegreesConverter;
import org.bidib.wizard.mvc.stepcontrol.view.converter.BooleanToPolarityConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AspectEditorPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AspectEditorPanel.class);
    private final EditorType editorType;
    private final AspectCallbackListener<StepControlAspect> callbackListener;
    private final StepControlAspect stepControlAspect;
    private final StepControlAspect originalAspect;
    private final ImageIcon selectedIcon;
    private final ImageIcon unselectedIcon;
    private final ImageIcon selectedRolloverIcon;
    private final ImageIcon unselectedRolloverIcon;
    private final long totalSteps;
    private final TurnTableType turnTableType;
    private final boolean useSelectionBackground = false;
    private Trigger trigger;
    private PresentationModel<StepControlAspect> presentationModel;
    private ValueModel activateButtonEnabled = new ValueHolder();
    private ValueModel applyButtonEnabled = new ValueHolder();
    private PropertyChangeListener listener;
    private JTextField currentAngle;
    private JLabel angleLabel;
    private JTextField currentOppositeAngle;
    private JLabel oppositeAngleLabel;
    private NullButton oppositeActivateButton;
    private BufferedValueModel bufferedPositionModel;
    private ValueModel currentPositionConverterModel;
    private BufferedValueModel bufferedOppositePositionModel;
    private ValueModel oppositePositionConverterModel;
    private PortValidationResultModel validationResultModel;
    private NullButton applyButton;
    private static final Border DLU3TOP_DLU4OTHERS = Paddings.createPadding((ConstantSize)Sizes.DLUY3, (ConstantSize)Sizes.DLUX4, (ConstantSize)Sizes.DLUY4, (ConstantSize)Sizes.DLUX4);

    public AspectEditorPanel(AspectCallbackListener<StepControlAspect> callbackListener, StepControlAspect stepControlAspect, ImageIcon selectedIcon, ImageIcon unselectedIcon, ImageIcon selectedRolloverIcon, ImageIcon unselectedRolloverIcon, StepControlModel stepControlModel, EditorType editorType) {
        LOGGER.info("Create new editor, editorType: {}, stepControlAspect: {}", (Object)editorType, (Object)stepControlAspect);
        this.callbackListener = callbackListener;
        this.editorType = editorType;
        this.originalAspect = stepControlAspect;
        this.stepControlAspect = new StepControlAspect(stepControlAspect.getAspectNumber(), stepControlAspect.getPosition(), stepControlAspect.getPolarity(), stepControlAspect.getOppositePosition(), stepControlAspect.getOppositePolarity());
        this.stepControlAspect.setStatus(stepControlAspect.getStatus());
        this.selectedIcon = selectedIcon;
        this.unselectedIcon = unselectedIcon;
        this.selectedRolloverIcon = selectedRolloverIcon;
        this.unselectedRolloverIcon = unselectedRolloverIcon;
        this.totalSteps = stepControlModel.getTotalSteps() != null ? stepControlModel.getTotalSteps() : 1L;
        this.turnTableType = stepControlModel.getTurnTableType();
        this.setLayout(new BorderLayout());
        this.add(this.createTextPanel(stepControlModel));
        this.add((Component)this.createControlPanel(), "South");
        this.triggerValidation();
    }

    public void setDefaultButton() {
        if (this.editorType == EditorType.editorNew && this.applyButton != null) {
            this.getRootPane().setDefaultButton((JButton)this.applyButton);
        }
    }

    private JComponent createTextPanel(final StepControlModel stepControlModel) {
        this.trigger = new Trigger();
        this.presentationModel = new PresentationModel((Object)this.stepControlAspect, (ValueModel)this.trigger);
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AspectEditorPanel.this.updateActivateButtonEnabled();
                AspectEditorPanel.this.updateApplyButtonEnabled();
            }
        };
        this.presentationModel.addPropertyChangeListener("buffering", this.listener);
        this.originalAspect.addPropertyChangeListener("status", this.listener);
        this.validationResultModel = new PortValidationResultModel();
        boolean debug = false;
        FormBuilder detailFormBuilder = FormBuilder.create().columns("p, 3dlu, max(30dlu;p), 3dlu, p, 3dlu, p, 6dlu, p, 3dlu, max(30dlu;p), 3dlu, p, 3dlu, p", new Object[0]).rows("p", new Object[0]).panel((JPanel)(debug ? new FormDebugPanel() : new JPanel()));
        detailFormBuilder.border((Border)Paddings.DLU4);
        this.bufferedPositionModel = this.presentationModel.getBufferedModel("position");
        this.currentPositionConverterModel = new ConverterValueModel((ValueModel)this.bufferedPositionModel, (BindingConverter)new StringToUnsignedLongConverter());
        JTextField currentPosition = new JTextField();
        InputValidationDocument currentPositionDocument = new InputValidationDocument(6, "0123456789");
        currentPosition.setDocument((Document)currentPositionDocument);
        currentPosition.setColumns(6);
        Bindings.bind((JTextField)currentPosition, (ValueModel)this.currentPositionConverterModel, (boolean)false);
        this.addSelectionMouseAdapter(currentPosition);
        JLabel positionLabel = new JLabel(Resources.getString(StepControlPanel.class, (String)"position"));
        positionLabel.setToolTipText(Resources.getString(StepControlPanel.class, (String)"position.tooltip"));
        detailFormBuilder.add((Component)positionLabel).xy(1, 1);
        detailFormBuilder.add((Component)currentPosition).xy(3, 1);
        ValidationComponentUtils.setMandatory((JComponent)currentPosition, (boolean)true);
        ValidationComponentUtils.setMessageKeys((JComponent)currentPosition, (Object[])new Object[]{"validation.currentPosition_key"});
        this.bufferedPositionModel.addValueChangeListener(evt -> this.triggerValidation());
        ImageIcon wrenchIcon = ImageUtils.createImageIcon(AspectEditorPanel.class, (String)"/icons/16x16/wrench.png");
        NullButton useCurrentPositionButton = new NullButton((Icon)wrenchIcon);
        useCurrentPositionButton.setToolTipText(Resources.getString(AspectEditorPanel.class, (String)"use_current_position"));
        useCurrentPositionButton.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        useCurrentPositionButton.addActionListener((ActionListener)new AbstractClickAction(Resources.getString(AspectEditorPanel.class, (String)"use_current_position"), (AbstractButton)useCurrentPositionButton){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.info("Use the current position to set the aspect position.");
                if (AspectEditorPanel.this.callbackListener != null) {
                    Long currentTurntablePosition = AspectEditorPanel.this.callbackListener.getCurrentTurntablePosition();
                    if (currentTurntablePosition != null && AspectEditorPanel.this.isRoundTurnTable(stepControlModel)) {
                        long halfTotalSteps = AspectEditorPanel.this.totalSteps / 2L;
                        if (currentTurntablePosition >= halfTotalSteps) {
                            LOGGER.info("The current position is greater than the 180 degrees position. Use the current position as opposite position: {}", (Object)currentTurntablePosition);
                            AspectEditorPanel.this.bufferedOppositePositionModel.setValue((Object)currentTurntablePosition);
                            currentTurntablePosition = currentTurntablePosition - halfTotalSteps;
                        }
                        LOGGER.info("Calculated new position for the current position: {}", (Object)currentTurntablePosition);
                    }
                    AspectEditorPanel.this.bufferedPositionModel.setValue((Object)currentTurntablePosition);
                }
            }
        });
        detailFormBuilder.add((Component)useCurrentPositionButton).xy(5, 1);
        this.addSelectionMouseAdapter((JComponent)useCurrentPositionButton);
        ConverterValueModel currentAngleConverterModel = new ConverterValueModel((ValueModel)this.bufferedPositionModel, (BindingConverter)new AngleDegreesConverter(this.totalSteps));
        this.currentAngle = WizardComponentFactory.createTextField((ValueModel)currentAngleConverterModel);
        this.currentAngle.setEditable(false);
        this.angleLabel = new JLabel(Resources.getString(StepControlPanel.class, (String)"angle"));
        detailFormBuilder.add((Component)this.angleLabel).xy(9, 1);
        detailFormBuilder.add((Component)this.currentAngle).xy(11, 1);
        ConverterValueModel polarityConverterModel = new ConverterValueModel((ValueModel)this.presentationModel.getBufferedModel("polarity"), (BindingConverter)new BooleanToPolarityConverter());
        JCheckBox currentPolarity = WizardComponentFactory.createCheckBox((ValueModel)polarityConverterModel, null);
        currentPolarity.setIcon(this.unselectedIcon);
        currentPolarity.setSelectedIcon(this.selectedIcon);
        currentPolarity.setRolloverIcon(this.unselectedRolloverIcon);
        currentPolarity.setRolloverSelectedIcon(this.selectedRolloverIcon);
        currentPolarity.setToolTipText(Resources.getString(StepControlPanel.class, (String)"polarity.tooltip"));
        JLabel polarityLabel = new JLabel(Resources.getString(StepControlPanel.class, (String)"polarity"));
        detailFormBuilder.add((Component)currentPolarity).xy(13, 1);
        this.addSelectionMouseAdapter(currentPolarity);
        NullButton activateButton = new NullButton(Resources.getString(AspectEditorPanel.class, (String)"activate"));
        activateButton.addActionListener((ActionListener)new AbstractClickAction(Resources.getString(AspectEditorPanel.class, (String)"activate"), (AbstractButton)activateButton){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AspectEditorPanel.this.callbackListener != null) {
                    AspectEditorPanel.this.callbackListener.activateAspect(AspectEditorPanel.this.originalAspect);
                }
            }
        });
        detailFormBuilder.add((Component)activateButton).xyw(15, 1, 1);
        this.addSelectionMouseAdapter((JComponent)activateButton);
        if (this.isRoundTurnTable(stepControlModel)) {
            detailFormBuilder.appendRows("3dlu, p", new Object[0]);
            this.bufferedOppositePositionModel = this.presentationModel.getBufferedModel("oppositePosition");
            this.oppositePositionConverterModel = new ConverterValueModel((ValueModel)this.bufferedOppositePositionModel, (BindingConverter)new StringToUnsignedLongConverter());
            JTextField oppositePosition = new JTextField();
            InputValidationDocument oppositePositionDocument = new InputValidationDocument(6, "0123456789");
            oppositePosition.setDocument((Document)oppositePositionDocument);
            oppositePosition.setColumns(6);
            Bindings.bind((JTextField)oppositePosition, (ValueModel)this.oppositePositionConverterModel, (boolean)false);
            JLabel oppositePositionLabel = new JLabel(Resources.getString(StepControlPanel.class, (String)"opposite_position"));
            oppositePositionLabel.setToolTipText(Resources.getString(StepControlPanel.class, (String)"opposite_position.tooltip"));
            detailFormBuilder.add((Component)oppositePositionLabel).xy(1, 3);
            detailFormBuilder.add((Component)oppositePosition).xy(3, 3);
            ValidationComponentUtils.setMandatory((JComponent)oppositePosition, (boolean)true);
            ValidationComponentUtils.setMessageKeys((JComponent)oppositePosition, (Object[])new Object[]{"validation.oppositePosition_key"});
            this.addSelectionMouseAdapter(oppositePosition);
            this.bufferedOppositePositionModel.addValueChangeListener(evt -> this.triggerValidation());
            NullButton useCurrentOppositePositionButton = new NullButton((Icon)wrenchIcon);
            useCurrentOppositePositionButton.setToolTipText(Resources.getString(AspectEditorPanel.class, (String)"use_current_opposite_position"));
            useCurrentOppositePositionButton.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            useCurrentOppositePositionButton.addActionListener((ActionListener)new AbstractClickAction(Resources.getString(AspectEditorPanel.class, (String)"use_current_opposite_position"), (AbstractButton)useCurrentOppositePositionButton){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LOGGER.info("Use the current position to set the aspect opposite position.");
                    if (AspectEditorPanel.this.callbackListener != null) {
                        Long currentTurntablePosition = AspectEditorPanel.this.callbackListener.getCurrentTurntablePosition();
                        AspectEditorPanel.this.bufferedOppositePositionModel.setValue((Object)currentTurntablePosition);
                    }
                }
            });
            detailFormBuilder.add((Component)useCurrentOppositePositionButton).xy(5, 3);
            this.addSelectionMouseAdapter((JComponent)useCurrentOppositePositionButton);
            ImageIcon calculatorIcon = ImageUtils.createImageIcon(AspectEditorPanel.class, (String)"/icons/16x16/calculator.png");
            NullButton calculateOppositePositionButton = new NullButton((Icon)calculatorIcon);
            calculateOppositePositionButton.setToolTipText(Resources.getString(AspectEditorPanel.class, (String)"calculate_opposite_position"));
            calculateOppositePositionButton.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            calculateOppositePositionButton.addActionListener((ActionListener)new AbstractClickAction(Resources.getString(AspectEditorPanel.class, (String)"calculate_opposite_position"), (AbstractButton)calculateOppositePositionButton){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LOGGER.info("Calculate the position to set the aspect opposite position.");
                    if (AspectEditorPanel.this.callbackListener != null) {
                        try {
                            Object configuredPositionValue = AspectEditorPanel.this.bufferedPositionModel.getValue();
                            if (configuredPositionValue != null) {
                                long configuredPosition = (Long)configuredPositionValue;
                                long totalSteps = stepControlModel.getTotalSteps();
                                long calculatedOppositePosition = configuredPosition + totalSteps / 2L;
                                LOGGER.info("Set the calculatedOppositePosition: {}", (Object)calculatedOppositePosition);
                                if (calculatedOppositePosition > totalSteps) {
                                    LOGGER.warn("The calculated opposite position is out of range: {}, min: {}, max: {}", new Object[]{calculatedOppositePosition, totalSteps / 2L, totalSteps - 1L});
                                    throw new PositionOutOfRangeException(calculatedOppositePosition, totalSteps / 2L, totalSteps - 1L, -1);
                                }
                                AspectEditorPanel.this.bufferedOppositePositionModel.setValue(calculatedOppositePosition);
                            }
                        }
                        catch (PositionOutOfRangeException ex) {
                            long position = ex.getPosition();
                            LOGGER.info("Set the calculated position failed: {}", (Object)position);
                            JOptionPane.showMessageDialog(AspectEditorPanel.this, Resources.getString(AspectEditorPanel.class, (String)"set_calculated_position_failed_message", (Object[])new Object[]{position}), Resources.getString(AspectEditorPanel.class, (String)"set_calculated_position_title"), 0);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Calculate opposite value failed.", (Throwable)ex);
                        }
                    }
                }
            });
            detailFormBuilder.add((Component)calculateOppositePositionButton).xy(7, 3);
            ConverterValueModel currentOppositeAngleConverterModel = new ConverterValueModel((ValueModel)this.bufferedOppositePositionModel, (BindingConverter)new AngleDegreesConverter(this.totalSteps));
            this.currentOppositeAngle = WizardComponentFactory.createTextField((ValueModel)currentOppositeAngleConverterModel);
            this.currentOppositeAngle.setEditable(false);
            this.oppositeAngleLabel = new JLabel(Resources.getString(StepControlPanel.class, (String)"angle"));
            detailFormBuilder.add((Component)this.oppositeAngleLabel).xy(9, 3);
            detailFormBuilder.add((Component)this.currentOppositeAngle).xy(11, 3);
            ConverterValueModel oppositePolarityConverterModel = new ConverterValueModel((ValueModel)this.presentationModel.getBufferedModel("oppositePolarity"), (BindingConverter)new BooleanToPolarityConverter());
            JCheckBox currentOppositePolarity = WizardComponentFactory.createCheckBox((ValueModel)oppositePolarityConverterModel, null);
            currentOppositePolarity.setIcon(this.unselectedIcon);
            currentOppositePolarity.setSelectedIcon(this.selectedIcon);
            currentOppositePolarity.setRolloverIcon(this.unselectedRolloverIcon);
            currentOppositePolarity.setRolloverSelectedIcon(this.selectedRolloverIcon);
            JLabel oppositePolarityLabel = new JLabel(Resources.getString(StepControlPanel.class, (String)"polarity"));
            detailFormBuilder.add((Component)currentOppositePolarity).xy(13, 3);
            this.addSelectionMouseAdapter(currentOppositePolarity);
            this.oppositeActivateButton = new NullButton(Resources.getString(AspectEditorPanel.class, (String)"activate"));
            this.oppositeActivateButton.addActionListener((ActionListener)new AbstractClickAction(Resources.getString(AspectEditorPanel.class, (String)"activate"), (AbstractButton)this.oppositeActivateButton){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AspectEditorPanel.this.callbackListener != null) {
                        AspectEditorPanel.this.callbackListener.activateOppositeAspect(AspectEditorPanel.this.originalAspect);
                    }
                }
            });
            detailFormBuilder.add((Component)this.oppositeActivateButton).xyw(15, 3, 1);
            this.addSelectionMouseAdapter((JComponent)this.oppositeActivateButton);
        }
        stepControlModel.addPropertyChangeListener("turnTableType", evt -> {
            boolean showAngle = stepControlModel.getTurnTableType() == TurnTableType.round;
            this.setComponentsVisible(showAngle);
        });
        boolean showAngle = stepControlModel.getTurnTableType() == TurnTableType.round;
        this.setComponentsVisible(showAngle);
        JPanel panel = detailFormBuilder.build();
        if (this.getValidationResultModel() != null) {
            LOGGER.debug("Create iconfeedback panel.");
            IconFeedbackPanel cvIconPanel = new IconFeedbackPanel((ValidationResultModel)this.getValidationResultModel(), (JComponent)detailFormBuilder.build());
            FormBuilder feedbackBuilder = FormBuilder.create().columns("p:g", new Object[0]).rows("fill:p:grow", new Object[0]).panel(new JPanel());
            feedbackBuilder.add((Component)cvIconPanel).xy(1, 1);
            panel = feedbackBuilder.build();
        } else {
            panel = detailFormBuilder.build();
        }
        PropertyConnector.connect((Object)this.activateButtonEnabled, (String)"value", (Object)activateButton, (String)"enabled");
        if (this.oppositeActivateButton != null) {
            PropertyConnector.connect((Object)this.activateButtonEnabled, (String)"value", (Object)this.oppositeActivateButton, (String)"enabled");
        }
        return panel;
    }

    private boolean isRoundTurnTable(StepControlModel stepControlModel) {
        return TurnTableType.round == stepControlModel.getTurnTableType();
    }

    private void updateActivateButtonEnabled() {
        LOGGER.info("Current validState: {}, originalAspect: {}", (Object)(this.validationResultModel != null ? this.validationResultModel.getValidStateNoWarnOrErrors() : true), (Object)this.originalAspect);
        this.activateButtonEnabled.setValue((Object)(!this.presentationModel.isBuffering() && (this.validationResultModel == null || this.validationResultModel.getValidStateNoWarnOrErrors()) && StepControlAspect.AspectPersistanceStatus.statusPersistent == this.originalAspect.getStatus() ? 1 : 0));
    }

    protected void triggerValidation() {
        LOGGER.info("Validation is triggered.");
        ValidationResult validationResult = this.validateModel();
        this.validationResultModel.setResult(validationResult);
        this.updateActivateButtonEnabled();
        this.updateApplyButtonEnabled();
    }

    protected ValidationResult validateModel() {
        PropertyValidationI18NSupport support = new PropertyValidationI18NSupport(this.presentationModel, "validation");
        Long position = null;
        if (this.currentPositionConverterModel.getValue() == null) {
            support.addError("currentPosition_key", "not_empty_for_write");
        } else {
            position = (Long)this.bufferedPositionModel.getValue();
            if (TurnTableType.round == this.turnTableType) {
                if (position >= this.totalSteps / 2L) {
                    support.addError("currentPosition_key", "position_range_exceeded_half");
                }
            } else if (position >= this.totalSteps) {
                support.addError("currentPosition_key", "position_range_exceeded");
            }
        }
        if (TurnTableType.round == this.turnTableType) {
            if (this.oppositePositionConverterModel.getValue() == null) {
                support.addError("oppositePosition_key", "not_empty_for_write");
            } else if (position != null) {
                Long oppositePosition = (Long)this.bufferedOppositePositionModel.getValue();
                if (position >= oppositePosition) {
                    support.addError("oppositePosition_key", "opposite_position_greater_than_position");
                }
                if (oppositePosition >= this.totalSteps) {
                    support.addError("oppositePosition_key", "position_range_exceeded");
                }
            }
        }
        ValidationResult validationResult = support.getResult();
        LOGGER.debug("Prepared validationResult: {}", (Object)validationResult);
        return validationResult;
    }

    protected PortValidationResultModel getValidationResultModel() {
        return this.validationResultModel;
    }

    private void setComponentsVisible(boolean showAngle) {
        this.currentAngle.setVisible(showAngle);
        this.angleLabel.setVisible(showAngle);
        if (this.currentOppositeAngle != null) {
            this.currentOppositeAngle.setVisible(showAngle);
        }
        if (this.oppositeAngleLabel != null) {
            this.oppositeAngleLabel.setVisible(showAngle);
        }
    }

    public boolean isDirty() {
        if (this.presentationModel != null) {
            return this.presentationModel.isBuffering();
        }
        return false;
    }

    public StepControlAspect commitBuffer(BiConsumer<Long, Long> validationCallback) {
        LOGGER.info("Commit the buffer.");
        Long position = (Long)this.presentationModel.getBufferedValue("position");
        if (TurnTableType.round == this.turnTableType && position > this.totalSteps / 2L) {
            throw new IllegalArgumentException("Provided position value is not in the first half of total steps.");
        }
        Long positionOpposite = (Long)this.presentationModel.getBufferedValue("oppositePosition");
        LOGGER.info("Call the validation callback with position: {}, positionOpposite: {}", (Object)position, (Object)positionOpposite);
        validationCallback.accept(position, positionOpposite);
        if (this.trigger != null) {
            this.trigger.triggerCommit();
        }
        LOGGER.info("Commited the buffer, stepControlAspect: {}", (Object)this.stepControlAspect);
        return this.stepControlAspect;
    }

    public StepControlAspect flushBuffer() {
        LOGGER.info("Flush the buffer.");
        if (this.trigger != null) {
            this.trigger.triggerFlush();
        }
        return this.stepControlAspect;
    }

    private void clearAttribute(JComponent comp) {
        comp.setFont(null);
        comp.setBackground(null);
        comp.setForeground(null);
    }

    private JComponent createControlPanel() {
        boolean debug = false;
        FormBuilder detailFormBuilder = FormBuilder.create().columns("p, 3dlu, p", new Object[0]).rows("p", new Object[0]).panel((JPanel)(debug ? new FormDebugPanel() : new JPanel()));
        detailFormBuilder.border(DLU3TOP_DLU4OTHERS);
        this.applyButton = new NullButton(Resources.getString(AspectEditorPanel.class, (String)"apply"));
        this.applyButton.addActionListener((ActionListener)new AbstractClickAction("Apply", (AbstractButton)this.applyButton){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AspectEditorPanel.this.applyChanges();
                }
                catch (VetoChangeException ex) {
                    LOGGER.warn("Save changes was vetoed.");
                }
            }
        });
        detailFormBuilder.add((Component)this.applyButton).xy(1, 1);
        NullButton revertButton = new NullButton(EditorType.editorUpdate == this.editorType ? Resources.getString(AspectEditorPanel.class, (String)"revert") : Resources.getString(AspectEditorPanel.class, (String)"cancel"));
        revertButton.addActionListener((ActionListener)new AbstractClickAction("Revert", (AbstractButton)revertButton){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AspectEditorPanel.this.callbackListener != null) {
                    try {
                        AspectEditorPanel.this.callbackListener.discardChanges(() -> AspectEditorPanel.this.flushBuffer());
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Discard pending changes failed.", (Throwable)ex);
                    }
                }
            }
        });
        detailFormBuilder.add((Component)revertButton).xy(3, 1);
        this.applyButton.setEnabled(this.presentationModel.isBuffering());
        revertButton.setEnabled(this.presentationModel.isBuffering());
        PropertyConnector.connect((Object)this.applyButtonEnabled, (String)"value", (Object)this.applyButton, (String)"enabled");
        PropertyConnector.connect(this.presentationModel, (String)"buffering", (Object)revertButton, (String)"enabled");
        return detailFormBuilder.build();
    }

    private void updateApplyButtonEnabled() {
        LOGGER.info("Current validState: {}, buffering: {}", (Object)(this.validationResultModel != null ? this.validationResultModel.getValidStateNoWarnOrErrors() : true), (Object)this.presentationModel.isBuffering());
        this.applyButtonEnabled.setValue((Object)(this.presentationModel.isBuffering() && (this.validationResultModel == null || this.validationResultModel.getValidStateNoWarnOrErrors()) ? 1 : 0));
    }

    public void applyChanges() {
        if (this.callbackListener != null) {
            LOGGER.info("Apply the changes.");
            try {
                this.callbackListener.saveChanges(this.originalAspect, originalAspect -> this.commitBuffer((pos, posOpp) -> this.callbackListener.verifyUniquePosition((StepControlAspect)originalAspect, (Long)pos, (Long)posOpp)));
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warn("Save changes failed: {}", (Object)ex.getMessage());
                JOptionPane.showMessageDialog(this, Resources.getString(StepControlPanel.class, (String)"apply-changes-failed", (Object[])new Object[]{ex.getMessage()}), Resources.getString(StepControlPanel.class, (String)"apply"), 0);
                throw new VetoChangeException();
            }
            catch (Exception ex) {
                LOGGER.warn("Save pending changes failed.", (Throwable)ex);
                JOptionPane.showMessageDialog(this, Resources.getString(StepControlPanel.class, (String)"apply-changes-failed", (Object[])new Object[]{"unspecified"}), Resources.getString(StepControlPanel.class, (String)"apply"), 0);
                throw new VetoChangeException();
            }
        }
        this.cleanup();
    }

    public void cleanup() {
        LOGGER.info("Cleanup the editor: {}", (Object)this);
        if (this.listener != null) {
            this.presentationModel.removePropertyChangeListener("buffering", this.listener);
            this.originalAspect.removePropertyChangeListener("status", this.listener);
        }
    }

    private void addSelectionMouseAdapter(final JComponent component) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Container firstComponentByClass = SwingUtilities.getAncestorOfClass(AspectTable.class, component);
                if (firstComponentByClass != null) {
                    LOGGER.trace("e.source: {}, hasFocus: {}", e.getSource(), (Object)component.hasFocus());
                    MouseEvent tableEvent = new MouseEvent(firstComponentByClass, 501, System.currentTimeMillis(), 1040, e.getLocationOnScreen().x - firstComponentByClass.getLocationOnScreen().x, e.getLocationOnScreen().y - firstComponentByClass.getLocationOnScreen().y, 1, false, 1);
                    firstComponentByClass.dispatchEvent(tableEvent);
                }
                component.requestFocusInWindow();
                super.mouseClicked(e);
            }
        });
    }

    public static enum EditorType {
        editorNew,
        editorUpdate;

    }

    private static abstract class AbstractClickAction
    implements ActionListener {
        String buttonName;
        AbstractButton button;

        public AbstractClickAction(String buttonName, AbstractButton button) {
            this.buttonName = buttonName;
            this.button = button;
        }
    }
}

