/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.stepcontrol.view;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.bidib.wizard.client.common.view.slider.SliderValueChangeListener;
import org.bidib.wizard.model.ports.MotorPort;
import org.bidib.wizard.mvc.main.view.table.MotorSliderEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MotorSlider
extends MotorSliderEditor
implements PropertyChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MotorSlider.class);
    private static final long serialVersionUID = 1L;
    private MotorPort motorPort;

    public MotorSlider(int minValue, int maxValue) {
        super(minValue, maxValue, minValue);
    }

    public JPanel getComponent() {
        return this.panel;
    }

    public void addSliderValueChangeListener(final SliderValueChangeListener listener) {
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                LOGGER.info("The slider state has changed, source value: {}", (Object)source.getValue());
                listener.stateChanged(e, source.getValueIsAdjusting(), source.getValue());
            }
        });
    }

    public void setPort(MotorPort port) {
        if (this.motorPort != null) {
            this.motorPort.removePropertyChangeListener("value", (PropertyChangeListener)this);
        }
        this.motorPort = port;
        if (this.motorPort != null) {
            this.motorPort.addPropertyChangeListener("value", (PropertyChangeListener)this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        LOGGER.info("The value of the motor port has changed: {}", (Object)evt);
        if ("value".equals(evt.getPropertyName()) && this.motorPort != null) {
            int value = this.motorPort.getValue();
            LOGGER.info("Set the new value: {}", (Object)value);
            BoundedRangeModel m = this.slider.getModel();
            m.setValue(value);
        }
    }
}

