package org.bidib.wizard.config;

import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.client.common.boot.SwingCommandLineRunner;
import org.bidib.wizard.common.event.WizardApplicationReadyEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import com.vlsolutions.swing.docking.DockingDesktop;

@Component
@Order(10)
public class InitClientControllerCmdLineRunner implements SwingCommandLineRunner {

    private static final Logger LOGGER = LoggerFactory.getLogger(InitClientControllerCmdLineRunner.class);

    @Autowired
    private ConsoleControllerFactory consoleControllerFactory;

    @Autowired
    private ApplicationContext context;

    @Override
    public void run(String... args) throws Exception {
        LOGGER.info("Run the InitClientControllerCmdLineRunner to create the ConsoleController.");

        final DockingDesktop desktop = context.getBean(DockingDesktop.class);
        final ConsoleService consoleService = context.getBean(ConsoleService.class);

        consoleControllerFactory.createController(desktop, consoleService);

        LOGGER.info("Publish the WizardApplicationReadyEvent.");
        context.publishEvent(new WizardApplicationReadyEvent(this));
    }

}
