package org.bidib.wizard.mvc.locolist.view;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.util.function.Consumer;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringToIntegerConverter;
import org.bidib.wizard.client.common.table.PortValidationResultModel;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.validation.IconFeedbackPanel;
import org.bidib.wizard.client.common.view.validation.PropertyValidationI18NSupport;
import org.bidib.wizard.dmx.client.view.scenery.tree.AbstractValidationDialog;
import org.bidib.wizard.model.locolist.LocoListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.Trigger;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.util.PropertyValidationSupport;

public class LocoEditDialog extends AbstractValidationDialog<LocoListModel> {

    private static final Logger LOGGER = LoggerFactory.getLogger(LocoEditDialog.class);

    private static final long serialVersionUID = 1L;

    private static final String ENCODED_COLUMN_SPECS = "pref, 3dlu, max(pref;100dlu)";

    private static final String ENCODED_ROW_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref";

    private final JButton cancelButton = new JButton(Resources.getString(LocoEditDialog.class, "cancel"));

    private final JButton applyButton = new JButton(Resources.getString(LocoEditDialog.class, "apply"));

    private final LocoListModel locoModel;

    private ValueModel locoAddressValueModel;

    public LocoEditDialog(Frame frame, String title, final LocoListModel locoModel) {
        super(frame, title, false);
        this.locoModel = locoModel;
    }

    private JPanel createPanel() {
        FormBuilder builder = null;
        boolean debug = false;
        if (debug) {
            builder =
                FormBuilder.create().columns(ENCODED_COLUMN_SPECS).rows(ENCODED_ROW_SPECS).panel(new FormDebugPanel());
        }
        else {
            builder = FormBuilder.create().columns(ENCODED_COLUMN_SPECS).rows(ENCODED_ROW_SPECS).panel(new JPanel());
        }
        builder.border(Paddings.TABBED_DIALOG);

        this.trigger = new Trigger();
        this.presentationModel = new PresentationModel<>(this.locoModel, this.trigger);

        // add a validation model that can trigger a button state with the validState property
        this.validationResultModel = new PortValidationResultModel();

        // add content
        int row = 1;

        // loco address
        this.locoAddressValueModel = this.presentationModel.getBufferedModel(LocoListModel.PROPERTY_ADDRESS);
        final ConverterValueModel locoAddressConverterModel =
            new ConverterValueModel(this.locoAddressValueModel, new StringToIntegerConverter());

        builder.add(Resources.getString(LocoEditDialog.class, "address")).xy(1, row);

        final JTextField locoAddress = WizardComponentFactory.createTextField(locoAddressConverterModel, false);
        // final IntegerInputValidationDocument locoAddressDocument =
        // new IntegerInputValidationDocument(4, InputValidationDocument.NUMERIC);
        // locoAddressDocument.setRangeValidationCallback(new DefaultRangeValidationCallback(0, 2048 /* max address
        // */));
        // locoAddress.setDocument(locoAddressDocument);
        //
        // // bind manually because we changed the document of the textfield
        // Bindings.bind(locoAddress, locoAddressConverterModel, false);
        locoAddress.setEditable(false);

        builder.add(locoAddress).xy(3, row);

        // ValidationComponentUtils.setMandatory(locoAddress, true);
        // ValidationComponentUtils.setMessageKeys(locoAddress, "validation.address_key");

        row += 2;

        // loco name
        ValueModel locoNameValueModel = this.presentationModel.getBufferedModel(LocoListModel.PROPERTY_LOCO_NAME);

        builder.add(Resources.getString(LocoEditDialog.class, "name")).xy(1, row);
        final JTextField locoName = WizardComponentFactory.createTextField(locoNameValueModel, false);
        builder.add(locoName).xy(3, row);
        //

        row += 2;

        // prepare the close button
        JPanel buttons = new ButtonBarBuilder().addGlue().addButton(applyButton, cancelButton).build();
        builder.add(buttons).xyw(1, row, 3);

        applyButton.setEnabled(getApplyButtonEnabled().getValue() == Boolean.TRUE);
        PropertyConnector.connect(getApplyButtonEnabled(), "value", applyButton, "enabled");

        locoNameValueModel.addValueChangeListener(evt -> triggerValidation());

        final JPanel contentPanel = builder.build();

        LOGGER.debug("Create iconfeedback panel.");
        JComponent cvIconPanel = new IconFeedbackPanel(validationResultModel, contentPanel);
        FormBuilder feedbackBuilder = FormBuilder.create().columns("pref:grow").rows("fill:pref:grow");
        feedbackBuilder.add(cvIconPanel).xy(1, 1);

        final JPanel dialogContent = feedbackBuilder.build();

        triggerValidation();

        return dialogContent;
    }

    @Override
    protected void performCancelAction(KeyEvent e) {
        // Key pressed is the ESCAPE key. Hide this Dialog.

        if (isDirty()) {
            LOGGER.warn("The model is dirty. Ask user if he want's to cancel.");
        }

        setVisible(false);
    }

    private void close() {
        setVisible(false);

        dispose();
    }

    public void showDialog(final Consumer<LocoListModel> saveConsumer) {

        this.add(createPanel(), BorderLayout.CENTER);

        applyButton.addActionListener(evt -> {

            final LocoListModel locoModel = getPresentationModel().getBean();

            // update the model
            if (trigger != null) {
                trigger.triggerCommit();
            }

            LOGGER.info("Prepared the locoModel: {}", locoModel);

            saveConsumer.accept(locoModel);

            close();
        });
        cancelButton.addActionListener(evt -> {
            // close the dialog
            close();
        });

        pack();

        setLocationRelativeTo(getParent());
        setVisible(true);
    }

    @Override
    protected ValidationResult validatePanel() {
        final PropertyValidationSupport support =
            new PropertyValidationI18NSupport(getPresentationModel(), "validation");

        if (this.locoAddressValueModel.getValue() == null
            || StringUtils.isBlank(this.locoAddressValueModel.getValue().toString())) {
            support.addError("address_key", "not_empty");
        }

        ValidationResult validationResult = support.getResult();
        // LOGGER.debug("Prepared validationResult: {}", validationResult);
        return validationResult;
    }
}
