package org.bidib.wizard.mvc.features.view.panel;

import java.util.List;

import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.assertj.core.api.Assertions;
import org.bidib.jbidibc.core.schema.BidibFactory;
import org.bidib.jbidibc.core.schema.bidib2.FeatureCode;
import org.bidib.jbidibc.messages.Feature;
import org.junit.jupiter.api.Test;

class FeatureTableModelTest {

    @Test
    void documentationTextTest() {

        List<FeatureCode> featureCodes = BidibFactory.getFeatureCodes();
        Assertions.assertThat(featureCodes).isNotEmpty();

        final Feature feature = new Feature();
        feature.setType(40);

        // FeatureCode featureCode = featureCodes.get(0);
        FeatureCode featureCode = IterableUtils.find(featureCodes, new Predicate<FeatureCode>() {

            @Override
            public boolean evaluate(FeatureCode featureCode) {
                return featureCode.getId() == feature.getType();
            }
        });

        String documentationText = FeatureTableModel.getDocumentationText(featureCode.getDocumentation(), "de");

        Assertions.assertThat(documentationText).isNotNull();
        Assertions.assertThat(documentationText).isNotEqualTo(featureCode.getName());
        Assertions.assertThat(documentationText).isEqualTo("Anzahl der steuerbaren Objekte (z.B. Weichen, Signale)");
    }
}
