/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.config;

import com.vlsolutions.swing.docking.DockingDesktop;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.client.common.boot.SwingCommandLineRunner;
import org.bidib.wizard.common.event.WizardApplicationReadyEvent;
import org.bidib.wizard.config.ConsoleControllerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=10)
public class InitClientControllerCmdLineRunner
implements SwingCommandLineRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(InitClientControllerCmdLineRunner.class);
    @Autowired
    private ConsoleControllerFactory consoleControllerFactory;
    @Autowired
    private ApplicationContext context;

    public void run(String ... args) throws Exception {
        LOGGER.info("Run the InitClientControllerCmdLineRunner to create the ConsoleController.");
        DockingDesktop desktop = (DockingDesktop)this.context.getBean(DockingDesktop.class);
        ConsoleService consoleService = (ConsoleService)this.context.getBean(ConsoleService.class);
        this.consoleControllerFactory.createController(desktop, consoleService);
        LOGGER.info("Publish the WizardApplicationReadyEvent.");
        this.context.publishEvent((ApplicationEvent)new WizardApplicationReadyEvent((Object)this));
    }
}

