/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.accessory.controller;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JFrame;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.enums.AccessoryAcknowledge;
import org.bidib.jbidibc.messages.enums.TimeBaseUnitEnum;
import org.bidib.jbidibc.messages.enums.TimingControlEnum;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.connection.AbstractMessageEvent;
import org.bidib.wizard.api.model.connection.event.CommandStationAccessoryAckMessageEvent;
import org.bidib.wizard.core.model.connection.MessageAdapter;
import org.bidib.wizard.core.model.connection.MessageEventConsumer;
import org.bidib.wizard.core.service.ConnectionService;
import org.bidib.wizard.mvc.accessory.controller.listener.AccessoryControllerListener;
import org.bidib.wizard.mvc.accessory.model.AccessoryModel;
import org.bidib.wizard.mvc.accessory.view.AccessoryView;
import org.bidib.wizard.mvc.accessory.view.listener.AccessoryViewListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AccessoryController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessoryController.class);
    private final Collection<AccessoryControllerListener> listeners = new LinkedList<AccessoryControllerListener>();
    private final NodeInterface node;
    private final JFrame parent;
    private final int x;
    private final int y;
    private final AccessoryModel model = new AccessoryModel();
    @Autowired
    private ConnectionService connectionService;
    private MessageAdapter messageAdapter;

    public AccessoryController(NodeInterface node, JFrame parent, int x, int y) {
        this.node = node;
        this.parent = parent;
        this.x = x;
        this.y = y;
    }

    public void addAccessoryControllerListener(AccessoryControllerListener listener) {
        this.listeners.add(listener);
    }

    public void start() {
        this.messageAdapter = new MessageAdapter(this.connectionService){

            protected void prepareMessageMap(Map<Class<? extends AbstractMessageEvent>, MessageEventConsumer<AbstractMessageEvent, NodeInterface>> messageActionMap) {
                LOGGER.info("Prepare the message map.");
                messageActionMap.put(CommandStationAccessoryAckMessageEvent.class, (MessageEventConsumer<AbstractMessageEvent, NodeInterface>)((MessageEventConsumer)(evt, node) -> {
                    CommandStationAccessoryAckMessageEvent event = (CommandStationAccessoryAckMessageEvent)evt;
                    int decoderAddress = event.getDecoderAddress();
                    AccessoryAcknowledge acknowledge = event.getAccessoryAcknowledge();
                    LOGGER.info("csAccessoryAcknowledge, decoderAddress: {}, acknowledge: {}", (Object)decoderAddress, (Object)acknowledge);
                    if (decoderAddress == AccessoryController.this.model.getDccAddress()) {
                        AccessoryController.this.model.setAcknowledge(acknowledge);
                    }
                }));
            }

            protected void onDisconnect() {
                super.onDisconnect();
            }
        };
        this.messageAdapter.setNode(this.node);
        this.messageAdapter.start();
        AccessoryView accessoryView = new AccessoryView(this.parent, this.model, this.x, this.y);
        accessoryView.addAccessoryViewListener(new AccessoryViewListener(){

            @Override
            public void close() {
                LOGGER.info("Close the dialog.");
                AccessoryController.this.messageAdapter.dispose();
            }

            @Override
            public void sendAccessoryRequest(AddressData dccAddress, int aspect, Integer switchTime, TimeBaseUnitEnum timeBaseUnit, TimingControlEnum timingControl) {
                LOGGER.info("Send the DCC accessory request, address: {}, aspect: {}", (Object)dccAddress, (Object)aspect);
                AccessoryController.this.model.setAcknowledge(null);
                AccessoryController.this.model.setDccAddress(dccAddress.getAddress());
                for (AccessoryControllerListener listener : AccessoryController.this.listeners) {
                    AccessoryAcknowledge accessoryAcknowledge = listener.sendAccessoryRequest(AccessoryController.this.node, dccAddress, aspect, switchTime, timeBaseUnit, timingControl);
                    LOGGER.info("Returned acknowledge: {}", (Object)accessoryAcknowledge);
                    AccessoryController.this.model.setAcknowledge(accessoryAcknowledge);
                }
            }

            @Override
            public void sendAccessoryRequest(AddressData dccAddress, int aspect, int coilState) {
                LOGGER.info("Send the DCC accessory request, address: {}, aspect: {}, coilState: {}", new Object[]{dccAddress, aspect, coilState});
                AccessoryController.this.model.setAcknowledge(null);
                AccessoryController.this.model.setDccAddress(dccAddress.getAddress());
                for (AccessoryControllerListener listener : AccessoryController.this.listeners) {
                    AccessoryAcknowledge accessoryAcknowledge = listener.sendAccessoryRequest(AccessoryController.this.node, dccAddress, aspect, coilState);
                    LOGGER.info("Returned acknowledge: {}", (Object)accessoryAcknowledge);
                    AccessoryController.this.model.setAcknowledge(accessoryAcknowledge);
                }
            }

            @Override
            public void sendExtendedAccessoryRequest(AddressData dccAddress, int aspect) {
                LOGGER.info("Send the DCC extended accessory request, address: {}, aspect: {}", (Object)dccAddress, (Object)aspect);
                AccessoryController.this.model.setAcknowledge(null);
                AccessoryController.this.model.setDccAddress(dccAddress.getAddress());
                for (AccessoryControllerListener listener : AccessoryController.this.listeners) {
                    AccessoryAcknowledge accessoryAcknowledge = listener.sendExtendedAccessoryRequest(AccessoryController.this.node, dccAddress, aspect);
                    LOGGER.info("Returned acknowledge: {}", (Object)accessoryAcknowledge);
                    AccessoryController.this.model.setAcknowledge(accessoryAcknowledge);
                }
            }
        });
    }
}

