/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.backup.view;

import com.jgoodies.binding.adapter.AbstractTableAdapter;
import com.jgoodies.binding.list.SelectionInList;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.BooleanCheckBoxCellEditor;
import com.jidesoft.grid.CellPainter;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.HeaderStyleModel;
import com.jidesoft.grid.StyleModel;
import com.jidesoft.icons.CheckBoxIcon;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.Icon;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.table.ProgressCellRenderer;
import org.bidib.wizard.mvc.backup.model.NodeBackupModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupTableTableModel
extends AbstractTableAdapter<NodeBackupModel>
implements ContextSensitiveTableModel,
HeaderStyleModel,
StyleModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackupTableTableModel.class);
    private static final long serialVersionUID = 1L;
    public static final int COLUMN_SELECTED = 0;
    public static final int COLUMN_UNIQUE_ID = 1;
    public static final int COLUMN_DESCRIPTION = 2;
    public static final int COLUMN_PROGRESS = 3;
    private static final String[] COLUMNNAMES = new String[]{Resources.getString(BackupTableTableModel.class, (String)"selected"), Resources.getString(BackupTableTableModel.class, (String)"uniqueId"), Resources.getString(BackupTableTableModel.class, (String)"description"), Resources.getString(BackupTableTableModel.class, (String)"progress")};
    private final CellStyle ICON_STYLE = new CellStyle();
    private final CellStyle CELL_STYLE_UNDERLAY = new CellStyle();

    public BackupTableTableModel(SelectionInList<NodeBackupModel> nodeBackupList) {
        super(nodeBackupList, COLUMNNAMES);
        this.ICON_STYLE.setHorizontalAlignment(0);
        this.ICON_STYLE.setVerticalAlignment(0);
        this.ICON_STYLE.setIcon((Icon)new CheckBoxIcon());
        this.ICON_STYLE.setText("");
        this.CELL_STYLE_UNDERLAY.setUnderlayCellPainter(new CellPainter(){

            public void paint(Graphics g, Component component, int row, int column, Rectangle cellRect, Object value) {
                if (value instanceof Double) {
                    Graphics2D g2d = (Graphics2D)g.create();
                    double dv = (Double)value;
                    Rectangle clip = new Rectangle(cellRect.x, cellRect.y, (int)((double)cellRect.width * dv / 100.0), cellRect.height);
                    g2d.clip(clip);
                    if (dv > 66.0) {
                        JideSwingUtilities.fillGradient((Graphics2D)g2d, (Shape)cellRect, (Color)new Color(147, 98, 184), (Color)new Color(229, 193, 255), (boolean)false);
                    } else if (dv > 33.0) {
                        JideSwingUtilities.fillGradient((Graphics2D)g2d, (Shape)cellRect, (Color)new Color(173, 135, 24), (Color)new Color(246, 218, 135), (boolean)false);
                    } else {
                        JideSwingUtilities.fillGradient((Graphics2D)g2d, (Shape)cellRect, (Color)new Color(75, 126, 176), (Color)new Color(170, 208, 246), (boolean)false);
                    }
                    g2d.dispose();
                } else if (value instanceof Integer) {
                    Graphics2D g2d = (Graphics2D)g.create();
                    int dv = (Integer)value;
                    Rectangle clip = new Rectangle(cellRect.x, cellRect.y, (int)((double)(cellRect.width * dv) / 100.0), cellRect.height);
                    g2d.clip(clip);
                    if ((double)dv > 66.0) {
                        JideSwingUtilities.fillGradient((Graphics2D)g2d, (Shape)cellRect, (Color)new Color(147, 98, 184), (Color)new Color(229, 193, 255), (boolean)false);
                    } else if ((double)dv > 33.0) {
                        JideSwingUtilities.fillGradient((Graphics2D)g2d, (Shape)cellRect, (Color)new Color(173, 135, 24), (Color)new Color(246, 218, 135), (boolean)false);
                    } else {
                        JideSwingUtilities.fillGradient((Graphics2D)g2d, (Shape)cellRect, (Color)new Color(75, 126, 176), (Color)new Color(170, 208, 246), (boolean)false);
                    }
                    g2d.dispose();
                }
            }
        });
        LOGGER.info("Current listModel: {}", (Object)this.getListModel());
    }

    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 1: {
                return String.class;
            }
            case 0: {
                return Boolean.class;
            }
            case 3: {
                return Integer.class;
            }
        }
        return Object.class;
    }

    public boolean isCellEditable(int row, int column) {
        return column == 0;
    }

    public ConverterContext getConverterContextAt(int rowIndex, int columnIndex) {
        return null;
    }

    public EditorContext getEditorContextAt(int rowIndex, int columnIndex) {
        EditorContext editorContext = null;
        switch (columnIndex) {
            case 0: {
                editorContext = BooleanCheckBoxCellEditor.CONTEXT;
                break;
            }
            case 3: {
                editorContext = ProgressCellRenderer.CONTEXT;
                break;
            }
        }
        return editorContext;
    }

    public Class<?> getCellClassAt(int rowIndex, int columnIndex) {
        return this.getColumnClass(columnIndex);
    }

    public CellStyle getHeaderStyleAt(int rowIndex, int columnIndex) {
        return columnIndex == 0 ? this.ICON_STYLE : null;
    }

    public boolean isHeaderStyleOn() {
        return true;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.getRowCount()) {
            return null;
        }
        NodeBackupModel nodeBackup = (NodeBackupModel)((Object)this.getRow(rowIndex));
        switch (columnIndex) {
            case 1: {
                return ByteUtils.getUniqueIdAsString((long)nodeBackup.getNode().getUniqueId());
            }
            case 2: {
                return nodeBackup.getNodeLabel();
            }
            case 0: {
                return nodeBackup.isSelected();
            }
            case 3: {
                return nodeBackup.getProgress();
            }
        }
        return null;
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        NodeBackupModel nodeBackup = (NodeBackupModel)((Object)this.getRow(rowIndex));
        switch (columnIndex) {
            case 0: {
                Boolean selected = value != null ? (Boolean)value : false;
                nodeBackup.setSelected(selected);
                break;
            }
        }
        super.setValueAt(value, rowIndex, columnIndex);
    }

    public CellStyle getCellStyleAt(int rowIndex, int columnIndex) {
        return null;
    }

    public boolean isCellStyleOn() {
        return true;
    }
}

