/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.booster.view;

import java.awt.Component;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.model.status.CommandStationStatus;

public class CommandStationStateCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    Map<CommandStationState, ImageIcon> commandStationStateIcons = new LinkedHashMap<CommandStationState, ImageIcon>();

    public CommandStationStateCellRenderer() {
        this.commandStationStateIcons.put(CommandStationState.OFF, ImageUtils.createImageIcon(CommandStationStateCellRenderer.class, (String)"/icons/commandstation/DCC_OFF_00.png"));
        this.commandStationStateIcons.put(CommandStationState.STOP, ImageUtils.createImageIcon(CommandStationStateCellRenderer.class, (String)"/icons/commandstation/DCC_STOP_01.png"));
        this.commandStationStateIcons.put(CommandStationState.SOFTSTOP, ImageUtils.createImageIcon(CommandStationStateCellRenderer.class, (String)"/icons/commandstation/DCC_SOFTSTOP_02.png"));
        this.commandStationStateIcons.put(CommandStationState.GO, ImageUtils.createImageIcon(CommandStationStateCellRenderer.class, (String)"/icons/commandstation/DCC_GO_03.png"));
        this.commandStationStateIcons.put(CommandStationState.PROG, ImageUtils.createImageIcon(CommandStationStateCellRenderer.class, (String)"/icons/commandstation/DCC_PROG_08.png"));
        this.commandStationStateIcons.put(CommandStationState.PROGBUSY, ImageUtils.createImageIcon(CommandStationStateCellRenderer.class, (String)"/icons/commandstation/DCC_PROGBUSY_09.png"));
        this.commandStationStateIcons.put(CommandStationState.BUSY, ImageUtils.createImageIcon(CommandStationStateCellRenderer.class, (String)"/icons/commandstation/DCC_BUSY_0D.png"));
        this.commandStationStateIcons.put(CommandStationState.QUERY, ImageUtils.createImageIcon(CommandStationStateCellRenderer.class, (String)"/icons/commandstation/DCC_QUERY_FF.png"));
        this.commandStationStateIcons.put(CommandStationState.GO_IGN_WD, ImageUtils.createImageIcon(CommandStationStateCellRenderer.class, (String)"/icons/commandstation/DCC_GO_IGN_WD_04.png"));
        this.setHorizontalAlignment(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, null, isSelected, hasFocus, row, column);
        if (value instanceof CommandStationState) {
            CommandStationState commandStationState = (CommandStationState)value;
            Icon icon = this.commandStationStateIcons.get(commandStationState);
            this.setIcon(icon);
            this.setToolTipText(Resources.getString(CommandStationStatus.class, (String)CommandStationStatus.valueOf((CommandStationState)commandStationState).getKey()));
        } else {
            this.setIcon(null);
            this.setToolTipText(null);
        }
        return this;
    }
}

