/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.booster.view;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.bidib.jbidibc.messages.CurrentValue;

public class CurrentCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof Integer) {
            int val = (Integer)value;
            this.setText(this.formatCurrent(val));
        } else if (value instanceof CurrentValue) {
            CurrentValue current = (CurrentValue)value;
            this.setText(this.formatCurrent(current));
        } else {
            this.setText(null);
        }
        return this;
    }

    private String formatCurrent(int current) {
        return String.format("%d mA", current);
    }

    private String formatCurrent(CurrentValue current) {
        switch (current.getCurrentType()) {
            case normal: {
                return String.format("%d mA", current.getCurrent());
            }
            case no_exact_value: {
                return "No exact value!";
            }
            case overcurrent: {
                return "Overcurrent!";
            }
        }
        return null;
    }
}

