/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.loco.view;

import com.formdev.flatlaf.ui.FlatButtonBorder;
import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.FormsSetup;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jidesoft.pane.CollapsiblePane;
import com.jidesoft.pane.event.CollapsiblePaneAdapter;
import com.jidesoft.pane.event.CollapsiblePaneEvent;
import com.jidesoft.pane.event.CollapsiblePaneListener;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideToggleButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSliderUI;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.enums.SpeedStepsEnum;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.beans.WizardPropertyConnector;
import org.bidib.wizard.client.common.binding.SwingPropertyAdapter;
import org.bidib.wizard.client.common.converter.BidibSpeedToDccSpeedConverter;
import org.bidib.wizard.client.common.converter.DirectionStatusToBooleanConverter;
import org.bidib.wizard.client.common.converter.StringConverter;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.client.common.text.IntegerRangeFilter;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.common.script.loco.LocoViewScripting;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.model.loco.LocoModel;
import org.bidib.wizard.model.loco.listener.LocoModelListener;
import org.bidib.wizard.model.status.BinStateValue;
import org.bidib.wizard.model.status.DirectionStatus;
import org.bidib.wizard.model.status.RfBasisMode;
import org.bidib.wizard.model.status.SpeedLevel;
import org.bidib.wizard.model.status.SpeedSteps;
import org.bidib.wizard.mvc.common.view.ViewCloseListener;
import org.bidib.wizard.mvc.common.view.graph.LedBarGraph;
import org.bidib.wizard.mvc.common.view.panel.DisabledPanel;
import org.bidib.wizard.mvc.loco.controller.LocoControlListener;
import org.bidib.wizard.mvc.loco.model.LocoConfigModel;
import org.bidib.wizard.mvc.loco.view.EmptyAddressHandler;
import org.bidib.wizard.mvc.loco.view.ScriptPanel;
import org.bidib.wizard.mvc.loco.view.SpeedGaugeBinding;
import org.bidib.wizard.mvc.loco.view.SpeedGaugeBuilder;
import org.bidib.wizard.mvc.loco.view.listener.LocoViewListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoView
implements LocoViewScripting,
TabPanelProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocoView.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, center:pref:grow";
    private static final String ENCODED_DIALOG_ROW_SPECS = "pref, 3dlu, pref, 3dlu, pref, 9dlu, pref, 3dlu, pref, 3dlu, pref";
    private static final int PAGE_STEPS = 12;
    private final LocoModel locoModel;
    private final LocoConfigModel locoConfigModel;
    private JComboBox<SpeedSteps> speedStepsCombo;
    private JTextField address;
    private JLabel speed;
    private JSlider speedSlider;
    private final JCheckBox directionCheckbox = new JCheckBox();
    private JLabel reportedSpeed;
    private JButton stopButton;
    private JButton stopEmergencyButton;
    private final Map<String, JButton> functionButtonMap = new HashMap<String, JButton>();
    private final List<LocoViewListener> locoViewListeners = new LinkedList<LocoViewListener>();
    private final List<ViewCloseListener> viewCloseListeners = new LinkedList<ViewCloseListener>();
    private final LocoModelListener locoModelListener;
    private JPanel directionPanel;
    private JPanel lightAndStopButtonPanel;
    private JPanel functionButtonPanel;
    private JPanel multiRfBaseButtonPanel;
    private JPanel counterPanel;
    private JPanel directBinStatePanel;
    private ScriptPanel scriptPanel;
    private LedBarGraph ledBarGraph;
    private JPanel contentPanel;
    private JLabel locoImage;
    private boolean m4SupportEnabled;
    private final Consumer<Integer> locoAddressChangeListener;
    private final LocoControlListener locoControlListener;
    private final PropertyChangeListener locoModelPropertyChangeListener;
    private final WizardPropertyConnector addressChangeConnector;
    private final Runnable resizeCallback;
    private final EmptyAddressHandler addressChangeHandler;
    private JComponent[] rfBaseButtons;
    private JComponent[] devBinStateValueButtons;
    private BlinkerLed blinkerRight;
    private BlinkerLed blinkerLeft;

    public LocoView(LocoModel locoModel, LocoConfigModel locoConfigModel, SettingsService settingsService, LocoControlListener locoControlListener, Consumer<Integer> locoAddressChangeListener, Runnable resizeCallback) {
        Object panel;
        this.locoModel = locoModel;
        this.locoConfigModel = locoConfigModel;
        this.locoAddressChangeListener = locoAddressChangeListener;
        this.locoControlListener = locoControlListener;
        this.resizeCallback = resizeCallback;
        this.m4SupportEnabled = settingsService.getWizardSettings().isM4SupportEnabled();
        FormBuilder formBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new FormDebugPanel(){
                private static final long serialVersionUID = 1L;

                public String getName() {
                    return Resources.getString(LocoView.class, (String)("title." + (LocoView.this.locoConfigModel.isCarControlEnabled() ? "car" : "loco")));
                }

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width + 20, super.getPreferredSize().height);
                }
            };
            formBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout()){
                private static final long serialVersionUID = 1L;

                @Override
                public String getName() {
                    return Resources.getString(LocoView.class, (String)("title." + (LocoView.this.locoConfigModel.isCarControlEnabled() ? "car" : "loco")));
                }
            };
            formBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        formBuilder.border((Border)Paddings.TABBED_DIALOG);
        try {
            formBuilder.add((Component)this.createLocoAddressPanel()).xy(1, 1);
        }
        catch (Exception ex) {
            LOGGER.warn("Create loco address panel failed.", (Throwable)ex);
        }
        try {
            this.directionPanel = this.createDirectionPanel();
            formBuilder.add((Component)this.directionPanel).xy(1, 3);
            DisabledPanel.disable(this.directionPanel);
            formBuilder.add((Component)this.createSpeedGaugePanel()).xywh(3, 1, 1, 7);
        }
        catch (Exception ex) {
            LOGGER.warn("Create direction panel failed.", (Throwable)ex);
        }
        final LinkedList<JideButton> functionButtons = new LinkedList<JideButton>();
        try {
            this.lightAndStopButtonPanel = this.createLightAndStopButtonPanel(functionButtons);
            formBuilder.add((Component)this.lightAndStopButtonPanel).xy(1, 5);
            DisabledPanel.disable(this.lightAndStopButtonPanel);
        }
        catch (Exception ex) {
            LOGGER.warn("Create light and buttons panel failed.", (Throwable)ex);
        }
        boolean powerUser = settingsService.getWizardSettings().isPowerUser();
        int row = 11;
        try {
            this.functionButtonPanel = this.createFunctionButtonPanel(functionButtons);
            formBuilder.add((Component)this.functionButtonPanel).xyw(1, 7, 1);
            DisabledPanel.disable(this.functionButtonPanel);
            this.locoImage = new JLabel();
            formBuilder.add((Component)this.locoImage).xy(3, 9);
            if (this.locoConfigModel.isCarControlEnabled()) {
                boolean debug = false;
                FormBuilder detailFormBuilder = FormBuilder.create().columns("p, 3dlu, p, 3dlu, min(p;30dlu), 3dlu, p:g:fill", new Object[0]).rows("top:p, 3dlu, p, 3dlu, p", new Object[0]).panel((JPanel)(debug ? new FormDebugPanel() : new JPanel()));
                this.multiRfBaseButtonPanel = this.addMultiRfBasisButtons();
                detailFormBuilder.add((Component)this.multiRfBaseButtonPanel).xyw(1, 1, 1);
                DisabledPanel.disable(this.multiRfBaseButtonPanel);
                detailFormBuilder.appendRows("3dlu, pref", new Object[0]);
                this.directBinStatePanel = this.addDirectBinStatePanel();
                detailFormBuilder.add((Component)this.directBinStatePanel).xy(1, 3);
                DisabledPanel.disable(this.directBinStatePanel);
                JPanel speedSliderPanel = detailFormBuilder.build();
                CollapsiblePane pane = new CollapsiblePane(Resources.getString(LocoView.class, (String)"multiRFBasis"));
                pane.setContentPane((JComponent)JideSwingUtilities.createTopPanel((Component)speedSliderPanel));
                pane.setCollapsed(true);
                pane.addCollapsiblePaneListener((CollapsiblePaneListener)new CollapsiblePaneAdapter(){

                    public void paneExpanded(CollapsiblePaneEvent event) {
                        LOGGER.info("pane expanded.");
                        if (LocoView.this.contentPanel != null) {
                            LocoView.this.contentPanel.invalidate();
                        }
                        if (LocoView.this.resizeCallback != null) {
                            LocoView.this.resizeCallback.run();
                        }
                    }

                    public void paneCollapsed(CollapsiblePaneEvent event) {
                        LOGGER.info("pane collapsed.");
                        if (LocoView.this.contentPanel != null) {
                            LocoView.this.contentPanel.invalidate();
                        }
                        if (LocoView.this.resizeCallback != null) {
                            LocoView.this.resizeCallback.run();
                        }
                    }
                });
                formBuilder.add((Component)pane).xyw(1, 9, 3);
            } else {
                LOGGER.info("No multi RF basis buttons added.");
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Create function buttons panel failed.", (Throwable)ex);
        }
        if (powerUser) {
            this.scriptPanel = new ScriptPanel(this, settingsService);
            this.addLocoViewListener(this.scriptPanel);
            JPanel panel2 = this.scriptPanel.createPanel();
            panel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Resources.getString(this.getClass(), (String)"script") + ":"));
            formBuilder.appendRows("3dlu, pref", new Object[0]);
            formBuilder.add((Component)panel2).xyw(1, row, 3);
        }
        this.locoModelListener = new LocoModelListener(){

            public void functionChanged(int index, boolean value) {
                SwingUtils.executeInEDT(() -> ((JideButton)functionButtons.get(index)).setSelected(value));
            }

            public void binaryStateChanged(int state, boolean value) {
            }
        };
        this.locoModel.addLocoModelListener(this.locoModelListener);
        this.locoModelPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SwingUtils.executeInEDT(() -> LocoView.this.handlePropertyChangeEvent(evt));
            }
        };
        this.locoModel.addPropertyChangeListener(this.locoModelPropertyChangeListener);
        this.contentPanel = formBuilder.build();
        this.addressChangeHandler = new EmptyAddressHandler(value -> SwingUtils.executeInEDT(() -> {
            LOGGER.info("The address value is not empty: {}", value);
            if (value.booleanValue()) {
                SpeedSteps speedSteps = this.locoModel.getSpeedSteps();
                this.speedStepsCombo.setSelectedItem(speedSteps);
                Integer currentSpeed = this.locoModel.getSpeed();
                if (currentSpeed != null) {
                    this.changeSliderSilently(currentSpeed);
                    if (currentSpeed == 0) {
                        this.enableDirectionCheckbox(true);
                    }
                }
                this.changeDirectionSilently(this.locoModel.getDirection());
                DisabledPanel.enable(this.directionPanel);
                DisabledPanel.enable(this.lightAndStopButtonPanel);
                DisabledPanel.enable(this.functionButtonPanel);
                if (this.multiRfBaseButtonPanel != null) {
                    DisabledPanel.enable(this.multiRfBaseButtonPanel);
                }
                if (this.counterPanel != null) {
                    DisabledPanel.enable(this.counterPanel);
                }
                if (this.directBinStatePanel != null) {
                    DisabledPanel.enable(this.directBinStatePanel);
                }
            } else {
                DisabledPanel.disable(this.directionPanel);
                DisabledPanel.disable(this.lightAndStopButtonPanel);
                DisabledPanel.disable(this.functionButtonPanel);
                if (this.multiRfBaseButtonPanel != null) {
                    DisabledPanel.disable(this.multiRfBaseButtonPanel);
                }
                if (this.counterPanel != null) {
                    DisabledPanel.disable(this.counterPanel);
                }
                if (this.directBinStatePanel != null) {
                    DisabledPanel.disable(this.directBinStatePanel);
                }
            }
        }));
        this.addressChangeConnector = WizardPropertyConnector.connect((Object)this.locoModel, (String)"address", (Object)this.addressChangeHandler, (String)"address");
        this.addressChangeConnector.updateProperty2();
        if (this.locoModel != null) {
            this.changeLocoImage(this.locoModel.getLocoImagePath());
        }
        this.registerKeystroke(this.contentPanel, 112, "F1");
        this.registerKeystroke(this.contentPanel, 113, "F2");
        this.registerKeystroke(this.contentPanel, 114, "F3");
        this.registerKeystroke(this.contentPanel, 115, "F4");
        this.registerKeystroke(this.contentPanel, 116, "F5");
        this.registerKeystroke(this.contentPanel, 117, "F6");
        this.registerKeystroke(this.contentPanel, 118, "F7");
        this.registerKeystroke(this.contentPanel, 119, "F8");
        this.registerKeystroke(this.contentPanel, 120, "F9");
        this.registerKeystroke(this.contentPanel, 121, "F10");
        this.registerKeystroke(this.contentPanel, 122, "F11");
        this.registerKeystroke(this.contentPanel, 123, "F12");
    }

    private void registerKeystroke(JPanel contentPanel, int keyEvent, final String key) {
        KeyStroke ksF2 = KeyStroke.getKeyStroke(keyEvent, 0);
        contentPanel.getInputMap(2).put(ksF2, key);
        contentPanel.getActionMap().put(key, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.info("{} is pressed.", (Object)key);
                JButton button = LocoView.this.functionButtonMap.get(key);
                if (button != null) {
                    button.doClick();
                }
            }
        });
    }

    private void enableDirectionCheckbox(boolean enabled) {
        if (enabled && this.locoConfigModel.isCarControlEnabled()) {
            enabled = false;
        }
        this.directionCheckbox.setEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePropertyChangeEvent(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "address": {
                LOGGER.info("The address has changed, set the reported speed and dynState energy to 0.");
                break;
            }
            case "direction": {
                LOGGER.info("The direction has changed: {}", (Object)this.locoModel.getDirection());
                this.changeDirectionSilently(this.locoModel.getDirection());
                break;
            }
            case "locoImagePath": {
                LOGGER.info("The locoImagePath has changed: {}", (Object)this.locoModel.getLocoImagePath());
                this.changeLocoImage(this.locoModel.getLocoImagePath());
                break;
            }
            case "speed": {
                LOGGER.info("The speed has changed: {}", (Object)this.locoModel.getSpeed());
                try {
                    SpeedStepsEnum speedSteps;
                    Integer speedValue = this.locoModel.getSpeed();
                    if (speedValue == null) break;
                    int currentSpeed = speedValue;
                    SpeedStepsEnum speedStepsEnum = speedSteps = this.locoModel.getSpeedSteps() != null ? this.locoModel.getSpeedSteps().getType() : SpeedStepsEnum.DCC128;
                    if (currentSpeed == 0) {
                        LOGGER.info("The current speed is stop or emergengy stop: {}, direction: {}", (Object)currentSpeed, (Object)this.locoModel.getDirection());
                        this.changeSliderSilently(0);
                        break;
                    }
                    LOGGER.info("Set the current speed value: {}, direction: {}", (Object)currentSpeed, (Object)this.locoModel.getDirection());
                    this.changeSliderSilently(currentSpeed);
                }
                catch (Exception ex) {
                    LOGGER.warn("Set speed failed.", (Throwable)ex);
                }
                break;
            }
            case "speedSteps": {
                SpeedSteps speedSteps = this.locoModel.getSpeedSteps();
                LOGGER.info(">>> The speed steps have changed: {}", (Object)speedSteps);
                if (speedSteps != null) {
                    ChangeListener[] changeListeners = this.speedSlider.getChangeListeners();
                    try {
                        for (ChangeListener cl : changeListeners) {
                            this.speedSlider.removeChangeListener(cl);
                        }
                        int steps = this.getSteps();
                        this.speedSlider.setMaximum(steps);
                        this.speedSlider.setMinimum(0);
                        this.speedSlider.setMajorTickSpacing(steps);
                        this.speedSlider.setMinorTickSpacing(steps);
                        this.speedSlider.setLabelTable(this.speedSlider.createStandardLabels(steps));
                    }
                    finally {
                        for (ChangeListener cl : changeListeners) {
                            this.speedSlider.addChangeListener(cl);
                        }
                    }
                }
                LOGGER.info("<<< The speed steps have changed: {}", (Object)speedSteps);
                break;
            }
            case "functions": {
                LOGGER.info("The functions have changed: {}", (Object)this.locoModel.getFunctions());
                this.updateFunctionState(this.locoModel.getFunctions(), this.functionButtonMap);
                break;
            }
            case "dynStateEnergy": {
                int dynStateEnergy = this.locoModel.getDynStateEnergy();
                LOGGER.info("The dynStateEnergy has changed, dynStateEnergy: {}", (Object)dynStateEnergy);
                if (this.ledBarGraph == null) break;
                SwingUtils.executeInEDT(() -> this.ledBarGraph.setValue(dynStateEnergy));
                break;
            }
            case "reportedSpeed": {
                Integer reportedSpeed = this.locoModel.getReportedSpeed();
                LOGGER.info("The reported speed has changed in the locoModel. Send the new speed value: {}", (Object)reportedSpeed);
                break;
            }
        }
    }

    protected Map<String, JButton> getFunctionButtonMap() {
        return this.functionButtonMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeSliderSilently(int speed) {
        ChangeListener[] changeListeners;
        for (ChangeListener listener : changeListeners = this.speedSlider.getChangeListeners()) {
            this.speedSlider.removeChangeListener(listener);
        }
        try {
            this.speedSlider.setValue(speed);
        }
        finally {
            for (ChangeListener listener : changeListeners) {
                this.speedSlider.addChangeListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeDirectionSilently(DirectionStatus direction) {
        ChangeListener[] changeListeners;
        LOGGER.info("changeDirectionSilently, direction: {}", (Object)direction);
        for (ChangeListener listener : changeListeners = this.directionCheckbox.getChangeListeners()) {
            this.directionCheckbox.removeChangeListener(listener);
        }
        try {
            this.directionCheckbox.setSelected(DirectionStatus.BACKWARD == direction);
        }
        finally {
            for (ChangeListener listener : changeListeners) {
                this.directionCheckbox.addChangeListener(listener);
            }
        }
    }

    private void changeLocoImage(String locoImagePath) {
        ImageIcon icon = null;
        if (StringUtils.isNotBlank((CharSequence)locoImagePath)) {
            try {
                File imageFile = new File(locoImagePath);
                if (imageFile.exists()) {
                    icon = ImageUtils.loadImageIcon((File)imageFile, (int)200, (int)87);
                } else {
                    LOGGER.info("The loco image file does not exist: {}", (Object)locoImagePath);
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Load loco image failed, locoImagePath: {}", (Object)locoImagePath, (Object)ex);
            }
        }
        this.locoImage.setIcon(icon);
    }

    public JPanel getComponent() {
        return this.contentPanel;
    }

    private JPanel createLocoAddressPanel() {
        FormBuilder formBuilder = FormBuilder.create().columns("pref, 3dlu, 40dlu, 3dlu, pref, 10dlu, pref, 3dlu, 60dlu, 10dlu, pref, 3dlu:grow", new Object[0]).rows("pref", new Object[0]);
        AbstractAction enterAddressAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                Integer currentAddress = null;
                if (!LocoView.this.address.getText().isEmpty()) {
                    try {
                        currentAddress = Integer.valueOf(LocoView.this.address.getText());
                    }
                    catch (NumberFormatException ex) {
                        LOGGER.warn("Parse decoder address failed.");
                        return;
                    }
                }
                if (LocoView.this.locoModel != null && currentAddress == null && LocoView.this.locoModel.getAddress() == null || currentAddress != null && currentAddress.equals(LocoView.this.locoModel.getAddress())) {
                    LOGGER.info("Address has not been changed.");
                    return;
                }
                LOGGER.info("Get the locoModel for the new address: {}", (Object)currentAddress);
                LocoView.this.locoAddressChangeListener.accept(currentAddress);
            }
        };
        this.address = new JTextField();
        this.address.setDocument((Document)new InputValidationDocument(5, "0123456789"));
        this.address.addActionListener(enterAddressAction);
        if (this.locoModel.getAddress() != null) {
            this.address.setText(Integer.toString(this.locoModel.getAddress()));
        } else {
            this.address.setText(null);
        }
        formBuilder.add(Resources.getString(this.getClass(), (String)"address"), new Object[0]).xy(1, 1);
        formBuilder.add((Component)this.address).xy(3, 1);
        ImageIcon acceptIcon = ImageUtils.loadImageIcon(this.getClass(), (String)"/icons/16x16/add.png", (int)16, (int)16);
        JButton acceptButton = new JButton(acceptIcon);
        acceptButton.setToolTipText(Resources.getString(this.getClass(), (String)"acceptLoco"));
        acceptButton.addActionListener(enterAddressAction);
        formBuilder.add((Component)acceptButton).xy(5, 1);
        if (this.m4SupportEnabled) {
            this.speedStepsCombo = new JComboBox<SpeedSteps>(SpeedSteps.values());
        } else {
            ArrayList<SpeedSteps> speedSteps = new ArrayList<SpeedSteps>();
            speedSteps.addAll(Arrays.asList(SpeedSteps.values()));
            CollectionUtils.filter(speedSteps, (Predicate)new Predicate<SpeedSteps>(){

                public boolean evaluate(SpeedSteps speedStep) {
                    return speedStep.ordinal() <= SpeedSteps.DCC_SDF.ordinal();
                }
            });
            this.speedStepsCombo = new JComboBox<SpeedSteps>(speedSteps.toArray(new SpeedSteps[0]));
        }
        this.speedStepsCombo.setEnabled(false);
        this.speedStepsCombo.setSelectedItem(this.locoModel.getSpeedSteps() != null ? this.locoModel.getSpeedSteps() : SpeedSteps.DCC128);
        this.speedStepsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpeedSteps speedSteps = (SpeedSteps)LocoView.this.speedStepsCombo.getSelectedItem();
                LOGGER.info("Speed steps combo has changed, update loco model: {}", (Object)speedSteps);
                LocoView.this.locoControlListener.setSpeedSteps(speedSteps);
                LocoView.this.locoModel.setSpeedSteps(speedSteps);
                int steps = LocoView.this.getSteps();
                LocoView.this.speedSlider.setMaximum(steps);
                LocoView.this.speedSlider.setMajorTickSpacing(steps);
                LocoView.this.speedSlider.setMinorTickSpacing(steps);
                LocoView.this.speedSlider.setLabelTable(LocoView.this.speedSlider.createStandardLabels(steps));
            }
        });
        formBuilder.add(Resources.getString(this.getClass(), (String)"speedSteps"), new Object[0]).xy(7, 1);
        formBuilder.add(this.speedStepsCombo).xyw(9, 1, 1);
        JButton removeButton = new JButton(Resources.getString(LocoView.class, (String)"remove"));
        removeButton.setToolTipText(Resources.getString(LocoView.class, (String)"remove.tooltip"));
        removeButton.addActionListener(evt -> {
            LOGGER.info("Remove loco from DCC refresh.");
            this.locoControlListener.clearLoco();
        });
        formBuilder.add((Component)removeButton).xyw(11, 1, 2);
        return formBuilder.build();
    }

    private int getSteps() {
        int steps = this.locoModel.getSpeedSteps() != null ? this.locoModel.getSpeedSteps().getSteps() - 1 : SpeedSteps.DCC128.getSteps() - 1;
        LOGGER.info("Current steps: {}", (Object)steps);
        return steps;
    }

    private JPanel createDirectionPanel() {
        FormBuilder formBuilder = FormBuilder.create().columns("pref, 3dlu, 60dlu:grow, 3dlu, pref", new Object[0]).rows("pref, 3dlu, pref, 3dlu, pref, 3dlu, pref", new Object[0]);
        formBuilder.border((Border)new EmptyBorder(10, 0, 10, 0));
        SwingPropertyAdapter speedModel = new SwingPropertyAdapter((Object)this.locoModel, "speed", true);
        ConverterValueModel speedConverterModel = new ConverterValueModel((ValueModel)speedModel, (BindingConverter)new BidibSpeedToDccSpeedConverter());
        this.speed = WizardComponentFactory.createLabel((ValueModel)speedConverterModel);
        formBuilder.add(Resources.getString(this.getClass(), (String)"speed"), new Object[0]).xy(1, 1);
        formBuilder.add((Component)this.speed).xy(3, 1);
        SwingPropertyAdapter reportedSpeedModel = new SwingPropertyAdapter((Object)this.locoModel, "reportedSpeed", true);
        ConverterValueModel reportedSpeedConverterModel = new ConverterValueModel((ValueModel)reportedSpeedModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        this.reportedSpeed = WizardComponentFactory.createLabel((ValueModel)reportedSpeedConverterModel);
        formBuilder.add(Resources.getString(this.getClass(), (String)"reportedSpeed"), new Object[0]).xy(1, 3);
        formBuilder.add((Component)this.reportedSpeed).xy(3, 3);
        this.speedSlider = new JSlider();
        final int steps = this.getSteps();
        this.speedSlider.setMaximum(steps);
        this.speedSlider.setMajorTickSpacing(steps);
        this.speedSlider.setMinorTickSpacing(steps);
        this.speedSlider.setMinimum(0);
        this.speedSlider.setPaintLabels(true);
        this.speedSlider.setLabelTable(this.speedSlider.createStandardLabels(steps));
        InputMap keyMap = (InputMap)UIManager.get("Slider.focusInputMap", this.speedSlider.getLocale());
        if (LOGGER.isDebugEnabled() && keyMap != null) {
            Object binding = keyMap.get(KeyStroke.getKeyStroke(36, 0));
            LOGGER.debug("HOME is binded: {}", binding);
        }
        this.speedSlider.getInputMap().put(KeyStroke.getKeyStroke(36, 0), "speedToMaxValue");
        this.speedSlider.getInputMap().put(KeyStroke.getKeyStroke(35, 0), "speedToMinValue");
        this.speedSlider.getInputMap().put(KeyStroke.getKeyStroke(33, 0), "speedUpValue");
        this.speedSlider.getInputMap().put(KeyStroke.getKeyStroke(34, 0), "speedDownValue");
        this.speedSlider.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "speedStop");
        this.speedSlider.getActionMap().put("speedToMaxValue", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.info("speedToMaxValue was called.");
                int steps = LocoView.this.locoModel.getSpeedSteps().getSteps() - 1;
                LocoView.this.speedSlider.setValue(steps);
            }
        });
        this.speedSlider.getActionMap().put("speedToMinValue", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.info("speedToMinValue was called.");
                LocoView.this.speedSlider.setValue(0);
            }
        });
        this.speedSlider.getActionMap().put("speedUpValue", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Integer speed = LocoView.this.locoModel.getSpeed();
                DirectionStatus dir = LocoView.this.locoModel.getDirection();
                LOGGER.info("speedUpValue was called, current speed: {}, dir: {}", (Object)speed, (Object)dir);
                if (speed == null) {
                    speed = 0;
                }
                if (speed < steps) {
                    speed = speed + 12;
                }
                if (speed > steps) {
                    speed = steps;
                }
                LOGGER.info("speedUpValue was called, new speed: {}", (Object)speed);
                LocoView.this.speedSlider.setValue(speed);
            }
        });
        this.speedSlider.getActionMap().put("speedDownValue", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Integer speed = LocoView.this.locoModel.getSpeed();
                DirectionStatus dir = LocoView.this.locoModel.getDirection();
                LOGGER.info("speedDownValue was called, current speed: {}, dir: {}", (Object)speed, (Object)dir);
                if (speed == null) {
                    speed = 0;
                }
                if (speed > 0) {
                    speed = speed - 13;
                }
                if (speed < 0) {
                    speed = 0;
                }
                LOGGER.info("speedDownValue was called, new speed: {}", (Object)speed);
                LocoView.this.speedSlider.setValue(speed);
            }
        });
        this.speedSlider.getActionMap().put("speedStop", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.info("speedStop was called.");
                LocoView.this.fireStop();
            }
        });
        this.speedSlider.setValue(0);
        this.speedSlider.addChangeListener(e -> {
            JSlider source = (JSlider)e.getSource();
            if (!source.getValueIsAdjusting()) {
                int value = this.speedSlider.getValue();
                LOGGER.info("Current speedSlider value: {}", (Object)value);
                DirectionStatus direction = this.directionCheckbox.isSelected() ? DirectionStatus.BACKWARD : DirectionStatus.FORWARD;
                LOGGER.info("Set the speed value: {}, direction: {}", (Object)value, (Object)direction);
                this.locoControlListener.setSpeed(new SpeedLevel(Integer.valueOf(value), this.locoModel.getSpeedSteps(), direction));
            }
        });
        this.speedSlider.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JSlider sourceSlider = (JSlider)e.getSource();
                BasicSliderUI ui = (BasicSliderUI)sourceSlider.getUI();
                int value = ui.valueForXPosition(e.getX());
                e.consume();
                LOGGER.info("Mouse pressed on slider. Set the new value: {}", (Object)value);
                LocoView.this.speedSlider.setValue(value);
            }
        });
        int speedDelta = 1;
        this.speedSlider.addMouseWheelListener(evt -> {
            if (evt.getWheelRotation() < 0) {
                int iNewValue = this.speedSlider.getValue() - speedDelta;
                if (iNewValue >= this.speedSlider.getMinimum()) {
                    this.speedSlider.setValue(iNewValue);
                } else {
                    this.speedSlider.setValue(0);
                }
            } else {
                int iNewValue = this.speedSlider.getValue() + speedDelta;
                if (iNewValue <= this.speedSlider.getMaximum()) {
                    this.speedSlider.setValue(iNewValue);
                } else {
                    this.speedSlider.setValue(this.speedSlider.getMaximum());
                }
            }
        });
        formBuilder.add((Component)this.speedSlider).xyw(1, 5, 3);
        ImageIcon backwardsIcon = ImageUtils.createImageIcon(LocoView.class, (String)"/icons/locolist/arrow_left.png");
        ImageIcon forwardsIcon = ImageUtils.createImageIcon(LocoView.class, (String)"/icons/locolist/arrow_right.png");
        this.directionCheckbox.setIcon(forwardsIcon);
        this.directionCheckbox.setSelectedIcon(backwardsIcon);
        this.directionCheckbox.setBorder((Border)new FlatButtonBorder());
        this.directionCheckbox.setBorderPainted(true);
        this.directionCheckbox.setBorderPaintedFlat(true);
        this.directionCheckbox.setToolTipText(Resources.getString(this.getClass(), (String)"changeDirection.tooltip"));
        SwingPropertyAdapter directionModel = new SwingPropertyAdapter((Object)this.locoModel, "direction", true);
        ConverterValueModel directionConverterModel = new ConverterValueModel((ValueModel)directionModel, (BindingConverter)new DirectionStatusToBooleanConverter());
        Bindings.bind((AbstractButton)this.directionCheckbox, (ValueModel)directionConverterModel);
        this.enableDirectionCheckbox(false);
        formBuilder.add((Component)this.directionCheckbox).xyw(5, 5, 1);
        JPanel helperPanel = new JPanel(new BorderLayout());
        helperPanel.setOpaque(false);
        this.ledBarGraph = new LedBarGraph(10, LedBarGraph.Orientation.vertical);
        this.ledBarGraph.setOpaque(FormsSetup.getOpaqueDefault());
        helperPanel.add((Component)formBuilder.build(), "Center");
        helperPanel.add((Component)this.ledBarGraph, "East");
        this.locoModel.addPropertyChangeListener("carControlEnabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LOGGER.info(">>> Received pce: {}", (Object)evt);
                if ("carControlEnabled".equals(evt.getPropertyName())) {
                    SwingUtils.executeInEDT(() -> {
                        LOGGER.info("The car control enabled flag has changed.");
                        if (LocoView.this.locoModel.getSpeedSteps() != null) {
                            int steps = LocoView.this.locoModel.getSpeedSteps().getSteps() - 1;
                            LocoView.this.speedSlider.setMaximum(steps);
                            LocoView.this.speedSlider.setMajorTickSpacing(steps);
                            LocoView.this.speedSlider.setMinorTickSpacing(steps);
                            try {
                                LocoView.this.speedSlider.setMinimum(0);
                            }
                            finally {
                                LocoView.this.locoControlListener.setSpeed(new SpeedLevel(null, LocoView.this.locoModel.getSpeedSteps(), null));
                            }
                        }
                    });
                }
            }
        });
        this.locoModel.addPropertyChangeListener("speed", evt -> {
            LOGGER.info(">>> Received pce for speed: {}", (Object)evt);
            if ("speed".equals(evt.getPropertyName())) {
                SwingUtils.executeInEDT(this::updateEnabledComponents);
            }
        });
        this.updateEnabledComponents();
        return helperPanel;
    }

    private void updateEnabledComponents() {
        boolean stopped = this.isSpeedStopped(this.locoModel.getSpeed());
        this.speedStepsCombo.setEnabled(stopped);
        this.enableDirectionCheckbox(stopped);
    }

    private boolean isSpeedStopped(Integer speed) {
        boolean stopped = false;
        if (speed != null) {
            if (speed == 0) {
                stopped = true;
            }
        } else {
            stopped = true;
        }
        return stopped;
    }

    private JComponent createSpeedGaugePanel() {
        SpeedGaugeBinding speedGauge = SpeedGaugeBuilder.speedGauge("Speed", "km/h");
        speedGauge.setPreferredSize(new Dimension(200, 200));
        speedGauge.setMaximumSize(new Dimension(200, 200));
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BorderLayout());
        panel.add((Component)((Object)speedGauge), "North");
        SwingPropertyAdapter reportedSpeedModel = new SwingPropertyAdapter((Object)this.locoModel, "reportedSpeed", true);
        Bindings.bind((JComponent)((Object)speedGauge), (String)"valueAnimated", (ValueModel)reportedSpeedModel);
        return panel;
    }

    private JPanel createLightAndStopButtonPanel(List<JideButton> functionButtons) {
        FormBuilder formBuilder = FormBuilder.create().columns("pref, 3dlu, 60dlu:grow, 3dlu, pref", new Object[0]).rows("pref", new Object[0]);
        ImageIcon lightOnIcon = ImageUtils.createImageIcon(LocoView.class, (String)"/icons/16x16/lightbulb.png");
        ImageIcon lightOffIcon = ImageUtils.createImageIcon(LocoView.class, (String)"/icons/16x16/lightbulb_off.png");
        JideToggleButton lightButton = new JideToggleButton((Icon)lightOffIcon);
        lightButton.setSelectedIcon((Icon)lightOnIcon);
        lightButton.setRolloverSelectedIcon((Icon)lightOnIcon);
        lightButton.setButtonStyle(1);
        lightButton.addActionListener(evt -> this.locoControlListener.setFunction(0, lightButton.isSelected()));
        functionButtons.add((JideButton)lightButton);
        this.functionButtonMap.put("F0", (JButton)lightButton);
        formBuilder.add((Component)lightButton).xy(1, 1);
        lightButton.setSelected(this.locoModel.getFunction(0));
        JPanel stopPanel = new JPanel(new GridBagLayout());
        stopPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Resources.getString(this.getClass(), (String)"stopLoco") + ":"));
        this.stopButton = new JButton(Resources.getString(this.getClass(), (String)"stop"));
        this.stopButton.addActionListener(evt -> this.fireStop());
        this.stopEmergencyButton = new JButton(Resources.getString(this.getClass(), (String)"emergencyStop"));
        this.stopEmergencyButton.addActionListener(evt -> this.fireEmergencyStop());
        JPanel buttonPanel = new ButtonBarBuilder().addGlue().addButton(new JComponent[]{this.stopButton, this.stopEmergencyButton}).build();
        formBuilder.add((Component)buttonPanel).xy(3, 1);
        return formBuilder.build();
    }

    private JPanel createFunctionButtonPanel(List<JideButton> functionButtons) {
        FormBuilder formBuilder = FormBuilder.create().columns("pref, 8dlu, pref, 8dlu, pref, 8dlu, pref, 8dlu, pref, 8dlu, pref, 8dlu, pref, 8dlu, pref, 8dlu, pref, 8dlu, pref", new Object[0]).rows("pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref", new Object[0]);
        formBuilder.addSeparator(Resources.getString(this.getClass(), (String)"additionalFunctions"), new Object[0]).xyw(1, 1, 19);
        int columns = 10;
        for (int row = 0; row < 4; ++row) {
            for (int column = 0; column < 10; ++column) {
                int functionIndex = row * 10 + (column + 1);
                String buttonText = "F" + functionIndex;
                if (functionIndex > 28) {
                    buttonText = "B" + functionIndex;
                }
                JideToggleButton functionButton = new JideToggleButton(buttonText);
                functionButton.setButtonStyle(1);
                functionButton.addActionListener(arg_0 -> this.lambda$createFunctionButtonPanel$10(functionIndex, (JideButton)functionButton, arg_0));
                functionButtons.add((JideButton)functionButton);
                this.functionButtonMap.put(buttonText, (JButton)functionButton);
                formBuilder.add((Component)functionButton).xy(column * 2 + 1, row * 2 + 3);
                if (functionIndex >= 29) continue;
                functionButton.setSelected(this.locoModel.getFunction(functionIndex));
            }
        }
        return formBuilder.build();
    }

    protected void updateFunctionState(BitSet functions, Map<String, JButton> functionButtonMap) {
        int maxFunctionIndex = functions.size();
        LOGGER.info("Current functions count: {}", (Object)maxFunctionIndex);
        for (int index = 0; index < maxFunctionIndex; ++index) {
            JButton functionButton;
            boolean value;
            String buttonText;
            if (index < 29) {
                buttonText = "F" + index;
                value = functions.get(index);
                functionButton = functionButtonMap.get(buttonText);
                if (functionButton != null) {
                    functionButton.setSelected(value);
                    continue;
                }
                LOGGER.warn("No functionButton available for index: {}", (Object)index);
                continue;
            }
            buttonText = "B" + index;
            value = functions.get(index);
            functionButton = functionButtonMap.get(buttonText);
            if (functionButton != null) {
                functionButton.setSelected(value);
                continue;
            }
            LOGGER.debug("No binary functionButton available for index: {}", (Object)index);
        }
    }

    private JPanel addMultiRfBasisButtons() {
        FormBuilder formBuilder = FormBuilder.create().columns("pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref:grow", new Object[0]).rows("pref, 3dlu, pref", new Object[0]);
        SwingPropertyAdapter activeBaseModel = new SwingPropertyAdapter((Object)this.locoModel, "activeBase", true);
        this.rfBaseButtons = new JComponent[RfBasisMode.values().length];
        int column = 0;
        int col = 0;
        int row = 1;
        for (RfBasisMode rfBaseMode : RfBasisMode.values()) {
            JRadioButton radio = WizardComponentFactory.createRadioButton((ValueModel)activeBaseModel, (Object)rfBaseMode, (String)Resources.getString(RfBasisMode.class, (String)rfBaseMode.getKey()));
            this.rfBaseButtons[column] = radio;
            formBuilder.add((Component)radio).xy(col * 2 + 1, row);
            ++column;
            ++col;
            if (rfBaseMode != RfBasisMode.SINGLE) continue;
            formBuilder.appendRows("3dlu, pref", new Object[0]);
            col = 0;
            row += 2;
        }
        formBuilder.appendRows("3dlu, pref", new Object[0]);
        col = 0;
        SwingPropertyAdapter reportedCellNumberModel = new SwingPropertyAdapter((Object)this.locoModel, "reportedCellNumber", true);
        ConverterValueModel reportedCellNumberConverterModel = new ConverterValueModel((ValueModel)reportedCellNumberModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        JTextField reportedCellNumberText = WizardComponentFactory.createTextField((ValueModel)reportedCellNumberConverterModel, (boolean)false);
        reportedCellNumberText.setEditable(false);
        formBuilder.add("Reported RF Cellnumber", new Object[0]).xyw(1, row += 2, 5);
        formBuilder.add((Component)reportedCellNumberText).xy(7, row);
        activeBaseModel.addValueChangeListener(evt -> {
            Integer functionIndex;
            LOGGER.info("The active RF base has changed: {}", evt.getNewValue());
            RfBasisMode activeRfBase = this.locoModel.getActiveBase();
            if (activeRfBase != null && (functionIndex = activeRfBase.getFunctionIndex()) != null) {
                this.locoControlListener.setBinaryState(functionIndex, true);
            }
        });
        return formBuilder.build();
    }

    private JPanel addCounterPanel() {
        FormBuilder formBuilder = FormBuilder.create().columns("pref, 5dlu, pref:grow", new Object[0]).rows("pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref", new Object[0]);
        formBuilder.addSeparator(Resources.getString(this.getClass(), (String)"Counter"), new Object[0]).xyw(1, 1, 3);
        SwingPropertyAdapter counterCsDriveModel = new SwingPropertyAdapter((Object)this.locoModel, "counterCsDrive", true);
        ConverterValueModel counterCsDriveConverterModel = new ConverterValueModel((ValueModel)counterCsDriveModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        JTextField counterCsDriveText = WizardComponentFactory.createTextField((ValueModel)counterCsDriveConverterModel, (boolean)false);
        counterCsDriveText.setEditable(false);
        formBuilder.add("CS_DRIVE", new Object[0]).xy(1, 3);
        formBuilder.add((Component)counterCsDriveText).xy(3, 3);
        SwingPropertyAdapter counterCsBinStateModel = new SwingPropertyAdapter((Object)this.locoModel, "counterCsBinState", true);
        ConverterValueModel counterCsBinStateConverterModel = new ConverterValueModel((ValueModel)counterCsBinStateModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        JTextField counterCsBinStateText = WizardComponentFactory.createTextField((ValueModel)counterCsBinStateConverterModel, (boolean)false);
        counterCsBinStateText.setEditable(false);
        formBuilder.add("CS_BIN_STATE", new Object[0]).xy(1, 5);
        formBuilder.add((Component)counterCsBinStateText).xy(3, 5);
        SwingPropertyAdapter counterCsDriveAckModel = new SwingPropertyAdapter((Object)this.locoModel, "counterCsDriveAck", true);
        ConverterValueModel counterCsDriveAckConverterModel = new ConverterValueModel((ValueModel)counterCsDriveAckModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        JTextField counterCsDriveAckText = WizardComponentFactory.createTextField((ValueModel)counterCsDriveAckConverterModel, (boolean)false);
        counterCsDriveAckText.setEditable(false);
        formBuilder.add("CS_DRIVE_ACK", new Object[0]).xy(1, 7);
        formBuilder.add((Component)counterCsDriveAckText).xy(3, 7);
        JButton resetButton = new JButton(Resources.getString(this.getClass(), (String)"reset"));
        resetButton.addActionListener(evt -> {
            LOGGER.info("Reset the counters.");
            this.locoModel.resetCounterCsDrive();
            this.locoModel.resetCounterCsAckDrive();
            this.locoModel.resetCounterCsBinState();
        });
        formBuilder.add((Component)resetButton).xy(1, 9);
        return formBuilder.build();
    }

    private JPanel addDirectBinStatePanel() {
        FormBuilder formBuilder = FormBuilder.create().columns("pref, 5dlu, max(pref;30dlu), 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu:grow", new Object[0]).rows("pref, 3dlu, pref", new Object[0]);
        formBuilder.addSeparator(Resources.getString(this.getClass(), (String)"devBinState"), new Object[0]).xyw(1, 1, 10);
        SwingPropertyAdapter devBinStateNumberModel = new SwingPropertyAdapter((Object)this.locoModel, "devBinStateNumber", true);
        ConverterValueModel binStateNumberConverterModel = new ConverterValueModel((ValueModel)devBinStateNumberModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        JTextField devBinStateNumberText = WizardComponentFactory.createTextField((ValueModel)binStateNumberConverterModel, (boolean)false);
        InputValidationDocument stateNumberDocument = new InputValidationDocument(5, "0123456789");
        stateNumberDocument.setDocumentFilter((DocumentFilter)new IntegerRangeFilter(0, Short.MAX_VALUE));
        devBinStateNumberText.setDocument((Document)stateNumberDocument);
        formBuilder.add("Number", new Object[0]).xy(1, 3);
        formBuilder.add((Component)devBinStateNumberText).xy(3, 3);
        SwingPropertyAdapter devBinStateValueModel = new SwingPropertyAdapter((Object)this.locoModel, "devBinStateValue", true);
        this.devBinStateValueButtons = new JComponent[BinStateValue.values().length];
        int column = 0;
        for (BinStateValue binStateValue : BinStateValue.values()) {
            JRadioButton radio = WizardComponentFactory.createRadioButton((ValueModel)devBinStateValueModel, (Object)binStateValue, (String)Resources.getString(BinStateValue.class, (String)binStateValue.getKey()));
            this.devBinStateValueButtons[column] = radio;
            formBuilder.add((Component)radio).xy(5 + column * 2, 3);
            ++column;
        }
        JButton sendButton = new JButton(Resources.getString(this.getClass(), (String)"send"));
        sendButton.addActionListener(evt -> {
            BinStateValue devBinStateValue = this.locoModel.getDevBinStateValue();
            if (devBinStateValue != null) {
                boolean functionValue = devBinStateValue.getFunctionValue();
                Integer binStateNumber = this.locoModel.getDevBinStateNumber();
                if (binStateNumber != null) {
                    this.locoControlListener.setBinaryState(binStateNumber, functionValue);
                } else {
                    LOGGER.info("No bin state number available. The BIN_STATE is not fired.");
                }
            }
        });
        sendButton.setEnabled(false);
        formBuilder.add((Component)sendButton).xy(9, 3);
        devBinStateNumberModel.addValueChangeListener(evt -> {
            Integer binStateNumber = this.locoModel.getDevBinStateNumber();
            sendButton.setEnabled(binStateNumber != null);
        });
        return formBuilder.build();
    }

    private JPanel createImagePanel(final List<JideButton> functionButtons) {
        JPanel imagePanel = new JPanel(new BorderLayout());
        JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.setPreferredSize(new Dimension(140, 140));
        ImageIcon carFrontIcon = ImageUtils.loadImageIcon(LocoView.class, (String)"/images/Truck-Front.png", (int)120, (int)120);
        JLabel backgroundLabel = new JLabel(carFrontIcon);
        backgroundLabel.setOpaque(true);
        backgroundLabel.setBounds(0, 0, 140, 140);
        layeredPane.add((Component)backgroundLabel, (Object)10);
        this.blinkerRight = new BlinkerLed(0, 0, 8, 6, Color.ORANGE.brighter(), Color.ORANGE);
        this.blinkerLeft = new BlinkerLed(0, 0, 8, 6, Color.ORANGE.brighter(), Color.ORANGE);
        final BlinkerLed lightRight = new BlinkerLed(0, 0, 8, 11, Color.YELLOW, Color.WHITE);
        final BlinkerLed lightLeft = new BlinkerLed(0, 0, 8, 11, Color.YELLOW, Color.WHITE);
        layeredPane.add((Component)this.blinkerLeft, (Object)20);
        layeredPane.add((Component)this.blinkerRight, (Object)20);
        layeredPane.add((Component)lightLeft, (Object)20);
        layeredPane.add((Component)lightRight, (Object)20);
        this.blinkerLeft.setBounds(37, 84, 10, 7);
        this.blinkerRight.setBounds(93, 84, 10, 7);
        lightLeft.setBounds(37, 92, 10, 11);
        lightRight.setBounds(93, 92, 10, 11);
        Cursor cursor = Cursor.getPredefinedCursor(12);
        this.blinkerLeft.setCursor(cursor);
        this.blinkerRight.setCursor(cursor);
        lightLeft.setCursor(cursor);
        lightRight.setCursor(cursor);
        final JideToggleButton functionButtonLeft = LocoView.getButton((JButton)functionButtons.get(2), JideToggleButton.class);
        functionButtonLeft.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LocoView.this.blinkerLeft.setActive(functionButtonLeft.isSelected(), true);
            }
        });
        final JideToggleButton functionButtonRight = LocoView.getButton((JButton)functionButtons.get(1), JideToggleButton.class);
        functionButtonRight.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LocoView.this.blinkerRight.setActive(functionButtonRight.isSelected(), true);
            }
        });
        final JideToggleButton functionButtonLights = LocoView.getButton((JButton)functionButtons.get(0), JideToggleButton.class);
        functionButtonLights.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LOGGER.info("Lights state has changed, selected: {}", (Object)functionButtonLights.isSelected());
                lightRight.setActive(functionButtonLights.isSelected(), false);
                lightLeft.setActive(functionButtonLights.isSelected(), false);
            }
        });
        backgroundLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point point = e.getPoint();
                LOGGER.info("Mouse clicked, point: {}", (Object)point);
                if (point.getX() > 37.0 && point.getX() < 44.0) {
                    if (point.getY() > 83.0 && point.getY() < 89.0) {
                        LOGGER.info("Turn left blinker on/off.");
                        int functionIndex = 2;
                        JideToggleButton functionButton = LocoView.getButton((JButton)functionButtons.get(functionIndex), JideToggleButton.class);
                        functionButton.setSelected(!functionButton.isSelected());
                        LocoView.this.locoControlListener.setFunction(functionIndex, functionButton.isSelected());
                    } else if (point.getY() > 91.0 && point.getY() < 102.0) {
                        LOGGER.info("Turn front lights on/off.");
                        int functionIndex = 0;
                        JideToggleButton functionButton = LocoView.getButton((JButton)functionButtons.get(functionIndex), JideToggleButton.class);
                        functionButton.setSelected(!functionButton.isSelected());
                        LocoView.this.locoControlListener.setFunction(functionIndex, functionButton.isSelected());
                    }
                } else if (point.getX() > 93.0 && point.getX() < 101.0) {
                    if (point.getY() > 83.0 && point.getY() < 89.0) {
                        LOGGER.info("Turn right blinker on/off.");
                        int functionIndex = 1;
                        JideToggleButton functionButton = LocoView.getButton((JButton)functionButtons.get(functionIndex), JideToggleButton.class);
                        functionButton.setSelected(!functionButton.isSelected());
                        LocoView.this.locoControlListener.setFunction(functionIndex, functionButton.isSelected());
                    } else if (point.getY() > 91.0 && point.getY() < 102.0) {
                        LOGGER.info("Turn front lights on/off.");
                        int functionIndex = 0;
                        JideToggleButton functionButton = LocoView.getButton((JButton)functionButtons.get(functionIndex), JideToggleButton.class);
                        functionButton.setSelected(!functionButton.isSelected());
                        LocoView.this.locoControlListener.setFunction(functionIndex, functionButton.isSelected());
                    }
                }
            }
        });
        imagePanel.add((Component)layeredPane, "Center");
        return imagePanel;
    }

    private static <T> T getButton(JButton button, Class<T> type) {
        if (type.isInstance(button)) {
            return type.cast(button);
        }
        throw new IllegalArgumentException("The provided button has not the requested type.");
    }

    protected void fireWriteState(int state, boolean value) {
        this.locoControlListener.setBinaryState(state, value);
    }

    private void addLocoViewListener(LocoViewListener listener) {
        this.locoViewListeners.add(listener);
    }

    public void addViewCloseListener(ViewCloseListener listener) {
        this.viewCloseListeners.add(listener);
    }

    private void fireEmergencyStop() {
        this.locoControlListener.setSpeed(new SpeedLevel(true, this.locoModel.getSpeedSteps()));
        for (LocoViewListener listener : this.locoViewListeners) {
            listener.emergencyStop();
        }
    }

    private void fireStop() {
        this.locoControlListener.setSpeed(new SpeedLevel(Integer.valueOf(0), this.locoModel.getSpeedSteps(), null));
        for (LocoViewListener listener : this.locoViewListeners) {
            listener.stop();
        }
    }

    public void selectDecoderAddress(int dccAddress) {
        LOGGER.info("Select the decoder address: {}", (Object)dccAddress);
        this.address.setText(String.valueOf(dccAddress));
        this.locoControlListener.setSpeed(new SpeedLevel(null, this.locoModel.getSpeedSteps(), null));
    }

    public void setSpeedSteps(SpeedSteps speedSteps) {
        LOGGER.info("Set the speed steps: {}", (Object)speedSteps);
        this.speedStepsCombo.setSelectedItem(speedSteps);
    }

    public void setSpeed(int speed) {
        LOGGER.info("Set the speed: {}", (Object)speed);
        this.changeSliderSilently(speed);
        this.locoControlListener.setSpeed(new SpeedLevel(Integer.valueOf(speed), this.locoModel.getSpeedSteps(), null));
    }

    public void setFunction(int function) {
        LOGGER.info("Set the function: {}", (Object)function);
        JideToggleButton functionButton = LocoView.getButton(this.functionButtonMap.get("F" + function), JideToggleButton.class);
        LOGGER.warn("Fetched functionButton: {}", (Object)functionButton);
        functionButton.doClick();
    }

    public void setBinState(int binStateNumber, boolean flag) {
        LOGGER.info("Set the binState, binStateNumber: {}, flag: {}", (Object)binStateNumber, (Object)flag);
        this.locoControlListener.setBinaryState(binStateNumber, flag);
    }

    public void setStop() {
        LOGGER.info("Set stop.");
        this.stopButton.doClick();
    }

    public void setStopEmergency() {
        LOGGER.info("Set stop emergency.");
        this.stopEmergencyButton.doClick();
    }

    public void cleanup(SettingsService settingsService) {
        LOGGER.info("The LocoView is disposed. Remove all listeners from the locoModel.");
        for (ViewCloseListener closeListener : this.viewCloseListeners) {
            try {
                closeListener.close();
            }
            catch (Exception ex) {
                LOGGER.warn("Notify view close listener failed.", (Throwable)ex);
            }
        }
        SpeedSteps lastSelectedSpeedSteps = this.locoModel.getSpeedSteps();
        settingsService.getWizardSettings().setLastSelectedSpeedSteps(lastSelectedSpeedSteps);
        if (this.blinkerLeft != null) {
            this.blinkerLeft.setActive(false, true);
        }
        if (this.blinkerRight != null) {
            this.blinkerRight.setActive(false, true);
        }
        this.viewCloseListeners.clear();
        this.locoViewListeners.clear();
        this.locoModel.removeLocoModelListener(this.locoModelListener);
        this.locoModel.removePropertyChangeListener(this.locoModelPropertyChangeListener);
        this.addressChangeConnector.release();
        if (this.scriptPanel != null) {
            this.scriptPanel.close();
            this.scriptPanel = null;
        }
        this.functionButtonMap.clear();
    }

    private /* synthetic */ void lambda$createFunctionButtonPanel$10(int functionIndex, JideButton functionButton, ActionEvent event) {
        LOGGER.info("Set function with index: {}", (Object)functionIndex);
        if (functionIndex < 29) {
            this.locoControlListener.setFunction(functionIndex, functionButton.isSelected());
        } else {
            this.locoControlListener.setBinaryState(functionIndex, true);
        }
    }

    private static class BlinkerLed
    extends JComponent {
        private static final long serialVersionUID = 1L;
        private Timer blinkerTimer;
        private Color colorOn;
        private Color colorOff;
        private boolean on;
        private int x;
        private int y;
        private int width;
        private int height;

        public BlinkerLed(int x, int y, int width, int height, Color colorOn, Color colorOff) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.colorOn = colorOn;
            this.colorOff = colorOff;
        }

        public void setActive(boolean active, boolean useTimer) {
            this.repaint();
            if (active) {
                if (useTimer && this.blinkerTimer == null) {
                    this.blinkerTimer = new Timer(500, evt -> {
                        this.on = !this.on;
                        this.repaint();
                    });
                }
                this.on = true;
                if (this.blinkerTimer != null) {
                    this.blinkerTimer.start();
                }
            } else if (!active) {
                this.on = false;
                if (this.blinkerTimer != null) {
                    this.blinkerTimer.stop();
                }
            }
        }

        @Override
        public void paintComponent(Graphics graphics) {
            if (this.on) {
                graphics.setColor(this.colorOn);
            } else {
                graphics.setColor(this.colorOff);
            }
            graphics.fillRect(this.x, this.y, this.width, this.height);
        }
    }
}

