/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.model;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import com.jgoodies.binding.beans.Model;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import org.bidib.jbidibc.messages.FeedbackPosition;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.mvc.main.controller.FeedbackPositionStatusChangeProvider;
import org.bidib.wizard.utils.NodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedbackPositionModel
extends Model
implements FeedbackPositionStatusChangeProvider {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedbackPositionModel.class);
    private final int MAX_SIZE = 3000;
    private NodeInterface selectedNode;
    private final PropertyChangeListener pclFeedbackPositions;
    private EventList<FeedbackPosition> positionsEventList = new BasicEventList(500);
    private boolean appendToEventList;

    public FeedbackPositionModel(WizardSettingsInterface wizardSettings) {
        this.appendToEventList = wizardSettings.isAppendToPositionTable();
        this.pclFeedbackPositions = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LOGGER.debug("Property has changed, evt: {}", (Object)evt);
                FeedbackPosition position = (FeedbackPosition)evt.getNewValue();
                NodeInterface node = (NodeInterface)evt.getSource();
                LOGGER.info("Received feedback position from node: {}", (Object)NodeUtils.prepareLabel(node));
                SwingUtilities.invokeLater(() -> {
                    FeedbackPositionModel.this.positionsEventList.getReadWriteLock().writeLock().lock();
                    try {
                        if (!FeedbackPositionModel.this.appendToEventList) {
                            int index = FeedbackPositionModel.this.positionsEventList.indexOf((Object)position);
                            if (index > -1) {
                                FeedbackPositionModel.this.positionsEventList.remove(index);
                                FeedbackPositionModel.this.positionsEventList.add(index, (Object)position);
                            } else {
                                FeedbackPositionModel.this.positionsEventList.add((Object)position);
                            }
                        } else {
                            if (FeedbackPositionModel.this.positionsEventList.size() > 3000) {
                                for (int index = 9; index >= 0; --index) {
                                    FeedbackPositionModel.this.positionsEventList.remove(index);
                                }
                            }
                            FeedbackPositionModel.this.positionsEventList.add((Object)position);
                        }
                    }
                    finally {
                        FeedbackPositionModel.this.positionsEventList.getReadWriteLock().writeLock().unlock();
                    }
                });
            }
        };
        wizardSettings.addPropertyChangeListener("appendToPositionTable", evt -> {
            this.appendToEventList = wizardSettings.isAppendToPositionTable();
        });
    }

    @Override
    public NodeInterface getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(NodeInterface selectedNode) {
        if (this.selectedNode != null) {
            LOGGER.info("Remove pcl from previous selected node: {}", (Object)this.selectedNode);
            this.selectedNode.removePropertyChangeListener("feedbackPositions", this.pclFeedbackPositions);
        }
        this.selectedNode = selectedNode;
        if (this.selectedNode != null) {
            LOGGER.info("Add pcl to currently selected node: {}", (Object)this.selectedNode);
            this.selectedNode.addPropertyChangeListener("feedbackPositions", this.pclFeedbackPositions);
        }
    }

    public EventList<FeedbackPosition> getPositionsEventList() {
        return this.positionsEventList;
    }
}

