/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import io.reactivex.rxjava3.subjects.Subject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.InputPortListener;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.model.listener.PortTableLayoutListener;
import org.bidib.wizard.client.common.table.AbstractPortHierarchicalTable;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.client.common.view.menu.listener.PortListMenuListener;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.InputPortStatus;
import org.bidib.wizard.mvc.main.controller.InputPortPanelController;
import org.bidib.wizard.mvc.main.model.InputPortTableModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.listener.InputPortModelListener;
import org.bidib.wizard.mvc.main.view.panel.SimpleHierarchicalPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabComponentCreator;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.bidib.wizard.mvc.main.view.table.InputPortTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputPortListPanel
extends SimpleHierarchicalPortListPanel<InputPortTableModel, InputPortStatus, InputPort, InputPortListener, InputPortModelListener>
implements TabVisibilityProvider,
PortTableLayoutListener,
TabPanelProvider,
TabComponentCreator {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(InputPortListPanel.class);
    private final MainModel mainModel;
    private final TabVisibilityListener tabVisibilityListener;

    public InputPortListPanel(InputPortPanelController controller, InputPortTableModel tableModel, MainModel mainModel, TabVisibilityListener tabVisibilityListener, Subject<PortConfigChangeEvent> portConfigChangeEventSubject) {
        super(tableModel, Resources.getString(InputPortListPanel.class, (String)"emptyTable"), portConfigChangeEventSubject, mainModel);
        this.mainModel = mainModel;
        this.tabVisibilityListener = tabVisibilityListener;
        this.init();
    }

    @Override
    protected AbstractPortHierarchicalTable<InputPort> createPortTable(InputPortTableModel tableModel, String emptyTableText) {
        return new InputPortTable(tableModel, emptyTableText);
    }

    @Override
    protected void createTable(InputPortTableModel tableModel, String emptyTableText, Subject<PortConfigChangeEvent> portConfigChangeEventSubject, NodeSelectionProvider nodeSelectionProvider) {
        super.createTable(tableModel, emptyTableText, portConfigChangeEventSubject, nodeSelectionProvider);
        PortListMenuListener portListMenuListener = this.createPortListMenuListener(this.table, nodeSelectionProvider, null);
        this.table.setPortListMenuListener(portListMenuListener);
    }

    @Override
    public JPanel getComponent() {
        return this;
    }

    @Override
    public Object getCreator() {
        return this;
    }

    public boolean equals(Object other) {
        TabComponentCreator creator;
        return other instanceof TabComponentCreator && (creator = (TabComponentCreator)other).getCreator() instanceof InputPortListPanel;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    protected void processListChanged() {
        super.processListChanged();
        this.tabVisibilityListener.setTabVisible(this, this.isTabVisible());
        NodeInterface node = this.mainModel.getSelectedNode();
        this.portTableLayoutChanged(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void portTableLayoutChanged(NodeInterface node) {
        boolean hasPortIdentifiers = false;
        ArrayList<InputPort> ports = new ArrayList<InputPort>();
        ports.addAll(this.getPorts());
        LOGGER.info("Number of ports: {}", (Object)ports.size());
        ArrayList<InputPort> arrayList = ports;
        synchronized (arrayList) {
            for (InputPort port : ports) {
                if (!port.isRemappingEnabled()) continue;
                hasPortIdentifiers = true;
                break;
            }
        }
        int viewColumnIndex = 1;
        if (node != null) {
            LOGGER.info("A node is selected.");
            boolean hasInputPortConfig = false;
            if (node.getNode().isPortFlatModelAvailable() && CollectionUtils.isNotEmpty((Collection)node.getEnabledInputPorts())) {
                InputPort port;
                LOGGER.info("Check if the at least one input port has the input port config available.");
                Iterator iterator = node.getEnabledInputPorts().iterator();
                while (iterator.hasNext() && !(hasInputPortConfig = (port = (InputPort)iterator.next()).isHasInputPortConfig())) {
                }
            }
            LOGGER.info("List has changed, hasPortIdentifiers: {}, hasInputPortConfig: {}", (Object)hasPortIdentifiers, (Object)hasInputPortConfig);
            viewColumnIndex = this.table.setColumnVisible(1, viewColumnIndex, hasInputPortConfig);
        }
        this.table.setColumnVisible(2, viewColumnIndex, hasPortIdentifiers);
    }

    public Class<?> getPortClass() {
        return InputPort.class;
    }

    @Override
    public boolean isTabVisible() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            boolean isTabVisible = node.hasInputPorts();
            LOGGER.debug("Check if tab is visible: {}", (Object)isTabVisible);
            return isTabVisible;
        }
        return false;
    }

    @Override
    protected List<InputPort> getPorts() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            LinkedList<InputPort> ports = new LinkedList<InputPort>();
            ports.addAll(node.getInputPorts());
            return ports;
        }
        return Collections.emptyList();
    }

    public void refreshView() {
        this.listChanged();
    }
}

