/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.StyledLabelBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.DropMode;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Flag;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.function.AccessoryOkayFunction;
import org.bidib.wizard.api.model.function.AnalogPortAction;
import org.bidib.wizard.api.model.function.BacklightPortAction;
import org.bidib.wizard.api.model.function.DelayFunction;
import org.bidib.wizard.api.model.function.Delayable;
import org.bidib.wizard.api.model.function.FlagFunction;
import org.bidib.wizard.api.model.function.Function;
import org.bidib.wizard.api.model.function.InputFunction;
import org.bidib.wizard.api.model.function.LightPortAction;
import org.bidib.wizard.api.model.function.MacroFunction;
import org.bidib.wizard.api.model.function.MotorPortAction;
import org.bidib.wizard.api.model.function.RandomDelayFunction;
import org.bidib.wizard.api.model.function.ServoMoveQueryFunction;
import org.bidib.wizard.api.model.function.ServoPortAction;
import org.bidib.wizard.api.model.function.SoundPortAction;
import org.bidib.wizard.api.model.function.SwitchPairPortAction;
import org.bidib.wizard.api.model.function.SwitchPortAction;
import org.bidib.wizard.client.common.table.AbstractStatusEmptyTable;
import org.bidib.wizard.client.common.view.renderer.BidibStatusListRenderer;
import org.bidib.wizard.client.common.view.renderer.FlagRenderer;
import org.bidib.wizard.client.common.view.renderer.MacroRenderer;
import org.bidib.wizard.client.common.view.renderer.PortTypeRenderer;
import org.bidib.wizard.client.common.view.slider.SliderRenderer;
import org.bidib.wizard.common.utils.MacroListUtils;
import org.bidib.wizard.model.ports.AnalogPort;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.ports.MotorPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.ServoPort;
import org.bidib.wizard.model.ports.SoundPort;
import org.bidib.wizard.model.ports.SwitchPairPort;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.model.status.AccessoryOkayStatus;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.MacroStatus;
import org.bidib.wizard.mvc.main.model.MacroTableModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.listener.MacroSelectionListener;
import org.bidib.wizard.mvc.main.view.menu.AccessoryTableMenu;
import org.bidib.wizard.mvc.main.view.menu.MacroTableMenu;
import org.bidib.wizard.mvc.main.view.menu.listener.MacroTableMenuListener;
import org.bidib.wizard.mvc.main.view.table.ComboBoxEditor;
import org.bidib.wizard.mvc.main.view.table.ComboBoxRenderer;
import org.bidib.wizard.mvc.main.view.table.MacroTableRowTransferHandler;
import org.bidib.wizard.mvc.main.view.table.NumberWithLabelEditor;
import org.bidib.wizard.mvc.main.view.table.NumberWithLabelRenderer;
import org.bidib.wizard.mvc.main.view.table.PortComboBoxEditor;
import org.bidib.wizard.mvc.main.view.table.PortComboBoxRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroContentPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MacroContentPanel.class);
    private final MainModel model;
    private final MacroTableModel tableModel;
    private final AbstractStatusEmptyTable table;
    private final MacroTableMenu macroTableMenu;
    private Function<?>[] functionsClipBoard;
    private final String emptyPortLabel;
    private final boolean showAbsoluteScale;

    public MacroContentPanel(final MainModel model, final boolean showAbsoluteScale) {
        this.model = model;
        this.showAbsoluteScale = showAbsoluteScale;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(5, 2, 5, 3));
        this.emptyPortLabel = Resources.getString(Port.class, (String)"portNone");
        this.macroTableMenu = new MacroTableMenu(model);
        this.macroTableMenu.addMenuListener(new MacroTableMenuListener(){

            @Override
            public void copy() {
                int[] rows = MacroContentPanel.this.table.getSelectedRows();
                if (rows != null && rows.length > 0) {
                    MacroContentPanel.this.fireCopy(rows);
                }
            }

            @Override
            public void cut() {
                int[] rows = MacroContentPanel.this.table.getSelectedRows();
                if (rows != null && rows.length > 0) {
                    MacroContentPanel.this.fireCut(rows);
                }
            }

            @Override
            public void delete() {
                int[] rows = MacroContentPanel.this.table.getSelectedRows();
                if (rows != null && rows.length > 0) {
                    MacroContentPanel.this.fireDelete(rows);
                }
            }

            @Override
            public void insertEmptyAfter() {
                MacroContentPanel.this.fireInsertEmptyAfter(MacroContentPanel.this.table.getSelectedRow());
            }

            @Override
            public void insertEmptyBefore() {
                MacroContentPanel.this.fireInsertEmptyBefore(MacroContentPanel.this.table.getSelectedRow());
            }

            @Override
            public void pasteAfter() {
                MacroContentPanel.this.firePasteAfter(MacroContentPanel.this.table.getSelectedRow());
            }

            @Override
            public void pasteBefore() {
                MacroContentPanel.this.firePasteBefore(MacroContentPanel.this.table.getSelectedRow());
            }

            @Override
            public void pasteInvertedAfter() {
                MacroContentPanel.this.firePasteInvertedAfter(MacroContentPanel.this.table.getSelectedRow());
            }

            @Override
            public void selectAll() {
                int rowCount = MacroContentPanel.this.table.getRowCount();
                if (rowCount > 0) {
                    MacroContentPanel.this.table.setRowSelectionInterval(0, rowCount - 1);
                }
            }
        });
        this.tableModel = new MacroTableModel(model, showAbsoluteScale);
        this.table = new AbstractStatusEmptyTable(this.tableModel, Resources.getString(this.getClass(), (String)"emptyTable")){
            private static final long serialVersionUID = 1L;

            public void adjustRowHeight() {
                SliderRenderer sliderEditor = new SliderRenderer(0, 255, 10);
                int rowHeight = sliderEditor.getTableCellRendererComponent((JTable)((Object)this), (Object)Integer.valueOf((int)1), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().height + 6;
                LOGGER.info("Set row height: {}", (Object)rowHeight);
                this.setRowHeight(rowHeight);
            }

            protected String getErrorText() {
                if (model.getSelectedMacro() != null && model.getSelectedMacro().isContainsError()) {
                    return Resources.getString(MacroContentPanel.class, (String)"restore-macro-failed");
                }
                return null;
            }

            public Dimension getMinimumSize() {
                return new Dimension(200, 100);
            }

            public BidibStatus[] getActions(BidibStatus status) {
                if (status != null) {
                    BidibStatus[] actions = status.getMacroValues();
                    return actions;
                }
                LOGGER.debug("No BidibStatus available.");
                return new BidibStatus[0];
            }

            public TableCellEditor getCellEditor(int row, int column) {
                AbstractCellEditor result = null;
                Function function = model.getSelectedMacro().getFunction(row);
                switch (column) {
                    case 1: {
                        if (function instanceof DelayFunction) {
                            result = new NumberWithLabelEditor(Resources.getString(MacroContentPanel.class, (String)"delay") + ":", "Ticks", 255);
                            break;
                        }
                        if (function instanceof RandomDelayFunction) {
                            result = new NumberWithLabelEditor(Resources.getString(MacroContentPanel.class, (String)"maximum") + ":", "Ticks", 255);
                            break;
                        }
                        if (!(function instanceof Delayable)) break;
                        result = new NumberWithLabelEditor(Resources.getString(MacroContentPanel.class, (String)"delay") + ":", "Ticks", 250);
                        break;
                    }
                    case 2: {
                        Function[] functions = MacroListUtils.prepareAvailableFunctions((NodeInterface)model.getSelectedNode());
                        JComboBox<Function> combobox = new JComboBox<Function>(functions);
                        combobox.setRenderer((ListCellRenderer<Function>)new PortTypeRenderer());
                        result = new ComboBoxEditor<Function>(combobox);
                        break;
                    }
                    case 3: {
                        BidibStatus[] actions;
                        if (function == null || (actions = this.getActions(function.getAction())).length <= 0) break;
                        if (function instanceof SwitchPairPortAction) {
                            result = ComboBoxEditor.createComboBoxEditor((BidibStatus[])actions, (String)"org.bidib.wizard.model.status.SwitchPairPortStatus");
                            break;
                        }
                        JComboBox<BidibStatus> comboboxStatus = new JComboBox<BidibStatus>(actions);
                        comboboxStatus.setRenderer((ListCellRenderer<BidibStatus>)new BidibStatusListRenderer((String)null));
                        result = new ComboBoxEditor<BidibStatus>(comboboxStatus);
                        break;
                    }
                    case 4: {
                        NodeInterface selectedNode = model.getSelectedNode();
                        if (function instanceof AccessoryOkayFunction) {
                            AccessoryOkayFunction aof = (AccessoryOkayFunction)function;
                            if (AccessoryOkayStatus.NO_FEEDBACK.equals((Object)aof.getAction())) break;
                            ArrayList<InputPort> inputPorts = new ArrayList<InputPort>();
                            inputPorts.add(InputPort.NONE);
                            inputPorts.addAll(selectedNode.getEnabledInputPorts());
                            result = PortComboBoxEditor.prepareEditor((Port[])inputPorts.toArray(new InputPort[0]), (String)MacroContentPanel.this.emptyPortLabel);
                            break;
                        }
                        if (function instanceof ServoMoveQueryFunction) {
                            ArrayList<ServoPort> servoPorts = new ArrayList<ServoPort>();
                            servoPorts.add(ServoPort.NONE);
                            servoPorts.addAll(selectedNode.getServoPorts());
                            result = PortComboBoxEditor.prepareEditor((Port[])servoPorts.toArray(new ServoPort[0]), (String)MacroContentPanel.this.emptyPortLabel);
                            break;
                        }
                        if (function instanceof AnalogPortAction) {
                            result = PortComboBoxEditor.prepareEditor((Port[])selectedNode.getAnalogPorts().toArray(new AnalogPort[0]), (String)MacroContentPanel.this.emptyPortLabel);
                            break;
                        }
                        if (function instanceof BacklightPortAction) {
                            result = PortComboBoxEditor.prepareEditor((Port[])selectedNode.getBacklightPorts().toArray(new BacklightPort[0]), (String)MacroContentPanel.this.emptyPortLabel);
                            break;
                        }
                        if (function instanceof FlagFunction) {
                            JComboBox<Flag> comboboxFlag = new JComboBox<Flag>(selectedNode.getFlags().toArray(new Flag[0]));
                            comboboxFlag.setRenderer((ListCellRenderer<Flag>)new FlagRenderer());
                            result = new ComboBoxEditor<Flag>(comboboxFlag);
                            break;
                        }
                        if (function instanceof InputFunction) {
                            ArrayList<InputPort> inputPorts = new ArrayList<InputPort>();
                            inputPorts.add(InputPort.NONE);
                            inputPorts.addAll(selectedNode.getEnabledInputPorts());
                            result = PortComboBoxEditor.prepareEditor((Port[])inputPorts.toArray(new InputPort[0]), (String)MacroContentPanel.this.emptyPortLabel);
                            break;
                        }
                        if (function instanceof LightPortAction) {
                            LinkedList<LightPort> ports = new LinkedList<LightPort>();
                            ports.add(LightPort.NONE);
                            ports.addAll(selectedNode.getEnabledLightPorts());
                            result = PortComboBoxEditor.prepareEditor((Port[])ports.toArray(new LightPort[0]), (String)MacroContentPanel.this.emptyPortLabel);
                            break;
                        }
                        if (function instanceof MacroFunction) {
                            MacroFunction macroFunction = (MacroFunction)function;
                            if (MacroStatus.END.equals((Object)macroFunction.getAction())) break;
                            JComboBox<Macro> comboboxMacro = new JComboBox<Macro>(selectedNode.getMacros().toArray(new Macro[0]));
                            comboboxMacro.setRenderer((ListCellRenderer<Macro>)new MacroRenderer());
                            result = new ComboBoxEditor<Macro>(comboboxMacro);
                            break;
                        }
                        if (function instanceof MotorPortAction) {
                            result = PortComboBoxEditor.prepareEditor((Port[])selectedNode.getMotorPorts().toArray(new MotorPort[0]), (String)MacroContentPanel.this.emptyPortLabel);
                            break;
                        }
                        if (function instanceof ServoPortAction) {
                            result = PortComboBoxEditor.prepareEditor((Port[])selectedNode.getServoPorts().toArray(new ServoPort[0]), (String)MacroContentPanel.this.emptyPortLabel);
                            break;
                        }
                        if (function instanceof SoundPortAction) {
                            result = PortComboBoxEditor.prepareEditor((Port[])selectedNode.getSoundPorts().toArray(new SoundPort[0]), (String)MacroContentPanel.this.emptyPortLabel);
                            break;
                        }
                        if (function instanceof SwitchPortAction) {
                            LinkedList<SwitchPort> ports = new LinkedList<SwitchPort>();
                            ports.add(SwitchPort.NONE);
                            ports.addAll(selectedNode.getEnabledSwitchPorts());
                            result = PortComboBoxEditor.prepareEditor((Port[])ports.toArray(new SwitchPort[0]), (String)MacroContentPanel.this.emptyPortLabel);
                            break;
                        }
                        if (!(function instanceof SwitchPairPortAction)) break;
                        LinkedList<SwitchPairPort> ports = new LinkedList<SwitchPairPort>();
                        ports.add(SwitchPairPort.NONE);
                        ports.addAll(selectedNode.getEnabledSwitchPairPorts());
                        result = PortComboBoxEditor.prepareEditor((Port[])ports.toArray(new SwitchPairPort[0]), (String)MacroContentPanel.this.emptyPortLabel);
                        break;
                    }
                    case 5: {
                        if (function instanceof ServoPortAction) {
                            result = new NumberWithLabelEditor(Resources.getString(MacroContentPanel.class, (String)"destination") + ":", showAbsoluteScale ? "" : "%", showAbsoluteScale ? 255 : 100);
                            break;
                        }
                        if (function instanceof BacklightPortAction) {
                            result = new NumberWithLabelEditor(Resources.getString(MacroContentPanel.class, (String)"brightness") + ":", showAbsoluteScale ? "" : "%", showAbsoluteScale ? 255 : 100);
                            break;
                        }
                        if (!(function instanceof MotorPortAction)) break;
                        result = new NumberWithLabelEditor(Resources.getString(MacroContentPanel.class, (String)"speed") + ":", null, 126);
                    }
                }
                return result;
            }

            public TableCellRenderer getCellRenderer(int row, int column) {
                ComboBoxRenderer result = super.getCellRenderer(row, column);
                if (model.getSelectedMacro() != null && row >= 0 && row < model.getSelectedMacro().getFunctions().size()) {
                    Function function = model.getSelectedMacro().getFunction(row);
                    switch (column) {
                        case 1: {
                            if (function instanceof DelayFunction) {
                                result = new NumberWithLabelRenderer(Resources.getString(MacroContentPanel.class, (String)"delay") + ":", "Ticks");
                                break;
                            }
                            if (function instanceof RandomDelayFunction) {
                                result = new NumberWithLabelRenderer(Resources.getString(MacroContentPanel.class, (String)"maximum") + ":", "Ticks");
                                break;
                            }
                            if (!(function instanceof Delayable)) break;
                            result = new NumberWithLabelRenderer(Resources.getString(MacroContentPanel.class, (String)"delay") + ":", "Ticks");
                            break;
                        }
                        case 2: {
                            ComboBoxRenderer<Function> renderer = new ComboBoxRenderer<Function>(MacroListUtils.prepareAvailableFunctions((NodeInterface)model.getSelectedNode()));
                            renderer.setRenderer((ListCellRenderer<Function>)new PortTypeRenderer());
                            result = renderer;
                            break;
                        }
                        case 3: {
                            BidibStatus[] actions;
                            if (function == null || (actions = this.getActions(function.getAction())).length <= 0) break;
                            if (function instanceof SwitchPairPortAction) {
                                result = ComboBoxRenderer.createComboBoxRenderer((BidibStatus[])actions, (String)"org.bidib.wizard.model.status.SwitchPairPortStatus");
                                break;
                            }
                            PortComboBoxRenderer rendererStatus = new ComboBoxRenderer(actions);
                            rendererStatus.setRenderer((ListCellRenderer<BidibStatus>)new BidibStatusListRenderer((String)null));
                            result = rendererStatus;
                            break;
                        }
                        case 4: {
                            NodeInterface selectedNode = model.getSelectedNode();
                            if (function instanceof AccessoryOkayFunction) {
                                AccessoryOkayFunction aof = (AccessoryOkayFunction)function;
                                if (AccessoryOkayStatus.NO_FEEDBACK.equals((Object)aof.getAction())) break;
                                ArrayList<InputPort> inputPorts = new ArrayList<InputPort>();
                                inputPorts.add(InputPort.NONE);
                                inputPorts.addAll(selectedNode.getEnabledInputPorts());
                                result = new PortComboBoxRenderer((Port[])inputPorts.toArray(new InputPort[0]), MacroContentPanel.this.emptyPortLabel);
                                break;
                            }
                            if (function instanceof ServoMoveQueryFunction) {
                                ArrayList<ServoPort> servoPorts = new ArrayList<ServoPort>();
                                servoPorts.add(ServoPort.NONE);
                                servoPorts.addAll(selectedNode.getServoPorts());
                                result = new PortComboBoxRenderer((Port[])servoPorts.toArray(new ServoPort[0]), MacroContentPanel.this.emptyPortLabel);
                                break;
                            }
                            if (function instanceof AnalogPortAction) {
                                result = new PortComboBoxRenderer((Port[])selectedNode.getAnalogPorts().toArray(new AnalogPort[0]), MacroContentPanel.this.emptyPortLabel);
                                break;
                            }
                            if (function instanceof BacklightPortAction) {
                                result = new PortComboBoxRenderer((Port[])selectedNode.getBacklightPorts().toArray(new BacklightPort[0]), MacroContentPanel.this.emptyPortLabel);
                                break;
                            }
                            if (function instanceof FlagFunction) {
                                ComboBoxRenderer<Flag> flagRenderer = new ComboBoxRenderer<Flag>(selectedNode.getFlags().toArray(new Flag[0]));
                                flagRenderer.setRenderer((ListCellRenderer<Flag>)new FlagRenderer());
                                result = flagRenderer;
                                break;
                            }
                            if (function instanceof InputFunction) {
                                LinkedList<InputPort> inputPorts = new LinkedList<InputPort>();
                                inputPorts.add(InputPort.NONE);
                                inputPorts.addAll(selectedNode.getEnabledInputPorts());
                                result = new PortComboBoxRenderer((Port[])inputPorts.toArray(new InputPort[0]), MacroContentPanel.this.emptyPortLabel);
                                break;
                            }
                            if (function instanceof LightPortAction) {
                                LinkedList<LightPort> ports = new LinkedList<LightPort>();
                                ports.add(LightPort.NONE);
                                ports.addAll(selectedNode.getEnabledLightPorts());
                                result = new PortComboBoxRenderer((Port[])ports.toArray(new LightPort[0]), MacroContentPanel.this.emptyPortLabel);
                                break;
                            }
                            if (function instanceof MacroFunction) {
                                MacroFunction macroFunction = (MacroFunction)function;
                                if (MacroStatus.END.equals((Object)macroFunction.getAction())) break;
                                ComboBoxRenderer<Macro> macroRenderer = new ComboBoxRenderer<Macro>(selectedNode.getMacros().toArray(new Macro[0]));
                                macroRenderer.setRenderer((ListCellRenderer<Macro>)new MacroRenderer());
                                result = macroRenderer;
                                break;
                            }
                            if (function instanceof MotorPortAction) {
                                result = new PortComboBoxRenderer((Port[])selectedNode.getMotorPorts().toArray(new MotorPort[0]), MacroContentPanel.this.emptyPortLabel);
                                break;
                            }
                            if (function instanceof ServoPortAction) {
                                result = new PortComboBoxRenderer((Port[])selectedNode.getServoPorts().toArray(new ServoPort[0]), MacroContentPanel.this.emptyPortLabel);
                                break;
                            }
                            if (function instanceof SoundPortAction) {
                                result = new PortComboBoxRenderer((Port[])selectedNode.getSoundPorts().toArray(new SoundPort[0]), MacroContentPanel.this.emptyPortLabel);
                                break;
                            }
                            if (function instanceof SwitchPortAction) {
                                LinkedList<SwitchPort> ports = new LinkedList<SwitchPort>();
                                ports.add(SwitchPort.NONE);
                                ports.addAll(selectedNode.getEnabledSwitchPorts());
                                result = new PortComboBoxRenderer((Port[])ports.toArray(new SwitchPort[0]), MacroContentPanel.this.emptyPortLabel);
                                break;
                            }
                            if (!(function instanceof SwitchPairPortAction)) break;
                            LinkedList<SwitchPairPort> ports = new LinkedList<SwitchPairPort>();
                            ports.add(SwitchPairPort.NONE);
                            ports.addAll(selectedNode.getEnabledSwitchPairPorts());
                            result = new PortComboBoxRenderer((Port[])ports.toArray(new SwitchPairPort[0]), MacroContentPanel.this.emptyPortLabel);
                            break;
                        }
                        case 5: {
                            if (function instanceof ServoPortAction) {
                                result = new NumberWithLabelRenderer(Resources.getString(MacroContentPanel.class, (String)"destination") + ":", showAbsoluteScale ? "" : "%");
                                break;
                            }
                            if (function instanceof BacklightPortAction) {
                                result = new NumberWithLabelRenderer(Resources.getString(MacroContentPanel.class, (String)"brightness") + ":", showAbsoluteScale ? "" : "%");
                                break;
                            }
                            if (!(function instanceof MotorPortAction)) break;
                            result = new NumberWithLabelRenderer(Resources.getString(MacroContentPanel.class, (String)"speed") + ":", null);
                        }
                    }
                }
                return result;
            }
        };
        this.table.adjustRowHeight();
        this.table.getInputMap(1).put(MacroTableMenu.KEYSTROKE_CUT, "cut");
        this.table.getActionMap().put("cut", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MacroContentPanel.this.macroTableMenu.fireCut();
            }
        });
        this.table.getInputMap(1).put(MacroTableMenu.KEYSTROKE_COPY, "copy");
        this.table.getActionMap().put("copy", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MacroContentPanel.this.macroTableMenu.fireCopy();
            }
        });
        this.table.getInputMap(1).put(MacroTableMenu.KEYSTROKE_PASTE, "paste");
        this.table.getActionMap().put("paste", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MacroContentPanel.this.macroTableMenu.firePasteAfter();
            }
        });
        this.table.getInputMap(1).put(AccessoryTableMenu.KEYSTROKE_DELETE, "delete");
        this.table.getActionMap().put("delete", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MacroContentPanel.this.macroTableMenu.fireDelete();
            }
        });
        this.table.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MacroContentPanel.this.handleMouseEvent(e, (JPopupMenu)((Object)MacroContentPanel.this.macroTableMenu));
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                MacroContentPanel.this.handleMouseEvent(e, (JPopupMenu)((Object)MacroContentPanel.this.macroTableMenu));
            }
        });
        this.table.setAutoResizeMode(0);
        this.table.setSortable(false);
        this.table.setDragEnabled(true);
        this.table.setSelectionMode(1);
        this.table.setDropMode(DropMode.INSERT_ROWS);
        this.table.setTransferHandler((TransferHandler)new MacroTableRowTransferHandler((JTable)this.table));
        block5: for (int i = 0; i < this.table.getColumnModel().getColumnCount(); ++i) {
            TableColumn column = this.table.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    column.setPreferredWidth(40);
                    continue block5;
                }
                case 1: {
                    column.setPreferredWidth(120);
                    continue block5;
                }
                case 5: {
                    column.setPreferredWidth(120);
                    continue block5;
                }
                default: {
                    column.setPreferredWidth(200);
                }
            }
        }
        this.setMinimumSize(new Dimension(400, 100));
        this.setPreferredSize(new Dimension(600, 200));
        final DefaultOverlayable overlayTable = new DefaultOverlayable((JComponent)new JScrollPane((Component)this.table));
        this.tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                overlayTable.setOverlayVisible(MacroContentPanel.this.tableModel.getRowCount() == 0);
            }
        });
        overlayTable.addOverlayComponent((JComponent)StyledLabelBuilder.createStyledLabel((String)("{" + this.table.getEmptyTableText() + ":f:gray}")));
        this.add((Component)overlayTable, "Center");
        model.addMacroSelectionListener(new MacroSelectionListener(){

            @Override
            public void macroChanged() {
                Macro macro = model.getSelectedMacro();
                LOGGER.info("The macro has changed: {}", (Object)macro);
                MacroContentPanel.this.tableModel.setMacro(macro);
            }
        });
    }

    private Function<? extends BidibStatus>[] getFunctions(int[] rows) {
        Function[] result = new Function[rows.length];
        for (int index = 0; index < rows.length; ++index) {
            result[index] = this.model.getSelectedMacro().getFunction(rows[index]);
        }
        return result;
    }

    private int getRow(Point point) {
        return this.table.rowAtPoint(point);
    }

    private void handleMouseEvent(MouseEvent e, JPopupMenu popupMenu) {
        if (e.isPopupTrigger()) {
            int row = this.getRow(e.getPoint());
            if (this.table.getSelectedRowCount() == 0 && this.table.getRowCount() > 0 && row >= 0 && row < this.table.getRowCount()) {
                this.table.setRowSelectionInterval(row, row);
            }
            this.table.grabFocus();
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void setFunctionsToClipboard(Function<?>[] functions) {
        if (functions != null) {
            try {
                this.functionsClipBoard = new Function[functions.length];
                for (int index = 0; index < functions.length; ++index) {
                    if (functions[index] == null) continue;
                    this.functionsClipBoard[index] = (Function)functions[index].clone();
                }
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.functionsClipBoard = null;
        }
    }

    private Function<?>[] getFunctionsFromClipboard() {
        Function[] result = null;
        if (this.functionsClipBoard != null) {
            try {
                result = new Function[this.functionsClipBoard.length];
                for (int index = 0; index < this.functionsClipBoard.length; ++index) {
                    if (this.functionsClipBoard[index] == null) continue;
                    result[index] = (Function)this.functionsClipBoard[index].clone();
                }
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private void fireCopy(int[] rows) {
        Function<? extends BidibStatus>[] functions = this.getFunctions(rows);
        this.setFunctionsToClipboard(functions);
    }

    private void fireCut(int[] rows) {
        Function<? extends BidibStatus>[] functions = this.getFunctions(rows);
        this.setFunctionsToClipboard(functions);
        for (int index = rows.length - 1; index >= 0; --index) {
            this.model.getSelectedMacro().removeFunction(rows[index]);
        }
    }

    private void fireDelete(int[] rows) {
        for (int index = rows.length - 1; index >= 0; --index) {
            this.model.getSelectedMacro().removeFunction(rows[index]);
        }
    }

    private void fireInsertEmptyAfter(int row) {
        this.model.getSelectedMacro().addFunctionsAfter(row, null);
    }

    private void fireInsertEmptyBefore(int row) {
        this.model.getSelectedMacro().addFunctionsBefore(row >= 0 ? row : 0, null);
    }

    private void firePasteAfter(int row) {
        this.model.getSelectedMacro().addFunctionsAfter(row, this.getFunctionsFromClipboard());
    }

    private void firePasteBefore(int row) {
        this.model.getSelectedMacro().addFunctionsBefore(row >= 0 ? row : 0, this.getFunctionsFromClipboard());
    }

    private void firePasteInvertedAfter(int row) {
        this.model.getSelectedMacro().addFunctionsInvertedAfter(row, this.getFunctionsFromClipboard());
    }

    public void refreshView() {
        LOGGER.info("Refresh the macro panel.");
        Macro macro = this.model.getSelectedMacro();
        LOGGER.info("The macro has changed: {}", (Object)macro);
        this.tableModel.setMacro(macro);
    }
}

