/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jidesoft.grid.RowStripeTableStyleProvider;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TableStyleProvider;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.StyledLabelBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.enums.LcMacroState;
import org.bidib.jbidibc.messages.exception.ProtocolNoAnswerException;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.MacroSaveState;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.PortsProvider;
import org.bidib.wizard.api.model.listener.MacroListListener;
import org.bidib.wizard.api.model.listener.NodeSelectionListener;
import org.bidib.wizard.api.utils.MacroUtils;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.client.common.view.statusbar.StatusBar;
import org.bidib.wizard.common.labels.BidibLabelUtils;
import org.bidib.wizard.common.labels.DefaultWizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.script.node.types.TargetType;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.common.utils.MacroListUtils;
import org.bidib.wizard.mvc.common.view.panel.DisabledPanel;
import org.bidib.wizard.mvc.common.view.table.DefaultTextCellEditor;
import org.bidib.wizard.mvc.main.controller.MacroPanelController;
import org.bidib.wizard.mvc.main.controller.listener.MacroPanelListener;
import org.bidib.wizard.mvc.main.model.MacroFactory;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.SingleColumnTableModel;
import org.bidib.wizard.mvc.main.model.listener.MacroSelectionListener;
import org.bidib.wizard.mvc.main.view.component.DefaultTabSelectionPanel;
import org.bidib.wizard.mvc.main.view.component.MacroFileDialog;
import org.bidib.wizard.mvc.main.view.menu.MacroListMenu;
import org.bidib.wizard.mvc.main.view.menu.listener.MacroListMenuListener;
import org.bidib.wizard.mvc.main.view.panel.MacroPanel;
import org.bidib.wizard.mvc.main.view.panel.PendingChangesAware;
import org.bidib.wizard.mvc.main.view.panel.listener.LabelChangedListener;
import org.bidib.wizard.mvc.main.view.panel.listener.MacroActionListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabComponentCreator;
import org.bidib.wizard.mvc.main.view.panel.listener.TabSelectionListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.bidib.wizard.mvc.main.view.panel.renderer.MacroListRenderer;
import org.bidib.wizard.nodescript.script.node.ChangeLabelSupport;
import org.oxbow.swingbits.dialog.task.TaskDialogs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroListPanel
implements MacroListMenuListener,
MacroListListener,
MacroActionListener,
MacroSelectionListener,
ChangeLabelSupport,
TabVisibilityProvider,
TabPanelProvider,
PendingChangesAware,
TabSelectionListener,
NodeSelectionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MacroListPanel.class);
    private static final String EMPTY_LABEL = " ";
    private final MainModel mainModel;
    private final List<LabelChangedListener<Macro>> labelChangedListeners = new ArrayList<LabelChangedListener<Macro>>();
    private final TabVisibilityListener tabVisibilityListener;
    private MacroPanelListener macroPanelListener;
    private final MacroPanel macroPanel;
    private final MacroListMenu macroListMenu = new MacroListMenu();
    private final DisabledPanel disabledBorderPanel;
    private JScrollPane scrollMacroList;
    private final JPanel contentPanel;
    private final StatusBar statusBar;
    private final SettingsService settingsService;
    private final WizardLabelWrapper wizardLabelWrapper;
    private final MacroList macroList;
    private final MacroPanelController macroPanelController;
    private static final String WORKING_DIR_MACRO_EXCHANGE_KEY = "macroExchange";

    public MacroListPanel(MacroPanelController macroPanelController, MainModel model, TabVisibilityListener tabVisibilityListener, SettingsService settingsService, WizardLabelWrapper wizardLabelWrapper, DefaultWizardLabelFactory bidibLabelFactory, StatusBar statusBar) {
        this.macroPanelController = macroPanelController;
        this.mainModel = model;
        this.tabVisibilityListener = tabVisibilityListener;
        this.wizardLabelWrapper = wizardLabelWrapper;
        this.settingsService = settingsService;
        this.statusBar = statusBar;
        this.contentPanel = new DefaultTabSelectionPanel(this){
            private static final long serialVersionUID = 1L;

            public boolean equals(Object other) {
                TabComponentCreator creator;
                return other instanceof TabComponentCreator && (creator = (TabComponentCreator)other).getCreator() instanceof MacroListPanel;
            }

            public int hashCode() {
                return super.hashCode();
            }

            @Override
            public void tabSelected(boolean selected) {
            }

            @Override
            public String getName() {
                return Resources.getString(MacroListPanel.class, (String)"name");
            }
        };
        this.contentPanel.setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.macroListMenu.addMenuListener(this);
        this.macroPanel = new MacroPanel(this.macroPanelController, this.mainModel, this.settingsService, this);
        JPanel panel = new JPanel(new BorderLayout());
        this.disabledBorderPanel = new DisabledPanel(this.macroPanel);
        panel.add(this.disabledBorderPanel);
        SingleColumnTableModel<Macro> tableModel = new SingleColumnTableModel<Macro>(Macro.class);
        tableModel.addLabelChangedListener((T macro, String label) -> {
            LOGGER.info("The label of the macro was changed: {}, label: {}", macro, (Object)label);
            long uniqueId = model.getSelectedNode().getUniqueId();
            macro.setLabel(label);
            NodeLabels nodeLabels = this.wizardLabelWrapper.loadLabels(Long.valueOf(uniqueId));
            BidibLabelUtils.replaceMacroLabel((NodeLabels)nodeLabels, (int)macro.getId(), (String)label);
            this.wizardLabelWrapper.saveNodeLabels(Long.valueOf(uniqueId));
        });
        this.macroList = new MacroList(tableModel);
        this.macroList.adjustRowHeight();
        this.macroList.getTableHeader().setReorderingAllowed(false);
        this.macroList.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.macroList.setSortable(false);
        this.macroList.setSelectionMode(0);
        TableColumn tc = this.macroList.getColumnModel().getColumn(0);
        tc.setPreferredWidth(80);
        tc.setWidth(80);
        MacroListRenderer renderer = new MacroListRenderer();
        tc.setCellRenderer(renderer);
        tc.setCellEditor(new DefaultTextCellEditor(new JTextField()));
        this.macroList.setPreferredScrollableViewportSize(new Dimension(200, 200));
        final DefaultOverlayable overlayTable = new DefaultOverlayable((JComponent)new JScrollPane((Component)((Object)this.macroList)));
        this.macroList.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                overlayTable.setOverlayVisible(MacroListPanel.this.macroList.getModel().getRowCount() == 0);
            }
        });
        this.macroList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MacroListPanel.this.handleMouseEvent(e, (JPopupMenu)((Object)MacroListPanel.this.macroListMenu));
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                MacroListPanel.this.handleMouseEvent(e, (JPopupMenu)((Object)MacroListPanel.this.macroListMenu));
            }
        });
        overlayTable.addOverlayComponent((JComponent)StyledLabelBuilder.createStyledLabel((String)("{" + this.macroList.getEmptyTableText() + ":f:gray}")));
        this.scrollMacroList = new JScrollPane((Component)overlayTable);
        JSplitPane splitPane = new JSplitPane(1, this.scrollMacroList, panel);
        splitPane.setContinuousLayout(true);
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(0.2);
        this.contentPanel.add((Component)splitPane, "Center");
        this.setEnabled(false);
    }

    public void setMacroPanelListener(MacroPanelListener macroPanelListener) {
        this.macroPanelListener = macroPanelListener;
    }

    @Override
    public JPanel getComponent() {
        return this.contentPanel;
    }

    public void setEnabled(boolean enabled) {
        this.disabledBorderPanel.setEnabled(enabled);
    }

    private void fireExportMacro() {
        Macro macro = this.mainModel.getSelectedMacro();
        if (macro.isValid()) {
            this.exportMacro(macro);
        } else {
            LOGGER.warn("Macro is not valid for export.");
        }
    }

    private void fireReloadMacro() {
        this.reloadMacro(this.mainModel.getSelectedMacro());
    }

    private void fireSaveMacro() {
        Macro macro = this.mainModel.getSelectedMacro();
        if (macro.isValid()) {
            this.saveMacro(macro);
        } else {
            JOptionPane.showMessageDialog(this.contentPanel, Resources.getString(this.getClass(), (String)"macro_content_not_valid"), Resources.getString(this.getClass(), (String)"save"), 2);
        }
    }

    private void fireTestMacro(boolean transferBeforeStart) {
        Macro macro = this.mainModel.getSelectedMacro();
        if (macro.isValid()) {
            int result;
            if (!transferBeforeStart && macro.getMacroSaveState().equals((Object)MacroSaveState.PENDING_CHANGES) && (result = JOptionPane.showConfirmDialog(this.contentPanel, Resources.getString(this.getClass(), (String)"macro_transfer_pending_changes_before_test"), Resources.getString(this.getClass(), (String)"start"), 0, 2)) == 0) {
                transferBeforeStart = true;
            }
            this.startMacro(macro, transferBeforeStart);
        } else {
            JOptionPane.showMessageDialog(this.contentPanel, Resources.getString(this.getClass(), (String)"macro_content_not_valid"), Resources.getString(this.getClass(), (String)"start"), 2);
        }
    }

    @Override
    public void remoteStartMacro() {
        Macro macro = this.mainModel.getSelectedMacro();
        this.startMacro(macro, false);
    }

    private void fireStopMacro() {
        this.stopMacro(this.mainModel.getSelectedMacro());
    }

    private void fireInitializeMacro() {
        this.initializeMacro(this.mainModel.getSelectedMacro());
    }

    @Override
    public void transferMacro() {
        Macro macro = this.mainModel.getSelectedMacro();
        if (macro.isValid()) {
            this.transferMacro(this.mainModel.getSelectedMacro());
        } else {
            JOptionPane.showMessageDialog(this.contentPanel, Resources.getString(this.getClass(), (String)"macro_content_not_valid"), Resources.getString(this.getClass(), (String)"transfer"), 2);
        }
    }

    @Override
    public void exportMacro() {
        this.fireExportMacro();
    }

    @Override
    public void startMacro() {
        boolean powerUser = this.settingsService.getWizardSettings().isPowerUser();
        this.fireTestMacro(powerUser);
    }

    @Override
    public void stopMacro() {
        this.fireStopMacro();
    }

    @Override
    public void initializeMacro() {
        this.fireInitializeMacro();
    }

    @Override
    public void saveMacro() {
        this.fireSaveMacro();
    }

    @Override
    public void reloadMacro() {
        this.fireReloadMacro();
    }

    @Override
    public void testMacro(boolean transferBeforeStart) {
        this.fireTestMacro(transferBeforeStart);
    }

    public void listChanged() {
        LOGGER.info("Macro list has been changed.");
        SwingUtils.executeInEDT(() -> this.internalListChanged());
    }

    private void internalListChanged() {
        LOGGER.info("Macro list has been changed. Reload the macros.");
        ArrayList<Macro> macros = new ArrayList<Macro>();
        macros.addAll(this.mainModel.getMacros());
        Collections.sort(macros, new Comparator<Macro>(){

            @Override
            public int compare(Macro o1, Macro o2) {
                return o1.getId() - o2.getId();
            }
        });
        this.macroList.setItems(macros.toArray(new Macro[0]));
        this.resetMacroScrollPane();
        this.setEnabled(false);
        this.tabVisibilityListener.setTabVisible(this.getComponent(), this.isTabVisible());
    }

    private void resetMacroScrollPane() {
        JScrollBar verticalScrollBar = this.scrollMacroList.getVerticalScrollBar();
        JScrollBar horizontalScrollBar = this.scrollMacroList.getHorizontalScrollBar();
        verticalScrollBar.setValue(verticalScrollBar.getMinimum());
        horizontalScrollBar.setValue(horizontalScrollBar.getMinimum());
    }

    @Override
    public void macroChanged() {
        LOGGER.info("Macro selection has changed.");
        Macro macro = this.mainModel.getSelectedMacro();
        LOGGER.info("The selected macro has been changed, macro: {}", (Object)macro);
        if (macro != null) {
            this.labelChanged(macro, macro.toString());
        } else {
            this.labelChanged(macro, EMPTY_LABEL);
        }
        this.setEnabled(macro != null);
        SwingUtils.executeInEDT(() -> this.macroList.requestFocusInWindow());
    }

    public void pendingChangesChanged() {
        SwingUtils.invokeLater(() -> this.macroList.refreshView());
    }

    public void changeLabel(TargetType portType) {
        int portNum = portType.getPortNum();
        String label = portType.getLabel();
        Macro macro = MacroListUtils.findMacroByMacroNumber(this.mainModel.getMacros(), (int)portNum);
        if (macro != null) {
            LOGGER.info("Current macro: {}, new label: {}", (Object)macro, (Object)label);
            macro.setLabel(label);
            if (macro.equals((Object)this.mainModel.getSelectedMacro())) {
                this.labelChanged(macro, label);
            }
            this.fireLabelChanged(macro, label);
        }
    }

    @Override
    public boolean isTabVisible() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            boolean isTabVisible = node.hasMacros();
            LOGGER.debug("Check if tab is visible: {}", (Object)isTabVisible);
            return isTabVisible;
        }
        return false;
    }

    public boolean equals(Object other) {
        return other instanceof MacroListPanel;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void exportMacro(final Macro macro) {
        int result;
        if (CollectionUtils.isNotEmpty((Collection)macro.getFunctions()) && MacroUtils.hasEmptySteps((Macro)macro)) {
            result = JOptionPane.showConfirmDialog(this.getComponent(), Resources.getString(MacroListPanel.class, (String)"ask_continue_export_macro_with_empty_step"), Resources.getString(MacroListPanel.class, (String)"export_macro.title"), 2, 2);
            if (result != 0) {
                LOGGER.info("User canceled export empty macro.");
                return;
            }
            LOGGER.info("Remove empty macro steps.");
            MacroUtils.removeEmptySteps((Macro)macro);
        }
        if (CollectionUtils.isEmpty((Collection)macro.getFunctions()) && (result = JOptionPane.showConfirmDialog(this.getComponent(), Resources.getString(MacroListPanel.class, (String)"ask_export_empty_macro"), Resources.getString(MacroListPanel.class, (String)"export_macro.title"), 2)) != 0) {
            LOGGER.info("User canceled export empty macro.");
            return;
        }
        final WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_MACRO_EXCHANGE_KEY);
        MacroFileDialog dialog = new MacroFileDialog(this.getComponent(), 1, storedWorkingDirectory, macro){

            public void approve(String selectedFile) {
                try {
                    boolean flatPortModel = false;
                    if (MacroListPanel.this.mainModel.getSelectedNode() != null && MacroListPanel.this.mainModel.getSelectedNode().getNode().isPortFlatModelAvailable()) {
                        flatPortModel = true;
                    }
                    LOGGER.info("Set the flat port model flag: {}", (Object)flatPortModel);
                    macro.setFlatPortModel(flatPortModel);
                    MacroFactory.ExportFormat exportFormat = MacroFactory.ExportFormat.jaxb;
                    MacroFactory.saveMacro(selectedFile, macro, exportFormat);
                    MacroListPanel.this.statusBar.setStatusText(String.format(Resources.getString(MacroListPanel.class, (String)"exportedMacro"), selectedFile), -1);
                    String workingDir = Paths.get(selectedFile, new String[0]).toString();
                    LOGGER.info("Save current workingDir: {}", (Object)workingDir);
                    wizardSettings.setWorkingDirectory(MacroListPanel.WORKING_DIR_MACRO_EXCHANGE_KEY, workingDir);
                }
                catch (Exception ex) {
                    LOGGER.warn("Export macro failed.", (Throwable)ex);
                    TaskDialogs.build((Window)JOptionPane.getFrameForComponent(MacroListPanel.this.getComponent()), (String)Resources.getString(MacroListPanel.class, (String)"export_macro_failed.instruction"), (String)Resources.getString(MacroListPanel.class, (String)"export_macro_failed", (Object[])new Object[]{macro.toString()})).title(Resources.getString(MacroListPanel.class, (String)"export_macro.title")).exception((Throwable)ex);
                }
            }
        };
        dialog.showDialog();
    }

    @Override
    public void importMacro() {
        if (this.mainModel.getSelectedMacro() != null && this.mainModel.getSelectedMacro().getMacroSaveState().equals((Object)MacroSaveState.PENDING_CHANGES)) {
            int result = JOptionPane.showConfirmDialog(this.getComponent(), Resources.getString(MacroListPanel.class, (String)"macro_has_pending_changes"), Resources.getString(MacroListPanel.class, (String)"pending_changes"), 2);
            if (result != 0) {
                LOGGER.info("User canceled discard pending changes.");
                return;
            }
            this.mainModel.getSelectedMacro().setMacroSaveState(MacroSaveState.SAVED_ON_NODE);
        }
        final NodeInterface selectedNode = this.mainModel.getSelectedNode();
        final WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_MACRO_EXCHANGE_KEY);
        MacroFileDialog dialog = new MacroFileDialog(this.getComponent(), 0, storedWorkingDirectory, null){

            public void approve(String selectedFile) {
                MacroFactory.ExportFormat exportFormat = MacroFactory.ExportFormat.jaxb;
                Macro macro = MacroFactory.loadMacro(selectedFile, exportFormat, (PortsProvider)selectedNode);
                LOGGER.info("Loaded macro, flatPortModel: {}", (Object)macro.isFlatPortModel());
                macro.setId(MacroListPanel.this.mainModel.getSelectedMacro().getId());
                macro.setMacroSaveState(MacroSaveState.PENDING_CHANGES);
                MacroListPanel.this.replaceMacro(macro, false);
                String workingDir = Paths.get(selectedFile, new String[0]).toString();
                LOGGER.info("Save current workingDir: {}", (Object)workingDir);
                wizardSettings.setWorkingDirectory(MacroListPanel.WORKING_DIR_MACRO_EXCHANGE_KEY, workingDir);
            }
        };
        dialog.showDialog();
    }

    public void replaceMacro(Macro macro, boolean saveOnNode) {
        block5: {
            LOGGER.info("Replace the macro: {}", (Object)macro);
            if (macro != null) {
                int result;
                NodeInterface node = this.mainModel.getSelectedNode();
                macro.setFunctionSize(node.getMaxMacroSteps());
                if (this.mainModel.getSelectedMacro() != null && this.mainModel.getSelectedMacro().getMacroSaveState().equals((Object)MacroSaveState.PENDING_CHANGES) && (result = JOptionPane.showConfirmDialog(this.getComponent(), Resources.getString(MacroListPanel.class, (String)"macro_has_pending_changes"), Resources.getString(MacroListPanel.class, (String)"pending_changes"), 2)) != 0) {
                    LOGGER.info("User canceled discard pending changes.");
                    return;
                }
                this.mainModel.replaceMacro(macro);
            }
            if (saveOnNode) {
                LOGGER.info("Transfer the macro to node and save permanently: {}", (Object)macro);
                try {
                    this.macroPanelListener.storeMacroOnNode(macro);
                    LOGGER.info("Transfer and save macro passed.");
                }
                catch (RuntimeException ex) {
                    LOGGER.warn("Transfer macro content and save macro failed.", (Throwable)ex);
                    this.mainModel.getSelectedNode().setNodeHasError(true);
                    this.mainModel.getSelectedNode().setReasonData("Transfer macro content and save macro failed.");
                    if (!(ex.getCause() instanceof ProtocolNoAnswerException)) break block5;
                    TaskDialogs.build((Window)JOptionPane.getFrameForComponent(this.getComponent()), (String)Resources.getString(MacroListPanel.class, (String)"save-macro-to-node-failed.instruction"), (String)Resources.getString(MacroListPanel.class, (String)"save-macro-to-node-failed", (Object[])new Object[]{macro.toString()})).title(Resources.getString(MacroListPanel.class, (String)"save-macro.title")).exception((Throwable)ex);
                }
            }
        }
    }

    @Override
    public void labelChanged(Macro macro, String label) {
        LOGGER.info("Label of macro has changed, macro: {}, label: {}", (Object)macro, (Object)label);
        this.saveChangedLabel(macro, label);
    }

    private void saveChangedLabel(Macro macro, String label) {
        if (macro != null) {
            long uniqueId = this.mainModel.getSelectedNode().getNode().getUniqueId();
            try {
                NodeLabels nodeLabels = this.wizardLabelWrapper.loadLabels(Long.valueOf(uniqueId));
                BidibLabelUtils.replaceMacroLabel((NodeLabels)nodeLabels, (int)macro.getId(), (String)label);
                this.wizardLabelWrapper.saveNodeLabels(Long.valueOf(uniqueId));
            }
            catch (Exception e) {
                LOGGER.warn("Save macro labels failed.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void reloadMacro(Macro macro) {
        if (macro != null && macro.getMacroSaveState().equals((Object)MacroSaveState.PENDING_CHANGES)) {
            int result = JOptionPane.showConfirmDialog(this.getComponent(), Resources.getString(MacroListPanel.class, (String)"macro_has_pending_changes"), Resources.getString(MacroListPanel.class, (String)"pending_changes"), 2);
            if (result != 0) {
                LOGGER.info("User canceled discard pending changes.");
                return;
            }
            macro.setMacroSaveState(MacroSaveState.SAVED_ON_NODE);
        }
        try {
            LcMacroState lcMacroState = this.macroPanelListener.reloadMacro(macro);
            LOGGER.info("Reload macro returned: {}", (Object)lcMacroState);
            this.mainModel.getSelectedMacro().setMacroSaveState(MacroSaveState.PERMANENTLY_STORED_ON_NODE);
            macro.setContainsError(false);
        }
        catch (RuntimeException ex) {
            LOGGER.warn("Restore macro content failed.", (Throwable)ex);
            this.mainModel.getSelectedNode().setNodeHasError(true);
            this.mainModel.getSelectedNode().setReasonData("Restore macro content failed.");
        }
    }

    @Override
    public void saveMacro(Macro macro) {
        LOGGER.info("Save macro: {}", (Object)macro);
        try {
            LcMacroState lcMacroState = this.macroPanelListener.saveMacro(macro);
            LOGGER.info("Save macro returned: {}", (Object)lcMacroState);
            macro.setContainsError(false);
        }
        catch (RuntimeException ex) {
            LOGGER.warn("Save macro content failed.", (Throwable)ex);
            if (ex.getCause() instanceof ProtocolNoAnswerException) {
                TaskDialogs.build((Window)JOptionPane.getFrameForComponent(this.getComponent()), (String)Resources.getString(MacroListPanel.class, (String)"save-macro-to-node-failed.instruction"), (String)Resources.getString(MacroListPanel.class, (String)"save-macro-to-node-failed", (Object[])new Object[]{macro.toString()})).title(Resources.getString(MacroListPanel.class, (String)"save-macro.title")).exception((Throwable)ex);
            }
            this.mainModel.getSelectedNode().setNodeHasError(true);
            this.mainModel.getSelectedNode().setReasonData("Save macro content failed.");
        }
    }

    @Override
    public void startMacro(Macro macro, boolean transferBeforeStart) {
        LOGGER.info("Start macro: {}, transferBeforeStart: {}", (Object)macro, (Object)transferBeforeStart);
        LcMacroState lcMacroState = this.macroPanelListener.startMacro(macro, transferBeforeStart);
        LOGGER.info("Start macro returned: {}", (Object)lcMacroState);
    }

    @Override
    public void stopMacro(Macro macro) {
        LOGGER.info("Stop macro: {}", (Object)macro);
        LcMacroState lcMacroState = this.macroPanelListener.stopMacro(macro);
        LOGGER.info("Stop macro returned: {}", (Object)lcMacroState);
    }

    @Override
    public void transferMacro(Macro macro) {
        LOGGER.info("Transfer macro: {}", (Object)macro);
        try {
            this.macroPanelListener.transferMacro(macro);
            LOGGER.info("Transfer macro passed.");
        }
        catch (RuntimeException ex) {
            LOGGER.warn("Transfer macro content failed.", (Throwable)ex);
            if (ex.getCause() instanceof ProtocolNoAnswerException) {
                TaskDialogs.build((Window)JOptionPane.getFrameForComponent(this.getComponent()), (String)Resources.getString(MacroListPanel.class, (String)"transfer-macro-to-node-failed.instruction"), (String)Resources.getString(MacroListPanel.class, (String)"transfer-macro-to-node-failed", (Object[])new Object[]{macro.toString()})).title(Resources.getString(MacroListPanel.class, (String)"transfer-macro.title")).exception((Throwable)ex);
            }
            this.mainModel.getSelectedNode().setNodeHasError(true);
            this.mainModel.getSelectedNode().setReasonData("Transfer macro content and save macro failed.");
        }
    }

    @Override
    public void initializeMacro(Macro macro) {
        try {
            if (this.mainModel.getSelectedMacro() != null && this.mainModel.getSelectedMacro().equals((Object)macro) && this.mainModel.getSelectedMacro().getMacroSaveState().equals((Object)MacroSaveState.PENDING_CHANGES)) {
                int result = JOptionPane.showConfirmDialog(this.getComponent(), Resources.getString(MacroListPanel.class, (String)"macro_has_pending_changes"), Resources.getString(MacroListPanel.class, (String)"pending_changes"), 2);
                if (result != 0) {
                    LOGGER.info("User canceled discard pending changes.");
                    return;
                }
                this.mainModel.getSelectedMacro().setMacroSaveState(MacroSaveState.SAVED_ON_NODE);
            }
            macro.initialize();
            macro.setMacroSaveState(MacroSaveState.PENDING_CHANGES);
            macro.setLabel(null);
            this.saveChangedLabel(macro, null);
            this.mainModel.setSelectedMacro(macro);
        }
        catch (Exception ex) {
            LOGGER.warn("Set the new selcted macro failed.", (Throwable)ex);
        }
    }

    @Override
    public boolean hasPendingChanges() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            List macros = node.getMacros();
            for (Macro macro : macros) {
                if (MacroSaveState.PENDING_CHANGES != macro.getMacroSaveState()) continue;
                LOGGER.info("Found pending changes in macro: {}", (Object)macro);
                return true;
            }
        }
        return false;
    }

    @Override
    public void savePendingChanges() {
        LOGGER.info("Save the pending changes.");
    }

    public void addLabelChangedListener(LabelChangedListener<Macro> l) {
        this.labelChangedListeners.add(l);
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.macroList.addListSelectionListener(l);
    }

    protected void fireLabelChanged(Macro macro, String label) {
        this.labelChanged(macro, label);
        this.macroList.refreshView();
        for (LabelChangedListener<Macro> l : this.labelChangedListeners) {
            l.labelChanged(macro, label);
        }
    }

    @Override
    public void tabSelected(boolean selected) {
        LOGGER.info("Tab is selected: {}", (Object)selected);
        if (selected && this.macroList.getCellEditor() != null) {
            this.macroList.getCellEditor().stopCellEditing();
        }
    }

    public void editLabel(MouseEvent popupEvent) {
        SwingUtils.invokeLater(() -> {
            int selectedRow = this.macroList.getSelectedRow();
            if (selectedRow > -1) {
                LOGGER.debug("Edit row, selectedRow: {}", (Object)selectedRow);
                this.macroList.requestFocus();
                this.macroList.editCellAt(selectedRow, 0);
                TableCellEditor editor = this.macroList.getCellEditor();
                if (editor != null) {
                    SwingUtils.invokeLater(() -> {
                        JTextField textField = (JTextField)((DefaultTextCellEditor)editor).getComponent();
                        textField.requestFocusInWindow();
                    });
                }
            }
        });
    }

    protected void handleMouseEvent(MouseEvent e, JPopupMenu popupMenu) {
        if (e.isPopupTrigger() && this.macroList.getRowCount() > 0) {
            if (this.macroList.getCellEditor() != null) {
                this.macroList.getCellEditor().stopCellEditing();
            }
            int selectRow = this.macroList.rowAtPoint(e.getPoint());
            this.macroList.setRowSelectionInterval(selectRow, selectRow);
            SwingUtils.executeInEDT(() -> popupMenu.show(e.getComponent(), e.getX(), e.getY()));
        }
    }

    public void refreshView() {
        this.macroList.refreshView();
    }

    public void notifyMacrosChanged() {
        if (this.macroPanel != null) {
            this.macroPanel.refreshView();
        }
    }

    public void selectedNodeChanged(NodeInterface selectedNode) {
        if (selectedNode != null) {
            Feature macroSave = Feature.findFeature((Collection)selectedNode.getNode().getFeatures(), (int)61);
            int macroSaveValue = 0;
            if (macroSave != null) {
                macroSaveValue = macroSave.getValue();
            }
            this.macroPanel.updateMacroSaveCount(macroSaveValue);
        }
    }

    public class MacroList
    extends SortableTable {
        private static final long serialVersionUID = 1L;
        private TableStyleProvider tableStyleProvider;
        private List<ListSelectionListener> listSelectionListeners;

        public MacroList(final DefaultTableModel tableModel) {
            super((TableModel)tableModel);
            this.listSelectionListeners = new ArrayList<ListSelectionListener>();
            this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int selectedRow = MacroList.this.getSelectedRow();
                    LOGGER.info("Selected macro changed, selectedRow: {}", (Object)selectedRow);
                    if (!e.getValueIsAdjusting()) {
                        ListSelectionEvent evt = new ListSelectionEvent(tableModel, selectedRow, selectedRow, e.getValueIsAdjusting());
                        for (ListSelectionListener listener : MacroList.this.listSelectionListeners) {
                            listener.valueChanged(evt);
                        }
                        MacroList.this.requestFocus();
                    }
                }
            });
        }

        protected String getEmptyTableText() {
            return "No macros available.";
        }

        public void adjustRowHeight() {
            this.setRowHeight(this.getRowHeight() + 8);
        }

        protected void prepareTableStyleProvider() {
            this.tableStyleProvider = new RowStripeTableStyleProvider(new Color[]{UIManager.getColor("tableRowStripe.background"), UIManager.getColor("tableRowStripe.alternativeBackground")});
        }

        public TableStyleProvider getTableStyleProvider() {
            if (this.tableStyleProvider == null) {
                this.prepareTableStyleProvider();
            }
            return this.tableStyleProvider;
        }

        public void setItems(Macro[] macros) {
            LOGGER.info("Set the macros: {}", new Object[]{macros});
            DefaultTableModel tableModel = (DefaultTableModel)this.getModel();
            if (tableModel.getColumnCount() > 0) {
                tableModel.setRowCount(0);
            }
            for (Macro macro : macros) {
                tableModel.addRow(new Object[]{macro});
            }
        }

        public void refreshView() {
            this.repaint();
        }

        public void addListSelectionListener(ListSelectionListener l) {
            LOGGER.info("Add list selection listener to macroList: {}", (Object)l);
            this.listSelectionListeners.add(l);
        }

        public Macro getSelectedItem() {
            int selectedRow = this.getSelectedRow();
            if (selectedRow > -1) {
                return (Macro)this.getModel().getValueAt(selectedRow, 0);
            }
            return null;
        }
    }
}

