/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.MacroRepeatDay;
import org.bidib.wizard.api.model.MacroRepeatTime;
import org.bidib.wizard.api.model.MacroSaveState;
import org.bidib.wizard.api.model.StartCondition;
import org.bidib.wizard.api.model.TimeStartCondition;
import org.bidib.wizard.api.model.function.Function;
import org.bidib.wizard.api.model.listener.MacroListener;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.mvc.common.view.panel.DisabledPanel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.listener.MacroSelectionListener;
import org.bidib.wizard.mvc.main.view.panel.SliderPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroParameterPanel
extends JPanel
implements MacroListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MacroParameterPanel.class);
    private final JSpinner timeSpinner = new JSpinner(new SpinnerDateModel());
    private final DisabledPanel disabledRepeatPanel;
    private boolean silentUpdate;
    private Macro macro;
    private final SliderPanel cyclesPanel;
    private final SliderPanel slowdownPanel;
    private final JCheckBox timeButton;
    private final JComboBox<MacroRepeatTime> repeatTime;
    private final JComboBox<MacroRepeatDay> repeatDay;

    public MacroParameterPanel(final MainModel model) {
        this.setLayout(new GridBagLayout());
        JPanel repeatPanel = new JPanel(new GridLayout(2, 1));
        this.repeatTime = new JComboBox();
        this.repeatTime.setRenderer(new MacroRepeatTimeRenderer());
        this.repeatTime.setModel(new DefaultComboBoxModel<MacroRepeatTime>(MacroRepeatTime.values()));
        this.repeatDay = new JComboBox();
        this.repeatDay.setRenderer(new MacroRepeatDayRenderer());
        this.repeatDay.setModel(new DefaultComboBoxModel<MacroRepeatDay>(MacroRepeatDay.values()));
        this.timeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                for (StartCondition startCondition : model.getSelectedMacro().getStartConditions()) {
                    if (!(startCondition instanceof TimeStartCondition)) continue;
                    JSpinner spinner = (JSpinner)e.getSource();
                    Calendar spinnerTime = Calendar.getInstance();
                    spinnerTime.setTime((Date)spinner.getValue());
                    Calendar time = Calendar.getInstance();
                    time.set(11, spinnerTime.get(11));
                    time.set(12, spinnerTime.get(12));
                    ((TimeStartCondition)startCondition).setTime(time);
                }
            }
        });
        this.timeButton = new JCheckBox(Resources.getString(this.getClass(), (String)"time") + ":");
        this.timeButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LOGGER.debug("The selected item has been changed, silentUpdate: {}.", (Object)MacroParameterPanel.this.silentUpdate);
                MacroParameterPanel.this.timeSpinner.setEnabled(e.getStateChange() == 1);
                MacroParameterPanel.this.disabledRepeatPanel.setEnabled(e.getStateChange() == 1);
                if (e.getStateChange() == 1) {
                    Calendar time = Calendar.getInstance();
                    time.setTime((Date)MacroParameterPanel.this.timeSpinner.getValue());
                    if (!MacroParameterPanel.this.silentUpdate) {
                        model.getSelectedMacro().addStartCondition((StartCondition)new TimeStartCondition(time));
                    }
                } else if (!MacroParameterPanel.this.silentUpdate) {
                    model.getSelectedMacro().removeStartCondition((StartCondition)new TimeStartCondition());
                }
                if (!MacroParameterPanel.this.silentUpdate) {
                    Macro macro = model.getSelectedMacro();
                    macro.setMacroSaveState(MacroSaveState.PENDING_CHANGES);
                }
            }
        });
        JPanel startConditionPanel = new JPanel(new BorderLayout());
        startConditionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Resources.getString(this.getClass(), (String)"condition") + ":"));
        FlowLayout leftLayout = new FlowLayout();
        leftLayout.setAlignment(0);
        this.timeSpinner.setEditor(new JSpinner.DateEditor(this.timeSpinner, "HH:mm"));
        JPanel timePanel = new JPanel(leftLayout);
        timePanel.add(this.timeButton);
        timePanel.add(this.timeSpinner);
        startConditionPanel.add((Component)timePanel, "North");
        this.repeatTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (StartCondition startCondition : model.getSelectedMacro().getStartConditions()) {
                    if (!(startCondition instanceof TimeStartCondition)) continue;
                    MacroRepeatTime repeatTime = (MacroRepeatTime)((JComboBox)e.getSource()).getSelectedItem();
                    ((TimeStartCondition)startCondition).setRepeatTime(repeatTime);
                    if (MacroParameterPanel.this.silentUpdate) continue;
                    Macro macro = model.getSelectedMacro();
                    macro.setMacroSaveState(MacroSaveState.PENDING_CHANGES);
                }
            }
        });
        repeatPanel.add(this.repeatTime);
        this.repeatDay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (StartCondition startCondition : model.getSelectedMacro().getStartConditions()) {
                    if (!(startCondition instanceof TimeStartCondition)) continue;
                    ((TimeStartCondition)startCondition).setRepeatDay((MacroRepeatDay)((JComboBox)e.getSource()).getSelectedItem());
                    if (MacroParameterPanel.this.silentUpdate) continue;
                    Macro macro = model.getSelectedMacro();
                    macro.setMacroSaveState(MacroSaveState.PENDING_CHANGES);
                }
            }
        });
        repeatPanel.add(this.repeatDay);
        repeatPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Resources.getString(this.getClass(), (String)"repetition") + ":"));
        this.disabledRepeatPanel = new DisabledPanel(repeatPanel);
        startConditionPanel.add((Component)this.disabledRepeatPanel, "Center");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)startConditionPanel, gbc);
        this.slowdownPanel = new SliderPanel(Resources.getString(this.getClass(), (String)"delay") + ":", 1, 250, 250, true, 0){
            private static final long serialVersionUID = 1L;

            @Override
            public void stateChanged(ChangeEvent e) {
                Macro macro = model.getSelectedMacro();
                if (macro != null) {
                    JSlider source = (JSlider)e.getSource();
                    int slowdown = source.getValue();
                    LOGGER.debug("Set the current macro slowdown: {}", (Object)slowdown);
                    macro.setSpeed(slowdown);
                    this.setLabel(macro.getSpeed());
                    macro.setMacroSaveState(MacroSaveState.PENDING_CHANGES);
                }
            }
        };
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.add((Component)this.slowdownPanel, gbc);
        this.cyclesPanel = new SliderPanel(Resources.getString(this.getClass(), (String)"cycles") + ":", 1, 251, 1, false, 251){
            private static final long serialVersionUID = 1L;

            @Override
            public void stateChanged(ChangeEvent e) {
                Macro macro = model.getSelectedMacro();
                if (macro != null) {
                    JSlider source = (JSlider)e.getSource();
                    int cycles = source.getValue();
                    if (cycles > 250) {
                        cycles = 0;
                    }
                    macro.setCycles(cycles);
                    this.setLabel(source.getValue());
                    macro.setMacroSaveState(MacroSaveState.PENDING_CHANGES);
                }
            }
        };
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.add((Component)this.cyclesPanel, gbc);
        model.addMacroSelectionListener(new MacroSelectionListener(){

            @Override
            public void macroChanged() {
                MacroParameterPanel.this.processMacroChanged(model);
            }
        });
    }

    private void processMacroChanged(MainModel model) {
        Macro macro = model.getSelectedMacro();
        LOGGER.info("The selected macro has changed: {}", (Object)macro);
        if (this.macro != null) {
            this.macro.removeMacroListener((MacroListener)this);
        }
        this.macro = macro;
        if (macro != null) {
            this.macro.addMacroListener((MacroListener)this);
        }
        this.setValueSilently();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValueSilently() {
        this.silentUpdate = true;
        try {
            if (this.macro != null) {
                this.slowdownPanel.setValueSilently(this.macro.getSpeed());
                int cycles = this.macro.getCycles();
                if (cycles == 0) {
                    cycles = 251;
                }
                this.cyclesPanel.setValueSilently(cycles);
                boolean hasTimeCondition = false;
                for (StartCondition startCondition : this.macro.getStartConditions()) {
                    if (!(startCondition instanceof TimeStartCondition)) continue;
                    hasTimeCondition = true;
                    Calendar time = ((TimeStartCondition)startCondition).getTime();
                    if (time != null) {
                        this.timeSpinner.setValue(time.getTime());
                    }
                    this.repeatDay.setSelectedIndex(((TimeStartCondition)startCondition).getRepeatDay().ordinal());
                    this.repeatTime.setSelectedIndex(((TimeStartCondition)startCondition).getRepeatTime().ordinal());
                }
                this.timeButton.setSelected(hasTimeCondition);
                this.timeSpinner.setEnabled(hasTimeCondition);
                this.disabledRepeatPanel.setEnabled(hasTimeCondition);
            }
        }
        finally {
            this.silentUpdate = false;
        }
    }

    public void functionsAdded(int macroId, int row, Function<? extends BidibStatus>[] functions) {
    }

    public void functionRemoved(int macroId, int row) {
    }

    public void functionMoved(int macroId, int fromIndex, int toIndex, Function<? extends BidibStatus> fromFunction) {
    }

    public void functionsRemoved(int macroId) {
    }

    public void startConditionChanged() {
        LOGGER.debug("The start condition has changed.");
        SwingUtils.executeInEDT(() -> this.setValueSilently());
    }

    public void slowdownFactorChanged() {
        LOGGER.debug("The slowdown factor has changed.");
        SwingUtils.executeInEDT(() -> this.setValueSilently());
    }

    public void cyclesChanged() {
        LOGGER.debug("The cycles have changed.");
        SwingUtils.executeInEDT(() -> this.setValueSilently());
    }

    private static class MacroRepeatTimeRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private MacroRepeatTimeRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            MacroRepeatTime macroRepeatTime = (MacroRepeatTime)value;
            this.setText(Resources.getString(MacroRepeatTime.class, (String)macroRepeatTime.toString()));
            return this;
        }
    }

    private static class MacroRepeatDayRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private MacroRepeatDayRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            MacroRepeatDay macroRepeatDay = (MacroRepeatDay)value;
            this.setText(Resources.getString(MacroRepeatDay.class, (String)macroRepeatDay.toString()));
            return this;
        }
    }
}

