/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jidesoft.grid.CellStyleTableHeader;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.StyledLabelBuilder;
import io.reactivex.rxjava3.subjects.Subject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.listener.PortListListener;
import org.bidib.wizard.api.model.listener.PortListener;
import org.bidib.wizard.api.model.listener.PortListenerProvider;
import org.bidib.wizard.api.utils.PortListUtils;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.dialog.LabelDialog;
import org.bidib.wizard.client.common.model.SimpleHierarchicalPortTableModel;
import org.bidib.wizard.client.common.model.SimplePortTableModel;
import org.bidib.wizard.client.common.model.listener.PortModelListener;
import org.bidib.wizard.client.common.table.AbstractHierarchicalEmptyTable;
import org.bidib.wizard.client.common.table.AbstractPortEditorPanel;
import org.bidib.wizard.client.common.table.AbstractPortHierarchicalTable;
import org.bidib.wizard.client.common.table.DefaultPortListMenuListener;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.client.common.view.menu.listener.PortListMenuListener;
import org.bidib.wizard.common.script.node.types.TargetType;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.mvc.main.controller.InsertPortsAware;
import org.bidib.wizard.mvc.main.view.panel.PendingChangesAware;
import org.bidib.wizard.nodescript.script.node.ChangeLabelSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleHierarchicalPortListPanel<TM extends SimpleHierarchicalPortTableModel<S, P, M>, S extends BidibStatus, P extends Port<S>, L extends PortListener<P>, M extends PortModelListener<P>>
extends JPanel
implements PortListListener,
ChangeLabelSupport,
PortListenerProvider<P>,
PendingChangesAware {
    private static final long serialVersionUID = 1L;
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected final TM tableModel;
    protected AbstractPortHierarchicalTable<P> table;
    protected L portListener;
    private final String emptyTableText;
    private final Subject<PortConfigChangeEvent> portConfigChangeEventSubject;
    private final NodeSelectionProvider nodeSelectionProvider;

    public SimpleHierarchicalPortListPanel(TM tableModel, String emptyTableText, Subject<PortConfigChangeEvent> portConfigChangeEventSubject, NodeSelectionProvider nodeSelectionProvider) {
        this.tableModel = tableModel;
        this.emptyTableText = emptyTableText;
        this.portConfigChangeEventSubject = portConfigChangeEventSubject;
        this.nodeSelectionProvider = nodeSelectionProvider;
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.createTable(this.tableModel, this.emptyTableText, this.portConfigChangeEventSubject, this.nodeSelectionProvider);
        final DefaultOverlayable overlayTable = new DefaultOverlayable((JComponent)new JScrollPane((Component)this.table));
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                overlayTable.setOverlayVisible(SimpleHierarchicalPortListPanel.this.table.getModel().getRowCount() == 0);
            }
        });
        overlayTable.addOverlayComponent((JComponent)StyledLabelBuilder.createStyledLabel((String)("{" + this.table.getEmptyTableText() + ":f:gray}")));
        this.add((Component)overlayTable, "Center");
    }

    protected SimplePortTableModel<S, P, M> getTableModel() {
        return this.tableModel;
    }

    protected void createTable(TM tableModel, String emptyTableText, Subject<PortConfigChangeEvent> portConfigChangeEventSubject, NodeSelectionProvider nodeSelectionProvider) {
        this.table = this.createPortTable(tableModel, emptyTableText);
        this.table.createComponentFactory(portConfigChangeEventSubject, nodeSelectionProvider);
        this.table.setSortingEnabled(false);
        this.table.setAutoResort(true);
        this.table.setRestoreSelectionAndRowHeightAutomatically(true);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = SimpleHierarchicalPortListPanel.this.table.getSelectedRow();
                if (row != -1) {
                    SimpleHierarchicalPortListPanel.this.table.expandRow(row);
                }
            }
        });
        this.table.adjustRowHeight();
        this.table.prepareTableColumns();
        JTableHeader header = this.table.getTableHeader();
        JideSwingUtilities.insertMouseListener((Component)header, (MouseListener)new MouseAdapter((SimpleHierarchicalPortTableModel)tableModel){
            final /* synthetic */ SimpleHierarchicalPortTableModel val$tableModel;
            {
                this.val$tableModel = simpleHierarchicalPortTableModel;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getSource() instanceof CellStyleTableHeader) {
                    CellStyleTableHeader _header = (CellStyleTableHeader)e.getSource();
                    Point p = e.getPoint();
                    int index = _header.originalColumnAtPoint(p);
                    if (_header.getTable() != null && index == 0 && p.x < 20) {
                        SimpleHierarchicalPortListPanel.this.LOGGER.info("Collapse all items.");
                        boolean isCollapsed = this.val$tableModel.isCollapsed();
                        this.val$tableModel.setCollapsed(!isCollapsed);
                        if (isCollapsed) {
                            SimpleHierarchicalPortListPanel.this.expandAllRows();
                        } else {
                            SimpleHierarchicalPortListPanel.this.collapseAllRows();
                        }
                    }
                }
            }
        }, (int)0);
    }

    protected AbstractPortHierarchicalTable<P> createPortTable(TM tableModel, String emptyTableText) {
        return new AbstractPortHierarchicalTable<P>((SimpleHierarchicalPortTableModel)tableModel, emptyTableText){
            private static final long serialVersionUID = 1L;

            public void clearTable() {
            }

            protected AbstractPortEditorPanel<P> createPortEditorPanel(P port, int row, Subject<PortConfigChangeEvent> portConfigChangeEventSubject, NodeSelectionProvider nodeSelectionProvider) {
                return null;
            }

            public void prepareTableColumns() {
            }
        };
    }

    protected PortListMenuListener createPortListMenuListener(final AbstractPortHierarchicalTable<P> portTable, final NodeSelectionProvider nodeSelectionProvider, final Supplier<InsertPortsAware<TM>> insertPortsAware) {
        DefaultPortListMenuListener listener = new DefaultPortListMenuListener(){

            public void editLabel(MouseEvent popupEvent) {
                final int row = portTable.getRow(popupEvent.getPoint());
                if (row > -1) {
                    Object value;
                    Object val = portTable.getValueAt(row, 0);
                    if (val instanceof Port) {
                        val = ((Port)val).toString();
                    }
                    if ((value = val) instanceof String) {
                        new LabelDialog((String)value, popupEvent.getXOnScreen(), popupEvent.getYOnScreen()){

                            public void labelChanged(String label) {
                                portTable.setValueAt((Object)label, row, 0);
                            }
                        };
                    }
                } else {
                    SimpleHierarchicalPortListPanel.this.LOGGER.warn("The row is not available!");
                }
            }

            public void mapPort(MouseEvent popupEvent, LcOutputType lcOutputType) {
                int result;
                int row;
                int[] selectedRows = portTable.getSelectedRows();
                if (selectedRows.length == 0 && (row = portTable.getRow(popupEvent.getPoint())) > -1) {
                    selectedRows = new int[]{row};
                }
                ArrayList<Port> portsToMap = new ArrayList<Port>();
                block0: for (int row2 : selectedRows) {
                    GenericPort pairedPortMaster;
                    Object val = portTable.getValueAt(row2, 0);
                    if (!portTable.getType().isInstance(val)) continue;
                    Port inputPort = (Port)val;
                    SimpleHierarchicalPortListPanel.this.LOGGER.info("Change mapping for port: {}", (Object)inputPort);
                    portsToMap.add(inputPort);
                    if (inputPort.getGenericPort() == null) continue;
                    if (inputPort.getGenericPort().getPairedPortMaster() != null) {
                        SimpleHierarchicalPortListPanel.this.LOGGER.info("The selected port is currently used as SwitchPairPort. Use the master to switch the port to a {}.", (Object)lcOutputType.getKey());
                        WeakReference pairedPortMaster2 = inputPort.getGenericPort().getPairedPortMaster();
                        if (pairedPortMaster2 == null || pairedPortMaster2.get() == null) continue;
                        Port masterPort = PortListUtils.findPortByPortNumber((List)nodeSelectionProvider.getSelectedNode().getPorts(), (int)((GenericPort)pairedPortMaster2.get()).getPortNumber());
                        SimpleHierarchicalPortListPanel.this.LOGGER.info("Found master port to use: {}", (Object)masterPort);
                        if (masterPort == null) continue;
                        if (masterPort.getGenericPort().getCurrentPortType() != LcOutputType.SWITCHPAIRPORT) {
                            masterPort = null;
                            continue;
                        }
                        int columnPortInstance = SimpleHierarchicalPortListPanel.this.tableModel.getColumnPortInstance();
                        Integer portNumber = masterPort.getGenericPort().getPortNumber();
                        for (int rowIndex = 0; rowIndex < SimpleHierarchicalPortListPanel.this.tableModel.getRowCount(); ++rowIndex) {
                            Port currentPort = (Port)SimpleHierarchicalPortListPanel.this.tableModel.getValueAt(rowIndex, columnPortInstance);
                            if (currentPort.getId() != portNumber.intValue()) continue;
                            SimpleHierarchicalPortListPanel.this.LOGGER.info("Found masterPort to map: {}", (Object)currentPort);
                            portsToMap.add(0, currentPort);
                            continue block0;
                        }
                        continue;
                    }
                    int currentPortNumber = inputPort.getId();
                    Port slavePort = PortListUtils.findPortByPortNumber((List)nodeSelectionProvider.getSelectedNode().getPorts(), (int)(currentPortNumber + 1));
                    SimpleHierarchicalPortListPanel.this.LOGGER.info("Found slave port to check: {}", (Object)slavePort);
                    if (slavePort == null || slavePort.getGenericPort().getPairedPortMaster() == null || (pairedPortMaster = (GenericPort)slavePort.getGenericPort().getPairedPortMaster().get()) == null || pairedPortMaster.getPortNumber() != currentPortNumber) continue;
                    SimpleHierarchicalPortListPanel.this.LOGGER.info("Found slave port to map: {}", (Object)slavePort);
                    portsToMap.add(slavePort);
                }
                if (!portsToMap.isEmpty() && (result = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(SimpleHierarchicalPortListPanel.this), Resources.getString(SimpleHierarchicalPortListPanel.class, (String)("switch-port-confirm." + lcOutputType.getKey())), Resources.getString(SimpleHierarchicalPortListPanel.class, (String)"switch-port-title"), 2, 3)) == 0) {
                    TableModel tm = SimpleHierarchicalPortListPanel.this.table.getModel();
                    if (tm instanceof SortableTableModel) {
                        SortableTableModel stm = (SortableTableModel)tm;
                        tm = stm.getActualModel();
                    }
                    SimplePortTableModel portTableModel = (SimplePortTableModel)tm;
                    for (Port port : portsToMap) {
                        SimpleHierarchicalPortListPanel.this.LOGGER.info("Change the port to a {} port: {}", (Object)lcOutputType.getKey(), (Object)port);
                        portTableModel.changePortType(lcOutputType, port);
                    }
                }
            }

            public void insertPorts() {
                if (portTable.getSelectedRow() > -1) {
                    TableModel tm = SimpleHierarchicalPortListPanel.this.table.getModel();
                    if (tm instanceof SortableTableModel) {
                        SortableTableModel stm = (SortableTableModel)tm;
                        tm = stm.getActualModel();
                    }
                    SimpleHierarchicalPortTableModel lightPortTableModel = (SimpleHierarchicalPortTableModel)tm;
                    ((InsertPortsAware)insertPortsAware.get()).insertPorts(portTable.getSelectedRow(), lightPortTableModel);
                }
            }

            public void removePort() {
                if (portTable.getSelectedRow() > -1) {
                    TableModel tm = SimpleHierarchicalPortListPanel.this.table.getModel();
                    if (tm instanceof SortableTableModel) {
                        SortableTableModel stm = (SortableTableModel)tm;
                        tm = stm.getActualModel();
                    }
                    SimpleHierarchicalPortTableModel lightPortTableModel = (SimpleHierarchicalPortTableModel)tm;
                    ((InsertPortsAware)insertPortsAware.get()).removePort(portTable.getSelectedRow(), lightPortTableModel);
                }
            }
        };
        return listener;
    }

    public void setPortListener(L listener) {
        this.portListener = listener;
    }

    @Override
    public String getName() {
        return Resources.getString(this.getClass(), (String)"name");
    }

    protected void collapseAllRows() {
        this.tableModel.setCollapsed(true);
        this.table.collapseAllRows();
    }

    protected void expandAllRows() {
        this.tableModel.setCollapsed(false);
        this.table.expandAllRows();
        this.scrollToTop();
    }

    public void listChanged() {
        SwingUtils.executeInEDT(() -> this.processListChanged());
    }

    public void refreshPorts() {
        this.LOGGER.info("Refresh ports.");
        this.getPorts();
        this.listChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processListChanged() {
        List<P> ports;
        if (this.tableModel == null) {
            return;
        }
        this.collapseAllRows();
        this.tableModel.setRowCount(0);
        List<P> list = ports = this.getPorts();
        synchronized (list) {
            for (Port port : ports) {
                this.LOGGER.debug("Adding row for port: {}", (Object)port);
                this.tableModel.addRow(port);
            }
        }
        if (AbstractHierarchicalEmptyTable.PackLastColumnEnum.NONE != this.isPackLastColumn()) {
            this.packColumn();
        }
        this.scrollToTop();
        this.LOGGER.debug("The port list has changed has finished in SimplePortListPanel.");
    }

    protected void packColumn() {
        if (this.table.getColumnCount() > 1) {
            this.table.packColumn(this.table.getColumnCount() - 1, 2, this.isPackLastColumn());
        }
    }

    protected AbstractHierarchicalEmptyTable.PackLastColumnEnum isPackLastColumn() {
        return AbstractHierarchicalEmptyTable.PackLastColumnEnum.FIXED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeLabel(TargetType portType) {
        List<P> ports;
        int portNum = portType.getPortNum();
        String label = portType.getLabel();
        Port port = null;
        List<P> list = ports = this.getPorts();
        synchronized (list) {
            port = PortListUtils.findPortByPortNumber(ports, (int)portNum);
        }
        if (port != null) {
            this.LOGGER.info("Set the port label: {}", (Object)label);
            port.setLabel(label);
            try {
                this.portListener.labelChanged(port, label);
            }
            catch (Exception ex) {
                this.LOGGER.warn("Change port label failed.", (Throwable)ex);
            }
        }
    }

    protected abstract List<P> getPorts();

    public PortListener<P> getPortListener() {
        return this.portListener;
    }

    private void scrollToTop() {
        this.table.scrollToTop();
    }

    @Override
    public boolean hasPendingChanges() {
        return this.table != null && this.table.hasPendingChanges();
    }

    @Override
    public void savePendingChanges() {
        this.LOGGER.info("Save pending changes.");
        if (this.table != null) {
            this.table.savePendingChanges();
        }
    }
}

