/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.table;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;
import org.bidib.wizard.client.common.view.renderer.BidibStatusListRenderer;
import org.bidib.wizard.model.status.BidibStatus;

public class ComboBoxRenderer<E>
extends JComboBox<E>
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    private Color unselectedForeground;
    private Color unselectedBackground;
    private static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);

    public ComboBoxRenderer(E[] items) {
        super(items);
        this.setOpaque(false);
        this.setBorder(this.getNoFocusBorder());
    }

    public static <E extends BidibStatus> ComboBoxRenderer<E> createComboBoxRenderer(E[] items, String resourceClazz) {
        ComboBoxRenderer<E> comboBoxRenderer = new ComboBoxRenderer<E>(items);
        comboBoxRenderer.setRenderer((ListCellRenderer<E>)new BidibStatusListRenderer(resourceClazz));
        return comboBoxRenderer;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color fg = null;
        Color bg = null;
        if (isSelected) {
            super.setForeground(fg == null ? table.getSelectionForeground() : fg);
            super.setBackground(bg == null ? table.getSelectionBackground() : bg);
        } else {
            Color alternateColor;
            Color background;
            Color color = background = this.unselectedBackground != null ? this.unselectedBackground : table.getBackground();
            if ((background == null || background instanceof UIResource) && (alternateColor = UIManager.getDefaults().getColor("Table.alternateRowColor")) != null && row % 2 != 0) {
                background = alternateColor;
            }
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
            super.setBackground(background);
        }
        if (hasFocus) {
            Border border = null;
            if (isSelected) {
                border = UIManager.getDefaults().getBorder("Table.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getDefaults().getBorder("Table.focusCellHighlightBorder");
            }
            this.setBorder(border);
            if (!isSelected && table.isCellEditable(row, column)) {
                Color col = UIManager.getDefaults().getColor("Table.focusCellForeground");
                if (col != null) {
                    super.setForeground(col);
                }
                if ((col = UIManager.getDefaults().getColor("Table.focusCellBackground")) != null) {
                    super.setBackground(col);
                }
            }
        } else {
            this.setBorder(this.getNoFocusBorder());
        }
        this.setSelectedItem(value);
        return this;
    }

    private Border getNoFocusBorder() {
        Border border = UIManager.getDefaults().getBorder("Table.cellNoFocusBorder");
        if (border != null) {
            return border;
        }
        return SAFE_NO_FOCUS_BORDER;
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.unselectedForeground = c;
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.unselectedBackground = c;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }
}

