/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.pom.view.panel;

import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.util.DefaultValidationResultModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PomValidationResultModel
extends DefaultValidationResultModel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PomValidationResultModel.class);
    public static final String PROPERTY_VALID_STATE = "validState";
    public static final String PROPERTY_VALID_STATE_NO_WARN_OR_ERRORS = "validStateNoWarnOrErrors";
    private boolean validState;
    private boolean validStateNoWarnOrErrors;
    private PomValidationResultModel parentValidationModel;

    public PomValidationResultModel() {
        this(null);
    }

    public PomValidationResultModel(PomValidationResultModel parentValidationModel) {
        this.parentValidationModel = parentValidationModel;
    }

    public void setResult(ValidationResult newResult) {
        boolean oldValidStateNoWarnErrors;
        boolean oldValidState = this.getResult().isEmpty();
        boolean bl = oldValidStateNoWarnErrors = !this.getResult().hasWarnings() && !this.getResult().hasErrors();
        if (this.parentValidationModel != null) {
            LOGGER.info("Add the messages of the parent.");
            ValidationResult parentResult = this.parentValidationModel.getResult();
            newResult.addAll(parentResult.getMessages());
        }
        super.setResult(newResult);
        boolean newValidState = newResult.isEmpty();
        boolean newValidStateNoWarnErrors = !newResult.hasWarnings() && !newResult.hasErrors();
        LOGGER.info("Set the newValidState: {}, oldValidState: {}, newValidStateNoWarnErrors: {}, oldValidStateNoWarnErrors: {}", new Object[]{newValidState, oldValidState, newValidStateNoWarnErrors, oldValidStateNoWarnErrors});
        this.validState = newValidState;
        this.validStateNoWarnOrErrors = newValidStateNoWarnErrors;
        this.firePropertyChange(PROPERTY_VALID_STATE, oldValidState, newValidState);
        this.firePropertyChange(PROPERTY_VALID_STATE_NO_WARN_OR_ERRORS, oldValidStateNoWarnErrors, newValidStateNoWarnErrors);
    }

    public boolean getValidState() {
        return this.validState;
    }

    public boolean getValidStateNoWarnOrErrors() {
        return this.validStateNoWarnOrErrors;
    }
}

