/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.position.model;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.messages.enums.FeedbackPortEnum;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.wizard.model.ports.FeedbackPort;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.FeedbackPortStatus;
import org.bidib.wizard.mvc.position.model.PositionAddressData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionFeedbackPort
extends Port<FeedbackPortStatus> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PositionFeedbackPort.class);
    private static final long serialVersionUID = 1L;
    private Set<PositionAddressData> addresses;

    public PositionFeedbackPort(int locationAddress) {
        super((GenericPort)null);
        this.setId(locationAddress);
        this.addresses = new HashSet<PositionAddressData>();
        this.setStatus(FeedbackPortStatus.FREE);
    }

    public void setStatus(FeedbackPortStatus status) {
        super.setStatus((BidibStatus)status);
        if (FeedbackPortStatus.FREE.equals((Object)status)) {
            // empty if block
        }
    }

    public Set<PositionAddressData> getAddresses() {
        return this.addresses;
    }

    public boolean hasAddresses() {
        return CollectionUtils.isNotEmpty(this.addresses);
    }

    public void setAddresses(Set<PositionAddressData> addresses) {
        this.addresses = addresses;
    }

    public void addAddress(PositionAddressData address) {
        LOGGER.debug("Add the address: {}", (Object)address);
        this.addresses.remove(address);
        this.addresses.add(address);
    }

    public void removeAddress(PositionAddressData address) {
        LOGGER.debug("remove the address: {}", (Object)address);
        this.addresses.remove(address);
    }

    public void clear() {
        this.addresses.clear();
    }

    public boolean isOutdated(long timeout) {
        boolean outdated = false;
        if (this.addresses != null) {
            for (PositionAddressData address : this.addresses) {
                if (!this.isOutDated(address.getLastSeenTimestamp(), System.currentTimeMillis(), timeout)) continue;
                outdated = true;
            }
        }
        return outdated;
    }

    private boolean isOutDated(long timestamp, long now, long timeout) {
        return now - timestamp > timeout;
    }

    public byte[] getPortConfig() {
        return new byte[]{0, 0, 0, 0};
    }

    public boolean equals(Object obj) {
        if (obj instanceof FeedbackPort) {
            return ((FeedbackPort)obj).getId() == this.getId();
        }
        return false;
    }

    public int hashCode() {
        return this.getId();
    }

    public LcOutputType getPortType() {
        return LcOutputType.FEEDBACKPORT;
    }

    protected FeedbackPortStatus internalGetStatus(GenericPort genericPort) {
        return FeedbackPortStatus.valueOf((FeedbackPortEnum)FeedbackPortEnum.valueOf((byte)genericPort.getPortStatus()));
    }
}

