/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.position.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.api.model.PositionAddressData;
import org.bidib.wizard.api.model.PositionFeedbackPort;
import org.bidib.wizard.model.status.FeedbackPortStatus;
import org.bidib.wizard.mvc.common.view.panel.DisabledPanel;

public class FeedbackPositionTableCellRenderer
implements TableCellRenderer {
    private JPanel panel = new JPanel(new GridBagLayout());
    private DisabledPanel disabledInnerPanel;
    private int timeout = 5000;
    private JPanel innerPanel;
    private JLabel portLabel;
    private JLabel confidenceLabel;
    private JPanel addressPanel;
    private JLabel dynStateLabel;
    private JLabel timestampLabel;

    public FeedbackPositionTableCellRenderer() {
        this.panel.setOpaque(true);
        this.disabledInnerPanel = this.createInnerPanel();
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.panel.removeAll();
        if (value instanceof PositionFeedbackPort) {
            PositionFeedbackPort port = (PositionFeedbackPort)value;
            FeedbackPortStatus status = (FeedbackPortStatus)port.getStatus();
            ArrayList addresses = new ArrayList(port.getAddresses());
            String label = null;
            label = StringUtils.isNotBlank((CharSequence)port.getLabel()) ? String.format("%1$02d : %2$s", port.getId(), port.getLabel()) : (port.getId() > -1 ? String.format("%1$02d", port.getId()) : " ");
            this.portLabel.setText(label);
            this.addressPanel.removeAll();
            if (addresses != null) {
                for (PositionAddressData address : addresses) {
                    this.addressPanel.add(new JLabel(this.getAddressData(address)));
                }
            }
            if (status == FeedbackPortStatus.OCCUPIED) {
                if (!port.isOutdated((long)this.timeout)) {
                    this.innerPanel.setBackground(Color.RED);
                } else {
                    this.innerPanel.setBackground(Color.ORANGE);
                }
            } else {
                this.innerPanel.setBackground(Color.GREEN);
            }
            boolean enabled = true;
            this.disabledInnerPanel.setEnabled(enabled);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.panel.add((Component)this.disabledInnerPanel, c);
        }
        return this.panel;
    }

    private DisabledPanel createInnerPanel() {
        this.innerPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        this.portLabel = new JLabel();
        Font f = this.portLabel.getFont();
        this.portLabel.setFont(f.deriveFont(f.getStyle() | 1));
        this.innerPanel.add((Component)this.portLabel, c);
        ++c.gridy;
        this.confidenceLabel = new JLabel();
        this.innerPanel.add((Component)this.confidenceLabel, c);
        this.addressPanel = new JPanel();
        this.addressPanel.setOpaque(false);
        this.addressPanel.setLayout(new BoxLayout(this.addressPanel, 3));
        ++c.gridy;
        this.innerPanel.add((Component)this.addressPanel, c);
        this.dynStateLabel = new JLabel();
        ++c.gridy;
        this.innerPanel.add((Component)this.dynStateLabel, c);
        this.timestampLabel = new JLabel();
        ++c.gridy;
        this.innerPanel.add((Component)this.timestampLabel, c);
        c.fill = 1;
        ++c.gridy;
        c.weighty = 1.0;
        this.innerPanel.add(Box.createVerticalGlue(), c);
        DisabledPanel disabledInnerPanel = new DisabledPanel(this.innerPanel);
        c.gridy = 0;
        this.panel.add((Component)disabledInnerPanel, c);
        return disabledInnerPanel;
    }

    private String getAddressData(PositionAddressData address) {
        StringBuilder result = new StringBuilder();
        if (address != null) {
            if (result.length() > 0) {
                result.append(',');
            }
            int addr = address.getDecoderAddress();
            result.append(addr);
        } else {
            result.append("[]");
        }
        return result.toString();
    }
}

