/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.worklist.controller.actions;

import com.vlsolutions.swing.docking.DockingDesktop;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.swing.JOptionPane;
import org.bidib.api.json.types.firmware.FirmwareVersionType;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.wizard.api.event.FirmwareUpdateWorkListItemEvent;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.exception.UserActionAbortedException;
import org.bidib.wizard.client.common.view.statusbar.StatusBar;
import org.bidib.wizard.firmwarerepo.core.NodeFirmwareRepoService;
import org.bidib.wizard.mvc.worklist.controller.actions.WorkListAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class DownloadFirmwareAction
implements WorkListAction<FirmwareUpdateWorkListItemEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadFirmwareAction.class);
    private final ApplicationContext applicationContext;
    private final StatusBar statusBar;
    private final ScheduledExecutorService firmwareDownloadWorker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("firmwareDownloadWorkers-thread-%d").build());

    public DownloadFirmwareAction(ApplicationContext applicationContext, StatusBar statusBar) {
        this.applicationContext = applicationContext;
        this.statusBar = statusBar;
    }

    @Override
    public void apply(DockingDesktop desktop, FirmwareUpdateWorkListItemEvent actionEvent) throws UserActionAbortedException {
        LOGGER.info("Let the node firmware repo service download the new firmware.");
        int result = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(desktop.getRootPane()), Resources.getString(DownloadFirmwareAction.class, (String)"download-new-firmware.text"), Resources.getString(DownloadFirmwareAction.class, (String)"download-new-firmware.title"), 2);
        if (result == 0) {
            LOGGER.info("Download the new firmware to the local repo. Current repoOrigin: {}", List.of(actionEvent.getRepoOrigin()));
            if (actionEvent.getRepoOrigin() != null && actionEvent.getRepoOrigin().length > 0) {
                for (FirmwareVersionType.FirmwareRepoOriginType repoOrigin : actionEvent.getRepoOrigin()) {
                    this.downloadFirmware(repoOrigin);
                }
            } else {
                this.downloadFirmware(FirmwareVersionType.FirmwareRepoOriginType.publicRepo);
            }
        } else {
            LOGGER.info("Download the new firmware to the local repo dialog was cancelled.");
            throw new UserActionAbortedException("Download the new firmware to the local repo dialog was cancelled.");
        }
    }

    private void downloadFirmware(FirmwareVersionType.FirmwareRepoOriginType repoOrigin) {
        this.statusBar.setStatusText(Resources.getString(DownloadFirmwareAction.class, (String)"download-firmware-start.text"));
        this.firmwareDownloadWorker.submit(() -> {
            try {
                NodeFirmwareRepoService nodeFirmwareRepoService = (NodeFirmwareRepoService)this.applicationContext.getBean(NodeFirmwareRepoService.class);
                nodeFirmwareRepoService.downloadNewRemoteFirmwareAvailable(repoOrigin, path -> this.statusBar.setProgress(Resources.getString(DownloadFirmwareAction.class, (String)"download-successful", (Object[])new Object[]{path}), true));
                this.statusBar.setStatusText(Resources.getString(DownloadFirmwareAction.class, (String)"download-firmware-passed.text"));
            }
            catch (Exception ex) {
                LOGGER.warn("Download firmware has failed.", (Throwable)ex);
                this.statusBar.setStatusText(Resources.getString(DownloadFirmwareAction.class, (String)"download-firmware-failed.text", (Object[])new Object[]{ex.getMessage()}));
            }
        });
    }
}

