/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.worklist.view;

import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jidesoft.grid.RolloverTableUtils;
import com.jidesoft.grid.SortableTableModel;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingDesktop;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.bidib.wizard.api.event.WorkListItemEvent;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.table.AbstractEmptyTable;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.mvc.worklist.controller.listener.WorkListControllerListener;
import org.bidib.wizard.mvc.worklist.model.ActionTableCellRenderer;
import org.bidib.wizard.mvc.worklist.model.WorkItemListModel;
import org.bidib.wizard.mvc.worklist.model.WorkItemModel;
import org.bidib.wizard.mvc.worklist.model.WorkListItemTableModel;
import org.bidib.wizard.mvc.worklist.view.ButtonsCellEditorRenderer;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkListView
implements Dockable {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkListView.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, fill:50dlu:grow";
    private static final String ENCODED_DIALOG_ROW_SPECS = "fill:50dlu:grow";
    private JPanel contentPanel;
    private final DockingDesktop desktop;
    private final WorkItemListModel workItemListModel;
    private final WorkListControllerListener controller;
    private SelectionInList<WorkItemModel> workItemSelection;
    private ButtonsCellEditorRenderer buttonEditor;

    public WorkListView(DockingDesktop desktop, WorkListControllerListener controller, WorkItemListModel workItemListModel) {
        this.desktop = desktop;
        this.controller = controller;
        this.workItemListModel = workItemListModel;
        DockKeys.DOCKKEY_WORK_LIST_VIEW.setName(Resources.getString(this.getClass(), (String)"title"));
        DockKeys.DOCKKEY_WORK_LIST_VIEW.setLocation(DockableState.Location.HIDDEN);
    }

    private JPanel createPanel() {
        Object panel;
        LOGGER.info("Create the content panel.");
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new FormDebugPanel();
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout());
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        this.workItemSelection = new SelectionInList(this.workItemListModel.getWorkItemListModel());
        final SortableTableModel tableModel = new SortableTableModel((TableModel)((Object)new WorkListItemTableModel(this.workItemSelection)));
        final AbstractEmptyTable workItemsTable = new AbstractEmptyTable((TableModel)tableModel, Resources.getString(this.getClass(), (String)"empty_table")){
            private static final long serialVersionUID = 1L;
        };
        workItemsTable.adjustRowHeight();
        this.buttonEditor = new ButtonsCellEditorRenderer(d -> {
            LOGGER.info("Pressed button on row: {}, action: {}", (Object)d.getRow(), (Object)d.getAction());
            int selectedRow = d.getRow();
            int sortedRow = tableModel.getSortedRowAt(selectedRow);
            WorkListItemTableModel workListItemTableModel = (WorkListItemTableModel)((Object)((Object)tableModel.getActualModel()));
            WorkItemModel selected = (WorkItemModel)((Object)((Object)workListItemTableModel.getRow(sortedRow)));
            switch (d.getAction()) {
                case DELETE: {
                    LOGGER.info("Remove selected: {}", (Object)selected);
                    int result = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(this.desktop.getRootPane()), Resources.getString(WorkListView.class, (String)"delete-item.text"), Resources.getString(WorkListView.class, (String)"delete-item.title"), 2);
                    if (result != 0) break;
                    try {
                        this.workItemListModel.removeWorkListItem(selected);
                        if (!this.workItemListModel.getWorkItems().isEmpty()) break;
                        RolloverTableUtils.cancelRollover((JTable)workItemsTable, null);
                        workItemsTable.updateUI();
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Remove item or cancel rollover failed.", (Throwable)ex);
                    }
                    break;
                }
                case EDIT: {
                    LOGGER.info("Perform action on row: {}", (Object)d.getRow());
                    try {
                        this.controller.applyAction(selected);
                        RolloverTableUtils.cancelRollover((JTable)workItemsTable, null);
                        workItemsTable.updateUI();
                        break;
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Perform action of item failed.", (Throwable)ex);
                    }
                }
            }
        });
        workItemsTable.getColumnModel().getColumn(0).setPreferredWidth(60);
        workItemsTable.getColumnModel().getColumn(1).setCellRenderer(new ActionTableCellRenderer());
        workItemsTable.getColumnModel().getColumn(2).setCellEditor((TableCellEditor)((Object)this.buttonEditor));
        workItemsTable.getColumnModel().getColumn(2).setCellRenderer((TableCellRenderer)((Object)this.buttonEditor));
        int columnWidth = 35;
        workItemsTable.getColumnModel().getColumn(2).setPreferredWidth(columnWidth);
        workItemsTable.getColumnModel().getColumn(2).setMaxWidth(100);
        workItemsTable.getColumnModel().getColumn(2).setMinWidth(columnWidth);
        RolloverTableUtils.install((JTable)workItemsTable);
        JScrollPane positionsTableScrollPane = new JScrollPane((Component)workItemsTable);
        dialogBuilder.add((Component)positionsTableScrollPane).xyw(1, 1, 3);
        this.contentPanel = dialogBuilder.build();
        AnnotationProcessor.process((Object)this);
        workItemsTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    int selectedRow = workItemsTable.getSelectedRow();
                    int sortedRow = tableModel.getSortedRowAt(selectedRow);
                    WorkListItemTableModel workListItemTableModel = (WorkListItemTableModel)((Object)tableModel.getActualModel());
                    WorkItemModel selected = (WorkItemModel)((Object)workListItemTableModel.getRow(sortedRow));
                    LOGGER.info("Perform action on selected: {}", (Object)selected);
                    try {
                        WorkListView.this.controller.applyAction(selected);
                        RolloverTableUtils.cancelRollover((JTable)workItemsTable, null);
                        workItemsTable.updateUI();
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Perform action of item failed.", (Throwable)ex);
                    }
                }
                super.mouseClicked(e);
            }
        });
        return this.contentPanel;
    }

    public Component getComponent() {
        if (this.contentPanel == null) {
            this.contentPanel = this.createPanel();
        }
        return this.contentPanel;
    }

    public DockKey getDockKey() {
        return DockKeys.DOCKKEY_WORK_LIST_VIEW;
    }

    public boolean addWorkListItem(WorkListItemEvent item) {
        LOGGER.info("Received worklist item event: {}", (Object)item);
        return this.workItemListModel.addWorkListItem(item);
    }
}

