/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.utils;

import java.util.List;
import org.bidib.jbidibc.core.schema.bidib2.DirectionType;
import org.bidib.jbidibc.core.schema.bidib2.FunctionAccessoryNotification;
import org.bidib.jbidibc.core.schema.bidib2.FunctionCriticalSection;
import org.bidib.jbidibc.core.schema.bidib2.FunctionDelay;
import org.bidib.jbidibc.core.schema.bidib2.FunctionFlag;
import org.bidib.jbidibc.core.schema.bidib2.FunctionInput;
import org.bidib.jbidibc.core.schema.bidib2.FunctionMacro;
import org.bidib.jbidibc.core.schema.bidib2.FunctionOutputLight;
import org.bidib.jbidibc.core.schema.bidib2.FunctionOutputSwitch;
import org.bidib.jbidibc.core.schema.bidib2.MacroPoint;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointAccessoryNotification;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointCriticalSection;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointDelay;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointFlag;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointInput;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointMacro;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointOutputAnalog;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointOutputBacklight;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointOutputLight;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointOutputMotor;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointOutputServo;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointOutputSound;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointOutputSwitch;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointOutputSwitchPair;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointServoMoveQuery;
import org.bidib.wizard.api.model.Flag;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.function.AccessoryOkayFunction;
import org.bidib.wizard.api.model.function.AnalogPortAction;
import org.bidib.wizard.api.model.function.BacklightPortAction;
import org.bidib.wizard.api.model.function.CriticalFunction;
import org.bidib.wizard.api.model.function.DelayFunction;
import org.bidib.wizard.api.model.function.FlagFunction;
import org.bidib.wizard.api.model.function.Function;
import org.bidib.wizard.api.model.function.InputFunction;
import org.bidib.wizard.api.model.function.LightPortAction;
import org.bidib.wizard.api.model.function.MacroFunction;
import org.bidib.wizard.api.model.function.MotorPortAction;
import org.bidib.wizard.api.model.function.RandomDelayFunction;
import org.bidib.wizard.api.model.function.ServoMoveQueryFunction;
import org.bidib.wizard.api.model.function.ServoPortAction;
import org.bidib.wizard.api.model.function.SoundPortAction;
import org.bidib.wizard.api.model.function.SwitchPairPortAction;
import org.bidib.wizard.api.model.function.SwitchPortAction;
import org.bidib.wizard.api.utils.PortListUtils;
import org.bidib.wizard.common.utils.FlagListUtils;
import org.bidib.wizard.model.ports.AnalogPort;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.ports.MotorPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.ServoPort;
import org.bidib.wizard.model.ports.SoundPort;
import org.bidib.wizard.model.ports.SwitchPairPort;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.model.status.AccessoryOkayStatus;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.CriticalFunctionStatus;
import org.bidib.wizard.model.status.FlagStatus;
import org.bidib.wizard.model.status.InputStatus;
import org.bidib.wizard.model.status.LightPortStatus;
import org.bidib.wizard.model.status.MacroStatus;
import org.bidib.wizard.model.status.MotorPortStatus;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionConversionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(FunctionConversionFactory.class);

    public MacroPoint convert(Function<? extends BidibStatus> function) {
        MacroPoint macroPoint = null;
        LOGGER.info("Current key: {}", (Object)function.getKey());
        switch (function.getKey()) {
            case "accessoryOkay": {
                macroPoint = this.convertAccessoryAction((AccessoryOkayFunction)function);
                break;
            }
            case "analog": {
                macroPoint = this.convertAnalogPortAction((AnalogPortAction)function);
                break;
            }
            case "backlight": {
                macroPoint = this.convertBacklightPortAction((BacklightPortAction)function);
                break;
            }
            case "critical": {
                macroPoint = this.convertCriticalAction((CriticalFunction)function);
                break;
            }
            case "delay": {
                macroPoint = this.convertDelayAction((DelayFunction)function);
                break;
            }
            case "flag": {
                macroPoint = this.convertFlagAction((FlagFunction)function);
                break;
            }
            case "input": {
                macroPoint = this.convertInputAction((InputFunction)function);
                break;
            }
            case "light": {
                macroPoint = this.convertLightPortAction((LightPortAction)function);
                break;
            }
            case "macro": {
                macroPoint = this.convertMacroAction((MacroFunction)function);
                break;
            }
            case "motor": {
                macroPoint = this.convertMotorPortAction((MotorPortAction)function);
                break;
            }
            case "randomDelay": {
                macroPoint = this.convertRandomDelayAction((RandomDelayFunction)function);
                break;
            }
            case "servo": {
                macroPoint = this.convertServoPortAction((ServoPortAction)function);
                break;
            }
            case "moveServoQuery": {
                macroPoint = this.convertServoMoveQueryAction((ServoMoveQueryFunction)function);
                break;
            }
            case "sound": {
                macroPoint = this.convertSoundPortAction((SoundPortAction)function);
                break;
            }
            case "switch": {
                macroPoint = this.convertSwitchPortAction((SwitchPortAction)function);
                break;
            }
            case "switchpair": {
                macroPoint = this.convertSwitchPairPortAction((SwitchPairPortAction)function);
                break;
            }
            default: {
                LOGGER.warn("Unknown function detected: {}", function);
            }
        }
        return macroPoint;
    }

    public Function<? extends BidibStatus> convert(MacroPoint macroPoint, NodeInterface node) {
        CriticalFunction function = null;
        LOGGER.info("Current macroPoint: {}", (Object)macroPoint);
        if (macroPoint instanceof MacroPointInput) {
            function = this.convertInputPoint((MacroPointInput)macroPoint, node.getInputPorts());
        } else if (macroPoint instanceof MacroPointMacro) {
            function = this.convertMacroPointMacro((MacroPointMacro)macroPoint);
        } else if (macroPoint instanceof MacroPointFlag) {
            function = this.convertMacroPointFlag((MacroPointFlag)macroPoint, node.getFlags());
        } else if (macroPoint instanceof MacroPointDelay) {
            function = this.convertMacroPointDelay((MacroPointDelay)macroPoint);
        } else if (macroPoint instanceof MacroPointCriticalSection) {
            function = this.convertMacroPointCriticalSection((MacroPointCriticalSection)macroPoint);
        } else if (macroPoint instanceof MacroPointAccessoryNotification) {
            function = this.convertMacroPointAccessoryNotification((MacroPointAccessoryNotification)macroPoint, node.getInputPorts());
        } else if (macroPoint instanceof MacroPointServoMoveQuery) {
            function = this.convertMacroPointServoMoveQuery((MacroPointServoMoveQuery)macroPoint, node.getServoPorts());
        } else if (macroPoint instanceof MacroPointOutputServo) {
            function = this.convertMacroPointOutputServo((MacroPointOutputServo)macroPoint, node.getServoPorts());
        } else if (macroPoint instanceof MacroPointOutputSwitch) {
            function = this.convertMacroPointOutputSwitch((MacroPointOutputSwitch)macroPoint, node.getSwitchPorts());
        } else if (macroPoint instanceof MacroPointOutputSwitchPair) {
            function = this.convertMacroPointOutputSwitchPair((MacroPointOutputSwitchPair)macroPoint, node.getSwitchPairPorts());
        } else if (macroPoint instanceof MacroPointOutputSound) {
            function = this.convertMacroPointOutputSound((MacroPointOutputSound)macroPoint, node.getSoundPorts());
        } else if (macroPoint instanceof MacroPointOutputMotor) {
            function = this.convertMacroPointOutputMotor((MacroPointOutputMotor)macroPoint, node.getMotorPorts());
        } else if (macroPoint instanceof MacroPointOutputAnalog) {
            function = this.convertMacroPointOutputAnalog((MacroPointOutputAnalog)macroPoint, node.getAnalogPorts());
        } else if (macroPoint instanceof MacroPointOutputLight) {
            function = this.convertMacroPointOutputLight((MacroPointOutputLight)macroPoint, node.getLightPorts());
        } else if (macroPoint instanceof MacroPointOutputBacklight) {
            function = this.convertMacroPointOutputBacklight((MacroPointOutputBacklight)macroPoint, node.getBacklightPorts());
        } else {
            LOGGER.warn("Unhandled macroPoint detected: {}", (Object)macroPoint);
        }
        return function;
    }

    protected MacroPoint convertInputAction(InputFunction function) {
        MacroPointInput macroPoint = new MacroPointInput();
        switch ((InputStatus)function.getAction()) {
            case QUERY0: {
                macroPoint.setFunction(FunctionInput.WAIT_FOR_0);
                break;
            }
            case QUERY1: {
                macroPoint.setFunction(FunctionInput.WAIT_FOR_1);
                break;
            }
            default: {
                LOGGER.warn("Unknown input action detected: {}", (Object)function);
            }
        }
        macroPoint.setInputNumber(function.getInput().getId());
        return macroPoint;
    }

    protected InputFunction convertInputPoint(MacroPointInput macroPoint, List<InputPort> inputPorts) {
        InputFunction function = new InputFunction();
        switch (macroPoint.getFunction()) {
            case WAIT_FOR_0: {
                function.setAction((BidibStatus)InputStatus.QUERY0);
                break;
            }
            case WAIT_FOR_1: {
                function.setAction((BidibStatus)InputStatus.QUERY1);
                break;
            }
            default: {
                LOGGER.warn("Unknown input action detected: {}", (Object)macroPoint);
            }
        }
        InputPort inputPort = (InputPort)PortListUtils.findPortByPortNumber(inputPorts, (int)macroPoint.getInputNumber());
        function.setInput(inputPort);
        return function;
    }

    protected MacroPoint convertMacroAction(MacroFunction function) {
        MacroPointMacro macroPoint = new MacroPointMacro();
        switch ((MacroStatus)function.getAction()) {
            case START: {
                macroPoint.setFunction(FunctionMacro.START);
                break;
            }
            case STOP: {
                macroPoint.setFunction(FunctionMacro.STOP);
                break;
            }
            default: {
                LOGGER.warn("Unknown macro action detected: {}", (Object)function);
            }
        }
        macroPoint.setMacroNumber(function.getMacroId());
        return macroPoint;
    }

    protected MacroFunction convertMacroPointMacro(MacroPointMacro macroPoint) {
        MacroFunction function = new MacroFunction();
        switch (macroPoint.getFunction()) {
            case START: {
                function.setAction((BidibStatus)MacroStatus.START);
                break;
            }
            case STOP: {
                function.setAction((BidibStatus)MacroStatus.STOP);
                break;
            }
            default: {
                LOGGER.warn("Unknown macro action detected: {}", (Object)macroPoint);
            }
        }
        function.setMacroId(macroPoint.getMacroNumber());
        return function;
    }

    protected MacroPoint convertFlagAction(FlagFunction function) {
        MacroPointFlag macroPoint = new MacroPointFlag();
        switch ((FlagStatus)function.getAction()) {
            case CLEAR: {
                macroPoint.setFunction(FunctionFlag.RESET);
                break;
            }
            case QUERY_0: {
                macroPoint.setFunction(FunctionFlag.QUERY_0);
                break;
            }
            case QUERY_1: {
                macroPoint.setFunction(FunctionFlag.QUERY_1);
                break;
            }
            case SET: {
                macroPoint.setFunction(FunctionFlag.SET);
                break;
            }
            default: {
                LOGGER.warn("Unknown flag action detected: {}", (Object)function);
            }
        }
        macroPoint.setFlagNumber(function.getFlag().getId());
        return macroPoint;
    }

    protected FlagFunction convertMacroPointFlag(MacroPointFlag macroPoint, List<Flag> flags) {
        FlagFunction function = new FlagFunction();
        switch (macroPoint.getFunction()) {
            case RESET: {
                function.setAction((BidibStatus)FlagStatus.CLEAR);
                break;
            }
            case QUERY_0: {
                function.setAction((BidibStatus)FlagStatus.QUERY_0);
                break;
            }
            case QUERY_1: {
                function.setAction((BidibStatus)FlagStatus.QUERY_1);
                break;
            }
            case SET: {
                function.setAction((BidibStatus)FlagStatus.SET);
                break;
            }
            default: {
                LOGGER.warn("Unknown flag action detected: {}", (Object)macroPoint);
            }
        }
        Flag flag = FlagListUtils.findFlagByNumber(flags, (int)macroPoint.getFlagNumber());
        function.setFlag(flag);
        return function;
    }

    protected MacroPoint convertDelayAction(DelayFunction function) {
        MacroPointDelay macroPoint = new MacroPointDelay();
        macroPoint.setFunction(FunctionDelay.FIXED);
        macroPoint.setDelay(function.getDelay());
        return macroPoint;
    }

    protected MacroPoint convertRandomDelayAction(RandomDelayFunction function) {
        MacroPointDelay macroPoint = new MacroPointDelay();
        macroPoint.setFunction(FunctionDelay.RANDOM);
        macroPoint.setDelay(function.getMaximumValue());
        return macroPoint;
    }

    protected Function<? extends BidibStatus> convertMacroPointDelay(MacroPointDelay macroPoint) {
        if (FunctionDelay.FIXED.equals((Object)macroPoint.getFunction())) {
            return ((DelayFunction.DelayFunctionBuilder)DelayFunction.DelayFunctionBuilder.delayFunction().withDelay(macroPoint.getDelay())).build();
        }
        return ((RandomDelayFunction.RandomDelayFunctionBuilder)RandomDelayFunction.RandomDelayFunctionBuilder.randomDelayFunction().withDelay(macroPoint.getDelay())).build();
    }

    protected MacroPoint convertCriticalAction(CriticalFunction function) {
        MacroPointCriticalSection macroPoint = new MacroPointCriticalSection();
        switch ((CriticalFunctionStatus)function.getAction()) {
            case BEGIN: {
                macroPoint.setFunction(FunctionCriticalSection.BEGIN);
                break;
            }
            case END: {
                macroPoint.setFunction(FunctionCriticalSection.END);
                break;
            }
            default: {
                LOGGER.warn("Unknown criticalSection action detected: {}", (Object)function);
            }
        }
        return macroPoint;
    }

    protected CriticalFunction convertMacroPointCriticalSection(MacroPointCriticalSection macroPoint) {
        CriticalFunction function = new CriticalFunction();
        switch (macroPoint.getFunction()) {
            case BEGIN: {
                function.setAction((BidibStatus)CriticalFunctionStatus.BEGIN);
                break;
            }
            case END: {
                function.setAction((BidibStatus)CriticalFunctionStatus.END);
                break;
            }
            default: {
                LOGGER.warn("Unknown criticalSection action detected: {}", (Object)macroPoint);
            }
        }
        return function;
    }

    protected MacroPoint convertAccessoryAction(AccessoryOkayFunction function) {
        MacroPointAccessoryNotification macroPoint = new MacroPointAccessoryNotification();
        switch ((AccessoryOkayStatus)function.getAction()) {
            case QUERY0: {
                macroPoint.setFunction(FunctionAccessoryNotification.OKAY_IF_INPUT_0);
                macroPoint.setInputNumber(Integer.valueOf(function.getInput().getId()));
                break;
            }
            case QUERY1: {
                macroPoint.setFunction(FunctionAccessoryNotification.OKAY_IF_INPUT_1);
                macroPoint.setInputNumber(Integer.valueOf(function.getInput().getId()));
                break;
            }
            case NO_FEEDBACK: {
                macroPoint.setFunction(FunctionAccessoryNotification.OKAY);
                break;
            }
            default: {
                LOGGER.warn("Unknown accessoryOkay action detected: {}", (Object)function.getAction());
            }
        }
        return macroPoint;
    }

    protected AccessoryOkayFunction convertMacroPointAccessoryNotification(MacroPointAccessoryNotification macroPoint, List<InputPort> inputPorts) {
        AccessoryOkayFunction function = new AccessoryOkayFunction();
        switch (macroPoint.getFunction()) {
            case OKAY_IF_INPUT_0: {
                function.setAction((BidibStatus)AccessoryOkayStatus.QUERY0);
                function.setInput((InputPort)PortListUtils.findPortByPortNumber(inputPorts, (int)macroPoint.getInputNumber()));
                break;
            }
            case OKAY_IF_INPUT_1: {
                function.setAction((BidibStatus)AccessoryOkayStatus.QUERY1);
                function.setInput((InputPort)PortListUtils.findPortByPortNumber(inputPorts, (int)macroPoint.getInputNumber()));
                break;
            }
            case OKAY: {
                function.setAction((BidibStatus)AccessoryOkayStatus.NO_FEEDBACK);
            }
        }
        return function;
    }

    protected MacroPoint convertServoMoveQueryAction(ServoMoveQueryFunction function) {
        MacroPointServoMoveQuery macroPoint = new MacroPointServoMoveQuery();
        macroPoint.setOutputNumber(Integer.valueOf(function.getPort().getId()));
        return macroPoint;
    }

    protected ServoMoveQueryFunction convertMacroPointServoMoveQuery(MacroPointServoMoveQuery macroPoint, List<ServoPort> servoPorts) {
        ServoMoveQueryFunction function = new ServoMoveQueryFunction();
        function.setPort((ServoPort)PortListUtils.findPortByPortNumber(servoPorts, (int)macroPoint.getOutputNumber()));
        return function;
    }

    protected MacroPoint convertServoPortAction(ServoPortAction action) {
        MacroPointOutputServo macroPoint = new MacroPointOutputServo();
        macroPoint.setDelay(action.getDelay());
        macroPoint.setOutputNumber(((ServoPort)action.getPort()).getId());
        macroPoint.setPosition(action.getValue());
        return macroPoint;
    }

    protected ServoPortAction convertMacroPointOutputServo(MacroPointOutputServo macroPoint, List<ServoPort> servoPorts) {
        ServoPortAction action = new ServoPortAction();
        action.setDelay(macroPoint.getDelay());
        action.setPort((Port)((ServoPort)PortListUtils.findPortByPortNumber(servoPorts, (int)macroPoint.getOutputNumber())));
        action.setValue(macroPoint.getPosition());
        return action;
    }

    protected MacroPoint convertSwitchPortAction(SwitchPortAction action) {
        MacroPointOutputSwitch macroPoint = new MacroPointOutputSwitch();
        macroPoint.setDelay(action.getDelay());
        macroPoint.setOutputNumber(((SwitchPort)action.getPort()).getId());
        switch ((SwitchPortStatus)action.getAction()) {
            case OFF: {
                macroPoint.setFunction(FunctionOutputSwitch.OFF);
                break;
            }
            case ON: {
                macroPoint.setFunction(FunctionOutputSwitch.ON);
                break;
            }
            default: {
                LOGGER.warn("Unknown switchport action detected: {}", (Object)action.getAction());
            }
        }
        return macroPoint;
    }

    protected SwitchPortAction convertMacroPointOutputSwitch(MacroPointOutputSwitch macroPoint, List<SwitchPort> switchPorts) {
        SwitchPortAction action = new SwitchPortAction();
        action.setDelay(macroPoint.getDelay());
        action.setPort((Port)((SwitchPort)PortListUtils.findPortByPortNumber(switchPorts, (int)macroPoint.getOutputNumber())));
        switch (macroPoint.getFunction()) {
            case OFF: {
                action.setAction((BidibStatus)SwitchPortStatus.OFF);
                break;
            }
            case ON: {
                action.setAction((BidibStatus)SwitchPortStatus.ON);
                break;
            }
            default: {
                LOGGER.warn("Unknown switchport action detected: {}", (Object)macroPoint);
            }
        }
        return action;
    }

    protected MacroPoint convertSwitchPairPortAction(SwitchPairPortAction action) {
        MacroPointOutputSwitchPair macroPoint = new MacroPointOutputSwitchPair();
        macroPoint.setDelay(action.getDelay());
        macroPoint.setOutputNumber(((SwitchPairPort)action.getPort()).getId());
        switch ((SwitchPortStatus)action.getAction()) {
            case OFF: {
                macroPoint.setFunction(FunctionOutputSwitch.OFF);
                break;
            }
            case ON: {
                macroPoint.setFunction(FunctionOutputSwitch.ON);
                break;
            }
            default: {
                LOGGER.warn("Unknown switchPairPort action detected: {}", (Object)action.getAction());
            }
        }
        return macroPoint;
    }

    protected SwitchPairPortAction convertMacroPointOutputSwitchPair(MacroPointOutputSwitchPair macroPoint, List<SwitchPairPort> switchPairPorts) {
        SwitchPairPortAction action = new SwitchPairPortAction();
        action.setDelay(macroPoint.getDelay());
        action.setPort((Port)((SwitchPairPort)PortListUtils.findPortByPortNumber(switchPairPorts, (int)macroPoint.getOutputNumber())));
        switch (macroPoint.getFunction()) {
            case OFF: {
                action.setAction((BidibStatus)SwitchPortStatus.OFF);
                break;
            }
            case ON: {
                action.setAction((BidibStatus)SwitchPortStatus.ON);
                break;
            }
            default: {
                LOGGER.warn("Unknown switchPairPort action detected: {}", (Object)macroPoint);
            }
        }
        return action;
    }

    protected MacroPoint convertLightPortAction(LightPortAction action) {
        MacroPointOutputLight macroPoint = new MacroPointOutputLight();
        macroPoint.setDelay(action.getDelay());
        macroPoint.setOutputNumber(((LightPort)action.getPort()).getId());
        switch ((LightPortStatus)action.getAction()) {
            case BLINKA: {
                macroPoint.setFunction(FunctionOutputLight.BLINK_A);
                break;
            }
            case BLINKB: {
                macroPoint.setFunction(FunctionOutputLight.BLINK_B);
                break;
            }
            case DOUBLEFLASH: {
                macroPoint.setFunction(FunctionOutputLight.DOUBLE_FLASH);
                break;
            }
            case DOWN: {
                macroPoint.setFunction(FunctionOutputLight.DIM_DOWN);
                break;
            }
            case FLASHA: {
                macroPoint.setFunction(FunctionOutputLight.FLASH_A);
                break;
            }
            case FLASHB: {
                macroPoint.setFunction(FunctionOutputLight.FLASH_B);
                break;
            }
            case NEON: {
                macroPoint.setFunction(FunctionOutputLight.NEON_FLICKER);
                break;
            }
            case OFF: {
                macroPoint.setFunction(FunctionOutputLight.TURN_OFF);
                break;
            }
            case ON: {
                macroPoint.setFunction(FunctionOutputLight.TURN_ON);
                break;
            }
            case UP: {
                macroPoint.setFunction(FunctionOutputLight.DIM_UP);
                break;
            }
            default: {
                LOGGER.warn("Unknown lightport action detected: {}", (Object)action.getAction());
            }
        }
        return macroPoint;
    }

    protected LightPortAction convertMacroPointOutputLight(MacroPointOutputLight macroPoint, List<LightPort> lightPorts) {
        LightPortAction action = new LightPortAction();
        action.setDelay(macroPoint.getDelay());
        action.setPort((Port)((LightPort)PortListUtils.findPortByPortNumber(lightPorts, (int)macroPoint.getOutputNumber())));
        switch (macroPoint.getFunction()) {
            case BLINK_A: {
                action.setAction((BidibStatus)LightPortStatus.BLINKA);
                break;
            }
            case BLINK_B: {
                action.setAction((BidibStatus)LightPortStatus.BLINKB);
                break;
            }
            case DOUBLE_FLASH: {
                action.setAction((BidibStatus)LightPortStatus.DOUBLEFLASH);
                break;
            }
            case DIM_DOWN: {
                action.setAction((BidibStatus)LightPortStatus.DOWN);
                break;
            }
            case FLASH_A: {
                action.setAction((BidibStatus)LightPortStatus.FLASHA);
                break;
            }
            case FLASH_B: {
                action.setAction((BidibStatus)LightPortStatus.FLASHB);
                break;
            }
            case NEON_FLICKER: {
                action.setAction((BidibStatus)LightPortStatus.NEON);
                break;
            }
            case TURN_OFF: {
                action.setAction((BidibStatus)LightPortStatus.OFF);
                break;
            }
            case TURN_ON: {
                action.setAction((BidibStatus)LightPortStatus.ON);
                break;
            }
            case DIM_UP: {
                action.setAction((BidibStatus)LightPortStatus.UP);
                break;
            }
            default: {
                LOGGER.warn("Unknown lightport action detected: {}", (Object)macroPoint);
            }
        }
        return action;
    }

    protected MacroPoint convertBacklightPortAction(BacklightPortAction action) {
        MacroPointOutputBacklight macroPoint = new MacroPointOutputBacklight();
        macroPoint.setDelay(action.getDelay());
        macroPoint.setOutputNumber(((BacklightPort)action.getPort()).getId());
        macroPoint.setBrightness(action.getValue());
        return macroPoint;
    }

    protected BacklightPortAction convertMacroPointOutputBacklight(MacroPointOutputBacklight macroPoint, List<BacklightPort> backlightPorts) {
        BacklightPortAction action = new BacklightPortAction();
        action.setDelay(macroPoint.getDelay());
        action.setPort((Port)((BacklightPort)PortListUtils.findPortByPortNumber(backlightPorts, (int)macroPoint.getOutputNumber())));
        action.setValue(macroPoint.getBrightness());
        return action;
    }

    protected MacroPoint convertAnalogPortAction(AnalogPortAction function) {
        MacroPointOutputAnalog macroPoint = new MacroPointOutputAnalog();
        macroPoint.setDelay(function.getDelay());
        macroPoint.setOutputNumber(((AnalogPort)function.getPort()).getId());
        return macroPoint;
    }

    protected AnalogPortAction convertMacroPointOutputAnalog(MacroPointOutputAnalog macroPoint, List<AnalogPort> analogPorts) {
        AnalogPortAction action = new AnalogPortAction();
        action.setDelay(macroPoint.getDelay());
        action.setPort((Port)((AnalogPort)PortListUtils.findPortByPortNumber(analogPorts, (int)macroPoint.getOutputNumber())));
        return action;
    }

    protected MacroPoint convertMotorPortAction(MotorPortAction function) {
        MacroPointOutputMotor macroPoint = new MacroPointOutputMotor();
        macroPoint.setDelay(function.getDelay());
        macroPoint.setOutputNumber(((MotorPort)function.getPort()).getId());
        switch ((MotorPortStatus)function.getAction()) {
            case FORWARD: {
                macroPoint.setDirection(DirectionType.FORWARD);
                break;
            }
            case BACKWARD: {
                macroPoint.setDirection(DirectionType.BACKWARD);
                break;
            }
            default: {
                LOGGER.warn("Unknown lightport action detected: {}", (Object)function.getAction());
            }
        }
        return macroPoint;
    }

    protected MotorPortAction convertMacroPointOutputMotor(MacroPointOutputMotor macroPoint, List<MotorPort> motorPorts) {
        MotorPortAction action = new MotorPortAction();
        action.setDelay(macroPoint.getDelay());
        action.setPort((Port)((MotorPort)PortListUtils.findPortByPortNumber(motorPorts, (int)macroPoint.getOutputNumber())));
        switch (macroPoint.getDirection()) {
            case FORWARD: {
                action.setAction((BidibStatus)MotorPortStatus.FORWARD);
                break;
            }
            case BACKWARD: {
                action.setAction((BidibStatus)MotorPortStatus.BACKWARD);
                break;
            }
            default: {
                LOGGER.warn("Unknown lightport action detected: {}", (Object)macroPoint);
            }
        }
        return action;
    }

    protected MacroPoint convertSoundPortAction(SoundPortAction function) {
        MacroPointOutputSound macroPoint = new MacroPointOutputSound();
        macroPoint.setDelay(function.getDelay());
        macroPoint.setOutputNumber(((SoundPort)function.getPort()).getId());
        return macroPoint;
    }

    protected SoundPortAction convertMacroPointOutputSound(MacroPointOutputSound macroPoint, List<SoundPort> soundPorts) {
        SoundPortAction action = new SoundPortAction();
        action.setDelay(macroPoint.getDelay());
        action.setPort((Port)((SoundPort)PortListUtils.findPortByPortNumber(soundPorts, (int)macroPoint.getOutputNumber())));
        return action;
    }
}

