package org.bidib.wizard.mvc.console.model;

import java.util.LinkedList;
import java.util.List;

import javax.swing.SwingUtilities;

import org.bidib.wizard.api.service.console.ConsoleColor;
import org.bidib.wizard.api.service.console.ConsoleModel;

import com.jgoodies.binding.beans.Model;

public class DefaultConsoleModel extends Model implements ConsoleModel {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_CONSOLE_CONTENT = "consoleContent";

    public static final String PROPERTY_CONSOLE_CONTENT_SIZE = "consoleContentSize";

    private List<ConsoleLine> consoleMessages = new LinkedList<>();

    public static final class ConsoleLine {
        private final ConsoleColor color;

        private final String message;

        public ConsoleLine(ConsoleColor color, String message) {
            this.color = color;
            this.message = message;
        }

        /**
         * @return the color
         */
        public ConsoleColor getColor() {
            return color;
        }

        /**
         * @return the message
         */
        public String getMessage() {
            return message;
        }
    }

    public DefaultConsoleModel() {
    }

    @Override
    public void addConsoleLine(final ConsoleColor consoleColor, final String line) {

        if (SwingUtilities.isEventDispatchThread()) {
            internalAddConsoleLine(consoleColor, line);
        }
        else {
            SwingUtilities.invokeLater(() -> internalAddConsoleLine(consoleColor, line));
        }
    }

    private void internalAddConsoleLine(ConsoleColor consoleColor, String line) {
        final ConsoleLine consoleLine = new ConsoleLine(consoleColor, line);

        // only keep 250 in memory
        if (consoleMessages.size() > 250) {
            consoleMessages.remove(0);
        }

        consoleMessages.add(consoleLine);

        int index = consoleMessages.size() - 1;

        fireIndexedPropertyChange(PROPERTY_CONSOLE_CONTENT, index, null, consoleLine);
    }

    public void clear() {
        int oldSize = consoleMessages.size();

        consoleMessages.clear();

        firePropertyChange(PROPERTY_CONSOLE_CONTENT_SIZE, oldSize, consoleMessages.size());
    }
}
