package org.bidib.wizard.mvc.worklist.model;

import java.util.Collections;
import java.util.List;

import org.bidib.wizard.api.event.WorkListItemEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.common.collect.ArrayListModel;

public class WorkItemListModel extends Model {

    private static final Logger LOGGER = LoggerFactory.getLogger(WorkItemListModel.class);

    private static final long serialVersionUID = 1L;

    private ArrayListModel<WorkItemModel> workItemList = new ArrayListModel<>();

    public WorkItemListModel() {
    }

    public ArrayListModel<WorkItemModel> getWorkItemListModel() {
        return this.workItemList;
    }

    public List<WorkItemModel> getWorkItems() {
        return Collections.unmodifiableList(workItemList);
    }

    public boolean contains(final WorkListItemEvent item) {
        long count =
            this.workItemList
                .stream().filter(wi -> wi.getWorkListItemEvent().getComponent().equals(item.getComponent())
                    && wi.getWorkListItemEvent().getClass() == item.getClass())
                .count();

        return count > 0;
    }

    public void addWorkListItem(final WorkListItemEvent item) {

        // check if an item exists already
        if (!contains(item)) {
            final WorkItemModel workItemModel = new WorkItemModel(item);
            this.addWorkListItem(workItemModel);
        }
        else {
            LOGGER.info("Skip adding duplicate item: {}", item);
        }
    }

    public void addWorkListItem(final WorkItemModel workItemModel) {
        this.workItemList.add(workItemModel);
    }

    public void removeWorkListItem(final WorkItemModel workItemModel) {
        this.workItemList.remove(workItemModel);
    }

    public void addWorkListItems(final List<WorkListItemEvent> items) {
        for (WorkListItemEvent item : items) {
            this.addWorkListItem(item);
        }
    }

    public void clear() {
        this.workItemList.clear();
    }
}
