/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.dmx.view;

import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.event.DockableStateChangeListener;
import java.awt.Component;
import javax.swing.JComponent;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.mvc.dmx.controller.listener.DmxModelerControllerListener;
import org.bidib.wizard.mvc.dmx.model.DmxSceneryModel;
import org.bidib.wizard.mvc.dmx.view.scenery.SceneryPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmxSceneryView
implements Dockable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmxSceneryView.class);
    private JComponent sceneryPanel;
    private final DmxSceneryModel dmxSceneryModel;
    private final NodeInterface node;
    private DmxModelerControllerListener dmxModelerControllerListener;
    private final DockableStateChangeListener dockableStateChangeListener;
    private final SettingsService settingsService;
    private WizardLabelWrapper wizardLabelWrapper;

    public DmxSceneryView(DockingDesktop desktop, NodeInterface node, DmxSceneryModel dmxSceneryModel, SettingsService settingsService, WizardLabelWrapper wizardLabelWrapper) {
        this.dmxSceneryModel = dmxSceneryModel;
        this.node = node;
        this.settingsService = settingsService;
        this.wizardLabelWrapper = wizardLabelWrapper;
        DockKeys.DOCKKEY_DMX_SCENERY_VIEW.setName(Resources.getString(this.getClass(), (String)"title"));
        DockKeys.DOCKKEY_DMX_SCENERY_VIEW.setCloseEnabled(true);
        DockKeys.DOCKKEY_DMX_SCENERY_VIEW.setAutoHideEnabled(false);
        DockKeys.DOCKKEY_DMX_SCENERY_VIEW.setFloatEnabled(true);
        this.dockableStateChangeListener = new /* Unavailable Anonymous Inner Class!! */;
        desktop.addDockableStateChangeListener(this.dockableStateChangeListener);
    }

    public void createPanel() {
        LOGGER.info("Create the scenery panel.");
        SceneryPanel comp = new SceneryPanel(this.node, this.dmxSceneryModel, this.settingsService, this.wizardLabelWrapper);
        comp.setDmxModelerControllerListener(this.dmxModelerControllerListener);
        this.sceneryPanel = comp.createPanel();
    }

    public void setDmxModelerControllerListener(DmxModelerControllerListener dmxModelerControllerListener) {
        this.dmxModelerControllerListener = dmxModelerControllerListener;
    }

    public DockKey getDockKey() {
        return DockKeys.DOCKKEY_DMX_SCENERY_VIEW;
    }

    public Component getComponent() {
        return this.sceneryPanel;
    }
}

