/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.model;

import java.awt.Color;
import java.util.Arrays;
import java.util.Set;
import java.util.function.IntConsumer;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortConfigKeys;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.utils.PortUtils;
import org.bidib.wizard.client.common.model.SimpleHierarchicalPortTableModel;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.LightPortStatus;
import org.bidib.wizard.mvc.main.model.listener.LightPortModelListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightPortTableModel
extends SimpleHierarchicalPortTableModel<LightPortStatus, LightPort, LightPortModelListener> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LightPortTableModel.class);
    private static final long serialVersionUID = 1L;
    public static final int COLUMN_LABEL = 0;
    public static final int COLUMN_PWM_MIN = 1;
    public static final int COLUMN_PWM_MAX = 2;
    public static final int COLUMN_DIM_MIN = 3;
    public static final int COLUMN_DIM_MAX = 4;
    public static final int COLUMN_RGB = 5;
    public static final int COLUMN_TRANSITION_TIME = 6;
    public static final int COLUMN_DMX_MAPPING = 7;
    public static final int COLUMN_PORT_IDENTIFIER = 8;
    public static final int COLUMN_STATUS = 9;
    public static final int COLUMN_TEST = 10;
    public static final int COLUMN_PORT_INSTANCE = 11;

    public int getColumnPortInstance() {
        return 11;
    }

    public Integer getTestColumnIndex() {
        return 10;
    }

    protected void initialize() {
        this.columnNames = new String[]{Resources.getString(LightPortTableModel.class, (String)"label"), Resources.getString(LightPortTableModel.class, (String)"portLevelOff"), Resources.getString(LightPortTableModel.class, (String)"portLevelOn"), Resources.getString(LightPortTableModel.class, (String)"dimmDown"), Resources.getString(LightPortTableModel.class, (String)"dimmUp"), Resources.getString(LightPortTableModel.class, (String)"rgbValue"), Resources.getString(LightPortTableModel.class, (String)"transitionTime"), Resources.getString(LightPortTableModel.class, (String)"dmxMapping"), Resources.getString(LightPortTableModel.class, (String)"portIdentifier"), Resources.getString(LightPortTableModel.class, (String)"status"), Resources.getString(LightPortTableModel.class, (String)"test"), null};
    }

    public void addRow(LightPort port) {
        if (port != null) {
            Object[] rowData = new Object[this.columnNames.length];
            rowData[0] = port.toString();
            rowData[1] = port.getPwmMin();
            rowData[2] = port.getPwmMax();
            rowData[3] = port.getDimMin();
            rowData[4] = port.getDimMax();
            rowData[5] = port.getRgbValue() != null ? new Color(port.getRgbValue()) : null;
            rowData[6] = port.getTransitionTime();
            rowData[7] = port.getDmxMapping();
            rowData[8] = port.getPortIdentifier();
            rowData[9] = port.getStatus();
            LightPortStatus oppositeStatus = (LightPortStatus)PortUtils.getOppositeStatus((BidibStatus)((LightPortStatus)port.getStatus()));
            rowData[10] = oppositeStatus;
            rowData[11] = port;
            this.addRow(rowData);
        }
    }

    public boolean isCellEditable(int row, int column) {
        boolean isEditable = false;
        LightPort lightPort = (LightPort)this.getValueAt(row, 11);
        switch (column) {
            case 10: {
                if (Port.getConfiguredPortType((Port)lightPort) != LcOutputType.LIGHTPORT) break;
                isEditable = true;
                break;
            }
        }
        return isEditable;
    }

    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 5: {
                return Color.class;
            }
            case 9: {
                return Object.class;
            }
            case 10: {
                return Object.class;
            }
            case 8: 
            case 11: {
                return Object.class;
            }
        }
        return Integer.class;
    }

    public void setValueAt(Object value, int row, int column) {
        LightPort port = (LightPort)super.getValueAt(row, 11);
        switch (column) {
            case 0: {
                port.setLabel((String)value);
                super.setValueAt((Object)port.toString(), row, column);
                this.fireLabelChanged((Port)port, port.getLabel());
                break;
            }
            case 1: {
                port.setPwmMin(((Integer)value).intValue());
                super.setValueAt(value, row, column);
                this.fireConfigValuesChanged(port, new PortConfigKeys[]{PortConfigKeys.BIDIB_PCFG_LEVEL_PORT_OFF});
                break;
            }
            case 2: {
                port.setPwmMax(((Integer)value).intValue());
                super.setValueAt(value, row, column);
                this.fireConfigValuesChanged(port, new PortConfigKeys[]{PortConfigKeys.BIDIB_PCFG_LEVEL_PORT_ON});
                break;
            }
            case 3: {
                try {
                    port.setDimMin(Integer.parseInt(value.toString()));
                    super.setValueAt(value, row, column);
                    this.fireConfigValuesChanged(port, new PortConfigKeys[]{PortConfigKeys.BIDIB_PCFG_DIMM_DOWN});
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 4: {
                try {
                    port.setDimMax(Integer.parseInt(value.toString()));
                    super.setValueAt(value, row, column);
                    this.fireConfigValuesChanged(port, new PortConfigKeys[]{PortConfigKeys.BIDIB_PCFG_DIMM_UP});
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 5: {
                Integer col = null;
                if (value instanceof Color) {
                    col = ((Color)value).getRGB();
                } else if (value instanceof Integer) {
                    col = (int)((Integer)value);
                }
                port.setRgbValue(col);
                super.setValueAt(value, row, column);
                this.fireConfigValuesChanged(port, new PortConfigKeys[]{PortConfigKeys.BIDIB_PCFG_RGB});
                break;
            }
            case 6: {
                try {
                    port.setTransitionTime(Integer.valueOf(Integer.parseInt(value.toString())));
                    super.setValueAt(value, row, column);
                    this.fireConfigValuesChanged(port, new PortConfigKeys[]{PortConfigKeys.BIDIB_PCFG_TRANSITION_TIME});
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 7: {
                try {
                    if (value instanceof Integer) {
                        port.setDmxMapping((Integer)value);
                    } else {
                        port.setDmxMapping(Integer.valueOf(Integer.parseInt(value.toString())));
                    }
                    super.setValueAt(value, row, column);
                    this.fireConfigValuesChanged(port, new PortConfigKeys[]{PortConfigKeys.BIDIB_PCFG_OUTPUT_MAP});
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 9: {
                port.setStatus((BidibStatus)((LightPortStatus)value));
                super.setValueAt(value, row, column);
                break;
            }
            case 10: {
                LightPortStatus portStatus = (LightPortStatus)value;
                LOGGER.info("Set the test port status: {}", (Object)portStatus);
                super.setValueAt((Object)portStatus, row, column);
                LightPort lightPort = new LightPort();
                lightPort.setId(port.getId());
                lightPort.setStatus((BidibStatus)portStatus);
                this.fireTestButtonPressed(lightPort);
            }
        }
    }

    public Object getValueAt(int row, int column) {
        LightPort port = (LightPort)super.getValueAt(row, 11);
        switch (column) {
            case 0: 
            case 8: {
                column = 11;
                break;
            }
            case 4: {
                return port.getDimMax();
            }
            case 3: {
                return port.getDimMin();
            }
            case 1: {
                return port.getPwmMin();
            }
            case 2: {
                return port.getPwmMax();
            }
            case 5: {
                return port.getRgbValue() != null ? new Color(port.getRgbValue()) : null;
            }
            case 6: {
                return port.getTransitionTime();
            }
            case 7: {
                return port.getDmxMapping();
            }
            case 9: {
                return port.getStatus();
            }
        }
        return super.getValueAt(row, column);
    }

    public void notifyPortStatusChanged(LightPort port) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            if (!port.equals(this.getValueAt(row, 11))) continue;
            LOGGER.info("The port state has changed: {}", (Object)port.getStatus());
            super.setValueAt((Object)port.getStatus(), row, 9);
            LightPortStatus oppositeStatus = (LightPortStatus)PortUtils.getOppositeStatus((BidibStatus)((LightPortStatus)port.getStatus()));
            LOGGER.info("Update port status: {}, oppositeStatus: {}", (Object)port.getStatus(), (Object)oppositeStatus);
            super.setValueAt((Object)oppositeStatus, row, 10);
            break;
        }
    }

    public void notifyPortConfigChanged(LightPort port) {
        LOGGER.debug("The port config was changed for port: {}", (Object)port);
        this.notifyPortStatusChanged(port);
    }

    public void notifyPortLabelChanged(LightPort port) {
        LOGGER.info("The port label was changed for port: {}", (Object)port.getDebugString());
        for (int row = 0; row < this.getRowCount(); ++row) {
            if (!port.equals(this.getValueAt(row, 11))) continue;
            super.setValueAt((Object)port.toString(), row, 0);
            break;
        }
    }

    public void refreshRow(LightPort port, IntConsumer rowConsumer) {
        int row = this.findRow(port);
        rowConsumer.accept(row);
    }

    private int findRow(LightPort port) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            LightPort current = (LightPort)this.getValueAt(row, 11);
            if (!port.equals((Object)current)) continue;
            return row;
        }
        return -1;
    }

    public void updatePortConfig(LightPort port) {
        LOGGER.debug("The config of the port has changed: {}", (Object)port.getDebugString());
        PortConfigKeys[] keys = PortConfigKeys.valueOf((Set)port.getKnownPortConfigKeys());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("prepared keys: {}", Arrays.asList(keys));
        }
        this.fireConfigValuesChanged(port, keys);
        int row = this.findRow(port);
        if (row > -1) {
            this.setValueAt((Object)port.getLabel(), row, 0);
        }
    }

    private void fireConfigValuesChanged(LightPort port, PortConfigKeys ... portConfigKeys) {
        LOGGER.info("The values of the port have changed: {}", (Object)port);
        ((LightPortModelListener)this.portListener).configChanged((Port)port, portConfigKeys);
    }

    public void changePortType(LcOutputType portType, LightPort port) {
        ((LightPortModelListener)this.portListener).changePortType(portType, port);
    }

    protected LightPort getRow(int rowIndex) {
        LightPort port = (LightPort)this.getValueAt(rowIndex, 11);
        return port;
    }

    public void fireTestButtonPressed(LightPort port) {
        LOGGER.info("Port status has changed for port: {}", (Object)port);
        ((LightPortModelListener)this.portListener).testButtonPressed(port, (LightPortStatus)port.getStatus());
    }
}

