/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.pom.view.panel;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.view.ValidationComponentUtils;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.enums.PomOperation;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringConverter;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.client.common.view.validation.PropertyValidationI18NSupport;
import org.bidib.wizard.mvc.pom.model.CurrentAddressBeanModel;
import org.bidib.wizard.mvc.pom.model.DirectAccessProgBeanModel;
import org.bidib.wizard.mvc.pom.model.PomMode;
import org.bidib.wizard.mvc.pom.model.PomProgrammerModel;
import org.bidib.wizard.mvc.pom.model.ProgCommandAwareBeanModel;
import org.bidib.wizard.mvc.pom.model.command.PomDirectAccessCommand;
import org.bidib.wizard.mvc.pom.view.panel.AbstractPomPanel;
import org.bidib.wizard.mvc.pom.view.panel.PomValidationResultModel;

public class ResetDecoderPanel
extends AbstractPomPanel<DirectAccessProgBeanModel> {
    private static final int CV8 = 8;
    private final DirectAccessProgBeanModel directAccessProgBeanModel = new DirectAccessProgBeanModel();
    private ValueModel cvNumberValueModel;
    private ValueModel cvValueValueModel;
    private JTextField cvNumber;
    private JTextField cvValue;
    private InputValidationDocument cvValueDocument;
    private PomValidationResultModel directValidationModel;

    public ResetDecoderPanel(PomProgrammerModel cvProgrammerModel, CurrentAddressBeanModel currentAddressBeanModel) {
        super(cvProgrammerModel, currentAddressBeanModel);
        this.directAccessProgBeanModel.setCvNumber(Integer.valueOf(8));
        this.directAccessProgBeanModel.setCvValue(Integer.valueOf(8));
        this.directAccessProgBeanModel.setMode(PomMode.BYTE);
        this.setProgCommandAwareBeanModel((ProgCommandAwareBeanModel)this.directAccessProgBeanModel);
    }

    protected void postConstruct() {
        if (this.currentAddressBeanModel.getDccAddress() != null) {
            this.LOGGER.info("The address is available already. Trigger the validation.");
            this.triggerValidation();
        }
    }

    protected void createWorkerPanel(FormBuilder builder, int[] rowHolder, PomValidationResultModel parentValidationModel) {
        int row = rowHolder[0];
        builder.add((Component)new JLabel(Resources.getString(this.getClass(), (String)"reset-decoder-message"))).xyw(1, row, 7);
        builder.appendRows("p, 3dlu", new Object[0]);
        builder.add(Resources.getString(this.getClass(), (String)"cv-number"), new Object[0]).xy(1, row += 2);
        this.cvNumberValueModel = new PropertyAdapter((Object)this.directAccessProgBeanModel, "cvNumber", true);
        ConverterValueModel cvNumberConverterModel = new ConverterValueModel(this.cvNumberValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        this.cvNumber = new JTextField();
        this.cvNumber.setDocument((Document)new InputValidationDocument(4, "0123456789"));
        this.cvNumber.setColumns(4);
        Bindings.bind((JTextField)this.cvNumber, (ValueModel)cvNumberConverterModel, (boolean)false);
        builder.add((Component)this.cvNumber).xy(3, row);
        this.cvNumber.setEditable(false);
        ValidationComponentUtils.setMessageKey((JComponent)this.cvNumber, (Object)"validation.cvnumber_key");
        this.directValidationModel = new PomValidationResultModel(parentValidationModel);
        builder.appendRows("p, 3dlu", new Object[0]);
        builder.add(Resources.getString(this.getClass(), (String)"cv-value"), new Object[0]).xy(1, row += 2);
        this.cvValueValueModel = new PropertyAdapter((Object)this.directAccessProgBeanModel, "cvValue", true);
        ConverterValueModel cvValueConverterModel = new ConverterValueModel(this.cvValueValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        this.cvValue = new JTextField();
        this.cvValueDocument = new InputValidationDocument(3, "0123456789");
        this.cvValue.setDocument((Document)this.cvValueDocument);
        this.cvValue.setColumns(3);
        Bindings.bind((JTextField)this.cvValue, (ValueModel)cvValueConverterModel, (boolean)false);
        builder.add((Component)this.cvValue).xy(3, row);
        ValidationComponentUtils.setMandatory((JComponent)this.cvValue, (boolean)true);
        ValidationComponentUtils.setMessageKey((JComponent)this.cvValue, (Object)"validation.cvvalue_key");
        row += 2;
        builder.appendRows("p, 3dlu", new Object[0]);
        this.directAccessProgBeanModel.addPropertyChangeListener("cvValue", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.writeButtonEnabled = new ValueHolder(false);
        this.writeButton.setEnabled(false);
        this.writeButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        JPanel progActionButtons = new ButtonBarBuilder().addGlue().addButton((JComponent)this.writeButton).build();
        builder.add((Component)progActionButtons).xyw(1, row, 7);
        rowHolder[0] = row;
    }

    protected ValidationResultModel getValidationResultModel() {
        return this.directValidationModel;
    }

    private ValidationResult validate() {
        PropertyValidationI18NSupport support = new PropertyValidationI18NSupport((Object)this.cvNumberValueModel, "validation");
        if (this.directAccessProgBeanModel.getCvNumber() == null) {
            support.addError("cvnumber_key", "not_empty");
        } else if (this.directAccessProgBeanModel.getCvNumber() < 1 || this.directAccessProgBeanModel.getCvNumber() > 1023) {
            support.addError("cvnumber_key", "invalid_value;min=1,max=1023");
        }
        if (this.directAccessProgBeanModel.getCvValue() == null) {
            support.addError("cvvalue_key", "not_empty_for_write");
        } else if (this.directAccessProgBeanModel.getCvValue() < 0 || this.directAccessProgBeanModel.getCvValue() > 255) {
            support.addError("cvvalue_key", "invalid_value;min=0,max=255");
        }
        ValidationResult validationResult = support.getResult();
        this.LOGGER.info("Prepared validationResult: {}", (Object)validationResult);
        return validationResult;
    }

    protected void triggerValidation() {
        ValidationResult validationResult = this.validate();
        this.directValidationModel.setResult(validationResult);
        this.LOGGER.info("Set the writeButtonEnabled, validStateNoWarnOrErrors: {}, validState: {}", (Object)this.directValidationModel.getValidStateNoWarnOrErrors(), (Object)this.directValidationModel.getValidState());
        this.writeButtonEnabled.setValue((Object)this.directValidationModel.getValidState());
    }

    protected void disableInputElements() {
        this.cvValue.setEnabled(false);
        super.disableInputElements();
    }

    protected void enableInputElements() {
        this.cvValue.setEnabled(true);
        this.triggerValidation();
    }

    private int prepareByteCvValue() {
        int cvValue = this.directAccessProgBeanModel.getCvValue() != null ? this.directAccessProgBeanModel.getCvValue() : 0;
        this.LOGGER.info("Prepared byte-based cvValue: {}", (Object)ByteUtils.byteToHex((int)cvValue));
        return cvValue;
    }

    private void fireWrite() {
        this.disableInputElements();
        this.LOGGER.info("Prepare the write request for model: {}", (Object)this.directAccessProgBeanModel);
        this.directAccessProgBeanModel.getExecutedProgCommands().clear();
        List progCommands = this.directAccessProgBeanModel.getProgCommands();
        progCommands.clear();
        int cvValue = this.prepareByteCvValue();
        int cvNumber = this.directAccessProgBeanModel.getCvNumber();
        PomAddressData addressData = new PomAddressData(this.currentAddressBeanModel.getDccAddress().intValue(), this.currentAddressBeanModel.getAddressType());
        PomOperation operation = PomMode.BIT.equals((Object)this.directAccessProgBeanModel.getMode()) ? PomOperation.WR_BIT : PomOperation.WR_BYTE;
        this.directAccessProgBeanModel.setCurrentOperation(operation);
        this.directAccessProgBeanModel.setExecution(ProgCommandAwareBeanModel.ExecutionType.WRITE);
        progCommands.add(new PomDirectAccessCommand(addressData, operation, cvNumber, cvValue));
        this.startTimeoutControl(1000);
        this.fireNextCommand();
    }

    protected Object getCurrentOperation() {
        return this.directAccessProgBeanModel.getCurrentOperation();
    }
}

