/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.stepcontrol.view;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.bidib.wizard.mvc.common.view.table.CustomCheckBox;
import org.bidib.wizard.mvc.stepcontrol.model.StepControlAspect;
import org.bidib.wizard.mvc.stepcontrol.view.PolarityTableCellEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolarityTableCellEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarityTableCellEditor.class);
    private CustomCheckBox editor;
    private StepControlAspect.Polarity source;

    public PolarityTableCellEditor(String pathSelectedIcon, String pathUnselectedIcon) {
        this.editor = new CustomCheckBox(pathSelectedIcon, pathUnselectedIcon);
        this.editor.addActionListener((ActionListener)new LoadActionListener(this));
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    protected CustomCheckBox prepare(JTable table, Object value, boolean isSelected, int row, int column) {
        if (!(value instanceof StepControlAspect.Polarity)) {
            this.source = null;
            this.editor.setEnabled(false);
            return null;
        }
        this.source = (StepControlAspect.Polarity)value;
        this.editor.setEnabled(true);
        this.editor.setSelected(this.source != StepControlAspect.Polarity.normal);
        if (isSelected) {
            this.editor.setForeground(table.getSelectionForeground());
            this.editor.setBackground(table.getSelectionBackground());
        } else {
            this.editor.setForeground(table.getForeground());
            this.editor.setBackground(table.getBackground());
        }
        return this.editor;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        CustomCheckBox button = this.prepare(table, value, isSelected, row, column);
        return button;
    }

    @Override
    public Object getCellEditorValue() {
        return this.source;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.prepare(table, value, isSelected, row, column);
    }
}

