package org.bidib.wizard.mvc.booster.view;

import java.awt.Component;

import javax.swing.JMenuItem;

import org.bidib.jbidibc.messages.enums.BoosterState;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.view.BasicPopupMenu;
import org.bidib.wizard.model.status.BoosterStatus;
import org.bidib.wizard.mvc.booster.controller.listener.BoosterTableControllerListener;
import org.bidib.wizard.mvc.booster.model.BoosterModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.list.SelectionInList;

public class BoosterTableMenu extends BasicPopupMenu {
    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(BoosterTableMenu.class);

    private JMenuItem boosterOnItem;

    private JMenuItem boosterOffItem;

    private JMenuItem commandStationOnItem;

    private JMenuItem commandStationOffItem;

    private final Component parent;

    private final BoosterTableControllerListener boosterTableController;

    private final SelectionInList<BoosterModel> boosterSelection;

    public BoosterTableMenu(final Component parent, final BoosterTableControllerListener boosterTableController,
        final SelectionInList<BoosterModel> boosterSelection) {
        this.parent = parent;
        this.boosterTableController = boosterTableController;
        this.boosterSelection = boosterSelection;

        // booster
        boosterOnItem = new JMenuItem(Resources.getString(BoosterTableMenu.class, "boosterOn"));
        boosterOnItem.addActionListener(e -> {
            BoosterModel boosterModel = boosterSelection.getSelection();
            if (boosterModel != null) {
                LOGGER.info("Turn booster on: {}", boosterModel);
                boosterTableController.setBoosterState(boosterModel.getBooster(), BoosterStatus.ON);
            }
        });
        add(boosterOnItem);

        boosterOffItem = new JMenuItem(Resources.getString(BoosterTableMenu.class, "boosterOff"));
        boosterOffItem.addActionListener(e -> {
            BoosterModel boosterModel = boosterSelection.getSelection();
            if (boosterModel != null) {
                LOGGER.info("Turn booster off: {}", boosterModel);
                boosterTableController.setBoosterState(boosterModel.getBooster(), BoosterStatus.OFF);
            }
        });
        add(boosterOffItem);

        addSeparator();

        // command station
        commandStationOnItem = new JMenuItem(Resources.getString(BoosterTableMenu.class, "commandStationOn"));
        commandStationOnItem.addActionListener(e -> {
            BoosterModel boosterModel = boosterSelection.getSelection();
            if (boosterModel != null) {
                LOGGER.info("Turn command station on: {}", boosterModel);
                boosterTableController.setCommandStationState(boosterModel.getBooster(), CommandStationState.GO_IGN_WD);
            }
        });
        add(commandStationOnItem);

        commandStationOffItem = new JMenuItem(Resources.getString(BoosterTableMenu.class, "commandStationOff"));
        commandStationOffItem.addActionListener(e -> {
            BoosterModel boosterModel = boosterSelection.getSelection();
            if (boosterModel != null) {
                LOGGER.info("Turn command station off: {}", boosterModel);
                boosterTableController.setCommandStationState(boosterModel.getBooster(), CommandStationState.STOP);
            }
        });
        add(commandStationOffItem);

        boosterOnItem.setEnabled(false);
        boosterOffItem.setEnabled(false);
        commandStationOnItem.setEnabled(false);
        commandStationOffItem.setEnabled(false);
    }

    public void prepareMenuItems(final BoosterState boosterState, final CommandStationState csState) {

        if (boosterState != null) {
            if (BoosterState.isOffState(boosterState)) {
                boosterOnItem.setEnabled(true);
                boosterOffItem.setEnabled(false);
            }
            else {
                boosterOnItem.setEnabled(false);
                boosterOffItem.setEnabled(true);
            }
        }
        else {
            boosterOnItem.setEnabled(false);
            boosterOffItem.setEnabled(false);
        }

        if (csState != null) {
            if (CommandStationState.isOffState(csState)) {
                commandStationOnItem.setEnabled(true);
                commandStationOffItem.setEnabled(false);
            }
            else {
                commandStationOnItem.setEnabled(false);
                commandStationOffItem.setEnabled(true);
            }
        }
        else {
            commandStationOnItem.setEnabled(false);
            commandStationOffItem.setEnabled(false);
        }
    }

}
