package org.bidib.wizard.mvc.dmx.model;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.DmxChannel;
import org.bidib.wizard.model.ports.DmxLightPort;

import com.jgoodies.binding.beans.Model;

/**
 * The <code>DmxSceneryModel</code> holds all information of the selected node that is needed for DMX modelling. It has
 * a list of the <code>DmxScenery</code> instances.
 */
public class DmxSceneryModel extends Model implements DmxEnvironmentProvider {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_SCENERIES = "sceneries";

    public static final String PROPERTY_DMX_CHANNELS = "dmxChannels";

    public static final String PROPERTY_LIGHTPORTS = "lightPorts";

    public static final String PROPERTY_BACKLIGHTPORTS = "backlightPorts";

    public static final String PROPERTY_MACROS = "macros";

    private List<BacklightPort> backlightPorts = new LinkedList<>();

    private List<DmxLightPort> lightPorts = new LinkedList<>();

    private List<DmxScenery> sceneries = new LinkedList<>();

    private List<DmxChannel> dmxChannels = new LinkedList<>();

    private List<Macro> macros = new LinkedList<>();

    /**
     * @return the backlightPorts
     */
    @Override
    public List<BacklightPort> getBacklightPorts() {
        return Collections.unmodifiableList(backlightPorts);
    }

    /**
     * @param backlightPorts
     *            the backlightPorts to set
     */
    public void setBacklightPorts(List<BacklightPort> backlightPorts) {
        List<BacklightPort> oldValue = new LinkedList<>(this.backlightPorts);

        this.backlightPorts.clear();
        this.backlightPorts.addAll(backlightPorts);

        firePropertyChange(PROPERTY_BACKLIGHTPORTS, oldValue, backlightPorts);
    }

    /**
     * @return the lightPorts
     */
    @Override
    public List<DmxLightPort> getLightPorts() {
        return Collections.unmodifiableList(lightPorts);
    }

    /**
     * @param lightPorts
     *            the lightPorts to set
     */
    public void setLightPorts(List<DmxLightPort> lightPorts) {
        List<DmxLightPort> oldValue = new LinkedList<>(this.lightPorts);

        this.lightPorts.clear();
        this.lightPorts.addAll(lightPorts);

        firePropertyChange(PROPERTY_LIGHTPORTS, oldValue, lightPorts);
    }

    /**
     * @return the sceneries
     */
    public List<DmxScenery> getSceneries() {
        return Collections.unmodifiableList(sceneries);
    }

    /**
     * @param scenery
     *            the scenery to add
     */
    public void addScenery(DmxScenery scenery) {
        List<DmxScenery> oldValue = new LinkedList<>(this.sceneries);

        this.sceneries.add(scenery);

        firePropertyChange(PROPERTY_SCENERIES, oldValue, sceneries);
    }

    /**
     * @param sceneries
     *            the sceneries to set
     */
    public void setSceneries(List<DmxScenery> sceneries) {
        List<DmxScenery> oldValue = new LinkedList<>(this.sceneries);

        this.sceneries.clear();
        this.sceneries.addAll(sceneries);

        firePropertyChange(PROPERTY_SCENERIES, oldValue, sceneries);
    }

    /**
     * @return the dmxChannels
     */
    @Override
    public List<DmxChannel> getDmxChannels() {
        return Collections.unmodifiableList(dmxChannels);
    }

    /**
     * @param dmxChannels
     *            the dmxChannels to set
     */
    public void setDmxChannels(List<DmxChannel> dmxChannels) {
        List<DmxChannel> oldValue = new LinkedList<>(this.dmxChannels);

        this.dmxChannels.clear();
        this.dmxChannels.addAll(dmxChannels);

        firePropertyChange(PROPERTY_DMX_CHANNELS, oldValue, dmxChannels);
    }

    /**
     * @return the macros
     */
    public List<Macro> getMacros() {
        return Collections.unmodifiableList(macros);
    }

    /**
     * @param macros
     *            the macros to set
     */
    public void setMacros(List<Macro> macros) {
        List<Macro> oldValue = new LinkedList<>(this.macros);

        this.macros.clear();
        this.macros.addAll(macros);

        firePropertyChange(PROPERTY_MACROS, oldValue, macros);
    }
}
