package org.bidib.wizard.mvc.features.controller;

import java.util.Collection;
import java.util.HashSet;

import javax.swing.JFrame;

import org.bidib.jbidibc.messages.Feature;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.mvc.features.controller.listener.FeaturesControllerListener;
import org.bidib.wizard.mvc.features.model.FeaturesModel;
import org.bidib.wizard.mvc.features.view.FeaturesView;
import org.bidib.wizard.mvc.features.view.listener.FeaturesViewListener;
import org.bidib.wizard.utils.WindowUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeaturesController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeaturesController.class);

    private final Collection<FeaturesControllerListener> listeners = new HashSet<FeaturesControllerListener>();

    private final JFrame parent;

    private final NodeInterface node;

    private final WizardSettingsInterface wizardSettings;

    private final FeaturesModel model;

    private FeaturesView view;

    public FeaturesController(final JFrame parent, final NodeInterface node, final WizardSettingsInterface wizardSettings) {
        this.parent = parent;
        this.node = node;
        this.wizardSettings= wizardSettings;

        model = new FeaturesModel(node);
    }

    public void addFeaturesControllerListener(FeaturesControllerListener listener) {
        listeners.add(listener);
    }

    private void fireClose() {
        for (FeaturesControllerListener listener : listeners) {
            listener.close();
        }
    }

    private void fireReadAll() {
        LOGGER.debug("Read all features.");

        // TODO read the features from the mainModel ...

        for (FeaturesControllerListener listener : listeners) {
            listener.readAll(node);
        }
    }

    /**
     * Write a feature to the node.
     * 
     * @param feature
     *            the feature to write
     */
    private void fireWrite(Feature feature) {
        LOGGER.debug("Write feature to node, feature: {}", feature);
        for (FeaturesControllerListener listener : listeners) {
            listener.write(node, feature);
        }
    }

    public void start() {

        view = new FeaturesView(parent, model, this.wizardSettings);
        view.addFeaturesViewListener(new FeaturesViewListener() {
            @Override
            public void close() {
                fireClose();
            }

            @Override
            public void write(Collection<Feature> features) {

                // iterate over the features and write the values
                for (Feature feature : features) {
                    // TODO what happens if an error occurs?
                    try {
                        fireWrite(feature);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Write feature failed.", ex);
                    }
                }
            }
        });

        // initially read all features
        fireReadAll();

        WindowUtils.centerOnCurrentScreen(parent, view);
        // make the view visible
        view.setVisible(true);
    }

    public void setFeatures(Collection<Feature> features) {
        LOGGER.info("Set the features in the model.");

        model.setFeatures(features);
    }

}
