package org.bidib.wizard.mvc.firmware.view.panel;

import java.io.File;

import javax.swing.filechooser.FileFilter;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.firmwarerepo.core.filesystem.BidibFirmwareFileInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * A {@code FileFilter} that does introspection of ZIP files for existence of a firmware.xml file and accepts files with
 * extension 'hex'.
 *
 */
public class BidibFirmwareFileFilter extends FileFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BidibFirmwareFileFilter.class);

    private final BidibFirmwareFileInspector bidibFirmwareFileInspector;

    public BidibFirmwareFileFilter() {

        bidibFirmwareFileInspector = new BidibFirmwareFileInspector();
    }

    @Override
    public boolean accept(File file) {

        try {
            return bidibFirmwareFileInspector.accept(file.toPath());
        }
        catch (Exception ex) {
            LOGGER.warn("Inspect firmare file failed: {}", file);
        }
        return false;
    }

    @Override
    public String getDescription() {
        return Resources.getString(BidibFirmwareFileFilter.class, "filter") + " (*."
            + BidibFirmwareFileInspector.SUFFIX_HEX + ", *." + BidibFirmwareFileInspector.SUFFIX_ZIP + ")";
    }

}
