package org.bidib.wizard.mvc.main.model.listener;

import org.bidib.wizard.api.model.Accessory;

public interface AccessoryRequestListener {

    /**
     * Store the accessory on the node.
     * 
     * @param accessory
     *            the accessory
     */
    void storeAccessory(final Accessory accessory);

    /**
     * Activate the aspect.
     * 
     * @param accessory
     *            the accessory
     * @param aspectNumber
     *            the aspect number
     */
    void activateAspect(final Accessory accessory, int aspectNumber);
}
