package org.bidib.wizard.mvc.main.view.component;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBusyFrame extends JFrame implements BusyFrame {
    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBusyFrame.class);

    protected JPanel glassPane;

    public DefaultBusyFrame() {
        initBusyJFrame();
    }

    protected void initBusyJFrame() {

        // Create our own glass pane which says it manages focus. This is
        // part of the key to capturing keyboard events.
        glassPane = new JPanel() {
            private static final long serialVersionUID = 1L;

            @Override
            public boolean getFocusTraversalKeysEnabled() {
                return true;
            }
        };
        // Add a no-op MouseAdapter so that we enable mouse events
        glassPane.addMouseListener(new MouseAdapter() {
        });
        // Eat keystrokes so they don't go to other components
        glassPane.addKeyListener(new KeyAdapter() {
            @Override
            public void keyPressed(KeyEvent e) {
                e.consume();
            }
        });
        glassPane.setOpaque(false);
        this.setGlassPane(glassPane);
    }

    private final Cursor waitCursor = Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR);

    private final Cursor defaultCursor = Cursor.getDefaultCursor();

    @Override
    public boolean setBusy(boolean busy) {
        if (busy) {
            LOGGER.debug("Set wait cursor");

            if (waitCursor.equals(getCursor())) {
                return false;
            }

            // Setting the frame cursor AND glass pane cursor in this order
            // works around the Win32 problem where you have to move the mouse 1
            // pixel to get the Cursor to change.
            this.setCursor(waitCursor);

            glassPane.setVisible(true);
            // Force glass pane to get focus so that we consume KeyEvents
            glassPane.requestFocus();
            glassPane.setCursor(waitCursor);
        }
        else {
            LOGGER.debug("Set default cursor");

            if (defaultCursor.equals(getCursor())) {
                return false;
            }

            glassPane.setCursor(defaultCursor);
            glassPane.setVisible(false);
            this.requestFocus();

            this.setCursor(defaultCursor);
        }

        return true;
    }

    public static void setWaitCursor(final Component component) {
        DefaultBusyFrame busyFrame = null;
        Frame frame = JOptionPane.getFrameForComponent(component);
        if (frame instanceof DefaultBusyFrame) {
            busyFrame = (DefaultBusyFrame) frame;
        }
        if (busyFrame != null) {
            busyFrame.setBusy(true);
        }
    }

    public static void setDefaultCursor(final Component component) {
        DefaultBusyFrame busyFrame = null;
        Frame frame = JOptionPane.getFrameForComponent(component);
        if (frame instanceof DefaultBusyFrame) {
            busyFrame = (DefaultBusyFrame) frame;
        }
        if (busyFrame != null) {
            busyFrame.setBusy(false);
        }
    }

}
