package org.bidib.wizard.mvc.main.view.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.LinkedList;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.view.listener.ButtonListener;
import org.bidib.wizard.client.common.view.renderer.BidibStatusListRenderer;
import org.bidib.wizard.model.ports.ConfigurablePort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.BidibStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jidesoft.grid.AbstractTableCellEditorRenderer;

public class PortComboBoxWithButtonEditorRenderer<E extends BidibStatus> extends AbstractTableCellEditorRenderer
    implements TableCellEditor {
    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(PortComboBoxWithButtonEditorRenderer.class);

    private final Collection<ButtonListener> buttonListeners = new LinkedList<ButtonListener>();

    // private final JPanel panel = new JPanel();

    // protected /* final */ JComboBox<E> comboBox;
    //
    // private /* final */ JButton button;

    private int row;

    private int column;

    private final E[] items;

    private final String buttonText;

    private final String resourceClazz;

    private final Integer instanceColumn;

    private static class RendererPanel<E> extends JPanel {

        private final JComboBox<E> comboBox;

        private final JButton button;

        public RendererPanel(final JComboBox<E> comboBox, final JButton button) {
            this.comboBox = comboBox;
            this.button = button;
        }

        public JComboBox<E> getComboBox() {
            return comboBox;
        }

        public JButton getButton() {
            return button;
        }
    }

    public PortComboBoxWithButtonEditorRenderer(E[] items, String buttonText, Class<?> resourceClazz,
        Integer instanceColumn) {
        this(items, buttonText, Resources.trimWizardPackage(resourceClazz.getName()), instanceColumn);
    }

    public PortComboBoxWithButtonEditorRenderer(E[] items, String buttonText, String resourceClazz,
        Integer instanceColumn) {
        this.items = items;
        this.buttonText = buttonText;
        this.resourceClazz = resourceClazz;

        this.instanceColumn = instanceColumn;
    }

    public void addButtonListener(ButtonListener l) {
        buttonListeners.add(l);
    }

    private void fireButtonPressed() {
        for (ButtonListener l : buttonListeners) {
            l.buttonPressed(row, column, getCellEditorValue());
        }
    }

    @Override
    public Object getCellEditorValue() {

        Component comp = this._editorComponent;
        Object value = null;
        if (comp instanceof RendererPanel) {
            RendererPanel<E> p = (RendererPanel<E>) comp;
            value = p.getComboBox().getSelectedItem();
        }

        LOGGER.info("Current cellEditor value: {}", value);
        return value;
    }

    private JComboBox<E> getComboBox() {
        Component comp = this._editorComponent;
        if (comp instanceof RendererPanel) {
            RendererPanel<E> p = (RendererPanel<E>) comp;
            return p.getComboBox();
        }
        return null;
    }

    protected void setSelectedValue(Port<? extends BidibStatus> port) {
        LOGGER.info("Set the selected value from port: {}", port);
        getComboBox().setSelectedItem(port.getStatus());
    }

    protected void setSelectedValue(E status) {
        LOGGER.info("Set the selected value: {}", status);
        getComboBox().setSelectedItem(status);
    }

    protected boolean isPortEnabled(ConfigurablePort<?> port) {
        return port.isEnabled();
    }

    @Override
    public void configureTableCellEditorRendererComponent(
        final JTable table, Component editorRendererComponent, boolean forRenderer, Object value, boolean isSelected,
        boolean hasFocus, final int row, int column) {

        LOGGER.debug("Current row: {}, value: {}, forRenderer: {}", row, value, forRenderer);

        JComboBox<E> comboBox = null;
        JButton button = null;

        if (editorRendererComponent instanceof RendererPanel) {
            RendererPanel<E> p = (RendererPanel<E>) editorRendererComponent;
            comboBox = p.getComboBox();
            button = p.getButton();
        }

        if (forRenderer) {
            if (value instanceof ConfigurablePort) {
                ConfigurablePort<?> port = (ConfigurablePort<?>) value;
                boolean isPortEnabled = isPortEnabled(port);
                LOGGER.debug("Port is enabled: {}, port: {}", isPortEnabled, port);
                editorRendererComponent.setEnabled(isPortEnabled);
                comboBox.setEnabled(isPortEnabled);
                button.setEnabled(isPortEnabled);

                // setSelectedValue((Port<? extends BidibStatus>) port);
                comboBox.setSelectedItem(port);
            }
            else if (value instanceof BidibStatus) {
                boolean isPortEnabled = true;
                if (this.instanceColumn != null) {
                    ConfigurablePort<?> port =
                        (ConfigurablePort<?>) table.getModel().getValueAt(row, instanceColumn.intValue());
                    isPortEnabled = isPortEnabled(port);
                }

                editorRendererComponent.setEnabled(isPortEnabled);
                comboBox.setEnabled(isPortEnabled);
                button.setEnabled(isPortEnabled);

                // setSelectedValue((E) value);
                comboBox.setSelectedItem(value);
            }
            else {
                if (value != null) {
                    LOGGER.warn("Invalid value: {}", value);
                }

                editorRendererComponent.setEnabled(false);
                comboBox.setEnabled(false);
                button.setEnabled(false);
            }
        }
        else {
            if (value instanceof ConfigurablePort) {
                ConfigurablePort<?> port = (ConfigurablePort<?>) value;
                // setSelectedValue((Port<? extends BidibStatus>) port);
                comboBox.setSelectedItem(port);
            }
            else if (value instanceof BidibStatus) {
                // setSelectedValue((E) value);
                comboBox.setSelectedItem(value);
            }
            else {
                LOGGER.warn("Invalid value: {}", value);
            }
        }

        if (isSelected) {
            editorRendererComponent.setForeground(table.getSelectionForeground());
            editorRendererComponent.setBackground(table.getSelectionBackground());
        }
        else {
            editorRendererComponent.setForeground(table.getForeground());
            editorRendererComponent.setBackground(table.getBackground());
            comboBox.setForeground(table.getForeground());
            comboBox.setBackground(table.getBackground());
            button.setForeground(table.getForeground());
            button.setBackground(table.getBackground());
        }
    }

    @Override
    public Component createTableCellEditorRendererComponent(JTable table, int row, int column) {

        this.row = row;
        this.column = column;

        final JComboBox<E> comboBox = new JComboBox<>(items.clone());
        comboBox.setRenderer(new BidibStatusListRenderer<>(resourceClazz));
        final JButton button = new JButton(buttonText);

        final RendererPanel<E> panel = new RendererPanel<>(comboBox, button);

        // use MouseListener because otherwise the row is expanded
        // button.addActionListener(new ActionListener() {
        // @Override
        // public void actionPerformed(ActionEvent e) {
        // fireEditingStopped();
        // fireButtonPressed();
        // }
        // });

        button.addMouseListener(new MouseAdapter() {
            @Override
            public void mousePressed(MouseEvent e) {

                e.consume();

                fireEditingStopped();
                fireButtonPressed();
            }
        });

        panel.setLayout(new GridBagLayout());
        panel.setFocusCycleRoot(true);

        GridBagConstraints c = new GridBagConstraints();

        c.anchor = GridBagConstraints.FIRST_LINE_START;
        c.fill = GridBagConstraints.BOTH;
        c.gridx = 0;
        c.insets = new Insets(0, 0, 0, 2);
        c.weightx = 1;
        panel.add(comboBox, c);
        c.anchor = GridBagConstraints.FIRST_LINE_END;
        c.gridx++;
        c.weightx = 0;
        panel.add(button, c);

        return panel;
    }
}
