package org.bidib.wizard.mvc.main.view.table;

import javax.swing.table.TableColumn;

import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.LoadTypeEnum;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.table.AbstractPortHierarchicalTable;
import org.bidib.wizard.client.common.view.listener.ButtonListener;
import org.bidib.wizard.client.common.view.renderer.BidibStatusTableRenderer;
import org.bidib.wizard.client.common.view.renderer.LocalPortConfigErrorAwareRenderer;
import org.bidib.wizard.client.common.view.renderer.PortIdentifierTableCellRenderer;
import org.bidib.wizard.model.ports.ConfigurablePort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.SwitchPairPort;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.bidib.wizard.mvc.main.model.SwitchPairPortTableModel;
import org.bidib.wizard.mvc.main.view.panel.renderer.LoadTypeComboBoxRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jidesoft.grid.TableColumnChooser;

import io.reactivex.rxjava3.subjects.PublishSubject;

public class SwitchPairPortTable extends AbstractPortHierarchicalTable<SwitchPairPort> {
    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(SwitchPairPortTable.class);

    public static final String STATUS_RESOURCE_KEY = "org.bidib.wizard.model.status.SwitchPairPortStatus";

    private final SwitchPairPortTableModel switchPairPortTableModel;

    public SwitchPairPortTable(final SwitchPairPortTableModel switchPortTableModel, String emptyTableText) {
        super(switchPortTableModel, emptyTableText);

        this.switchPairPortTableModel = switchPortTableModel;
    }

    @Override
    protected SwitchPairPortEditorPanel createPortEditorPanel(
        final SwitchPairPort port, int row, final PublishSubject<PortConfigChangeEvent> portConfigChangeEventSubject,
        final NodeSelectionProvider nodeSelectionProvider) {
        SwitchPairPortEditorPanel editorPanel =
            new SwitchPairPortEditorPanel(port,
                switchPairPort -> this.switchPairPortTableModel.updatePortConfig(switchPairPort),
                switchPairPort -> this.switchPairPortTableModel.fireTestButtonPressed(switchPairPort),
                switchPairPort -> this.switchPairPortTableModel
                    .refreshRow(switchPairPort,
                        changedRow -> repaint(getCellRect(changedRow, SwitchPairPortTableModel.COLUMN_LABEL, true))),
                portConfigChangeEventSubject, nodeSelectionProvider);
        editorPanel.createComponent();

        return editorPanel;
    }

    @Override
    public void clearTable() {

    }

    @Override
    public void prepareTableColumns() {

        TableColumn tc = getColumnModel().getColumn(SwitchPairPortTableModel.COLUMN_LABEL);
        tc.setCellRenderer(new LocalPortConfigErrorAwareRenderer(SwitchPairPortTableModel.COLUMN_LABEL));
        tc.setIdentifier(Integer.valueOf(SwitchPairPortTableModel.COLUMN_LABEL));

        tc = getColumnModel().getColumn(SwitchPairPortTableModel.COLUMN_SWITCH_OFF_TIME);
        tc.setCellRenderer(new PortTicksRenderer(SwitchPairPortTableModel.COLUMN_PORT_INSTANCE));
        tc.setIdentifier(Integer.valueOf(SwitchPairPortTableModel.COLUMN_SWITCH_OFF_TIME));

        final LoadTypeComboBoxRenderer<SwitchPairPort> tableCellRendererLoadType =
            new LoadTypeComboBoxRenderer<>(SwitchPairPortTableModel.COLUMN_PORT_INSTANCE, LoadTypeEnum.getValues(),
                BidibLibrary.BIDIB_PCFG_LOAD_TYPE);

        tc = getColumnModel().getColumn(SwitchPairPortTableModel.COLUMN_LOAD_TYPE);
        tc.setCellRenderer(tableCellRendererLoadType);
        tc.setIdentifier(Integer.valueOf(SwitchPairPortTableModel.COLUMN_LOAD_TYPE));

        tc = getColumnModel().getColumn(SwitchPairPortTableModel.COLUMN_PORT_IDENTIFIER);
        tc.setCellRenderer(new PortIdentifierTableCellRenderer());
        tc.setMaxWidth(80);
        tc.setIdentifier(Integer.valueOf(SwitchPairPortTableModel.COLUMN_PORT_IDENTIFIER));

        // Set the status renderer
        tc = getColumnModel().getColumn(SwitchPairPortTableModel.COLUMN_STATUS);
        tc.setIdentifier(Integer.valueOf(SwitchPairPortTableModel.COLUMN_STATUS));
        tc
            .setCellRenderer(new BidibStatusTableRenderer(SwitchPairPortTable.STATUS_RESOURCE_KEY, "status.",
                SwitchPairPortTableModel.COLUMN_PORT_INSTANCE) {
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean isPortEnabled(ConfigurablePort<?> port) {
                    if (port instanceof Port) {
                        if (Port.getConfiguredPortType((Port<?>) port) != LcOutputType.SWITCHPAIRPORT) {
                            return false;
                        }
                    }
                    return true;
                }
            });
        tc.setMinWidth(60);
        tc.setMaxWidth(80);

        final TableColumn buttonColumn = getColumnModel().getColumn(SwitchPairPortTableModel.COLUMN_TEST);
        buttonColumn.setIdentifier(Integer.valueOf(SwitchPairPortTableModel.COLUMN_TEST));
        buttonColumn.setMinWidth(180);
        buttonColumn.setMaxWidth(200);

        // buttonColumn
        // .setCellRenderer(new PortComboBoxWithButtonRenderer<BidibStatus>(getActions(SwitchPortStatus.ON), ">",
        // SwitchPairPortTable.STATUS_RESOURCE_KEY, SwitchPairPortTableModel.COLUMN_PORT_INSTANCE) {
        // private static final long serialVersionUID = 1L;
        //
        // @Override
        // protected void setSelectedValue(Port<?> port) {
        // SwitchPortStatus oppositeStatus = null;
        // if (port != null) {
        // oppositeStatus = (SwitchPortStatus) port.getStatus();
        // }
        // comboBox.setSelectedItem(oppositeStatus);
        // }
        //
        // @Override
        // protected boolean isPortEnabled(ConfigurablePort<?> port) {
        //
        // if (port instanceof Port) {
        // if (Port.getConfiguredPortType((Port<?>) port) != LcOutputType.SWITCHPAIRPORT) {
        // return false;
        // }
        // }
        // return true;
        // }
        // });

        final PortComboBoxWithButtonEditorRenderer<BidibStatus> editor =
            new PortComboBoxWithButtonEditorRenderer<BidibStatus>(getActions(SwitchPortStatus.ON), ">",
                SwitchPortStatus.class, SwitchPairPortTableModel.COLUMN_PORT_INSTANCE) {
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean isPortEnabled(ConfigurablePort<?> port) {

                    if (port instanceof Port) {
                        if (Port.getConfiguredPortType((Port<?>) port) != LcOutputType.SWITCHPAIRPORT) {
                            return false;
                        }
                    }
                    return true;
                }
            };
        editor.addButtonListener(new ButtonListener() {

            @Override
            public void buttonPressed(int row, int column, Object value) {
                LOGGER.info("The test button was pressed, row: {}, column: {}", row, column);
                getModel().setValueAt(value, row, SwitchPairPortTableModel.COLUMN_TEST);
            }
        });

        buttonColumn.setCellEditor(editor);
        buttonColumn.setCellRenderer(editor);

        TableColumnChooser.hideColumn(this, SwitchPairPortTableModel.COLUMN_PORT_INSTANCE);
    }
}
