package org.bidib.wizard.mvc.worklist.model;

import org.bidib.wizard.api.locale.Resources;

import com.jgoodies.binding.adapter.AbstractTableAdapter;
import com.jgoodies.binding.list.SelectionInList;

public class WorkListItemTableModel extends AbstractTableAdapter<WorkItemModel> {

    private static final long serialVersionUID = 1L;

    public static final int COLUMN_COMPONENT = 0;

    public static final int COLUMN_DESCRIPTION = 1;

    public static final int COLUMN_ACTION = 2;

    private static final String[] COLUMNNAMES =
        new String[] { Resources.getString(WorkListItemTableModel.class, "column.component"),
            Resources.getString(WorkListItemTableModel.class, "column.description"),
            Resources.getString(WorkListItemTableModel.class, "column.action") };

    public WorkListItemTableModel(SelectionInList<WorkItemModel> workItemSelection) {
        super(workItemSelection, COLUMNNAMES);

        // LOGGER.info("Current listModel: {}", getListModel());
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {

        final WorkItemModel workItem = getRow(rowIndex);
        switch (columnIndex) {
            case 0:
                return workItem.getComponent();
            case 1:
                // return workItem.getAction();
                return getActionText(workItem);
            default:
                break;

        }

        return null;
    }

    private String getActionText(final WorkItemModel workItem) {

        String actionKey = workItem.getAction();
        return Resources.getString(workItem.getWorkListItemEvent().getClass(), actionKey);
    }

}
