package org.bidib.wizard.mvc.main.dockable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;

public class MyTextEditor extends JPanel implements Dockable {

    private DockKey key;

    private JTextArea textArea;

    public MyTextEditor(int index) {
        key = new DockKey("textEditor" + index);
        setLayout(new BorderLayout());
        textArea = new JTextArea("A Text Area");
        JScrollPane jsp = new JScrollPane(textArea);
        jsp.setPreferredSize(new Dimension(200, 400));
        add(jsp, BorderLayout.CENTER);
    }

    @Override
    public DockKey getDockKey() {
        return key;
    }

    @Override
    public Component getComponent() {
        return this;
    }

}
