/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.firmware.controller;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabel;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.exchange.bidib.FirmwareFactory;
import org.bidib.jbidibc.exchange.firmware.FilenameType;
import org.bidib.jbidibc.exchange.vendorcv.VendorCV;
import org.bidib.jbidibc.exchange.vendorcv.VendorCvFactory;
import org.bidib.jbidibc.messages.FirmwareUpdateStat;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.SoftwareVersion;
import org.bidib.jbidibc.messages.enums.FirmwareUpdateOperation;
import org.bidib.jbidibc.messages.enums.FirmwareUpdateState;
import org.bidib.jbidibc.messages.exception.NoAnswerException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.helpers.DefaultContext;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.NodeListProvider;
import org.bidib.wizard.api.model.connection.BidibConnection;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.service.console.ConsoleColor;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.api.service.node.CommandStationService;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.core.dialog.FileDialog;
import org.bidib.wizard.core.service.ConnectionService;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.firmwarerepo.core.FirmwareRepoService;
import org.bidib.wizard.mvc.console.controller.ConsoleController;
import org.bidib.wizard.mvc.firmware.controller.FirmwareController;
import org.bidib.wizard.mvc.firmware.controller.listener.FirmwareControllerListener;
import org.bidib.wizard.mvc.firmware.model.FirmwareModel;
import org.bidib.wizard.mvc.firmware.view.FirmwareView;
import org.bidib.wizard.mvc.firmware.view.listener.FirmwareViewListener;
import org.bidib.wizard.utils.FirmwareUtils;
import org.bidib.wizard.utils.WindowUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FirmwareController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FirmwareController.class);
    private final Collection<FirmwareControllerListener> listeners = new LinkedList();
    private final NodeInterface node;
    private final JFrame parent;
    private final FirmwareModel firmwareModel = new FirmwareModel();
    private final NodeListProvider nodeListProvider;
    private NodeListListener nodeListListener;
    @Autowired
    private CommandStationService commandStationService;
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private WizardLabelWrapper wizardLabelWrapper;
    @Autowired
    private ConsoleService consoleService;
    @Autowired
    private ConnectionService connectionService;
    private final FirmwareRepoService firmwareRepoService;
    private final ScheduledExecutorService firmwareUpdateWorker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("firmwareUpdateWorkers-thread-%d").build());

    public FirmwareController(FirmwareRepoService firmwareRepoService, NodeInterface node, NodeListProvider nodeListProvider, JFrame parent) {
        this.parent = parent;
        this.node = node;
        this.nodeListProvider = nodeListProvider;
        this.firmwareRepoService = firmwareRepoService;
    }

    public void addFirmwareControllerListener(FirmwareControllerListener l) {
        this.listeners.add(l);
    }

    private void fireClose() {
        LOGGER.info("Close the firmware controller.");
        if (this.nodeListListener != null) {
            LOGGER.info("Remove the nodelist listener.");
            this.nodeListProvider.removeNodeListListener(this.nodeListListener);
            this.nodeListListener = null;
        }
        for (FirmwareControllerListener l : this.listeners) {
            l.close();
        }
    }

    private String prepareProductName(NodeInterface node) {
        Object productName = node.getNode().getStoredString(0);
        if (ProductUtils.isLightControl((long)node.getUniqueId())) {
            productName = this.firmwareModel.getNode().getStorableMacroCount() != 40 ? (String)productName + " (SIGNALS)" : (String)productName + " (STANDARD)";
        }
        return productName;
    }

    public void start() {
        this.start(null);
    }

    public void start(SoftwareVersion softwareVersion) {
        this.firmwareModel.setNode(this.node);
        String userName = this.node.getNode().getStoredString(1);
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            LOGGER.info("Store the userName from the node in the node labels: {}", (Object)userName);
            NodeLabels nodeLabels = this.wizardLabelWrapper.loadLabels(Long.valueOf(this.node.getUniqueId()));
            if (nodeLabels.getNodeLabel() == null) {
                nodeLabels.setNodeLabel(new NodeLabel().withUniqueId(this.node.getUniqueId()).withUserName(userName));
            } else {
                nodeLabels.getNodeLabel().setUserName(userName);
            }
            this.wizardLabelWrapper.saveNodeLabels(Long.valueOf(this.node.getUniqueId()));
        }
        this.firmwareModel.setNodeName(this.node.getLabel() != null ? this.node.getLabel() : NodeUtils.prepareNodeLabel((Node)this.node.getNode()));
        this.firmwareModel.setProductName(this.prepareProductName(this.node));
        long uniqueId = this.node.getNode().getUniqueId();
        this.firmwareModel.setUniqueId(ByteUtils.getUniqueIdAsString((long)uniqueId));
        SoftwareVersion swVersion = this.node.getNode().getSoftwareVersion();
        this.firmwareModel.setNodeCurrentVersion(swVersion != null ? swVersion.toString() : "unknown");
        File firmwareArchive = null;
        if (softwareVersion != null) {
            Integer vendorId = NodeUtils.getVendorId((long)this.node.getUniqueId());
            Integer productId = NodeUtils.getPid((long)this.node.getUniqueId());
            firmwareArchive = this.firmwareRepoService.findFirmwareArchive(vendorId, productId, softwareVersion);
            LOGGER.info("Found prepared firmwareArchive: {}", (Object)firmwareArchive);
        } else {
            LOGGER.info("No predefined firmware to update selected.");
        }
        boolean isBootloaderRootNode = false;
        isBootloaderRootNode = this.node.isUpdatable() && Arrays.equals(this.node.getNode().getAddr(), Node.ROOTNODE_ADDR);
        LOGGER.info("The current node is a bootloader rootnode: {}", (Object)isBootloaderRootNode);
        this.firmwareModel.setBootloaderRootNode(isBootloaderRootNode);
        this.nodeListListener = new /* Unavailable Anonymous Inner Class!! */;
        this.nodeListProvider.addNodeListListener(this.nodeListListener);
        this.firmwareModel.addPropertyChangeListener("cvDefinitionFiles", evt -> {
            if (CollectionUtils.isNotEmpty((Collection)this.firmwareModel.getCvDefinitionFiles())) {
                this.importFirmwareDefinitionFiles();
            }
        });
        this.firmwareModel.addPropertyChangeListener("vendorImageFiles", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.firmwareModel.addPropertyChangeListener("defaultLabelsFiles", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.firmwareModel.setPreventAskOverrideFile(true);
        FirmwareView view = new FirmwareView(this.parent, this.firmwareModel, this.settingsService, firmwareArchive);
        WindowUtils.centerOnCurrentScreen((Component)this.parent, (Component)view);
        BidibConnection connection = this.connectionService.find("main");
        view.addFirmwareViewListener((FirmwareViewListener)new /* Unavailable Anonymous Inner Class!! */);
        view.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importFirmwareDefinitionFiles() {
        List cvDefinitionFiles = this.firmwareModel.getCvDefinitionFiles();
        String version = this.firmwareModel.getUpdateVersion();
        LOGGER.info("Import the CV definition files: {}, version: {}", (Object)cvDefinitionFiles, (Object)version);
        String labelPath = this.settingsService.getMiscSettings().getBidibConfigDir();
        File searchPathLabelPath = new File(labelPath, "data/BiDiBNodeVendorData");
        searchPathLabelPath.mkdirs();
        String firmwareArchivePath = this.firmwareModel.getCvDefinitionArchivePath();
        File firmwareFile = new File(firmwareArchivePath);
        FirmwareFactory firmwareFactory = FirmwareFactory.createInstance();
        for (String cvDefinitionFile : cvDefinitionFiles) {
            try {
                LOGGER.info("Load CV definition from archive file into buffer: {}", (Object)firmwareArchivePath);
                List cvDefinitionContent = firmwareFactory.getCvDefinitionContent(firmwareFile, cvDefinitionFile);
                LOGGER.info("Load CV definition from file into buffer passed. Total number of lines: {}", (Object)cvDefinitionContent.size());
                Object targetFileName = cvDefinitionFile;
                if (!FirmwareUtils.hasVersionInFilename((String)cvDefinitionFile)) {
                    targetFileName = cvDefinitionFile.substring(0, cvDefinitionFile.indexOf(".xml")) + "-" + version + ".xml";
                    LOGGER.info("Prepared cvDefinitionFile with the version: {}", targetFileName);
                } else {
                    LOGGER.info("The cvDefinitionFile already contains a version: {}", targetFileName);
                }
                FileOutputStream fos = null;
                try {
                    File file = new File(searchPathLabelPath, (String)targetFileName);
                    if (file.exists()) {
                        if (!this.firmwareModel.isPreventAskOverrideFile()) {
                            boolean override = FileDialog.askOverrideExistingFiles((Component)this.parent);
                            if (!override) {
                                LOGGER.info("User decided to not overwrite the existing file.");
                                continue;
                            }
                            this.firmwareModel.setPreventAskOverrideFile(true);
                        } else {
                            LOGGER.info("Do not overwrite the existing file.");
                            continue;
                        }
                    }
                    fos = new FileOutputStream(file);
                    IOUtils.writeLines((Collection)cvDefinitionContent, null, (OutputStream)fos, (Charset)StandardCharsets.UTF_8);
                    fos.flush();
                }
                catch (Exception ex1) {
                    LOGGER.warn("Write CV definition file failed: {}", (Object)cvDefinitionFile, (Object)ex1);
                }
                finally {
                    if (fos == null) continue;
                    try {
                        fos.close();
                    }
                    catch (Exception e1) {
                        LOGGER.warn("Close fos failed.", (Throwable)e1);
                    }
                    continue;
                }
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    IOUtils.writeLines((Collection)cvDefinitionContent, null, (OutputStream)baos, (Charset)StandardCharsets.UTF_8);
                    baos.flush();
                    DefaultContext context = new DefaultContext();
                    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                    VendorCV vendorCV = VendorCvFactory.loadVendorCvFile((InputStream)bais, (Context)context);
                    if (vendorCV.getExtension() == null || !CollectionUtils.isNotEmpty((Collection)vendorCV.getExtension().getNodeLabels())) continue;
                    LOGGER.info("Found default node labels to import.");
                    File defaultLabelPath = new File(labelPath, "data/defaultLabels");
                    if (!defaultLabelPath.exists()) {
                        LOGGER.info("Create the defaultLabelPath directory: {}", (Object)defaultLabelPath);
                        defaultLabelPath.mkdirs();
                    }
                    String vidAndPid = FirmwareUtils.getVidAndPid((String)targetFileName);
                    for (NodeLabels nodeLabels : vendorCV.getExtension().getNodeLabels()) {
                        String lang = nodeLabels.getLang();
                        LOGGER.info("Found node labels for lang: {}", (Object)lang);
                        try {
                            String shortLang = StringUtils.substringBefore((String)lang, (String)"-");
                            StringBuilder sb = new StringBuilder("bidib-default-names-");
                            sb.append(vidAndPid).append("-").append(shortLang).append(".xml");
                            String defaultFileName = sb.toString();
                            LOGGER.info("Prepared default filename: {}, stored at defaultLabelPath: {}", (Object)defaultFileName, (Object)defaultLabelPath.getPath());
                            File file = new File(defaultLabelPath, defaultFileName);
                            if (file.exists()) {
                                LOGGER.info("Do not overwrite the existing default labels file: {}", (Object)file);
                                continue;
                            }
                            this.wizardLabelWrapper.saveDefaultLabels(nodeLabels, file);
                        }
                        catch (Exception ex2) {
                            LOGGER.warn("Write default lables file failed, lang: {}", (Object)lang, (Object)ex2);
                        }
                    }
                }
                catch (Exception ex1) {
                    LOGGER.warn("Write CV definition to byte array output stream failed: {}", (Object)cvDefinitionFile, (Object)ex1);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Load CV definition from file into buffer failed", (Throwable)e);
            }
        }
    }

    private void importVendorImageFiles() {
        List vendorImageFiles = this.firmwareModel.getVendorImageFiles();
        String version = this.firmwareModel.getUpdateVersion();
        LOGGER.info("Import the vendor image files: {}, version: {}", (Object)vendorImageFiles, (Object)version);
        String labelPath = this.settingsService.getMiscSettings().getBidibConfigDir();
        File vendorImageTargetPath = new File(labelPath, "data/images");
        vendorImageTargetPath.mkdirs();
        String vendorImageArchivePath = this.firmwareModel.getVendorImageArchivePath();
        File vendorImagePath = new File(vendorImageArchivePath);
        FirmwareFactory firmwareFactory = FirmwareFactory.createInstance();
        for (String vendorImageFile : vendorImageFiles) {
            try {
                LOGGER.info("Load vendor image from archive file into buffer: {}", (Object)vendorImageArchivePath);
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                firmwareFactory.getBinaryContent(vendorImagePath, vendorImageFile, buffer);
                LOGGER.info("Load CV definition from file into buffer passed. Total size: {}", (Object)buffer.size());
                String targetFileName = vendorImageFile;
                File file = new File(vendorImageTargetPath, targetFileName);
                if (file.exists()) {
                    if (!this.firmwareModel.isPreventAskOverrideFile()) {
                        boolean override = FileDialog.askOverrideExistingFiles((Component)this.parent);
                        if (!override) {
                            LOGGER.info("User decided to not overwrite the existing file.");
                            continue;
                        }
                        this.firmwareModel.setPreventAskOverrideFile(true);
                    } else {
                        LOGGER.info("Do not overwrite the existing file.");
                        continue;
                    }
                }
                try (FileOutputStream fos = new FileOutputStream(file);){
                    buffer.writeTo(fos);
                    fos.flush();
                }
                catch (Exception ex1) {
                    LOGGER.warn("Write vendor image file failed: {}", (Object)vendorImageFile, (Object)ex1);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Load vendor image from file into buffer failed", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importDefaultLabelsFiles() {
        List defaultLabelsFiles = this.firmwareModel.getDefaultLabelsFiles();
        String version = this.firmwareModel.getUpdateVersion();
        LOGGER.info("Import the default labels files: {}, version: {}", (Object)defaultLabelsFiles, (Object)version);
        String labelPath = this.settingsService.getMiscSettings().getBidibConfigDir();
        File searchPathLabelPath = new File(labelPath, "data/defaultLabels");
        searchPathLabelPath.mkdirs();
        String firmwareArchivePath = this.firmwareModel.getCvDefinitionArchivePath();
        File firmwareFile = new File(firmwareArchivePath);
        FirmwareFactory firmwareFactory = FirmwareFactory.createInstance();
        for (FilenameType defaultLabelFile : defaultLabelsFiles) {
            String lang = StringUtils.substringBefore((String)defaultLabelFile.getLang(), (String)"-");
            String labelFilename = defaultLabelFile.getFilename();
            LOGGER.info("Found configured default labels file for lang: {}, filename: {}", (Object)lang, (Object)labelFilename);
            List defaultLabelsContent = new ArrayList();
            try {
                LOGGER.info("Load default labels from archive file into buffer: {}", (Object)firmwareArchivePath);
                defaultLabelsContent = firmwareFactory.getCvDefinitionContent(firmwareFile, labelFilename);
                LOGGER.info("Load default labels from file into buffer passed. Total number of lines: {}", (Object)defaultLabelsContent.size());
                Object targetFileName = labelFilename;
                if (!FirmwareUtils.hasVersionInDefaultLablesFilename((String)labelFilename)) {
                    targetFileName = labelFilename.substring(0, labelFilename.indexOf(".xml") - 3) + "-" + version + "-" + lang + ".xml";
                    LOGGER.info("Prepared default labels file with the version: {}", targetFileName);
                } else {
                    LOGGER.info("The default labels file already contains a version: {}", targetFileName);
                }
                FileOutputStream fos = null;
                try {
                    File file = new File(searchPathLabelPath, (String)targetFileName);
                    if (file.exists()) {
                        if (!this.firmwareModel.isPreventAskOverrideFile()) {
                            boolean override = FileDialog.askOverrideExistingFiles((Component)this.parent);
                            if (!override) {
                                LOGGER.info("User decided to not overwrite the existing file.");
                                continue;
                            }
                            this.firmwareModel.setPreventAskOverrideFile(true);
                        } else {
                            LOGGER.info("Do not overwrite the existing file.");
                            continue;
                        }
                    }
                    fos = new FileOutputStream(file);
                    IOUtils.writeLines(defaultLabelsContent, null, (OutputStream)fos, (Charset)StandardCharsets.UTF_8);
                    fos.flush();
                }
                catch (Exception ex1) {
                    LOGGER.warn("Write default labels file failed: {}", (Object)labelFilename, (Object)ex1);
                }
                finally {
                    if (fos == null) continue;
                    try {
                        fos.close();
                    }
                    catch (Exception e1) {
                        LOGGER.warn("Close fos failed.", (Throwable)e1);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn("Load default labels from file into buffer failed", (Throwable)e);
            }
        }
    }

    private boolean sendCommand(BidibConnection connection, FirmwareUpdateOperation operation, byte ... data) throws InterruptedException {
        boolean result = false;
        FirmwareUpdateStat updateStat = null;
        try {
            updateStat = connection.sendFirmwareUpdateOperation(this.node, operation, data);
        }
        catch (NoAnswerException ex) {
            switch (5.$SwitchMap$org$bidib$jbidibc$messages$enums$FirmwareUpdateOperation[operation.ordinal()]) {
                case 1: {
                    LOGGER.warn("No answer received during enter firmware update mode.", (Throwable)ex);
                    break;
                }
                case 2: {
                    LOGGER.warn("No answer received during exit firmware update mode.", (Throwable)ex);
                    break;
                }
                default: {
                    LOGGER.warn("No answer received during firmware update, try send data again.", (Throwable)ex);
                    this.traceTimeout(operation, true);
                }
            }
        }
        if (updateStat == null && FirmwareUpdateOperation.DATA == operation) {
            LOGGER.warn("Try to retransfer the data block.");
            try {
                updateStat = connection.sendFirmwareUpdateOperation(this.node, operation, data);
            }
            catch (NoAnswerException ex) {
                LOGGER.warn("No answer received during firmware update when retry send data. Firmware update process will be aborted.", (Throwable)ex);
                this.traceTimeout(operation, false);
            }
        }
        if (updateStat != null) {
            LOGGER.info("Received update stat, timeout: {}, state: {}, last operation: {}", new Object[]{updateStat.getTimeout(), updateStat.getState(), operation});
            if (updateStat.getTimeout() > 0) {
                int extendedTime = updateStat.getTimeout() * 10;
                LOGGER.warn("The node requested a wait to complete: {} ms", (Object)extendedTime);
                this.traceMoreTimeRequested(extendedTime);
                Thread.sleep(extendedTime);
                this.traceContinueAfterMoreTimeRequested(extendedTime);
            }
            FirmwareUpdateState state = updateStat.getState();
            if (operation == FirmwareUpdateOperation.ENTER && state == FirmwareUpdateState.READY || operation == FirmwareUpdateOperation.DONE && state == FirmwareUpdateState.READY || operation == FirmwareUpdateOperation.EXIT && state == FirmwareUpdateState.EXIT || operation == FirmwareUpdateOperation.SETDEST && state == FirmwareUpdateState.DATA || operation == FirmwareUpdateOperation.DATA && state == FirmwareUpdateState.DATA) {
                result = true;
            } else {
                LOGGER.warn("The firmware update state ({}) returned from the node does not match the firmware operation ({}).", (Object)state, (Object)operation);
                ConsoleController.ensureConsoleVisible();
                this.consoleService.addConsoleLine(ConsoleColor.red, String.format("The firmware update state (%s) returned from the node does not match the firmware operation (%s).", state != null ? state.name() : "unknown", operation != null ? operation.name() : "unknown"));
                this.traceInvalidAnswer(state, operation);
            }
        } else {
            LOGGER.warn("No updateStat received for operation: {}", (Object)operation);
            ConsoleController.ensureConsoleVisible();
            this.consoleService.addConsoleLine(ConsoleColor.red, String.format("No firmware update state returned from the node after send the firmware operation (%s).", operation != null ? operation.name() : "unknown"));
            this.traceInvalidAnswer(operation);
        }
        LOGGER.debug("sendCommand return result: {}", (Object)result);
        return result;
    }

    private void traceTimeout(FirmwareUpdateOperation operation, boolean retry) {
        if (retry) {
            this.firmwareModel.addProcessingStatus(Resources.getString(FirmwareController.class, (String)"status.transfer-firmware-timeout-retry"), 1, new Object[]{operation});
        } else {
            this.firmwareModel.addProcessingStatus(Resources.getString(FirmwareController.class, (String)"status.transfer-firmware-timeout"), 1, new Object[]{operation});
        }
    }

    private void traceMoreTimeRequested(int extendedTime) {
        this.firmwareModel.addProcessingStatus(Resources.getString(FirmwareController.class, (String)"status.transfer-firmware-more-time-requested"), 1, new Object[]{extendedTime});
    }

    private void traceContinueAfterMoreTimeRequested(int extendedTime) {
        this.firmwareModel.addProcessingStatus(Resources.getString(FirmwareController.class, (String)"status.transfer-firmware-continue-after-more-time-wait"), 1, new Object[]{extendedTime});
    }

    private void traceInvalidAnswer(FirmwareUpdateState state, FirmwareUpdateOperation operation) {
        this.firmwareModel.addProcessingStatus(Resources.getString(FirmwareController.class, (String)"status.transfer-firmware-invalid-answer"), 1, new Object[]{state != null ? state.name() : "unknown", operation != null ? operation.name() : "unknown"});
    }

    private void traceInvalidAnswer(FirmwareUpdateOperation operation) {
        this.firmwareModel.addProcessingStatus(Resources.getString(FirmwareController.class, (String)"status.transfer-firmware-no-answer"), 1, new Object[]{operation != null ? operation.name() : "unknown"});
    }

    private void showErrorDialog(JFrame parent, String message, String title) {
        if (SwingUtilities.isEventDispatchThread()) {
            JOptionPane.showMessageDialog(parent, message, title, 0);
        } else {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(parent, message, title, 0));
        }
    }
}

