/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.StyledLabelBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.enums.LcMacroState;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.jbidibc.messages.exception.ProtocolNoAnswerException;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.MacroSaveState;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.MacroListListener;
import org.bidib.wizard.api.utils.MacroUtils;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.script.node.types.TargetType;
import org.bidib.wizard.common.utils.MacroListUtils;
import org.bidib.wizard.common.view.statusbar.StatusBar;
import org.bidib.wizard.core.labels.BidibLabelUtils;
import org.bidib.wizard.core.labels.DefaultWizardLabelFactory;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.mvc.common.view.panel.DisabledPanel;
import org.bidib.wizard.mvc.common.view.table.DefaultTextCellEditor;
import org.bidib.wizard.mvc.main.controller.MacroPanelController;
import org.bidib.wizard.mvc.main.controller.listener.MacroPanelListener;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.SingleColumnTableModel;
import org.bidib.wizard.mvc.main.model.listener.MacroSelectionListener;
import org.bidib.wizard.mvc.main.view.menu.MacroListMenu;
import org.bidib.wizard.mvc.main.view.menu.listener.MacroListMenuListener;
import org.bidib.wizard.mvc.main.view.panel.MacroListPanel;
import org.bidib.wizard.mvc.main.view.panel.MacroPanel;
import org.bidib.wizard.mvc.main.view.panel.PendingChangesAware;
import org.bidib.wizard.mvc.main.view.panel.listener.LabelChangedListener;
import org.bidib.wizard.mvc.main.view.panel.listener.MacroActionListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabSelectionListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.bidib.wizard.mvc.main.view.panel.renderer.MacroListRenderer;
import org.bidib.wizard.nodescript.script.node.ChangeLabelSupport;
import org.oxbow.swingbits.dialog.task.TaskDialogs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroListPanel
implements MacroListMenuListener,
MacroListListener,
MacroActionListener,
MacroSelectionListener,
ChangeLabelSupport,
TabVisibilityProvider,
TabPanelProvider,
PendingChangesAware,
TabSelectionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MacroListPanel.class);
    private static final String EMPTY_LABEL = " ";
    private final MainModel mainModel;
    private final Collection<LabelChangedListener<Macro>> labelChangedListeners = new LinkedList();
    private final TabVisibilityListener tabVisibilityListener;
    private MacroPanelListener macroPanelListener;
    private final MacroPanel macroPanel;
    private final MacroListMenu macroListMenu = new MacroListMenu();
    private final DisabledPanel disabledBorderPanel;
    private JScrollPane scrollMacroList;
    private final JPanel contentPanel;
    private final StatusBar statusBar;
    private final SettingsService settingsService;
    private final WizardLabelWrapper wizardLabelWrapper;
    private final MacroList macroList;
    private final MacroPanelController macroPanelController;
    private static final String WORKING_DIR_MACRO_EXCHANGE_KEY = "macroExchange";

    public MacroListPanel(MacroPanelController macroPanelController, MainModel model, TabVisibilityListener tabVisibilityListener, SettingsService settingsService, WizardLabelWrapper wizardLabelWrapper, DefaultWizardLabelFactory bidibLabelFactory) {
        this.macroPanelController = macroPanelController;
        this.mainModel = model;
        this.tabVisibilityListener = tabVisibilityListener;
        this.wizardLabelWrapper = wizardLabelWrapper;
        this.settingsService = settingsService;
        this.statusBar = (StatusBar)DefaultApplicationContext.getInstance().get("statusBar", StatusBar.class);
        this.contentPanel = new /* Unavailable Anonymous Inner Class!! */;
        this.contentPanel.setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.macroListMenu.addMenuListener((MacroListMenuListener)this);
        this.macroPanel = new MacroPanel(this.macroPanelController, this.mainModel, this.settingsService, (MacroListMenuListener)this);
        JPanel panel = new JPanel(new BorderLayout());
        this.disabledBorderPanel = new DisabledPanel((Container)this.macroPanel);
        panel.add((Component)this.disabledBorderPanel);
        SingleColumnTableModel tableModel = new SingleColumnTableModel(Macro.class);
        tableModel.addLabelChangedListener((macro, label) -> {
            LOGGER.info("The label of the macro was changed: {}, label: {}", macro, (Object)label);
            long uniqueId = model.getSelectedNode().getUniqueId();
            macro.setLabel(label);
            NodeLabels nodeLabels = this.wizardLabelWrapper.loadLabels(Long.valueOf(uniqueId));
            BidibLabelUtils.replaceMacroLabel((NodeLabels)nodeLabels, (int)macro.getId(), (String)label);
            this.wizardLabelWrapper.saveNodeLabels(Long.valueOf(uniqueId));
        });
        this.macroList = new MacroList(this, (DefaultTableModel)tableModel);
        this.macroList.adjustRowHeight();
        this.macroList.getTableHeader().setReorderingAllowed(false);
        this.macroList.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        this.macroList.setSortable(false);
        this.macroList.setSelectionMode(0);
        TableColumn tc = this.macroList.getColumnModel().getColumn(0);
        tc.setPreferredWidth(80);
        tc.setWidth(80);
        MacroListRenderer renderer = new MacroListRenderer();
        tc.setCellRenderer((TableCellRenderer)renderer);
        tc.setCellEditor((TableCellEditor)new DefaultTextCellEditor(new JTextField()));
        this.macroList.setPreferredScrollableViewportSize(new Dimension(200, 200));
        DefaultOverlayable overlayTable = new DefaultOverlayable((JComponent)new JScrollPane((Component)this.macroList));
        this.macroList.getModel().addTableModelListener((TableModelListener)new /* Unavailable Anonymous Inner Class!! */);
        this.macroList.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        overlayTable.addOverlayComponent((JComponent)StyledLabelBuilder.createStyledLabel((String)("{" + this.macroList.getEmptyTableText() + ":f:gray}")));
        this.scrollMacroList = new JScrollPane((Component)overlayTable);
        JSplitPane splitPane = new JSplitPane(1, this.scrollMacroList, panel);
        splitPane.setContinuousLayout(true);
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(0.2);
        this.contentPanel.add((Component)splitPane, "Center");
        this.setEnabled(false);
    }

    public void setMacroPanelListener(MacroPanelListener macroPanelListener) {
        this.macroPanelListener = macroPanelListener;
    }

    public JPanel getComponent() {
        return this.contentPanel;
    }

    public void setEnabled(boolean enabled) {
        this.disabledBorderPanel.setEnabled(enabled);
    }

    private void fireExportMacro() {
        Macro macro = this.mainModel.getSelectedMacro();
        if (macro.isValid()) {
            this.exportMacro(macro);
        } else {
            LOGGER.warn("Macro is not valid for export.");
        }
    }

    private void fireReloadMacro() {
        this.reloadMacro(this.mainModel.getSelectedMacro());
    }

    private void fireSaveMacro() {
        Macro macro = this.mainModel.getSelectedMacro();
        if (macro.isValid()) {
            this.saveMacro(macro);
        } else {
            JOptionPane.showMessageDialog(this.contentPanel, Resources.getString(this.getClass(), (String)"macro_content_not_valid"), Resources.getString(this.getClass(), (String)"save"), 2);
        }
    }

    private void fireTestMacro(boolean transferBeforeStart) {
        Macro macro = this.mainModel.getSelectedMacro();
        if (macro.isValid()) {
            int result;
            if (!transferBeforeStart && macro.getMacroSaveState().equals((Object)MacroSaveState.PENDING_CHANGES) && (result = JOptionPane.showConfirmDialog(this.contentPanel, Resources.getString(this.getClass(), (String)"macro_transfer_pending_changes_before_test"), Resources.getString(this.getClass(), (String)"start"), 0, 2)) == 0) {
                transferBeforeStart = true;
            }
            this.startMacro(macro, transferBeforeStart);
        } else {
            JOptionPane.showMessageDialog(this.contentPanel, Resources.getString(this.getClass(), (String)"macro_content_not_valid"), Resources.getString(this.getClass(), (String)"start"), 2);
        }
    }

    public void remoteStartMacro() {
        Macro macro = this.mainModel.getSelectedMacro();
        this.startMacro(macro, false);
    }

    private void fireStopMacro() {
        this.stopMacro(this.mainModel.getSelectedMacro());
    }

    private void fireInitializeMacro() {
        this.initializeMacro(this.mainModel.getSelectedMacro());
    }

    public void transferMacro() {
        Macro macro = this.mainModel.getSelectedMacro();
        if (macro.isValid()) {
            this.transferMacro(this.mainModel.getSelectedMacro());
        } else {
            JOptionPane.showMessageDialog(this.contentPanel, Resources.getString(this.getClass(), (String)"macro_content_not_valid"), Resources.getString(this.getClass(), (String)"transfer"), 2);
        }
    }

    public void exportMacro() {
        this.fireExportMacro();
    }

    public void startMacro() {
        boolean powerUser = this.settingsService.getWizardSettings().isPowerUser();
        this.fireTestMacro(powerUser);
    }

    public void stopMacro() {
        this.fireStopMacro();
    }

    public void initializeMacro() {
        this.fireInitializeMacro();
    }

    public void saveMacro() {
        this.fireSaveMacro();
    }

    public void reloadMacro() {
        this.fireReloadMacro();
    }

    public void testMacro(boolean transferBeforeStart) {
        this.fireTestMacro(transferBeforeStart);
    }

    public void listChanged() {
        LOGGER.info("Macro list has been changed.");
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalListChanged();
        } else {
            SwingUtilities.invokeLater(() -> this.internalListChanged());
        }
    }

    private void internalListChanged() {
        LOGGER.info("Macro list has been changed. Reload the macros.");
        ArrayList macros = new ArrayList();
        macros.addAll(this.mainModel.getMacros());
        Collections.sort(macros, new /* Unavailable Anonymous Inner Class!! */);
        this.macroList.setItems(macros.toArray(new Macro[0]));
        this.resetMacroScrollPane();
        this.setEnabled(false);
        this.tabVisibilityListener.setTabVisible((Component)this.getComponent(), this.isTabVisible());
    }

    private void resetMacroScrollPane() {
        JScrollBar verticalScrollBar = this.scrollMacroList.getVerticalScrollBar();
        JScrollBar horizontalScrollBar = this.scrollMacroList.getHorizontalScrollBar();
        verticalScrollBar.setValue(verticalScrollBar.getMinimum());
        horizontalScrollBar.setValue(horizontalScrollBar.getMinimum());
    }

    public void macroChanged() {
        LOGGER.info("Macro selection has changed.");
        Macro macro = this.mainModel.getSelectedMacro();
        LOGGER.info("The selected macro has been changed, macro: {}", (Object)macro);
        if (macro != null) {
            this.labelChanged(macro, macro.toString());
        } else {
            this.labelChanged(macro, EMPTY_LABEL);
        }
        this.setEnabled(macro != null);
        SwingUtilities.invokeLater(() -> this.macroList.requestFocusInWindow());
    }

    public void pendingChangesChanged() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.macroList.refreshView();
        } else {
            SwingUtilities.invokeLater(() -> this.macroList.refreshView());
        }
    }

    public void changeLabel(TargetType portType) {
        int portNum = portType.getPortNum();
        String label = portType.getLabel();
        Macro macro = MacroListUtils.findMacroByMacroNumber((List)this.mainModel.getMacros(), (int)portNum);
        if (macro != null) {
            LOGGER.info("Current macro: {}, new label: {}", (Object)macro, (Object)label);
            macro.setLabel(label);
            if (macro.equals((Object)this.mainModel.getSelectedMacro())) {
                this.labelChanged(macro, label);
            }
            this.fireLabelChanged(macro, label);
        }
    }

    public boolean isTabVisible() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            boolean isTabVisible = node.hasMacros();
            LOGGER.debug("Check if tab is visible: {}", (Object)isTabVisible);
            return isTabVisible;
        }
        return false;
    }

    public boolean equals(Object other) {
        return other instanceof MacroListPanel;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void exportMacro(Macro macro) {
        int result;
        if (CollectionUtils.isNotEmpty((Collection)macro.getFunctions()) && MacroUtils.hasEmptySteps((Macro)macro)) {
            result = JOptionPane.showConfirmDialog(this.getComponent(), Resources.getString(MacroListPanel.class, (String)"ask_continue_export_macro_with_empty_step"), Resources.getString(MacroListPanel.class, (String)"export_macro.title"), 2, 2);
            if (result != 0) {
                LOGGER.info("User canceled export empty macro.");
                return;
            }
            LOGGER.info("Remove empty macro steps.");
            MacroUtils.removeEmptySteps((Macro)macro);
        }
        if (CollectionUtils.isEmpty((Collection)macro.getFunctions()) && (result = JOptionPane.showConfirmDialog(this.getComponent(), Resources.getString(MacroListPanel.class, (String)"ask_export_empty_macro"), Resources.getString(MacroListPanel.class, (String)"export_macro.title"), 2)) != 0) {
            LOGGER.info("User canceled export empty macro.");
            return;
        }
        WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_MACRO_EXCHANGE_KEY);
        5 dialog = new /* Unavailable Anonymous Inner Class!! */;
        dialog.showDialog();
    }

    public void importMacro() {
        if (this.mainModel.getSelectedMacro() != null && this.mainModel.getSelectedMacro().getMacroSaveState().equals((Object)MacroSaveState.PENDING_CHANGES)) {
            int result = JOptionPane.showConfirmDialog(this.getComponent(), Resources.getString(MacroListPanel.class, (String)"macro_has_pending_changes"), Resources.getString(MacroListPanel.class, (String)"pending_changes"), 2);
            if (result != 0) {
                LOGGER.info("User canceled discard pending changes.");
                return;
            }
            this.mainModel.getSelectedMacro().setMacroSaveState(MacroSaveState.SAVED_ON_NODE);
        }
        NodeInterface selectedNode = this.mainModel.getSelectedNode();
        WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_MACRO_EXCHANGE_KEY);
        6 dialog = new /* Unavailable Anonymous Inner Class!! */;
        dialog.showDialog();
    }

    public void replaceMacro(Macro macro, boolean saveOnNode) {
        block5: {
            LOGGER.info("Replace the macro: {}", (Object)macro);
            if (macro != null) {
                int result;
                NodeInterface node = this.mainModel.getSelectedNode();
                macro.setFunctionSize(node.getMaxMacroSteps());
                if (this.mainModel.getSelectedMacro() != null && this.mainModel.getSelectedMacro().getMacroSaveState().equals((Object)MacroSaveState.PENDING_CHANGES) && (result = JOptionPane.showConfirmDialog(this.getComponent(), Resources.getString(MacroListPanel.class, (String)"macro_has_pending_changes"), Resources.getString(MacroListPanel.class, (String)"pending_changes"), 2)) != 0) {
                    LOGGER.info("User canceled discard pending changes.");
                    return;
                }
                this.mainModel.replaceMacro(macro);
            }
            if (saveOnNode) {
                LOGGER.info("Transfer the macro to node and save permanently: {}", (Object)macro);
                try {
                    this.macroPanelListener.storeMacroOnNode(macro);
                    LOGGER.info("Transfer and save macro passed.");
                }
                catch (RuntimeException ex) {
                    LOGGER.warn("Transfer macro content or save macro failed.", (Throwable)ex);
                    this.mainModel.setNodeHasError(this.mainModel.getSelectedNode(), true);
                    if (!(ex.getCause() instanceof ProtocolNoAnswerException)) break block5;
                    TaskDialogs.build((Window)JOptionPane.getFrameForComponent(this.getComponent()), (String)Resources.getString(MacroListPanel.class, (String)"save-macro-to-node-failed.instruction"), (String)Resources.getString(MacroListPanel.class, (String)"save-macro-to-node-failed", (Object[])new Object[]{macro.toString()})).title(Resources.getString(MacroListPanel.class, (String)"save-macro.title")).exception((Throwable)ex);
                }
            }
        }
    }

    public void labelChanged(Macro macro, String label) {
        LOGGER.info("Label of macro has changed, macro: {}, label: {}", (Object)macro, (Object)label);
        this.saveChangedLabel(macro, label);
    }

    private void saveChangedLabel(Macro macro, String label) {
        if (macro != null) {
            long uniqueId = this.mainModel.getSelectedNode().getNode().getUniqueId();
            try {
                NodeLabels nodeLabels = this.wizardLabelWrapper.loadLabels(Long.valueOf(uniqueId));
                BidibLabelUtils.replaceMacroLabel((NodeLabels)nodeLabels, (int)macro.getId(), (String)label);
                this.wizardLabelWrapper.saveNodeLabels(Long.valueOf(uniqueId));
            }
            catch (Exception e) {
                LOGGER.warn("Save macro labels failed.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public void reloadMacro(Macro macro) {
        if (macro != null && macro.getMacroSaveState().equals((Object)MacroSaveState.PENDING_CHANGES)) {
            int result = JOptionPane.showConfirmDialog(this.getComponent(), Resources.getString(MacroListPanel.class, (String)"macro_has_pending_changes"), Resources.getString(MacroListPanel.class, (String)"pending_changes"), 2);
            if (result != 0) {
                LOGGER.info("User canceled discard pending changes.");
                return;
            }
            macro.setMacroSaveState(MacroSaveState.SAVED_ON_NODE);
        }
        try {
            LcMacroState lcMacroState = this.macroPanelListener.reloadMacro(macro);
            LOGGER.info("Reload macro returned: {}", (Object)lcMacroState);
            this.mainModel.getSelectedMacro().setMacroSaveState(MacroSaveState.PERMANENTLY_STORED_ON_NODE);
            macro.setContainsError(false);
        }
        catch (InvalidConfigurationException ex) {
            LOGGER.warn("Restore macro content failed.", (Throwable)ex);
            this.mainModel.setNodeHasError(this.mainModel.getSelectedNode(), true);
        }
    }

    public void saveMacro(Macro macro) {
        LOGGER.info("Save macro: {}", (Object)macro);
        try {
            LcMacroState lcMacroState = this.macroPanelListener.saveMacro(macro);
            LOGGER.info("Save macro returned: {}", (Object)lcMacroState);
            macro.setContainsError(false);
        }
        catch (RuntimeException ex) {
            LOGGER.warn("Save macro content failed.", (Throwable)ex);
            if (ex.getCause() instanceof ProtocolNoAnswerException) {
                TaskDialogs.build((Window)JOptionPane.getFrameForComponent(this.getComponent()), (String)Resources.getString(MacroListPanel.class, (String)"save-macro-to-node-failed.instruction"), (String)Resources.getString(MacroListPanel.class, (String)"save-macro-to-node-failed", (Object[])new Object[]{macro.toString()})).title(Resources.getString(MacroListPanel.class, (String)"save-macro.title")).exception((Throwable)ex);
            }
            this.mainModel.setNodeHasError(this.mainModel.getSelectedNode(), true);
        }
    }

    public void startMacro(Macro macro, boolean transferBeforeStart) {
        LOGGER.info("Start macro: {}, transferBeforeStart: {}", (Object)macro, (Object)transferBeforeStart);
        LcMacroState lcMacroState = this.macroPanelListener.startMacro(macro, transferBeforeStart);
        LOGGER.info("Start macro returned: {}", (Object)lcMacroState);
    }

    public void stopMacro(Macro macro) {
        LOGGER.info("Stop macro: {}", (Object)macro);
        LcMacroState lcMacroState = this.macroPanelListener.stopMacro(macro);
        LOGGER.info("Stop macro returned: {}", (Object)lcMacroState);
    }

    public void transferMacro(Macro macro) {
        LOGGER.info("Transfer macro: {}", (Object)macro);
        try {
            this.macroPanelListener.transferMacro(macro);
            LOGGER.info("Transfer macro passed.");
        }
        catch (InvalidConfigurationException ex) {
            LOGGER.warn("Transfer macro content failed.", (Throwable)ex);
            this.mainModel.setNodeHasError(this.mainModel.getSelectedNode(), true);
        }
    }

    public void initializeMacro(Macro macro) {
        try {
            if (this.mainModel.getSelectedMacro() != null && this.mainModel.getSelectedMacro().equals((Object)macro) && this.mainModel.getSelectedMacro().getMacroSaveState().equals((Object)MacroSaveState.PENDING_CHANGES)) {
                int result = JOptionPane.showConfirmDialog(this.getComponent(), Resources.getString(MacroListPanel.class, (String)"macro_has_pending_changes"), Resources.getString(MacroListPanel.class, (String)"pending_changes"), 2);
                if (result != 0) {
                    LOGGER.info("User canceled discard pending changes.");
                    return;
                }
                this.mainModel.getSelectedMacro().setMacroSaveState(MacroSaveState.SAVED_ON_NODE);
            }
            macro.initialize();
            macro.setMacroSaveState(MacroSaveState.PENDING_CHANGES);
            macro.setLabel(null);
            this.saveChangedLabel(macro, null);
            this.mainModel.setSelectedMacro(macro);
        }
        catch (Exception ex) {
            LOGGER.warn("Set the new selcted macro failed.", (Throwable)ex);
        }
    }

    public boolean hasPendingChanges() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            List macros = node.getMacros();
            for (Macro macro : macros) {
                if (MacroSaveState.PENDING_CHANGES != macro.getMacroSaveState()) continue;
                LOGGER.info("Found pending changes in macro: {}", (Object)macro);
                return true;
            }
        }
        return false;
    }

    public void addLabelChangedListener(LabelChangedListener<Macro> l) {
        this.labelChangedListeners.add(l);
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.macroList.addListSelectionListener(l);
    }

    protected void fireLabelChanged(Macro macro, String label) {
        this.labelChanged(macro, label);
        this.macroList.refreshView();
        for (LabelChangedListener l : this.labelChangedListeners) {
            l.labelChanged((Object)macro, label);
        }
    }

    public void tabSelected(boolean selected) {
        LOGGER.info("Tab is selected: {}", (Object)selected);
        if (selected && this.macroList.getCellEditor() != null) {
            this.macroList.getCellEditor().stopCellEditing();
        }
    }

    public void editLabel(MouseEvent popupEvent) {
        SwingUtilities.invokeLater(() -> {
            int selectedRow = this.macroList.getSelectedRow();
            if (selectedRow > -1) {
                LOGGER.info(">>> Edit row, selectedRow: {}", (Object)selectedRow);
                this.macroList.requestFocus();
                this.macroList.editCellAt(selectedRow, 0);
                TableCellEditor editor = this.macroList.getCellEditor();
                if (editor != null) {
                    SwingUtilities.invokeLater(() -> {
                        JTextField textField = (JTextField)((DefaultTextCellEditor)editor).getComponent();
                        textField.requestFocusInWindow();
                    });
                }
            }
        });
    }

    protected void handleMouseEvent(MouseEvent e, JPopupMenu popupMenu) {
        if (e.isPopupTrigger() && this.macroList.getRowCount() > 0) {
            if (this.macroList.getCellEditor() != null) {
                this.macroList.getCellEditor().stopCellEditing();
            }
            int selectRow = this.macroList.rowAtPoint(e.getPoint());
            this.macroList.setRowSelectionInterval(selectRow, selectRow);
            SwingUtilities.invokeLater(() -> popupMenu.show(e.getComponent(), e.getX(), e.getY()));
        }
    }

    public void refreshView() {
        this.macroList.refreshView();
    }
}

