/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.worklist.model;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.common.collect.ArrayListModel;
import java.util.Collections;
import java.util.List;
import org.bidib.wizard.api.event.WorkListItemEvent;
import org.bidib.wizard.mvc.worklist.model.WorkItemModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkItemListModel
extends Model {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkItemListModel.class);
    private static final long serialVersionUID = 1L;
    private ArrayListModel<WorkItemModel> workItemList = new ArrayListModel();

    public ArrayListModel<WorkItemModel> getWorkItemListModel() {
        return this.workItemList;
    }

    public List<WorkItemModel> getWorkItems() {
        return Collections.unmodifiableList(this.workItemList);
    }

    public boolean contains(WorkListItemEvent item) {
        long count = this.workItemList.stream().filter(wi -> wi.getWorkListItemEvent().getComponent().equals(item.getComponent()) && wi.getWorkListItemEvent().getClass() == item.getClass()).count();
        return count > 0L;
    }

    public void addWorkListItem(WorkListItemEvent item) {
        if (!this.contains(item)) {
            WorkItemModel workItemModel = new WorkItemModel(item);
            this.addWorkListItem(workItemModel);
        } else {
            LOGGER.info("Skip adding duplicate item: {}", (Object)item);
        }
    }

    public void addWorkListItem(WorkItemModel workItemModel) {
        this.workItemList.add((Object)workItemModel);
    }

    public void removeWorkListItem(WorkItemModel workItemModel) {
        this.workItemList.remove((Object)workItemModel);
    }

    public void addWorkListItems(List<WorkListItemEvent> items) {
        for (WorkListItemEvent item : items) {
            this.addWorkListItem(item);
        }
    }

    public void clear() {
        this.workItemList.clear();
    }
}

