/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.console.controller;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingConstants;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.DockingUtilities;
import com.vlsolutions.swing.docking.RelativeDockablePosition;
import com.vlsolutions.swing.docking.TabbedDockableContainer;
import com.vlsolutions.swing.docking.event.DockableStateChangeListener;
import javax.swing.SwingUtilities;
import org.bidib.jbidibc.core.event.MessageTimeoutEvent;
import org.bidib.wizard.api.event.ErrorEvent;
import org.bidib.wizard.api.model.NodeListProvider;
import org.bidib.wizard.api.model.event.AccessoryErrorEvent;
import org.bidib.wizard.api.model.event.ConsoleMessageEvent;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.service.console.ConsoleColor;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.client.common.view.DockUtils;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.mvc.console.controller.ConsoleController;
import org.bidib.wizard.mvc.console.view.ConsoleView;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.EventListener;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConsoleController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsoleController.class);
    private ConsoleView consoleView;
    private final DockingDesktop desktop;
    private final NodeListProvider nodeListProvider;
    private final ConsoleService consoleService;

    public ConsoleController(DockingDesktop desktop, NodeListProvider nodeListProvider, ConsoleService consoleService) {
        this.desktop = desktop;
        this.nodeListProvider = nodeListProvider;
        this.consoleService = consoleService;
    }

    protected ConsoleService getConsoleService() {
        return this.consoleService;
    }

    public void start() {
        String searchKey = "ConsoleView";
        LOGGER.info("Search for view with key: {}", (Object)searchKey);
        Dockable view = this.desktop.getContext().getDockableByKey(searchKey);
        if (view != null) {
            LOGGER.info("Select the existing console view.");
            DockUtils.selectWindow((Dockable)view);
            return;
        }
        this.createDockable();
    }

    public Dockable createDockable() {
        LOGGER.info("Create new ConsoleView.");
        if (this.consoleView != null) {
            LOGGER.info("Select the existing console view.");
            DockUtils.selectWindow((Dockable)this.consoleView);
            return this.consoleView;
        }
        LOGGER.info("Create the consoleView instance.");
        this.consoleView = new ConsoleView(this.consoleService);
        DockableState[] dockables = this.desktop.getDockables();
        LOGGER.info("Current dockables: {}", new Object[]{dockables});
        if (dockables.length > 1) {
            DockableState boosterTableView = null;
            for (DockableState dockable : dockables) {
                if (!DockKeys.DOCKKEY_BOOSTER_TABLE_VIEW.equals((Object)dockable.getDockable().getDockKey())) continue;
                LOGGER.info("Found the booster table view dockable.");
                boosterTableView = dockable;
                break;
            }
            Dockable dock = this.desktop.getDockables()[1].getDockable();
            if (boosterTableView != null) {
                LOGGER.info("Add the console view to the booster table view panel.");
                dock = boosterTableView.getDockable();
                TabbedDockableContainer container = DockingUtilities.findTabbedDockableContainer((Dockable)dock);
                int order = 0;
                if (container != null) {
                    order = container.getTabCount();
                }
                LOGGER.info("Add new log panel at order: {}", (Object)order);
                this.desktop.createTab(dock, (Dockable)this.consoleView, order, true);
            } else if (this.desktop.getDockables().length > 1) {
                this.desktop.split(dock, (Dockable)this.consoleView, DockingConstants.SPLIT_BOTTOM);
                this.desktop.setDockableHeight((Dockable)this.consoleView, 0.2);
            } else {
                this.desktop.split(dock, (Dockable)this.consoleView, DockingConstants.SPLIT_RIGHT);
            }
        } else {
            this.desktop.addDockable((Dockable)this.consoleView, RelativeDockablePosition.RIGHT);
        }
        1 nodeListListener = new /* Unavailable Anonymous Inner Class!! */;
        this.desktop.addDockableStateChangeListener((DockableStateChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.nodeListProvider.addNodeListListener((NodeListListener)nodeListListener);
        AnnotationProcessor.process((Object)this);
        return this.consoleView;
    }

    public static synchronized void ensureConsoleVisible() {
        String searchKey = "ConsoleView";
        LOGGER.info("Search for view with key: {}", (Object)searchKey);
        DockingDesktop desktop = (DockingDesktop)DefaultApplicationContext.getInstance().get("desktop", DockingDesktop.class);
        if (desktop == null) {
            LOGGER.info("The desktop is not available.");
            return;
        }
        Dockable consoleView = desktop.getContext().getDockableByKey(searchKey);
        if (consoleView != null) {
            LOGGER.info("Select the existing console view.");
            DockUtils.selectWindow((Dockable)consoleView);
            return;
        }
        LOGGER.info("Create new controller to open the console.");
        ApplicationContext applicationContext = (ApplicationContext)DefaultApplicationContext.getInstance().get("SpringContext", ApplicationContext.class);
        ConsoleController consoleController = (ConsoleController)applicationContext.getBean(ConsoleController.class);
        consoleController.start();
    }

    public void ensureConsoleIsVisible() {
        LOGGER.info("Ensure that the console is visible. Current consoleView: {}", (Object)this.consoleView);
        if (this.consoleView != null) {
            LOGGER.info("Select the existing console view.");
            DockUtils.selectWindow((Dockable)this.consoleView);
            return;
        }
        LOGGER.info("Start the controller to open the console.");
        this.start();
    }

    public void addConsoleLine(ConsoleColor consoleColor, String line) {
        this.consoleService.addConsoleLine(consoleColor, line);
    }

    @EventSubscriber(eventClass=MessageTimeoutEvent.class)
    public void messageTimeoutEvent(MessageTimeoutEvent messageTimeoutEvent) {
        LOGGER.info("Received a messageTimeoutEvent: {}", (Object)messageTimeoutEvent);
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.addConsoleMessage(messageTimeoutEvent));
        } else {
            this.addConsoleMessage(messageTimeoutEvent);
        }
    }

    private void addConsoleMessage(MessageTimeoutEvent messageTimeoutEvent) {
        ConsoleController.ensureConsoleVisible();
        try {
            this.getConsoleService().addConsoleLine(ConsoleColor.red, String.format("Message timeout from node: %s, %s", messageTimeoutEvent.getNode().toString(), messageTimeoutEvent.getMessage()));
        }
        catch (Exception ex) {
            LOGGER.warn("Add messageTimeoutEvent to console model failed: {}", (Object)messageTimeoutEvent, (Object)ex);
        }
    }

    @EventListener
    public void errorEvent(ErrorEvent errorEvent) {
        LOGGER.info("Received a errorEvent: {}", (Object)errorEvent);
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.addConsoleMessage(errorEvent));
        } else {
            this.addConsoleMessage(errorEvent);
        }
    }

    private void addConsoleMessage(ErrorEvent errorEvent) {
        ConsoleController.ensureConsoleVisible();
        try {
            this.getConsoleService().addConsoleLine(ConsoleColor.red, String.format("Error event from connectionId: %s, message: %s", errorEvent.getConnectionId(), errorEvent.getMessage()));
        }
        catch (Exception ex) {
            LOGGER.warn("Add errorEvent to console model failed: {}", (Object)errorEvent, (Object)ex);
        }
    }

    @EventListener
    public void handleApplicationEvent(AccessoryErrorEvent accessoryErrorEvent) {
        LOGGER.info("Received a accessoryErrorEvent: {}", (Object)accessoryErrorEvent);
        SwingUtilities.invokeLater(() -> {
            ConsoleController.ensureConsoleVisible();
            this.getConsoleService().addConsoleLine(ConsoleColor.red, accessoryErrorEvent.getErrorMessage());
        });
    }

    @EventListener
    public void handleConsoleMessageEvent(ConsoleMessageEvent consoleMessageEvent) {
        LOGGER.info("Received a consoleMessageEvent: {}", (Object)consoleMessageEvent);
        SwingUtilities.invokeLater(() -> {
            if (consoleMessageEvent.isEnsureConsoleVisible()) {
                ConsoleController.ensureConsoleVisible();
            }
            this.getConsoleService().addConsoleLine(consoleMessageEvent.getConsoleColor(), consoleMessageEvent.getConsoleMessage());
        });
    }
}

