/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.dmx.view.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.function.MacroFunction;
import org.bidib.wizard.api.utils.PortUtils;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.DmxChannel;
import org.bidib.wizard.model.ports.DmxLightPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.LightPortStatus;
import org.bidib.wizard.model.status.MacroStatus;
import org.bidib.wizard.mvc.dmx.model.DmxModel;
import org.bidib.wizard.mvc.dmx.model.DmxScenery;
import org.bidib.wizard.mvc.dmx.model.DmxSceneryPoint;
import org.bidib.wizard.mvc.dmx.view.panel.DmxChannelAction;
import org.bidib.wizard.mvc.dmx.view.panel.DmxDataItem;
import org.bidib.wizard.mvc.dmx.view.panel.DmxSeries;
import org.bidib.wizard.mvc.dmx.view.panel.LightPortAction;
import org.bidib.wizard.mvc.dmx.view.panel.MacroAction;
import org.bidib.wizard.mvc.dmx.view.panel.MacroStatusAction;
import org.bidib.wizard.mvc.dmx.view.panel.PointRemoveAction;
import org.bidib.wizard.mvc.dmx.view.panel.PortAction;
import org.bidib.wizard.mvc.dmx.view.panel.renderer.DmxLineRenderer;
import org.bidib.wizard.mvc.dmx.view.panel.renderer.SceneryPointArrowAnnotation;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.UnknownKeyException;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmxChartPanel
extends ChartPanel {
    static final Logger LOGGER = LoggerFactory.getLogger(DmxChartPanel.class);
    private static final long serialVersionUID = 1L;
    private ChartEntity entityToDragLine;
    private DmxDataItem orgDmxDataItemToDragLine;
    private JMenu subMenuAddPoint;
    private JMenu subMenuAddMacro;
    private JMenu subMenuSetPort;
    private JMenu subMenuSetAction;
    private JPopupMenu.Separator setPortSeparator;
    private final Point currentMousePoint = new Point();
    private final DmxModel dmxModel;
    private JMenuItem removePointMenuItem;
    private PropertyChangeListener lightPortListener;
    private PropertyChangeListener backlightPortListener;

    public DmxChartPanel(JFreeChart chart, DmxModel dmxModel) {
        super(chart);
        this.dmxModel = dmxModel;
        this.setPopupMenu(this.createPopupMenu(false, false, false, true));
        this.lightPortListener = new /* Unavailable Anonymous Inner Class!! */;
        List lightPorts = this.dmxModel.getDmxSceneryModel().getLightPorts();
        if (CollectionUtils.isNotEmpty((Collection)lightPorts)) {
            for (DmxLightPort lightPort : lightPorts) {
                lightPort.addPropertyChangeListener(this.lightPortListener);
            }
        }
        this.backlightPortListener = new /* Unavailable Anonymous Inner Class!! */;
        List backlightPorts = this.dmxModel.getDmxSceneryModel().getBacklightPorts();
        if (CollectionUtils.isNotEmpty((Collection)backlightPorts)) {
            for (BacklightPort backlightPort : backlightPorts) {
                backlightPort.addPropertyChangeListener(this.backlightPortListener);
            }
        }
    }

    public void cleanup() {
        LOGGER.info("Cleanup the listeners.");
        if (this.lightPortListener != null) {
            List lightPorts = this.dmxModel.getDmxSceneryModel().getLightPorts();
            if (CollectionUtils.isNotEmpty((Collection)lightPorts)) {
                for (DmxLightPort lightPort : lightPorts) {
                    lightPort.removePropertyChangeListener(this.lightPortListener);
                }
            }
            this.lightPortListener = null;
        }
        if (this.backlightPortListener != null) {
            List backlightPorts = this.dmxModel.getDmxSceneryModel().getBacklightPorts();
            if (CollectionUtils.isNotEmpty((Collection)backlightPorts)) {
                for (BacklightPort backlightPort : backlightPorts) {
                    backlightPort.removePropertyChangeListener(this.backlightPortListener);
                }
            }
            this.backlightPortListener = null;
        }
    }

    protected Point getCurrentMousePoint() {
        return this.currentMousePoint;
    }

    private XYSeriesCollection getDataSet() {
        return (XYSeriesCollection)this.getChart().getXYPlot().getDataset();
    }

    private DmxSeries getDmxSeries(Comparable<String> seriesKey) {
        return (DmxSeries)this.getDataSet().getSeries(seriesKey);
    }

    protected void displayPopupMenu(int x, int y) {
        LOGGER.info("Display popupMenu, x: {}, y: {}", (Object)x, (Object)y);
        Rectangle2D plotArea = this.getScreenDataArea();
        XYPlot plot = (XYPlot)this.getChart().getPlot();
        double chartX = plot.getDomainAxis().java2DToValue((double)x, plotArea, RectangleEdge.BOTTOM);
        double chartY = plot.getRangeAxis().java2DToValue((double)y, plotArea, RectangleEdge.LEFT);
        LOGGER.info("Current chartX: {}, chartY: {}", (Object)chartX, (Object)chartY);
        this.currentMousePoint.setLocation(chartX, chartY);
        this.updatePopupMenu();
        super.displayPopupMenu(x, y);
    }

    protected JPopupMenu createPopupMenu(boolean properties, boolean copy, boolean save, boolean print, boolean zoom) {
        JPopupMenu defaultMenu = super.createPopupMenu(properties, copy, save, print, zoom);
        defaultMenu.setLabel(localizationResources.getString("Chart") + ":");
        return defaultMenu;
    }

    private void updatePopupMenu() {
        if (this.dmxModel != null && this.dmxModel.getDmxScenery() != null) {
            JPopupMenu defaultMenu;
            DmxScenery dmxScenery = this.dmxModel.getDmxScenery();
            if (!CollectionUtils.isNotEmpty((Collection)dmxScenery.getUsedChannels())) {
                return;
            }
            DmxChannel selectedDmxChannel = null;
            PointRemoveAction pointRemoveAction = null;
            if (this.getChart() != null) {
                int selectedDmxChannelId = -1;
                DmxLineRenderer dmxLineRenderer = (DmxLineRenderer)((XYPlot)this.getChart().getPlot()).getRenderer();
                boolean isHighlighted = dmxLineRenderer.isHighlighted();
                LOGGER.info("isHighlighted: {}, row: {}, column: {}", new Object[]{isHighlighted, dmxLineRenderer.getRow(), dmxLineRenderer.getColumn()});
                if (isHighlighted) {
                    if (this.subMenuSetPort == null) {
                        JPopupMenu defaultMenu2 = this.getPopupMenu();
                        this.subMenuSetPort = new JMenu(Resources.getString(DmxChartPanel.class, (String)"set-port"));
                        defaultMenu2.insert(this.subMenuSetPort, 0);
                        this.subMenuAddMacro = new JMenu(Resources.getString(DmxChartPanel.class, (String)"add-macro"));
                        defaultMenu2.insert(this.subMenuAddMacro, 1);
                        this.subMenuSetAction = new JMenu(Resources.getString(DmxChartPanel.class, (String)"set-action"));
                        defaultMenu2.insert(this.subMenuSetAction, 2);
                        this.setPortSeparator = new JPopupMenu.Separator();
                        defaultMenu2.insert(this.setPortSeparator, 3);
                    }
                    this.subMenuSetPort.setVisible(isHighlighted);
                    this.subMenuSetPort.removeAll();
                    this.subMenuAddMacro.setVisible(isHighlighted);
                    this.subMenuSetAction.setVisible(false);
                    this.setPortSeparator.setVisible(isHighlighted);
                    if (this.getChart().getPlot() instanceof XYPlot) {
                        try {
                            DmxDataItem item = (DmxDataItem)this.getDataSet().getSeries(dmxLineRenderer.getRow()).getDataItem(dmxLineRenderer.getColumn());
                            LOGGER.info("Fetched selected item: {}", (Object)item);
                            if (item != null) {
                                String seriesKey = (String)((Object)this.getDataSet().getSeriesKey(dmxLineRenderer.getRow()));
                                LOGGER.info("Currently no port assigned, seriesKey: {}, row: {}", (Object)seriesKey, (Object)dmxLineRenderer.getRow());
                                selectedDmxChannelId = Integer.parseInt(seriesKey);
                                for (DmxChannel dmxChannel : dmxScenery.getUsedChannels()) {
                                    LOGGER.debug("Current channel: {}", (Object)dmxChannel);
                                    if (selectedDmxChannelId != dmxChannel.getChannelId()) continue;
                                    pointRemoveAction = new PointRemoveAction(Resources.getString(DmxChartPanel.class, (String)"remove-point"), item, dmxChannel, this);
                                    if (CollectionUtils.isNotEmpty((Collection)dmxChannel.getAssignedPorts())) {
                                        for (Port port : dmxChannel.getAssignedPorts()) {
                                            this.subMenuSetPort.add((Action)new PortAction(port, dmxChannel, this, item));
                                        }
                                        this.subMenuSetPort.setEnabled(true);
                                    } else {
                                        this.subMenuSetPort.setEnabled(false);
                                    }
                                    selectedDmxChannel = dmxChannel;
                                    break;
                                }
                                if (this.subMenuAddMacro != null) {
                                    this.subMenuAddMacro.removeAll();
                                    for (Macro macro : this.dmxModel.getDmxSceneryModel().getMacros()) {
                                        if (macro == null) continue;
                                        this.subMenuAddMacro.add((Action)new MacroAction(macro, selectedDmxChannel, this, item));
                                    }
                                }
                                if (this.subMenuSetAction != null) {
                                    this.subMenuSetAction.removeAll();
                                    if (item.getPort() instanceof DmxLightPort) {
                                        this.subMenuSetAction.add((Action)new LightPortAction(LightPortStatus.UP, selectedDmxChannel, this, item));
                                        this.subMenuSetAction.add((Action)new LightPortAction(LightPortStatus.DOWN, selectedDmxChannel, this, item));
                                        this.subMenuSetAction.add((Action)new LightPortAction(LightPortStatus.ON, selectedDmxChannel, this, item));
                                        this.subMenuSetAction.add((Action)new LightPortAction(LightPortStatus.OFF, selectedDmxChannel, this, item));
                                        this.subMenuSetAction.setVisible(true);
                                    } else if (item.getMacro() != null) {
                                        this.subMenuSetAction.add((Action)new MacroStatusAction(MacroStatus.START, selectedDmxChannel, this, item));
                                        this.subMenuSetAction.add((Action)new MacroStatusAction(MacroStatus.STOP, selectedDmxChannel, this, item));
                                        this.subMenuSetAction.setVisible(true);
                                    }
                                }
                            }
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Get dataItem failed.", (Throwable)ex);
                        }
                    }
                } else {
                    if (this.subMenuSetPort != null) {
                        this.subMenuSetPort.setVisible(isHighlighted);
                        this.subMenuSetPort.removeAll();
                    }
                    if (this.subMenuAddMacro != null) {
                        this.subMenuAddMacro.setVisible(isHighlighted);
                        this.subMenuAddMacro.removeAll();
                    }
                    if (this.subMenuSetAction != null) {
                        this.subMenuSetAction.setVisible(isHighlighted);
                        this.subMenuSetAction.removeAll();
                    }
                    if (this.setPortSeparator != null) {
                        this.setPortSeparator.setVisible(isHighlighted);
                    }
                }
            }
            if (this.subMenuAddPoint == null) {
                JPopupMenu defaultMenu3 = this.getPopupMenu();
                this.subMenuAddPoint = new JMenu(Resources.getString(DmxChartPanel.class, (String)"add-point"));
                defaultMenu3.insert(this.subMenuAddPoint, 0);
                defaultMenu3.insert(new JPopupMenu.Separator(), 1);
            }
            if (pointRemoveAction != null) {
                LOGGER.info("Add point remove action.");
                defaultMenu = this.getPopupMenu();
                if (this.removePointMenuItem != null) {
                    defaultMenu.remove(this.removePointMenuItem);
                    this.removePointMenuItem = null;
                }
                this.removePointMenuItem = new JMenuItem((Action)pointRemoveAction);
                this.removePointMenuItem.setText(pointRemoveAction.getText());
                int insertIndexAfter = defaultMenu.getComponentIndex(this.subMenuAddMacro);
                if (insertIndexAfter > -1) {
                    LOGGER.info("Insert remvocePointMenuItem after index: {}", (Object)insertIndexAfter);
                } else {
                    insertIndexAfter = 0;
                }
                defaultMenu.insert(this.removePointMenuItem, insertIndexAfter + 1);
            } else {
                defaultMenu = this.getPopupMenu();
                if (this.removePointMenuItem != null) {
                    defaultMenu.remove(this.removePointMenuItem);
                    this.removePointMenuItem = null;
                }
            }
            if (this.subMenuAddPoint != null) {
                this.subMenuAddPoint.removeAll();
                for (DmxChannel dmxChannel : dmxScenery.getUsedChannels()) {
                    this.subMenuAddPoint.add((Action)new DmxChannelAction(dmxChannel, this));
                }
            }
        }
    }

    private boolean updateLocation(DmxSeries dmxSeries, int chartX, int chartY, DmxDataItem item) {
        int index = dmxSeries.indexOf((Number)chartX, item.getUniqueId());
        if (index > -1) {
            DmxDataItem storedDataItem = (DmxDataItem)dmxSeries.getDataItem(index);
            LOGGER.info("Current storedDataItem: {}, dragged item: {}", (Object)storedDataItem, (Object)item);
            if (storedDataItem.equals((Object)item)) {
                LOGGER.debug("We found the dragged item. Let's update the position.");
            } else {
                LOGGER.warn("A point is already stored at this position -> skip update to this position");
                return false;
            }
        }
        long oldUniqueId = item.getUniqueId();
        dmxSeries.moveItem(item, chartX, chartY);
        String seriesKey = (String)((Object)dmxSeries.getKey());
        int dmxChannelNumber = Integer.valueOf(seriesKey);
        DmxSceneryPoint dmxSceneryPoint = (DmxSceneryPoint)IterableUtils.find((Iterable)this.dmxModel.getDmxScenery().getSceneryPoints(), (Predicate)new /* Unavailable Anonymous Inner Class!! */);
        if (dmxSceneryPoint != null) {
            LOGGER.info("Update existing scenery point: {}", (Object)dmxSceneryPoint);
            dmxSceneryPoint.setTimeOffset(chartX);
            dmxSceneryPoint.setBrightness(chartY);
        }
        return true;
    }

    public void setLightPortAction(String seriesKey, DmxDataItem dmxDataItem, LightPortStatus action) {
        try {
            DmxSeries dmxSeries = this.getDmxSeries((Comparable)((Object)seriesKey));
            int index = dmxSeries.indexOf((Number)dmxDataItem.getTimeOffset(), dmxDataItem.getUniqueId());
            if (index > -1) {
                DmxDataItem prevDmxDataItem = (DmxDataItem)dmxSeries.remove(index);
                Port port = prevDmxDataItem.getPort();
                if (port instanceof DmxLightPort) {
                    LOGGER.info("Set the new action: {} on the lightport: {}", (Object)action, (Object)port);
                    prevDmxDataItem.setAction((BidibStatus)action);
                } else {
                    LOGGER.warn("The current port is not a lightport.");
                }
                dmxSeries.add((XYDataItem)prevDmxDataItem);
                int dmxChannelNumber = Integer.valueOf(seriesKey);
                DmxSceneryPoint dmxSceneryPoint = (DmxSceneryPoint)IterableUtils.find((Iterable)this.dmxModel.getDmxScenery().getSceneryPoints(), (Predicate)new /* Unavailable Anonymous Inner Class!! */);
                if (dmxSceneryPoint != null) {
                    LOGGER.info("Update existing scenery point: {}", (Object)dmxSceneryPoint);
                    dmxSceneryPoint.setAction((BidibStatus)action);
                }
            }
            this.refreshSceneryPointAnnotations(this.getChart().getXYPlot(), dmxSeries);
        }
        catch (Exception ex) {
            LOGGER.warn("Set action on lightport failed.", (Throwable)ex);
        }
    }

    public void setMacroStatusAction(String seriesKey, DmxDataItem dmxDataItem, MacroStatus action) {
        try {
            DmxSeries dmxSeries = this.getDmxSeries((Comparable)((Object)seriesKey));
            int index = dmxSeries.indexOf((Number)dmxDataItem.getTimeOffset(), dmxDataItem.getUniqueId());
            if (index > -1) {
                DmxDataItem prevDmxDataItem = (DmxDataItem)dmxSeries.remove(index);
                MacroFunction macro = prevDmxDataItem.getMacro();
                if (macro != null) {
                    macro.setAction((BidibStatus)action);
                } else {
                    LOGGER.warn("The current port is not a lightport.");
                }
                dmxSeries.add((XYDataItem)prevDmxDataItem);
                int dmxChannelNumber = Integer.valueOf(seriesKey);
                DmxSceneryPoint dmxSceneryPoint = (DmxSceneryPoint)IterableUtils.find((Iterable)this.dmxModel.getDmxScenery().getSceneryPoints(), (Predicate)new /* Unavailable Anonymous Inner Class!! */);
                if (dmxSceneryPoint != null) {
                    LOGGER.info("Update existing scenery point: {}", (Object)dmxSceneryPoint);
                    dmxSceneryPoint.setMacro(macro);
                }
            }
            this.refreshSceneryPointAnnotations(this.getChart().getXYPlot(), dmxSeries);
        }
        catch (Exception ex) {
            LOGGER.warn("Set action on lightport failed.", (Throwable)ex);
        }
    }

    public void removeDataItem(String seriesKey, DmxDataItem dmxDataItem) {
        try {
            DmxSeries dmxSeries = this.getDmxSeries((Comparable)((Object)seriesKey));
            int index = dmxSeries.indexOf((Number)dmxDataItem.getTimeOffset(), dmxDataItem.getUniqueId());
            if (index > -1) {
                DmxDataItem prevDmxDataItem = (DmxDataItem)dmxSeries.getDataItem(index);
                dmxSeries.remove(index);
                List sceneryPoints = this.dmxModel.getDmxScenery().getSceneryPoints();
                int dmxChannelNumber = Integer.valueOf(seriesKey);
                DmxSceneryPoint dmxSceneryPoint = (DmxSceneryPoint)IterableUtils.find((Iterable)sceneryPoints, (Predicate)new /* Unavailable Anonymous Inner Class!! */);
                LOGGER.info("Remove existing scenery point: {}", (Object)dmxSceneryPoint);
                long uniqueId = dmxSceneryPoint.getUniqueId();
                DmxSceneryPoint existingSceneryPoint = (DmxSceneryPoint)IterableUtils.find((Iterable)sceneryPoints, (Predicate)new /* Unavailable Anonymous Inner Class!! */);
                if (existingSceneryPoint != null) {
                    boolean removed = this.dmxModel.getDmxScenery().removeSceneryPoint(existingSceneryPoint);
                    if (!removed) {
                        LOGGER.warn("The dmxSceneryPoint was not removed: {}", (Object)dmxSceneryPoint);
                    }
                } else {
                    LOGGER.warn("No scenery point to remove available.");
                }
            } else {
                LOGGER.warn("No matching point to remove found.");
            }
            this.refreshSceneryPointAnnotations(this.getChart().getXYPlot(), dmxSeries);
        }
        catch (Exception ex) {
            LOGGER.warn("Remove data item failed.", (Throwable)ex);
        }
    }

    public void createDataItem(String seriesKey, int timeOffset, int brightness, Port<?> port, DmxChannel dmxChannel, DmxDataItem originalDataItem) {
        try {
            DmxSeries dmxSeries = this.getDmxSeries((Comparable)((Object)seriesKey));
            DmxSceneryPoint prevSceneryPoint = null;
            int index = -1;
            index = originalDataItem != null ? dmxSeries.indexOf((Number)timeOffset, originalDataItem.getUniqueId()) : dmxSeries.indexOf((Number)timeOffset);
            if (index > -1) {
                DmxDataItem prevDmxDataItem = (DmxDataItem)dmxSeries.getDataItem(index);
                prevSceneryPoint = new DmxSceneryPoint().withBrightness(brightness).withTimeOffset(timeOffset).withUniqueId(prevDmxDataItem.getUniqueId()).withMacro(prevDmxDataItem.getMacro()).withDmxChannelNumber(dmxChannel.getChannelId());
                if (prevDmxDataItem.getPort() != null) {
                    prevSceneryPoint.withPort(prevDmxDataItem.getPort());
                }
                if (prevDmxDataItem.getAction() != null) {
                    prevSceneryPoint.withAction(prevDmxDataItem.getAction());
                }
                prevDmxDataItem.setMacro(null);
                if (prevDmxDataItem.getPort() != null && !prevDmxDataItem.getPort().equals(port)) {
                    prevDmxDataItem.setAction(null);
                }
                prevDmxDataItem.setPort(port);
                dmxSeries.moveItem(prevDmxDataItem, timeOffset, brightness);
            } else {
                originalDataItem = dmxSeries.add(timeOffset, brightness, port);
            }
            DmxSceneryPoint dmxSceneryPoint = new DmxSceneryPoint().withBrightness(brightness).withTimeOffset(timeOffset).withPort(port).withDmxChannelNumber(dmxChannel.getChannelId());
            if (originalDataItem != null) {
                if (originalDataItem.getPort() != null && !originalDataItem.getPort().equals(port)) {
                    originalDataItem.setAction(null);
                }
                dmxSceneryPoint = dmxSceneryPoint.withAction(originalDataItem.getAction()).withUniqueId(originalDataItem.getUniqueId());
            }
            if (prevSceneryPoint != null) {
                LOGGER.info("Remove existing scenery point: {}", (Object)prevSceneryPoint);
                long uniqueId = prevSceneryPoint.getUniqueId();
                DmxSceneryPoint existingSceneryPoint = (DmxSceneryPoint)IterableUtils.find((Iterable)this.dmxModel.getDmxScenery().getSceneryPoints(), (Predicate)new /* Unavailable Anonymous Inner Class!! */);
                if (existingSceneryPoint != null) {
                    boolean removed = this.dmxModel.getDmxScenery().removeSceneryPoint(existingSceneryPoint);
                    if (!removed) {
                        LOGGER.warn("The prevSceneryPoint was not removed: {}", (Object)prevSceneryPoint);
                    }
                } else {
                    LOGGER.warn("No scenery point to remove available.");
                }
            }
            this.dmxModel.getDmxScenery().addSceneryPoint(dmxSceneryPoint);
            this.refreshSceneryPointAnnotations(this.getChart().getXYPlot(), dmxSeries);
        }
        catch (UnknownKeyException ex) {
            LOGGER.debug("Add new point failed because no series in dataset for key: {}", (Object)seriesKey);
            try {
                DmxSeries dmxSeries = new DmxSeries((Comparable)((Object)seriesKey), true);
                originalDataItem = dmxSeries.add(timeOffset, brightness, port);
                this.getDataSet().addSeries((XYSeries)dmxSeries);
                DmxSceneryPoint dmxSceneryPoint = new DmxSceneryPoint().withBrightness(brightness).withTimeOffset(timeOffset).withPort(port).withDmxChannelNumber(dmxChannel.getChannelId());
                if (originalDataItem != null) {
                    dmxSceneryPoint = dmxSceneryPoint.withAction(originalDataItem.getAction()).withUniqueId(originalDataItem.getUniqueId());
                    if (originalDataItem.getMacro() != null) {
                        LOGGER.info("Restore the macro function: {}", (Object)originalDataItem.getMacro());
                        dmxSceneryPoint = dmxSceneryPoint.withMacro(originalDataItem.getMacro());
                    }
                }
                this.dmxModel.getDmxScenery().addSceneryPoint(dmxSceneryPoint);
                XYItemRenderer renderer = this.getChart().getXYPlot().getRenderer();
                if (renderer != null && dmxChannel.getLineColor() != null) {
                    renderer.setSeriesPaint(this.getDataSet().indexOf((XYSeries)dmxSeries), (Paint)dmxChannel.getLineColor());
                }
                this.refreshSceneryPointAnnotations(this.getChart().getXYPlot(), dmxSeries);
            }
            catch (IllegalArgumentException ex1) {
                LOGGER.warn("Add new point failed.", (Throwable)ex1);
                JOptionPane.showMessageDialog((Component)this, Resources.getString(DmxChartPanel.class, (String)"add-point-failed"), Resources.getString(DmxChartPanel.class, (String)"add-point"), 0);
            }
        }
    }

    public void createDataItem(String seriesKey, int timeOffset, int brightness, MacroFunction macro, DmxChannel dmxChannel, DmxDataItem originalDataItem) {
        try {
            DmxSeries dmxSeries = this.getDmxSeries((Comparable)((Object)seriesKey));
            DmxSceneryPoint prevSceneryPoint = null;
            int index = -1;
            index = originalDataItem != null ? dmxSeries.indexOf((Number)timeOffset, originalDataItem.getUniqueId()) : dmxSeries.indexOf((Number)timeOffset);
            if (index > -1) {
                DmxDataItem prevDmxDataItem = (DmxDataItem)dmxSeries.getDataItem(index);
                prevSceneryPoint = new DmxSceneryPoint().withBrightness(brightness).withTimeOffset(timeOffset).withUniqueId(prevDmxDataItem.getUniqueId()).withPort(prevDmxDataItem.getPort()).withAction(prevDmxDataItem.getAction()).withDmxChannelNumber(dmxChannel.getChannelId());
                if (prevDmxDataItem.getMacro() != null) {
                    prevSceneryPoint.withMacro(prevDmxDataItem.getMacro());
                }
                prevDmxDataItem.setPort(null);
                prevDmxDataItem.setAction(null);
                prevDmxDataItem.setMacro(macro);
                dmxSeries.moveItem(prevDmxDataItem, timeOffset, brightness);
            } else {
                dmxSeries.add(timeOffset, brightness, macro);
            }
            DmxSceneryPoint dmxSceneryPoint = new DmxSceneryPoint().withBrightness(brightness).withTimeOffset(timeOffset).withMacro(macro).withDmxChannelNumber(dmxChannel.getChannelId());
            if (prevSceneryPoint != null) {
                LOGGER.info("Remove existing scenery point: {}", prevSceneryPoint);
                long uniqueId = prevSceneryPoint.getUniqueId();
                DmxSceneryPoint existingSceneryPoint = (DmxSceneryPoint)IterableUtils.find((Iterable)this.dmxModel.getDmxScenery().getSceneryPoints(), (Predicate)new /* Unavailable Anonymous Inner Class!! */);
                if (existingSceneryPoint != null) {
                    boolean removed = this.dmxModel.getDmxScenery().removeSceneryPoint(existingSceneryPoint);
                    if (!removed) {
                        LOGGER.warn("The prevSceneryPoint was not removed: {}", (Object)prevSceneryPoint);
                    }
                } else {
                    LOGGER.warn("No scenery point to remove available.");
                }
            }
            this.dmxModel.getDmxScenery().addSceneryPoint(dmxSceneryPoint);
            this.refreshSceneryPointAnnotations(this.getChart().getXYPlot(), dmxSeries);
        }
        catch (UnknownKeyException ex) {
            LOGGER.debug("Add new point failed because no series in dataset for key: {}", (Object)seriesKey);
            try {
                DmxSeries dmxSeries = new DmxSeries((Comparable)((Object)seriesKey), true);
                dmxSeries.add(timeOffset, brightness, macro);
                this.getDataSet().addSeries((XYSeries)dmxSeries);
                XYItemRenderer renderer = this.getChart().getXYPlot().getRenderer();
                if (renderer != null && dmxChannel.getLineColor() != null) {
                    renderer.setSeriesPaint(this.getDataSet().indexOf((XYSeries)dmxSeries), (Paint)dmxChannel.getLineColor());
                }
                this.refreshSceneryPointAnnotations(this.getChart().getXYPlot(), dmxSeries);
            }
            catch (IllegalArgumentException ex1) {
                LOGGER.warn("Add new point failed.", (Throwable)ex1);
                JOptionPane.showMessageDialog((Component)this, Resources.getString(DmxChartPanel.class, (String)"add-point-failed"), Resources.getString(DmxChartPanel.class, (String)"add-point"), 0);
            }
        }
    }

    public void mousePressed(MouseEvent event) {
        if (event.getButton() == 1 && !event.isControlDown() && this.getChart() != null) {
            EntityCollection entities;
            Insets insets = this.getInsets();
            int x = (int)((double)(event.getX() - insets.left) / this.getScaleX());
            int y = (int)((double)(event.getY() - insets.top) / this.getScaleY());
            ChartEntity entity = null;
            if (this.getChartRenderingInfo() != null && (entities = this.getChartRenderingInfo().getEntityCollection()) != null) {
                entity = entities.getEntity((double)x, (double)y);
            }
            if (entity instanceof XYItemEntity) {
                LOGGER.trace("Set the entity to drag line: {}", entity);
                this.entityToDragLine = entity;
                try {
                    XYItemEntity xyie = (XYItemEntity)this.entityToDragLine;
                    DmxDataItem item = (DmxDataItem)((XYSeriesCollection)this.getChart().getXYPlot().getDataset()).getSeries(xyie.getSeriesIndex()).getDataItem(xyie.getItem());
                    this.orgDmxDataItemToDragLine = (DmxDataItem)item.clone();
                }
                catch (Exception ex) {
                    LOGGER.warn("Clone dragged DmxDataItem failed.", (Throwable)ex);
                }
            } else {
                super.mousePressed(event);
            }
        } else {
            super.mousePressed(event);
        }
    }

    public void mouseDragged(MouseEvent event) {
        if (this.entityToDragLine != null) {
            Insets insets = this.getInsets();
            int x = event.getX() - insets.left;
            int y = event.getY() - insets.top;
            if (this.getChart() == null) {
                return;
            }
            LOGGER.trace("Move the entity to drag: {}", (Object)this.entityToDragLine);
            if (this.entityToDragLine instanceof XYItemEntity) {
                LOGGER.info("released, entityToDrag: {}", (Object)this.entityToDragLine);
                XYItemEntity xyie = (XYItemEntity)this.entityToDragLine;
                int seriesIndex = xyie.getSeriesIndex();
                XYDataset dataset = xyie.getDataset();
                XYPlot plot = this.getChart().getXYPlot();
                ValueAxis rangeAxis = plot.getRangeAxis();
                ValueAxis domainAxis = plot.getDomainAxis();
                Rectangle2D plotRectangle = this.getScreenDataArea();
                int chartY = (int)rangeAxis.java2DToValue((double)y, plotRectangle, plot.getRangeAxisEdge());
                int chartX = (int)domainAxis.java2DToValue((double)x, plotRectangle, plot.getDomainAxisEdge());
                String seriesKey = (String)((Object)dataset.getSeriesKey(seriesIndex));
                LOGGER.trace("seriesKey: {}, seriesIndex: {}, y: {}, x: {}", new Object[]{seriesKey, seriesIndex, chartY, chartX});
                if (chartX < 0) {
                    LOGGER.warn("No X values < 0 allowed.");
                    chartX = 0;
                }
                if (chartY < 0) {
                    LOGGER.warn("No Y values < 0 allowed.");
                    chartY = 0;
                }
                DmxSeries dmxSeries = (DmxSeries)((XYSeriesCollection)plot.getDataset()).getSeries((Comparable)((Object)seriesKey));
                DmxDataItem item = this.orgDmxDataItemToDragLine;
                if (event.isShiftDown()) {
                    LOGGER.trace("SHIFT is pressed.");
                    dmxSeries.addOrUpdate(item.getX(), (Number)chartY, item);
                } else {
                    this.updateLocation(dmxSeries, chartX, chartY, item);
                }
            }
            LOGGER.trace("+++ dragged, x: {}, y: {}, entity: {}.", new Object[]{x, y, this.entityToDragLine});
        } else {
            super.mouseDragged(event);
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (this.entityToDragLine != null && event.getButton() == 1 && !event.isControlDown()) {
            if (this.getChart() == null) {
                return;
            }
            Insets insets = this.getInsets();
            int x = event.getX() - insets.left;
            int y = event.getY() - insets.top;
            XYPlot plot = this.getChart().getXYPlot();
            DmxSeries dmxSeries = null;
            LOGGER.trace("Move the entity to drag: {}", (Object)this.entityToDragLine);
            if (this.entityToDragLine instanceof XYItemEntity) {
                LOGGER.trace("released, entityToDragLine: {}", (Object)this.entityToDragLine);
                XYItemEntity xyie = (XYItemEntity)this.entityToDragLine;
                int seriesIndex = xyie.getSeriesIndex();
                XYDataset dataset = xyie.getDataset();
                String seriesKey = (String)((Object)dataset.getSeriesKey(seriesIndex));
                dmxSeries = this.getDmxSeries((Comparable)((Object)seriesKey));
            }
            LOGGER.info("Reset the entity to drag line.");
            this.entityToDragLine = null;
            this.orgDmxDataItemToDragLine = null;
            if (dmxSeries != null) {
                this.refreshSceneryPointAnnotations(plot, dmxSeries);
            }
        } else {
            super.mouseReleased(event);
        }
    }

    private void refreshSceneryPointAnnotations(XYPlot plot, DmxSeries dmxSeries) {
        LOGGER.info("refreshSceneryPointAnnotations");
        XYItemRenderer renderer = plot.getRenderer();
        if (renderer instanceof AbstractXYItemRenderer) {
            AbstractXYItemRenderer abstractXYItemRenderer = (AbstractXYItemRenderer)renderer;
            for (Object annotation : abstractXYItemRenderer.getAnnotations()) {
                if (!(annotation instanceof SceneryPointArrowAnnotation)) continue;
                SceneryPointArrowAnnotation sceneryPointArrowAnnotation = (SceneryPointArrowAnnotation)annotation;
                if (!dmxSeries.getKey().equals(sceneryPointArrowAnnotation.getSeriesKey())) continue;
                abstractXYItemRenderer.removeAnnotation((XYAnnotation)sceneryPointArrowAnnotation);
            }
        }
        String seriesKey = (String)((Object)dmxSeries.getKey());
        for (Object item : dmxSeries.getItems()) {
            DmxDataItem dmxDataItem = (DmxDataItem)item;
            Integer dimmSlopeUp = null;
            Integer dimmSlopeDown = null;
            Port currentPort = dmxDataItem.getPort();
            if (currentPort instanceof BacklightPort) {
                BacklightPort backlightPort = (BacklightPort)currentPort;
                dimmSlopeUp = backlightPort.getDimSlopeUp();
                dimmSlopeDown = backlightPort.getDimSlopeDown();
            } else if (currentPort instanceof DmxLightPort) {
                DmxLightPort dmxLightPort = (DmxLightPort)currentPort;
                dimmSlopeUp = dmxLightPort.getLightPort().getDimMax();
                dimmSlopeDown = dmxLightPort.getLightPort().getDimMin();
            }
            LOGGER.info("Current dimmSlopeUp: {}, dimmSlopeDown: {}", (Object)dimmSlopeUp, dimmSlopeDown);
            if (dimmSlopeUp == null || dimmSlopeDown == null) continue;
            try {
                int volumeDeltaUp = 100 - dmxDataItem.getBrightness();
                int durationUp = PortUtils.calculateDimmDuration((double)(volumeDeltaUp * 255 / 100), (int)dimmSlopeUp);
                int volumeDeltaDown = dmxDataItem.getBrightness();
                int durationDown = PortUtils.calculateDimmDuration((double)(volumeDeltaDown * 255 / 100), (int)dimmSlopeDown);
                LOGGER.info("Current port: {}, volumeDeltaUp: {}, durationUp: {}, volumeDeltaDown: {}, durationDown: {}", new Object[]{currentPort, volumeDeltaUp, durationUp, volumeDeltaDown, durationDown});
                this.addSceneryPointAnnotation(renderer, (Comparable)((Object)seriesKey), dmxDataItem.getTimeOffset(), dmxDataItem.getBrightness(), durationUp, volumeDeltaUp, Color.red);
                this.addSceneryPointAnnotation(renderer, (Comparable)((Object)seriesKey), dmxDataItem.getTimeOffset(), dmxDataItem.getBrightness(), durationDown, -volumeDeltaDown, Color.green.darker());
            }
            catch (Exception ex) {
                LOGGER.warn("Prepare scenery point annotations failed.", (Throwable)ex);
            }
        }
    }

    private void addSceneryPointAnnotation(XYItemRenderer renderer, Comparable<String> seriesKey, int chartX, int chartY, int duration, int volumeDelta, Color color) {
        SceneryPointArrowAnnotation annotation = new SceneryPointArrowAnnotation(seriesKey, (double)chartX, (double)chartY, duration, volumeDelta);
        annotation.setBaseRadius(0.0);
        annotation.setArrowPaint((Paint)color);
        renderer.addAnnotation((XYAnnotation)annotation);
    }

    public void loadSceneryPoints() {
        LOGGER.info("Load scenery points.");
        XYPlot plot = this.getChart().getXYPlot();
        XYSeriesCollection dataSet = (XYSeriesCollection)plot.getDataset();
        dataSet.removeAllSeries();
        if (this.dmxModel != null && this.dmxModel.getDmxScenery() != null) {
            DmxScenery dmxScenery = this.dmxModel.getDmxScenery();
            if (!CollectionUtils.isNotEmpty((Collection)dmxScenery.getSceneryPoints())) {
                LOGGER.info("No stored scenery points available.");
                return;
            }
            if (!CollectionUtils.isNotEmpty((Collection)dmxScenery.getUsedChannels())) {
                return;
            }
            XYItemRenderer renderer = plot.getRenderer();
            LinkedList sceneryPoints = new LinkedList(dmxScenery.getSceneryPoints());
            Collections.sort(sceneryPoints, new /* Unavailable Anonymous Inner Class!! */);
            for (DmxSceneryPoint dmxSceneryPoint : sceneryPoints) {
                LOGGER.info("Current dmxSceneryPoint: {}", (Object)dmxSceneryPoint);
                int dmxChannelNumber = dmxSceneryPoint.getDmxChannelNumber();
                String seriesKey = Integer.toString(dmxChannelNumber);
                double chartX = dmxSceneryPoint.getTimeOffset();
                double chartY = dmxSceneryPoint.getBrightness();
                LOGGER.info("Prepared chartX: {}, chartY: {}, seriesKey: {}", new Object[]{chartX, chartY, seriesKey});
                try {
                    DmxSeries dmxSeries = this.getDmxSeries((Comparable)((Object)seriesKey));
                    DmxDataItem item = dmxSeries.getNewDmxDataItem(chartX, chartY);
                    dmxSceneryPoint.setUniqueId(item.getUniqueId());
                    if (dmxSceneryPoint.getPort() != null) {
                        item.setPort(dmxSceneryPoint.getPort());
                        item.setAction(dmxSceneryPoint.getAction());
                    } else {
                        item.setMacro(dmxSceneryPoint.getMacro());
                    }
                    dmxSeries.add((XYDataItem)item, false);
                }
                catch (UnknownKeyException ex) {
                    LOGGER.debug("Add new point failed because no series in dataset for key: {}", (Object)seriesKey);
                    LOGGER.info("Create new DmxSeries for seriesKey: {}", (Object)seriesKey);
                    DmxSeries dmxSeries = new DmxSeries((Comparable)((Object)seriesKey), true);
                    dataSet.addSeries((XYSeries)dmxSeries);
                    DmxDataItem item = dmxSeries.getNewDmxDataItem(chartX, chartY);
                    dmxSceneryPoint.setUniqueId(item.getUniqueId());
                    if (dmxSceneryPoint.getPort() != null) {
                        item.setPort(dmxSceneryPoint.getPort());
                        item.setAction(dmxSceneryPoint.getAction());
                    } else {
                        item.setMacro(dmxSceneryPoint.getMacro());
                    }
                    dmxSeries.add((XYDataItem)item, false);
                    int index = dmxScenery.getUsedChannels().indexOf(new DmxChannel(dmxChannelNumber));
                    DmxChannel dmxChannel = (DmxChannel)dmxScenery.getUsedChannels().get(index);
                    if (renderer == null || dmxChannel.getLineColor() == null) continue;
                    renderer.setSeriesPaint(dataSet.indexOf((XYSeries)dmxSeries), (Paint)dmxChannel.getLineColor());
                }
            }
            for (Object series : dataSet.getSeries()) {
                DmxSeries dmxSeries = (DmxSeries)series;
                if (dmxSeries == null) continue;
                dmxSeries.fireSeriesChanged();
                this.refreshSceneryPointAnnotations(plot, dmxSeries);
            }
        }
    }

    public void storeSceneryPoints() {
        LOGGER.info("Store scenery points.");
        XYPlot plot = this.getChart().getXYPlot();
        XYSeriesCollection dataSet = (XYSeriesCollection)plot.getDataset();
        LinkedList<DmxSceneryPoint> dmxSceneryPoints = new LinkedList<DmxSceneryPoint>();
        for (Object series : dataSet.getSeries()) {
            if (!(series instanceof DmxSeries)) continue;
            DmxSeries dmxSeries = (DmxSeries)series;
            LOGGER.info("Current series: {}", (Object)dmxSeries);
            String seriesKey = (String)((Object)dmxSeries.getKey());
            DmxChannel dmxChannel = new DmxChannel(Integer.parseInt(seriesKey));
            List dmxDataItems = dmxSeries.getItems();
            for (DmxDataItem dmxDataItem : dmxDataItems) {
                int brightness = dmxDataItem.getY().intValue();
                int timeOffset = dmxDataItem.getX().intValue();
                Port port = dmxDataItem.getPort();
                DmxSceneryPoint dmxSceneryPoint = new DmxSceneryPoint().withBrightness(brightness).withTimeOffset(timeOffset).withUniqueId(dmxDataItem.getUniqueId()).withPort(port).withDmxChannelNumber(dmxChannel.getChannelId());
                dmxSceneryPoints.add(dmxSceneryPoint);
            }
        }
        LOGGER.info("Set scenery points: {}", dmxSceneryPoints);
        this.dmxModel.getDmxScenery().setSceneryPoints(dmxSceneryPoints);
    }
}

