/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.dmx.view.panel.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.annotations.AbstractXYAnnotation;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.util.Args;
import org.jfree.chart.util.PublicCloneable;

public class SceneryPointArrowAnnotation
extends AbstractXYAnnotation
implements PublicCloneable {
    private static final long serialVersionUID = 1L;
    public static final double DEFAULT_BASE_RADIUS = 10.0;
    private double x;
    private double y;
    private double duration;
    private double volumeDelta;
    private transient Stroke arrowStroke;
    private transient Paint arrowPaint;
    private double baseRadius;
    private Comparable<String> seriesKey;

    public SceneryPointArrowAnnotation(Comparable<String> seriesKey, double x, double y, int duration, int volumeDelta) {
        this.seriesKey = seriesKey;
        this.x = x;
        this.y = y;
        this.duration = duration;
        this.volumeDelta = volumeDelta;
        this.arrowStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f, 2.0f}, 0.0f);
        this.arrowPaint = Color.black;
        this.baseRadius = 10.0;
    }

    public Comparable<String> getSeriesKey() {
        return this.seriesKey;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
        this.fireAnnotationChanged();
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
        this.fireAnnotationChanged();
    }

    public double getDuration() {
        return this.duration;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public double getVolumeDelta() {
        return this.volumeDelta;
    }

    public void setVolumeDelta(double volumeDelta) {
        this.volumeDelta = volumeDelta;
    }

    public Stroke getArrowStroke() {
        return this.arrowStroke;
    }

    public void setArrowStroke(Stroke stroke) {
        Args.nullNotPermitted((Object)stroke, (String)"stroke");
        this.arrowStroke = stroke;
        this.fireAnnotationChanged();
    }

    public Paint getArrowPaint() {
        return this.arrowPaint;
    }

    public void setArrowPaint(Paint paint) {
        Args.nullNotPermitted((Object)paint, (String)"paint");
        this.arrowPaint = paint;
        this.fireAnnotationChanged();
    }

    public double getBaseRadius() {
        return this.baseRadius;
    }

    public void setBaseRadius(double radius) {
        this.baseRadius = radius;
        this.fireAnnotationChanged();
    }

    public void draw(Graphics2D g2, XYPlot plot, Rectangle2D dataArea, ValueAxis domainAxis, ValueAxis rangeAxis, int rendererIndex, PlotRenderingInfo info) {
        PlotOrientation orientation = plot.getOrientation();
        RectangleEdge domainEdge = Plot.resolveDomainAxisLocation((AxisLocation)plot.getDomainAxisLocation(), (PlotOrientation)orientation);
        RectangleEdge rangeEdge = Plot.resolveRangeAxisLocation((AxisLocation)plot.getRangeAxisLocation(), (PlotOrientation)orientation);
        double j2DX = domainAxis.valueToJava2D(this.getX(), dataArea, domainEdge);
        double j2DY = rangeAxis.valueToJava2D(this.getY(), dataArea, rangeEdge);
        if (orientation == PlotOrientation.HORIZONTAL) {
            double temp = j2DX;
            j2DX = j2DY;
            j2DY = temp;
        }
        double startX = j2DX + this.getBaseRadius();
        double startY = j2DY + this.getBaseRadius();
        double endX = domainAxis.valueToJava2D(this.getX() + this.duration, dataArea, domainEdge);
        double endY = rangeAxis.valueToJava2D(this.getY() + this.volumeDelta, dataArea, rangeEdge);
        g2.setStroke(this.getArrowStroke());
        g2.setPaint(this.getArrowPaint());
        Line2D.Double line = new Line2D.Double(startX, startY, endX, endY);
        g2.draw(line);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SceneryPointArrowAnnotation)) {
            return false;
        }
        SceneryPointArrowAnnotation that = (SceneryPointArrowAnnotation)obj;
        if (this.x != that.x) {
            return false;
        }
        if (this.y != that.y) {
            return false;
        }
        if (!this.seriesKey.equals(that.seriesKey)) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int result = 193;
        result = 37 * result + this.seriesKey.hashCode();
        long temp = Double.doubleToLongBits(this.x);
        result = 37 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 37 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

